/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.mpp.apple;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.CopySpec;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.dsl.KotlinNativeBinaryContainer;
import org.jetbrains.kotlin.gradle.plugin.mpp.Framework;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinNativeTarget;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinNativeTargetPresetKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.NativeBuildType;
import org.jetbrains.kotlin.gradle.plugin.mpp.apple.XcodeEnvironment;
import org.jetbrains.kotlin.gradle.tasks.TasksProviderKt;
import org.jetbrains.kotlin.gradle.utils.StringUtilsKt;
import org.jetbrains.kotlin.konan.target.KonanTarget;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u001a\u0014\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\u0006H\u0002\u001a\u001c\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n*\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0002\u001a\u0014\u0010\r\u001a\u00020\u000e*\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0000\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u000f"}, d2={"namePrefix", "", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/Framework;", "getNamePrefix", "(Lorg/jetbrains/kotlin/gradle/plugin/mpp/Framework;)Ljava/lang/String;", "appleFrameworkDir", "Ljava/io/File;", "Lorg/gradle/api/Project;", "frameworkSearchDir", "registerAssembleAppleFrameworkTask", "Lorg/gradle/api/tasks/TaskProvider;", "Lorg/gradle/api/tasks/Copy;", "framework", "registerEmbedAndSignAppleFrameworkTask", "", "kotlin-gradle-plugin"})
public final class AppleXcodeTasksKt {
    /*
     * WARNING - void declaration
     */
    private static final TaskProvider<Copy> registerAssembleAppleFrameworkTask(Project $this$registerAssembleAppleFrameworkTask, Framework framework2) {
        void $this$registerTask_u24default$iv;
        if (!framework2.getKonanTarget$kotlin_gradle_plugin().getFamily().isAppleFamily() || !KotlinNativeTargetPresetKt.getEnabledOnCurrentHost(framework2.getKonanTarget$kotlin_gradle_plugin())) {
            return null;
        }
        NativeBuildType frameworkBuildType = framework2.getBuildType();
        KotlinNativeTarget frameworkTarget = framework2.getTarget();
        String[] stringArray = new String[]{"assemble", AppleXcodeTasksKt.getNamePrefix(framework2), frameworkBuildType.getName(), "AppleFrameworkForXcode", frameworkTarget.getName()};
        String frameworkTaskName = StringUtilsKt.lowerCamelCaseName(stringArray);
        NativeBuildType envBuildType = XcodeEnvironment.INSTANCE.getBuildType();
        KonanTarget envTarget = XcodeEnvironment.INSTANCE.getTarget();
        File envFrameworkSearchDir = XcodeEnvironment.INSTANCE.getFrameworkSearchDir();
        if (envBuildType == null || envTarget == null || envFrameworkSearchDir == null) {
            String envConfiguration = System.getenv("CONFIGURATION");
            if (envTarget != null && envConfiguration != null) {
                $this$registerAssembleAppleFrameworkTask.getLogger().warn("Unable to detect Kotlin framework build type for CONFIGURATION=" + envConfiguration + " automatically. Specify 'KOTLIN_FRAMEWORK_BUILD_TYPE' to 'debug' or 'release'");
            } else {
                $this$registerAssembleAppleFrameworkTask.getLogger().debug("Not registering " + frameworkTaskName + ", since not called from Xcode ('SDK_NAME' and 'CONFIGURATION' not provided)");
            }
            return null;
        }
        if (frameworkBuildType != envBuildType || !Intrinsics.areEqual((Object)frameworkTarget.getKonanTarget(), (Object)envTarget)) {
            return null;
        }
        Project envConfiguration = $this$registerAssembleAppleFrameworkTask;
        Function1 body$iv = (Function1)new Function1<Copy, Unit>(frameworkBuildType, frameworkTarget, framework2, $this$registerAssembleAppleFrameworkTask, envFrameworkSearchDir){
            final /* synthetic */ NativeBuildType $frameworkBuildType;
            final /* synthetic */ KotlinNativeTarget $frameworkTarget;
            final /* synthetic */ Framework $framework;
            final /* synthetic */ Project $this_registerAssembleAppleFrameworkTask;
            final /* synthetic */ File $envFrameworkSearchDir;
            {
                this.$frameworkBuildType = $frameworkBuildType;
                this.$frameworkTarget = $frameworkTarget;
                this.$framework = $framework;
                this.$this_registerAssembleAppleFrameworkTask = $receiver;
                this.$envFrameworkSearchDir = $envFrameworkSearchDir;
                super(1);
            }

            public final void invoke(@NotNull Copy task) {
                Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
                task.setGroup("build");
                task.setDescription("Packs " + this.$frameworkBuildType + ' ' + this.$frameworkTarget.getName() + " framework for Xcode");
                Object[] objectArray = new Object[]{this.$framework.getLinkTaskName()};
                task.dependsOn(objectArray);
                objectArray = new Object[]{this.$framework.getOutputDirectory()};
                task.from(objectArray);
                task.into((Object)AppleXcodeTasksKt.access$appleFrameworkDir(this.$this_registerAssembleAppleFrameworkTask, this.$envFrameworkSearchDir));
            }
        };
        List args$iv = CollectionsKt.emptyList();
        boolean $i$f$registerTask = false;
        return TasksProviderKt.registerTask((Project)$this$registerTask_u24default$iv, frameworkTaskName, Copy.class, args$iv, body$iv);
    }

    /*
     * WARNING - void declaration
     */
    public static final void registerEmbedAndSignAppleFrameworkTask(@NotNull Project $this$registerEmbedAndSignAppleFrameworkTask, @NotNull Framework framework2) {
        void $this$registerTask_u24default$iv;
        Intrinsics.checkParameterIsNotNull((Object)$this$registerEmbedAndSignAppleFrameworkTask, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)framework2, (String)"framework");
        TaskProvider<Copy> taskProvider = AppleXcodeTasksKt.registerAssembleAppleFrameworkTask((Project)$this$registerEmbedAndSignAppleFrameworkTask, framework2);
        if (taskProvider == null) {
            return;
        }
        TaskProvider<Copy> assembleTask = taskProvider;
        NativeBuildType envBuildType = XcodeEnvironment.INSTANCE.getBuildType();
        KonanTarget envTarget = XcodeEnvironment.INSTANCE.getTarget();
        File envEmbeddedFrameworksDir = XcodeEnvironment.INSTANCE.getEmbeddedFrameworksDir();
        File envFrameworkSearchDir = XcodeEnvironment.INSTANCE.getFrameworkSearchDir();
        String envSign = XcodeEnvironment.INSTANCE.getSign();
        String[] stringArray = new String[]{"embedAndSign", AppleXcodeTasksKt.getNamePrefix(framework2), "AppleFrameworkForXcode"};
        String frameworkTaskName = StringUtilsKt.lowerCamelCaseName(stringArray);
        if (envBuildType == null || envTarget == null || envEmbeddedFrameworksDir == null || envFrameworkSearchDir == null) {
            $this$registerEmbedAndSignAppleFrameworkTask.getLogger().debug("Not registering " + frameworkTaskName + ", since not called from Xcode ('SDK_NAME', 'CONFIGURATION', 'TARGET_BUILD_DIR' and 'FRAMEWORKS_FOLDER_PATH' not provided)");
            return;
        }
        if (framework2.getBuildType() != envBuildType || !Intrinsics.areEqual((Object)framework2.getKonanTarget$kotlin_gradle_plugin(), (Object)envTarget)) {
            return;
        }
        stringArray = $this$registerEmbedAndSignAppleFrameworkTask;
        Function1 body$iv = (Function1)new Function1<Copy, Unit>(framework2, assembleTask, (Project)$this$registerEmbedAndSignAppleFrameworkTask, envFrameworkSearchDir, envEmbeddedFrameworksDir, envSign, envBuildType, envTarget){
            final /* synthetic */ Framework $framework;
            final /* synthetic */ TaskProvider<Copy> $assembleTask;
            final /* synthetic */ Project $this_registerEmbedAndSignAppleFrameworkTask;
            final /* synthetic */ File $envFrameworkSearchDir;
            final /* synthetic */ File $envEmbeddedFrameworksDir;
            final /* synthetic */ String $envSign;
            final /* synthetic */ NativeBuildType $envBuildType;
            final /* synthetic */ KonanTarget $envTarget;
            {
                this.$framework = $framework;
                this.$assembleTask = $assembleTask;
                this.$this_registerEmbedAndSignAppleFrameworkTask = $receiver;
                this.$envFrameworkSearchDir = $envFrameworkSearchDir;
                this.$envEmbeddedFrameworksDir = $envEmbeddedFrameworksDir;
                this.$envSign = $envSign;
                this.$envBuildType = $envBuildType;
                this.$envTarget = $envTarget;
                super(1);
            }

            public final void invoke(@NotNull Copy task) {
                Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
                task.setGroup("build");
                task.setDescription("Embed and sign " + AppleXcodeTasksKt.access$getNamePrefix(this.$framework) + " framework as requested by Xcode's environment variables");
                Object[] objectArray = new Object[]{this.$assembleTask};
                task.dependsOn(objectArray);
                objectArray = task.getInputs();
                NativeBuildType nativeBuildType = this.$envBuildType;
                KonanTarget konanTarget2 = this.$envTarget;
                File file = this.$envEmbeddedFrameworksDir;
                String string = this.$envSign;
                boolean bl = false;
                boolean bl2 = false;
                Object[] $this$invoke_u24lambda_u2d0 = objectArray;
                boolean bl3 = false;
                $this$invoke_u24lambda_u2d0.property("type", (Object)nativeBuildType);
                $this$invoke_u24lambda_u2d0.property("target", (Object)konanTarget2);
                $this$invoke_u24lambda_u2d0.property("embeddedFrameworksDir", (Object)file);
                $this$invoke_u24lambda_u2d0.property("sign", (Object)string);
                task.from((Object)AppleXcodeTasksKt.access$appleFrameworkDir(this.$this_registerEmbedAndSignAppleFrameworkTask, this.$envFrameworkSearchDir), new Action(this.$framework){
                    final /* synthetic */ Framework $framework;
                    {
                        this.$framework = $framework;
                    }

                    public final void execute(CopySpec spec) {
                        String[] stringArray = new String[]{Intrinsics.stringPlus((String)this.$framework.getOutputFile().getName(), (Object)"/**")};
                        spec.include(stringArray);
                    }
                });
                task.into((Object)this.$envEmbeddedFrameworksDir);
                if (this.$envSign != null) {
                    task.doLast(new Action(this.$envEmbeddedFrameworksDir, this.$framework, this.$this_registerEmbedAndSignAppleFrameworkTask, this.$envSign){
                        final /* synthetic */ File $envEmbeddedFrameworksDir;
                        final /* synthetic */ Framework $framework;
                        final /* synthetic */ Project $this_registerEmbedAndSignAppleFrameworkTask;
                        final /* synthetic */ String $envSign;
                        {
                            this.$envEmbeddedFrameworksDir = $envEmbeddedFrameworksDir;
                            this.$framework = $framework;
                            this.$this_registerEmbedAndSignAppleFrameworkTask = $receiver;
                            this.$envSign = $envSign;
                        }

                        public final void execute(Task it) {
                            String string = this.$framework.getOutputFile().getName();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"framework.outputFile.name");
                            File binary = FilesKt.resolve((File)FilesKt.resolve((File)this.$envEmbeddedFrameworksDir, (String)string), (String)FilesKt.getNameWithoutExtension((File)this.$framework.getOutputFile()));
                            this.$this_registerEmbedAndSignAppleFrameworkTask.exec(new Action(this.$envSign, binary){
                                final /* synthetic */ String $envSign;
                                final /* synthetic */ File $binary;
                                {
                                    this.$envSign = $envSign;
                                    this.$binary = $binary;
                                }

                                public final void execute(ExecSpec it) {
                                    Object[] objectArray = new Object[]{"codesign", "--force", "--sign", this.$envSign, "--", this.$binary};
                                    it.commandLine(objectArray);
                                }
                            });
                        }
                    });
                }
            }
        };
        List args$iv = CollectionsKt.emptyList();
        boolean $i$f$registerTask = false;
        TasksProviderKt.registerTask((Project)$this$registerTask_u24default$iv, frameworkTaskName, Copy.class, args$iv, body$iv);
    }

    private static final String getNamePrefix(Framework $this$namePrefix) {
        return KotlinNativeBinaryContainer.Companion.extractPrefixFromBinaryName$kotlin_gradle_plugin($this$namePrefix.getName(), $this$namePrefix.getBuildType(), $this$namePrefix.getOutputKind().getTaskNameClassifier());
    }

    private static final File appleFrameworkDir(Project $this$appleFrameworkDir, File frameworkSearchDir) {
        File file = $this$appleFrameworkDir.getBuildDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"buildDir");
        return FilesKt.resolve((File)FilesKt.resolve((File)file, (String)"xcode-frameworks"), (File)frameworkSearchDir);
    }

    public static final /* synthetic */ File access$appleFrameworkDir(Project $receiver, File frameworkSearchDir) {
        return AppleXcodeTasksKt.appleFrameworkDir($receiver, frameworkSearchDir);
    }

    public static final /* synthetic */ String access$getNamePrefix(Framework $receiver) {
        return AppleXcodeTasksKt.getNamePrefix($receiver);
    }
}

