/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.statistics;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.tasks.TaskState;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationCompletionListener;
import org.gradle.tooling.events.task.TaskFailureResult;
import org.gradle.tooling.events.task.TaskFinishEvent;
import org.gradle.tooling.events.task.TaskOperationResult;
import org.gradle.tooling.events.task.TaskSkippedResult;
import org.gradle.tooling.events.task.TaskSuccessResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.gradle.plugin.internal.state.TaskExecutionResults;
import org.jetbrains.kotlin.gradle.plugin.stat.CompileStatData;
import org.jetbrains.kotlin.gradle.plugin.stat.ReportStatistics;
import org.jetbrains.kotlin.gradle.plugin.statistics.KotlinBuildEsStatListener;
import org.jetbrains.kotlin.gradle.plugin.statistics.ReportStatisticsToElasticSearch;
import org.jetbrains.kotlin.gradle.plugin.statistics.TaskExecutionState;
import org.jetbrains.kotlin.gradle.report.TaskExecutionResult;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0014H\u0016J\b\u0010\u0019\u001a\u00020\u0012H\u0016J\u0012\u0010\u001a\u001a\u00020\u00122\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J \u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002R\u001d\u0010\u0007\u001a\u0004\u0018\u00010\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/statistics/KotlinBuildEsStatListener;", "Lorg/gradle/tooling/events/OperationCompletionListener;", "Ljava/lang/AutoCloseable;", "Lorg/gradle/api/execution/TaskExecutionListener;", "projectName", "", "(Ljava/lang/String;)V", "label", "getLabel", "()Ljava/lang/String;", "label$delegate", "Lkotlin/Lazy;", "getProjectName", "reportStatistics", "Lorg/jetbrains/kotlin/gradle/plugin/stat/ReportStatistics;", "getReportStatistics", "()Lorg/jetbrains/kotlin/gradle/plugin/stat/ReportStatistics;", "afterExecute", "", "task", "Lorg/gradle/api/Task;", "taskState", "Lorg/gradle/api/tasks/TaskState;", "beforeExecute", "p0", "close", "onFinish", "event", "Lorg/gradle/tooling/events/FinishEvent;", "reportData", "taskPath", "duration", "", "taskResult", "Lorg/jetbrains/kotlin/gradle/plugin/statistics/TaskExecutionState;", "kotlin-gradle-plugin"})
public final class KotlinBuildEsStatListener
implements OperationCompletionListener,
AutoCloseable,
TaskExecutionListener {
    @NotNull
    private final String projectName;
    @NotNull
    private final ReportStatistics reportStatistics;
    @NotNull
    private final Lazy label$delegate;

    public KotlinBuildEsStatListener(@NotNull String projectName) {
        Intrinsics.checkParameterIsNotNull((Object)projectName, (String)"projectName");
        this.projectName = projectName;
        this.reportStatistics = ReportStatisticsToElasticSearch.INSTANCE;
        this.label$delegate = LazyKt.lazy((Function0)label.2.INSTANCE);
    }

    @NotNull
    public final String getProjectName() {
        return this.projectName;
    }

    @NotNull
    public final ReportStatistics getReportStatistics() {
        return this.reportStatistics;
    }

    @Nullable
    public final String getLabel() {
        Lazy lazy = this.label$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    public void onFinish(@Nullable FinishEvent event) {
        if (event instanceof TaskFinishEvent) {
            TaskOperationResult result2 = ((TaskFinishEvent)event).getResult();
            String taskPath = ((TaskFinishEvent)event).getDescriptor().getTaskPath();
            long duration = ((TaskFinishEvent)event).getResult().getEndTime() - ((TaskFinishEvent)event).getResult().getStartTime();
            TaskOperationResult taskOperationResult = result2;
            TaskExecutionState taskResult = taskOperationResult instanceof TaskSuccessResult ? (((TaskSuccessResult)result2).isFromCache() ? TaskExecutionState.FROM_CACHE : (((TaskSuccessResult)result2).isUpToDate() ? TaskExecutionState.UP_TO_DATE : TaskExecutionState.SUCCESS)) : (taskOperationResult instanceof TaskSkippedResult ? TaskExecutionState.SKIPPED : (taskOperationResult instanceof TaskFailureResult ? TaskExecutionState.FAILED : TaskExecutionState.UNKNOWN));
            Intrinsics.checkExpressionValueIsNotNull((Object)taskPath, (String)"taskPath");
            this.reportData(taskPath, duration, taskResult);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void reportData(String taskPath, long duration, TaskExecutionState taskResult) {
        Object object;
        Object object2;
        Map map;
        Object object3 = TaskExecutionResults.INSTANCE.get(taskPath);
        if (object3 == null) {
            map = null;
        } else {
            object2 = ((TaskExecutionResult)object3).getBuildMetrics();
            if (object2 == null) {
                map = null;
            } else {
                object = object2.getBuildTimes();
                if (object == null) {
                    map = null;
                } else {
                    Map map2 = object.asMap();
                    if (map2 == null) {
                        map = null;
                    } else {
                        void $this$mapKeysTo$iv$iv;
                        Map $this$mapKeys$iv = map2;
                        boolean $i$f$mapKeys = false;
                        Map map3 = $this$mapKeys$iv;
                        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
                        boolean $i$f$mapKeysTo = false;
                        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
                        boolean $i$f$associateByTo = false;
                        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                            void it$iv$iv;
                            void $dstr$key$_u24__u24;
                            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                            Map map4 = destination$iv$iv;
                            boolean bl = false;
                            void var22_19 = $dstr$key$_u24__u24;
                            boolean bl2 = false;
                            BuildTime key = (BuildTime)var22_19.getKey();
                            String string = key.name();
                            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                            String string2 = string;
                            Map map5 = map4;
                            boolean bl3 = false;
                            entry = it$iv$iv.getValue();
                            map5.put(string2, entry);
                        }
                        map = destination$iv$iv;
                    }
                }
            }
        }
        Map map6 = map;
        Map statData = map6 == null ? MapsKt.emptyMap() : map6;
        object3 = taskResult.name();
        object2 = this.getLabel();
        object = this.projectName;
        CompileStatData compileStatData = new CompileStatData(0, (String)object, (String)object2, taskPath, (String)object3, duration, statData, 1, null);
        this.reportStatistics.report(compileStatData);
    }

    public void afterExecute(@NotNull Task task, @NotNull TaskState taskState) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        Intrinsics.checkParameterIsNotNull((Object)taskState, (String)"taskState");
        TaskExecutionState taskResult = taskState.getSkipped() ? TaskExecutionState.SKIPPED : (taskState.getFailure() != null ? TaskExecutionState.FAILED : (taskState.getUpToDate() ? TaskExecutionState.UP_TO_DATE : (taskState.getDidWork() ? TaskExecutionState.SUCCESS : (taskState.getExecuted() ? TaskExecutionState.FROM_CACHE : TaskExecutionState.UNKNOWN))));
        String taskPath = task.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)taskPath, (String)"taskPath");
        this.reportData(taskPath, 0L, taskResult);
    }

    @Override
    public void close() {
    }

    public void beforeExecute(@NotNull Task p0) {
        Intrinsics.checkParameterIsNotNull((Object)p0, (String)"p0");
    }
}

