/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.report;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.BuildListener;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.PropertiesProvider;
import org.jetbrains.kotlin.gradle.report.BuildDataRecorder;
import org.jetbrains.kotlin.gradle.report.BuildReportMode;
import org.jetbrains.kotlin.gradle.report.ConfigureReporingKt$configureReporting$1$execute$;
import org.jetbrains.kotlin.gradle.report.MetricsWriter;
import org.jetbrains.kotlin.gradle.report.PlainTextBuildReportWriter;
import org.jetbrains.kotlin.gradle.report.ReportingSettings;
import org.jetbrains.kotlin.gradle.report.data.BuildExecutionDataProcessor;
import org.jetbrains.kotlin.gradle.tasks.AbstractKotlinCompile;
import org.jetbrains.kotlin.gradle.utils.ConfigurationCacheKt;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"configurePlainTextReportWriter", "Lorg/jetbrains/kotlin/gradle/report/data/BuildExecutionDataProcessor;", "gradle", "Lorg/gradle/api/invocation/Gradle;", "reportingSettings", "Lorg/jetbrains/kotlin/gradle/report/ReportingSettings;", "configureReporting", "", "rootProject", "Lorg/gradle/api/Project;", "kotlin-gradle-plugin"})
public final class ConfigureReporingKt {
    public static final void configureReporting(@NotNull Gradle gradle) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)gradle, (String)"gradle");
        ArrayList<Object> buildDataProcessors = new ArrayList<Object>();
        Project rootProject = gradle.getRootProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)rootProject, (String)"rootProject");
        ReportingSettings reportingSettings = ConfigureReporingKt.reportingSettings(rootProject);
        gradle.getTaskGraph().whenReady(new Action(reportingSettings){
            final /* synthetic */ ReportingSettings $reportingSettings;
            {
                this.$reportingSettings = $reportingSettings;
            }

            /*
             * WARNING - void declaration
             */
            public final void execute(TaskExecutionGraph graph) {
                void $this$forEach$iv;
                List list2 = graph.getAllTasks();
                Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"graph.allTasks");
                Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)list2);
                boolean $i$f$filterIsInstance = false;
                Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)configureReporting$1$execute$$inlined$filterIsInstance$1.INSTANCE);
                if (sequence == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
                }
                $this$filterIsInstance$iv = sequence;
                ReportingSettings reportingSettings = this.$reportingSettings;
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    AbstractKotlinCompile it = (AbstractKotlinCompile)element$iv;
                    boolean bl = false;
                    it.setReportingSettings$kotlin_gradle_plugin(reportingSettings);
                }
            }
        });
        if (reportingSettings.getBuildReportMode() != BuildReportMode.NONE && reportingSettings.getBuildReportDir() != null && (object = ConfigureReporingKt.configurePlainTextReportWriter(gradle, reportingSettings)) != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            buildDataProcessors.add(it);
        }
        if (reportingSettings.getMetricsOutputFile() != null) {
            object = reportingSettings.getMetricsOutputFile().getAbsoluteFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"reportingSettings.metricsOutputFile.absoluteFile");
            Object object3 = object;
            object = rootProject.getLogger();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"rootProject.logger");
            buildDataProcessors.add(new MetricsWriter((File)object3, (Logger)object));
        }
        object = buildDataProcessors;
        boolean bl = false;
        if (!object.isEmpty() && !ConfigurationCacheKt.isConfigurationCacheAvailable(gradle)) {
            BuildDataRecorder listener = new BuildDataRecorder(gradle, (Iterable<? extends BuildExecutionDataProcessor>)buildDataProcessors);
            gradle.addBuildListener((BuildListener)listener);
        }
    }

    private static final ReportingSettings reportingSettings(Project rootProject) {
        File file;
        PropertiesProvider properties2 = PropertiesProvider.Companion.invoke(rootProject);
        BuildReportMode buildReportMode = !properties2.getBuildReportEnabled() ? BuildReportMode.NONE : (properties2.getBuildReportVerbose() ? BuildReportMode.VERBOSE : BuildReportMode.SIMPLE);
        File metricsOutputFile = properties2.getSingleBuildMetricsFile();
        File file2 = properties2.getBuildReportDir();
        if (file2 == null) {
            File file3 = rootProject.getBuildDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"rootProject.buildDir");
            file = FilesKt.resolve((File)file3, (String)"reports/kotlin-build");
        } else {
            file = file2;
        }
        File buildReportDir = file;
        boolean includeMetricsInReport = properties2.getBuildReportMetrics() || buildReportMode == BuildReportMode.VERBOSE;
        return new ReportingSettings(metricsOutputFile, buildReportDir, metricsOutputFile != null || includeMetricsInReport, includeMetricsInReport, buildReportMode);
    }

    private static final BuildExecutionDataProcessor configurePlainTextReportWriter(Gradle gradle, ReportingSettings reportingSettings) {
        Logger log = gradle.getRootProject().getLogger();
        File file = reportingSettings.getBuildReportDir();
        if (file == null) {
            Intrinsics.throwNpe();
        }
        File file2 = file;
        boolean bl = false;
        boolean bl2 = false;
        File $this$configurePlainTextReportWriter_u24lambda_u2d1 = file2;
        boolean bl3 = false;
        $this$configurePlainTextReportWriter_u24lambda_u2d1.mkdirs();
        File reportDir = file2;
        if (reportDir.isFile()) {
            log.error("Kotlin build report cannot be created: '" + reportDir + "' is a file");
            return null;
        }
        reportDir.mkdirs();
        String ts = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss").format(Calendar.getInstance().getTime());
        File reportFile = FilesKt.resolve((File)reportDir, (String)(gradle.getRootProject().getName() + "-build-" + ts + ".txt"));
        boolean bl4 = reportingSettings.getIncludeMetricsInReport();
        Intrinsics.checkExpressionValueIsNotNull((Object)log, (String)"log");
        return new PlainTextBuildReportWriter(reportFile, bl4, log);
    }
}

