/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.report;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.BuildAdapter;
import org.gradle.BuildResult;
import org.gradle.StartParameter;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.tasks.TaskState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.internal.state.TaskExecutionResults;
import org.jetbrains.kotlin.gradle.report.BuildDataRecorder;
import org.jetbrains.kotlin.gradle.report.TaskRecord;
import org.jetbrains.kotlin.gradle.report.data.BuildExecutionData;
import org.jetbrains.kotlin.gradle.report.data.BuildExecutionDataProcessor;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/gradle/report/BuildDataRecorder;", "Lorg/gradle/BuildAdapter;", "Lorg/gradle/api/execution/TaskExecutionListener;", "gradle", "Lorg/gradle/api/invocation/Gradle;", "buildDataProcessors", "", "Lorg/jetbrains/kotlin/gradle/report/data/BuildExecutionDataProcessor;", "(Lorg/gradle/api/invocation/Gradle;Ljava/lang/Iterable;)V", "taskRecords", "Ljava/util/HashMap;", "Lorg/gradle/api/Task;", "Lorg/jetbrains/kotlin/gradle/report/TaskRecord;", "afterExecute", "", "task", "state", "Lorg/gradle/api/tasks/TaskState;", "beforeExecute", "buildFinished", "result", "Lorg/gradle/BuildResult;", "kotlin-gradle-plugin"})
public final class BuildDataRecorder
extends BuildAdapter
implements TaskExecutionListener {
    @NotNull
    private final Gradle gradle;
    @NotNull
    private final Iterable<BuildExecutionDataProcessor> buildDataProcessors;
    @NotNull
    private final HashMap<Task, TaskRecord> taskRecords;

    public BuildDataRecorder(@NotNull Gradle gradle, @NotNull Iterable<? extends BuildExecutionDataProcessor> buildDataProcessors) {
        Intrinsics.checkParameterIsNotNull((Object)gradle, (String)"gradle");
        Intrinsics.checkParameterIsNotNull(buildDataProcessors, (String)"buildDataProcessors");
        this.gradle = gradle;
        this.buildDataProcessors = buildDataProcessors;
        this.taskRecords = new HashMap();
    }

    public synchronized void beforeExecute(@NotNull Task task) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        long startNs = System.nanoTime();
        Map map = this.taskRecords;
        TaskRecord taskRecord = new TaskRecord(task, startNs);
        boolean bl = false;
        map.put(task, taskRecord);
    }

    public synchronized void afterExecute(@NotNull Task task, @NotNull TaskState state) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        TaskRecord taskRecord = this.taskRecords.get(task);
        if (taskRecord != null) {
            TaskRecord taskRecord2 = taskRecord;
            boolean bl = false;
            boolean bl2 = false;
            TaskRecord $this$afterExecute_u24lambda_u2d0 = taskRecord2;
            boolean bl3 = false;
            String string = task.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"task.path");
            $this$afterExecute_u24lambda_u2d0.processResult(state, TaskExecutionResults.INSTANCE.get(string));
        }
    }

    public void buildFinished(@NotNull BuildResult result2) {
        Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
        boolean bl = false;
        ArrayList<String> startParams = new ArrayList<String>();
        StartParameter startParameter = this.gradle.getStartParameter();
        boolean bl2 = false;
        boolean bl3 = false;
        StartParameter $this$buildFinished_u24lambda_u2d1 = startParameter;
        boolean bl4 = false;
        List list2 = $this$buildFinished_u24lambda_u2d1.getTaskRequests();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"taskRequests");
        startParams.add(Intrinsics.stringPlus((String)"tasks = ", (Object)CollectionsKt.joinToString$default((Iterable)list2, null, null, null, (int)0, null, (Function1)buildFinished.1.1.INSTANCE, (int)31, null)));
        startParams.add(Intrinsics.stringPlus((String)"excluded tasks = ", (Object)$this$buildFinished_u24lambda_u2d1.getExcludedTaskNames()));
        startParams.add(Intrinsics.stringPlus((String)"current dir = ", (Object)$this$buildFinished_u24lambda_u2d1.getCurrentDir()));
        startParams.add(Intrinsics.stringPlus((String)"project properties args = ", (Object)$this$buildFinished_u24lambda_u2d1.getProjectProperties()));
        startParams.add(Intrinsics.stringPlus((String)"system properties args = ", (Object)$this$buildFinished_u24lambda_u2d1.getSystemPropertiesArgs()));
        Collection collection = startParams;
        Throwable throwable = result2.getFailure();
        Collection<TaskRecord> collection2 = this.taskRecords.values();
        Intrinsics.checkExpressionValueIsNotNull(collection2, (String)"taskRecords.values");
        Iterable $this$sortedBy$iv = collection2;
        boolean $i$f$sortedBy = false;
        boolean bl5 = false;
        BuildExecutionData buildData = new BuildExecutionData(collection, throwable, CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                TaskRecord it = (TaskRecord)a;
                boolean bl2 = false;
                Comparable comparable = Long.valueOf(it.getStartNs());
                it = (TaskRecord)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Long l = it.getStartNs();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
            }
        }));
        Iterable<BuildExecutionDataProcessor> $this$forEach$iv = this.buildDataProcessors;
        boolean $i$f$forEach = false;
        Iterator<BuildExecutionDataProcessor> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            BuildExecutionDataProcessor element$iv;
            BuildExecutionDataProcessor it = element$iv = iterator.next();
            boolean bl6 = false;
            it.process(buildData);
        }
    }
}

