/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.utils;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a2\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\f\u0010\b\u001a\u00020\u0003*\u00020\u0001H\u0000\u001a\f\u0010\t\u001a\u00020\u0007*\u00020\u0001H\u0000\u001a\u001a\u0010\n\u001a\u00020\u0007*\u00020\u00012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fH\u0000\u001a\u001e\u0010\r\u001a\u00020\u0007*\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00012\b\b\u0002\u0010\u000f\u001a\u00020\u0007H\u0000\u001a!\u0010\u0010\u001a\u0012\u0012\u000e\b\u0001\u0012\n \u0012*\u0004\u0018\u00010\u00010\u00010\u0011*\u00020\u0001H\u0000\u00a2\u0006\u0002\u0010\u0013\u001a\u001a\u0010\u0014\u001a\u00020\u0003*\b\u0012\u0004\u0012\u00020\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0001H\u0000\u001a\u0014\u0010\u0017\u001a\u00020\u0003*\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0001H\u0000\u001a\u0014\u0010\u0018\u001a\u00020\u0003*\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u001a\u001d\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011*\b\u0012\u0004\u0012\u00020\u00010\u0015H\u0000\u00a2\u0006\u0002\u0010\u001c\u00a8\u0006\u001d"}, d2={"newTmpFile", "Ljava/io/File;", "prefix", "", "suffix", "directory", "deleteOnExit", "", "canonicalPathWithoutExtension", "isJavaFile", "isKotlinFile", "sourceFilesExtensions", "", "isParentOf", "childCandidate", "strict", "listFilesOrEmpty", "", "kotlin.jvm.PlatformType", "(Ljava/io/File;)[Ljava/io/File;", "pathsAsStringRelativeTo", "", "base", "relativeOrCanonical", "relativeToRoot", "project", "Lorg/gradle/api/Project;", "toPathsArray", "(Ljava/lang/Iterable;)[Ljava/lang/String;", "kotlin-gradle-plugin"})
public final class FileUtilsKt {
    public static final boolean isJavaFile(@NotNull File $this$isJavaFile) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isJavaFile, (String)"<this>");
        return StringsKt.equals((String)FilesKt.getExtension((File)$this$isJavaFile), (String)"java", (boolean)true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isKotlinFile(@NotNull File $this$isKotlinFile, @NotNull List<String> sourceFilesExtensions) {
        String it;
        Intrinsics.checkParameterIsNotNull((Object)$this$isKotlinFile, (String)"<this>");
        Intrinsics.checkParameterIsNotNull(sourceFilesExtensions, (String)"sourceFilesExtensions");
        if (FileUtilsKt.isJavaFile($this$isKotlinFile)) return false;
        Iterable $this$any$iv = sourceFilesExtensions;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (String)element$iv;
            boolean bl = false;
        } while (!StringsKt.equals((String)it, (String)FilesKt.getExtension((File)$this$isKotlinFile), (boolean)true));
        return true;
    }

    @NotNull
    public static final String relativeOrCanonical(@NotNull File $this$relativeOrCanonical, @NotNull File base) {
        Object object;
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$this$relativeOrCanonical, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)base, (String)"base");
        Object object2 = FilesKt.relativeToOrNull((File)$this$relativeOrCanonical, (File)base);
        String string2 = string = object2 == null ? null : ((File)object2).getPath();
        if (string == null) {
            object2 = $this$relativeOrCanonical.getCanonicalPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"canonicalPath");
            object = object2;
        } else {
            object = string;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String pathsAsStringRelativeTo(@NotNull Iterable<? extends File> $this$pathsAsStringRelativeTo, @NotNull File base) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull($this$pathsAsStringRelativeTo, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)base, (String)"base");
        Iterable<? extends File> $this$map$iv = $this$pathsAsStringRelativeTo;
        boolean $i$f$map = false;
        Iterable<? extends File> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = FileUtilsKt.relativeOrCanonical((File)it, base);
            collection.add(string);
        }
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv)), null, null, null, (int)0, null, null, (int)63, null);
    }

    @NotNull
    public static final String relativeToRoot(@NotNull File $this$relativeToRoot, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)$this$relativeToRoot, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        File file = project.getRootProject().getRootDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.rootProject.rootDir");
        return FileUtilsKt.relativeOrCanonical($this$relativeToRoot, file);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String[] toPathsArray(@NotNull Iterable<? extends File> $this$toPathsArray) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull($this$toPathsArray, (String)"<this>");
        Iterable<? extends File> $this$map$iv = $this$toPathsArray;
        boolean $i$f$map = false;
        Iterable<? extends File> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getCanonicalPath();
            collection.add(string);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return stringArray;
    }

    @NotNull
    public static final File newTmpFile(@NotNull String prefix, @Nullable String suffix, @Nullable File directory2, boolean deleteOnExit) {
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        File file = (directory2 == null ? Files.createTempFile(prefix, suffix, new FileAttribute[0]) : Files.createTempFile(directory2.toPath(), prefix, suffix, new FileAttribute[0])).toFile();
        boolean bl = false;
        boolean bl2 = false;
        File $this$newTmpFile_u24lambda_u2d3 = file;
        boolean bl3 = false;
        if (deleteOnExit) {
            $this$newTmpFile_u24lambda_u2d3.deleteOnExit();
        }
        File file2 = file;
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"if (directory == null) F\u2026eOnExit) deleteOnExit() }");
        return file2;
    }

    public static /* synthetic */ File newTmpFile$default(String string, String string2, File file, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            file = null;
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        return FileUtilsKt.newTmpFile(string, string2, file, bl);
    }

    public static final boolean isParentOf(@NotNull File $this$isParentOf, @NotNull File childCandidate, boolean strict) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isParentOf, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)childCandidate, (String)"childCandidate");
        Path parentPath = Paths.get($this$isParentOf.getAbsolutePath(), new String[0]).normalize();
        Path childCandidatePath = Paths.get(childCandidate.getAbsolutePath(), new String[0]).normalize();
        return strict ? childCandidatePath.startsWith(parentPath) && !Intrinsics.areEqual((Object)parentPath, (Object)childCandidate) : childCandidatePath.startsWith(parentPath);
    }

    public static /* synthetic */ boolean isParentOf$default(File file, File file2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return FileUtilsKt.isParentOf(file, file2, bl);
    }

    @NotNull
    public static final String canonicalPathWithoutExtension(@NotNull File $this$canonicalPathWithoutExtension) {
        Intrinsics.checkParameterIsNotNull((Object)$this$canonicalPathWithoutExtension, (String)"<this>");
        String string = $this$canonicalPathWithoutExtension.getCanonicalPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"canonicalPath");
        return StringsKt.substringBeforeLast$default((String)string, (String)".", null, (int)2, null);
    }

    @NotNull
    public static final File[] listFilesOrEmpty(@NotNull File $this$listFilesOrEmpty) {
        Intrinsics.checkParameterIsNotNull((Object)$this$listFilesOrEmpty, (String)"<this>");
        File[] $this$orEmpty$iv = $this$listFilesOrEmpty.exists() ? $this$listFilesOrEmpty.listFiles() : null;
        boolean $i$f$orEmpty = false;
        File[] fileArray = $this$orEmpty$iv;
        if ($this$orEmpty$iv == null) {
            fileArray = new File[]{};
        }
        return fileArray;
    }
}

