/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.statistics;

import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Base64;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.gson.Gson;
import org.jetbrains.kotlin.gradle.plugin.stat.CompileStatData;
import org.jetbrains.kotlin.gradle.plugin.stat.ReportStatistics;
import org.jetbrains.kotlin.gradle.plugin.statistics.ReportStatisticsToElasticSearch;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001d\u0010\t\u001a\u0004\u0018\u00010\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\b\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u000e\u001a\u0004\u0018\u00010\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\b\u001a\u0004\b\u000f\u0010\fR\u001d\u0010\u0011\u001a\u0004\u0018\u00010\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\b\u001a\u0004\b\u0012\u0010\f\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/statistics/ReportStatisticsToElasticSearch;", "Lorg/jetbrains/kotlin/gradle/plugin/stat/ReportStatistics;", "()V", "enable", "", "getEnable", "()Z", "enable$delegate", "Lkotlin/Lazy;", "password", "", "getPassword", "()Ljava/lang/String;", "password$delegate", "url", "getUrl", "url$delegate", "user", "getUser", "user$delegate", "checkResponseAndLog", "", "connection", "Ljava/net/HttpURLConnection;", "report", "data", "Lorg/jetbrains/kotlin/gradle/plugin/stat/CompileStatData;", "kotlin-gradle-plugin"})
public final class ReportStatisticsToElasticSearch
implements ReportStatistics {
    @NotNull
    public static final ReportStatisticsToElasticSearch INSTANCE = new ReportStatisticsToElasticSearch();
    @NotNull
    private static final Lazy url$delegate = LazyKt.lazy((Function0)url.2.INSTANCE);
    @NotNull
    private static final Lazy user$delegate = LazyKt.lazy((Function0)user.2.INSTANCE);
    @NotNull
    private static final Lazy enable$delegate = LazyKt.lazy((Function0)enable.2.INSTANCE);
    @NotNull
    private static final Lazy password$delegate = LazyKt.lazy((Function0)password.2.INSTANCE);

    private ReportStatisticsToElasticSearch() {
    }

    @Nullable
    public final String getUrl() {
        Lazy lazy = url$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    @Nullable
    public final String getUser() {
        Lazy lazy = user$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    public final boolean getEnable() {
        Lazy lazy = enable$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Boolean)lazy.getValue();
    }

    @Nullable
    public final String getPassword() {
        Lazy lazy = password$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void report(@NotNull CompileStatData data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        if (!this.getEnable()) {
            return;
        }
        URLConnection uRLConnection = new URL(this.getUrl()).openConnection();
        if (uRLConnection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.net.HttpURLConnection");
        }
        HttpURLConnection connection = (HttpURLConnection)uRLConnection;
        try {
            boolean bl;
            Charset charset;
            Object object;
            Closeable it2;
            Object auth;
            if (this.getUser() != null && this.getPassword() != null) {
                Base64.Encoder encoder = Base64.getEncoder();
                Object object2 = this.getUser() + ':' + this.getPassword();
                Charset charset2 = Charsets.UTF_8;
                boolean bl2 = false;
                String string = object2;
                if (string == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string.getBytes(charset2);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                byte[] byArray2 = encoder.encode(byArray);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"getEncoder()\n           \u2026$password\".toByteArray())");
                object2 = Charsets.UTF_8;
                boolean bl3 = false;
                bl2 = false;
                auth = new String(byArray2, (Charset)object2);
                connection.addRequestProperty("Authorization", Intrinsics.stringPlus((String)"Basic ", (Object)auth));
            }
            connection.addRequestProperty("Content-Type", "application/json");
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            auth = connection.getOutputStream();
            boolean bl4 = false;
            boolean bl5 = false;
            Throwable throwable = null;
            try {
                it2 = (OutputStream)auth;
                boolean bl6 = false;
                object = new Gson().toJson(data);
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"Gson().toJson(data)");
                charset = Charsets.UTF_8;
                bl = false;
                byte[] byArray = ((String)object).getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                it2.write(byArray);
                it2 = Unit.INSTANCE;
            }
            catch (Throwable it2) {
                throwable = it2;
                throw it2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)auth, (Throwable)throwable);
            }
            connection.connect();
            this.checkResponseAndLog(connection);
            auth = connection.getInputStream();
            bl4 = false;
            boolean bl7 = false;
            Throwable throwable2 = null;
            try {
                String string;
                it2 = (InputStream)auth;
                boolean bl8 = false;
                Intrinsics.checkExpressionValueIsNotNull((Object)it2, (String)"it");
                object = it2;
                charset = Charsets.UTF_8;
                bl = false;
                object = new InputStreamReader((InputStream)object, charset);
                boolean bl9 = false;
                bl = false;
                Throwable throwable3 = null;
                try {
                    InputStreamReader reader = (InputStreamReader)object;
                    boolean bl10 = false;
                    string = TextStreamsKt.readText((Reader)reader);
                }
                catch (Throwable throwable4) {
                    throwable3 = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable3);
                }
                String string2 = string;
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
            finally {
                CloseableKt.closeFinally((Closeable)auth, (Throwable)throwable2);
            }
        }
        catch (Exception e) {
            this.checkResponseAndLog(connection);
        }
        finally {
            connection.disconnect();
        }
    }

    private final void checkResponseAndLog(HttpURLConnection connection) {
        boolean isResponseBad;
        int n = connection.getResponseCode();
        boolean bl = isResponseBad = !(200 <= n ? n <= 299 : false);
        if (isResponseBad) {
            throw new Exception("Failed to send statistic to " + connection.getURL() + ": " + connection.getResponseMessage());
        }
    }
}

