/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import java.io.File;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.compilerRunner.GradleCompilerRunner;
import org.jetbrains.kotlin.gradle.logging.GradleLoggingUtilsKt;
import org.jetbrains.kotlin.gradle.plugin.internal.state.TaskExecutionResults;
import org.jetbrains.kotlin.gradle.plugin.internal.state.TaskLoggers;
import org.jetbrains.kotlin.gradle.utils.FileUtilsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\fJ\b\u0010\u0010\u001a\u00020\tH\u0002J\u0011\u0010\u0011\u001a\u0004\u0018\u00010\tH\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/KotlinGradleFinishBuildHandler;", "", "()V", "log", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "shouldReportMemoryUsage", "", "startMemory", "", "Ljava/lang/Long;", "buildFinished", "", "gradle", "Lorg/gradle/api/invocation/Gradle;", "buildStart", "getGcCount", "getUsedMemoryKb", "getUsedMemoryKb$kotlin_gradle_plugin", "()Ljava/lang/Long;", "kotlin-gradle-plugin"})
public final class KotlinGradleFinishBuildHandler {
    private final Logger log = Logging.getLogger(this.getClass());
    @Nullable
    private Long startMemory;
    private final boolean shouldReportMemoryUsage = System.getProperty("kotlin.gradle.test.report.memory.usage") != null;

    public final void buildStart() {
        this.startMemory = this.getUsedMemoryKb$kotlin_gradle_plugin();
    }

    public final void buildFinished(@NotNull Gradle gradle) {
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)gradle, (String)"gradle");
        TaskLoggers.INSTANCE.clear();
        TaskExecutionResults.INSTANCE.clear();
        GradleCompilerRunner.Companion.clearBuildModulesInfo$kotlin_gradle_plugin();
        Project rootProject = gradle.getRootProject();
        File file = rootProject.getBuildDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"rootProject.buildDir");
        File sessionsDir = GradleCompilerRunner.Companion.sessionsDir$kotlin_gradle_plugin(file);
        if (sessionsDir.exists()) {
            File[] sessionFiles = sessionsDir.listFiles();
            if (sessionFiles.length > 1) {
                Intrinsics.checkNotNullExpressionValue((Object)rootProject, (String)"rootProject");
                this.log.warn(Intrinsics.stringPlus((String)"w: Detected multiple Kotlin daemon sessions at ", (Object)FileUtilsKt.relativeToRoot(sessionsDir, rootProject)));
            }
            Intrinsics.checkNotNullExpressionValue((Object)sessionFiles, (String)"sessionFiles");
            for (File file2 : sessionFiles) {
                file2.delete();
                logger = this.log;
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"log");
                Logger $this$kotlinDebug$iv = logger;
                boolean $i$f$kotlinDebug = false;
                if (!$this$kotlinDebug$iv.isDebugEnabled()) continue;
                Logger logger2 = $this$kotlinDebug$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
                Intrinsics.checkNotNullExpressionValue((Object)rootProject, (String)"rootProject");
                String string = Intrinsics.stringPlus((String)"Deleted session-is-alive flag file: ", (Object)FileUtilsKt.relativeToRoot(file2, rootProject));
                GradleLoggingUtilsKt.kotlinDebug(logger2, string);
            }
        }
        if (this.shouldReportMemoryUsage) {
            Long l = this.startMemory;
            Intrinsics.checkNotNull((Object)l);
            long startMem = l;
            Long l2 = this.getUsedMemoryKb$kotlin_gradle_plugin();
            Intrinsics.checkNotNull((Object)l2);
            long endMem = l2;
            StringBuilder stringBuilder = new StringBuilder().append("[KOTLIN][PERF] Used memory after build: ").append(endMem).append(" kb (difference since build start: ");
            logger = new Logger[]{Long.valueOf(endMem - startMem)};
            Logger logger3 = logger;
            String string = String.format("%+d", Arrays.copyOf(logger3, ((Logger)logger3).length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.String.format(this, *args)");
            this.log.lifecycle(stringBuilder.append(string).append(" kb)").toString());
        }
        gradle.removeListener((Object)this);
    }

    @Nullable
    public final Long getUsedMemoryKb$kotlin_gradle_plugin() {
        if (!this.shouldReportMemoryUsage) {
            return null;
        }
        this.log.lifecycle("Forcing System.gc()");
        long gcCountBefore = this.getGcCount();
        System.gc();
        while (this.getGcCount() == gcCountBefore) {
        }
        Runtime rt = Runtime.getRuntime();
        return (rt.totalMemory() - rt.freeMemory()) / (long)1024;
    }

    /*
     * WARNING - void declaration
     */
    private final long getGcCount() {
        void var3_3;
        List<GarbageCollectorMXBean> list2 = ManagementFactory.getGarbageCollectorMXBeans();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getGarbageCollectorMXBeans()");
        Iterable $this$sumByLong$iv = list2;
        boolean $i$f$sumByLong = false;
        long sum$iv = 0L;
        for (Object element$iv : $this$sumByLong$iv) {
            void it;
            GarbageCollectorMXBean garbageCollectorMXBean = (GarbageCollectorMXBean)element$iv;
            long l = sum$iv;
            boolean bl = false;
            long l2 = Math.max(0L, it.getCollectionCount());
            sum$iv = l + l2;
        }
        return (long)var3_3;
    }
}

