/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.report;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.report.metrics.BuildAttribute;
import org.jetbrains.kotlin.build.report.metrics.BuildAttributeKind;
import org.jetbrains.kotlin.build.report.metrics.BuildAttributes;
import org.jetbrains.kotlin.build.report.metrics.BuildMetrics;
import org.jetbrains.kotlin.build.report.metrics.BuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.BuildPerformanceMetrics;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.build.report.metrics.BuildTimes;
import org.jetbrains.kotlin.gradle.report.KotlinBuildReporterHandlerKt;
import org.jetbrains.kotlin.gradle.report.PlainTextBuildReportWriterKt;
import org.jetbrains.kotlin.gradle.report.TextTable;
import org.jetbrains.kotlin.gradle.report.data.BuildExecutionData;
import org.jetbrains.kotlin.gradle.report.data.BuildExecutionDataProcessor;
import org.jetbrains.kotlin.gradle.report.data.TaskExecutionData;
import org.jetbrains.kotlin.gradle.utils.Printer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0004\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u001e\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u001f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/gradle/report/PlainTextBuildReportWriter;", "Lorg/jetbrains/kotlin/gradle/report/data/BuildExecutionDataProcessor;", "outputFile", "Ljava/io/File;", "printMetrics", "", "log", "Lorg/gradle/api/logging/Logger;", "(Ljava/io/File;ZLorg/gradle/api/logging/Logger;)V", "p", "Lorg/jetbrains/kotlin/gradle/utils/Printer;", "printBuildAttributes", "", "buildAttributes", "Lorg/jetbrains/kotlin/build/report/metrics/BuildAttributes;", "printBuildInfo", "build", "Lorg/jetbrains/kotlin/gradle/report/data/BuildExecutionData;", "printBuildPerformanceMetrics", "buildMetrics", "Lorg/jetbrains/kotlin/build/report/metrics/BuildPerformanceMetrics;", "printBuildReport", "printBuildTimes", "buildTimes", "Lorg/jetbrains/kotlin/build/report/metrics/BuildTimes;", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetrics;", "printTaskLog", "task", "Lorg/jetbrains/kotlin/gradle/report/data/TaskExecutionData;", "printTaskOverview", "printTasksLog", "process", "kotlin-gradle-plugin"})
public final class PlainTextBuildReportWriter
implements BuildExecutionDataProcessor {
    @NotNull
    private final File outputFile;
    private final boolean printMetrics;
    @NotNull
    private final Logger log;
    private Printer p;

    public PlainTextBuildReportWriter(@NotNull File outputFile2, boolean printMetrics, @NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)outputFile2, (String)"outputFile");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.outputFile = outputFile2;
        this.printMetrics = printMetrics;
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(@NotNull BuildExecutionData build) {
        Intrinsics.checkNotNullParameter((Object)build, (String)"build");
        try {
            Object object = this.outputFile;
            Object object2 = Charsets.UTF_8;
            int n = 8192;
            Object object3 = object;
            boolean bl = false;
            Object object4 = object3;
            boolean bl2 = false;
            object4 = new FileOutputStream((File)object4);
            bl2 = false;
            object3 = new OutputStreamWriter((OutputStream)object4, (Charset)object2);
            bl = false;
            object = object3 instanceof BufferedWriter ? (BufferedWriter)object3 : new BufferedWriter((Writer)object3, n);
            object2 = null;
            try {
                BufferedWriter writer = (BufferedWriter)object;
                boolean bl3 = false;
                this.p = new Printer(writer, null, null, 6, null);
                this.printBuildReport(build);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
            this.log.lifecycle(Intrinsics.stringPlus((String)"Kotlin build report is written to ", (Object)this.outputFile.getCanonicalPath()));
        }
        catch (Exception e) {
            this.log.error(Intrinsics.stringPlus((String)"Could not write Kotlin build report to ", (Object)this.outputFile.getCanonicalPath()), (Throwable)e);
        }
    }

    private final void printBuildReport(BuildExecutionData build) {
        this.printBuildInfo(build);
        this.printMetrics(build.getAggregatedMetrics());
        this.printTaskOverview(build);
        this.printTasksLog(build);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void printBuildInfo(BuildExecutionData build) {
        String[] stringArray;
        String[] stringArray2;
        void this_$iv;
        String[] stringArray3;
        Object object = this.p;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            stringArray3 = null;
        } else {
            stringArray3 = object;
        }
        object = stringArray3;
        String headLine$iv = "Gradle start parameters:";
        boolean $i$f$withIndent = false;
        String[] stringArray4 = new String[]{headLine$iv};
        this_$iv.println(stringArray4);
        this_$iv.pushIndent();
        try {
            boolean bl = false;
            Iterable $this$forEach$iv = build.getStartParameters();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String[] stringArray5;
                String it = (String)element$iv;
                boolean bl2 = false;
                String[] stringArray6 = this.p;
                if (stringArray6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                    stringArray5 = null;
                } else {
                    stringArray5 = stringArray6;
                }
                stringArray6 = new String[]{it};
                stringArray5.println(stringArray6);
            }
            stringArray4 = Unit.INSTANCE;
        }
        finally {
            this_$iv.popIndent();
        }
        object = this.p;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            stringArray2 = null;
        } else {
            stringArray2 = object;
        }
        stringArray2.println(new String[0]);
        if (build.getFailure() != null) {
            String[] stringArray7;
            object = this.p;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                stringArray7 = null;
            } else {
                stringArray7 = object;
            }
            object = new String[]{Intrinsics.stringPlus((String)"Build failed: ", (Object)build.getFailure())};
            stringArray7.println((String)object);
        }
        if ((object = this.p) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            stringArray = null;
        } else {
            stringArray = object;
        }
        stringArray.println(new String[0]);
    }

    private final void printMetrics(BuildMetrics buildMetrics) {
        if (!this.printMetrics) {
            return;
        }
        this.printBuildTimes(buildMetrics.getBuildTimes());
        this.printBuildPerformanceMetrics(buildMetrics.getBuildPerformanceMetrics());
        this.printBuildAttributes(buildMetrics.getBuildAttributes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void printBuildTimes(BuildTimes buildTimes) {
        Object object;
        void this_$iv;
        Object v1;
        String[] stringArray;
        Map collectedBuildTimes = buildTimes.asMap();
        if (collectedBuildTimes.isEmpty()) {
            return;
        }
        Object object2 = this.p;
        if (object2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            stringArray = null;
        } else {
            stringArray = object2;
        }
        object2 = new String[]{"Time metrics:"};
        stringArray.println((String[])object2);
        object2 = this.p;
        if (object2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            v1 = null;
        } else {
            v1 = this_$iv;
        }
        this_$iv = v1;
        Object headLine$iv = null;
        boolean $i$f$withIndent = false;
        this_$iv.pushIndent();
        try {
            boolean bl = false;
            HashSet<BuildTime> visitedBuildTimes = new HashSet<BuildTime>();
            for (BuildTime buildTime : BuildTime.values()) {
                if (buildTime.getParent() != null) continue;
                PlainTextBuildReportWriter.printBuildTimes$lambda-5$printBuildTime(visitedBuildTimes, collectedBuildTimes, this, buildTime);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.popIndent();
        }
        object2 = this.p;
        if (object2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            object = null;
        } else {
            object = object2;
        }
        ((Printer)object).println(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void printBuildPerformanceMetrics(BuildPerformanceMetrics buildMetrics) {
        Printer printer;
        void this_$iv;
        Printer printer2;
        Map allBuildMetrics = buildMetrics.asMap();
        if (allBuildMetrics.isEmpty()) {
            return;
        }
        Printer printer3 = this.p;
        if (printer3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            printer2 = null;
        } else {
            printer2 = printer3;
        }
        printer3 = printer2;
        String headLine$iv = "Build performance metrics:";
        boolean $i$f$withIndent = false;
        String[] stringArray = new String[]{headLine$iv};
        this_$iv.println(stringArray);
        this_$iv.pushIndent();
        try {
            boolean bl = false;
            BuildPerformanceMetric[] buildPerformanceMetricArray = BuildPerformanceMetric.values();
            int n = 0;
            int n2 = buildPerformanceMetricArray.length;
            while (n < n2) {
                String[] stringArray2;
                BuildPerformanceMetric metric = buildPerformanceMetricArray[n];
                ++n;
                String[] stringArray3 = this.p;
                if (stringArray3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                    stringArray2 = null;
                } else {
                    stringArray2 = stringArray3;
                }
                stringArray3 = new String[]{metric.name() + ": " + allBuildMetrics.get(metric)};
                stringArray2.println(stringArray3);
            }
            stringArray = Unit.INSTANCE;
        }
        finally {
            this_$iv.popIndent();
        }
        printer3 = this.p;
        if (printer3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            printer = null;
        } else {
            printer = printer3;
        }
        printer.println(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void printBuildAttributes(BuildAttributes buildAttributes) {
        Printer printer;
        void this_$iv;
        Printer printer2;
        Map allAttributes = buildAttributes.asMap();
        if (allAttributes.isEmpty()) {
            return;
        }
        Printer printer3 = this.p;
        if (printer3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            printer2 = null;
        } else {
            printer2 = printer3;
        }
        printer3 = printer2;
        String headLine$iv = "Build attributes:";
        boolean $i$f$withIndent = false;
        String[] stringArray = new String[]{headLine$iv};
        this_$iv.println(stringArray);
        this_$iv.pushIndent();
        try {
            void $this$groupByTo$iv$iv;
            boolean bl = false;
            Iterable $this$groupBy$iv = allAttributes.entrySet();
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo2 = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                Map.Entry it = (Map.Entry)element$iv$iv;
                boolean bl2 = false;
                BuildAttributeKind key$iv$iv = ((BuildAttribute)it.getKey()).getKind();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl3 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            SortedMap attributesByKind = MapsKt.toSortedMap((Map)destination$iv$iv);
            for (Map.Entry entry : ((Map)attributesByKind).entrySet()) {
                Collection<Pair> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Printer printer4;
                Object element$iv$iv;
                BuildAttributeKind kind = (BuildAttributeKind)entry.getKey();
                List attributesCounts = (List)entry.getValue();
                Object $i$f$groupByTo2 = this.p;
                if ($i$f$groupByTo2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                    printer4 = null;
                } else {
                    printer4 = $i$f$groupByTo2;
                }
                String string = kind.name();
                Intrinsics.checkNotNullExpressionValue((Object)attributesCounts, (String)"attributesCounts");
                $i$f$groupByTo2 = attributesCounts;
                String string2 = string;
                Printer printer5 = printer4;
                boolean $i$f$map = false;
                element$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void $dstr$k$v;
                    Map.Entry $i$f$getOrPut = (Map.Entry)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl4 = false;
                    BuildAttribute k = (BuildAttribute)$dstr$k$v.getKey();
                    int v = ((Number)$dstr$k$v.getValue()).intValue();
                    Pair pair = TuplesKt.to((Object)k.name(), (Object)v);
                    collection.add(pair);
                }
                collection = (List)destination$iv$iv2;
                PlainTextBuildReportWriterKt.access$printMap(printer5, string2, MapsKt.toMap((Iterable)collection));
            }
            stringArray = Unit.INSTANCE;
        }
        finally {
            this_$iv.popIndent();
        }
        printer3 = this.p;
        if (printer3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            printer = null;
        } else {
            printer = printer3;
        }
        printer.println(new String[0]);
    }

    private final void printTaskOverview(BuildExecutionData build) {
        Object object;
        Object object2;
        Printer printer;
        long allTasksTimeMs = 0L;
        long kotlinTotalTimeMs = 0L;
        ArrayList<TaskExecutionData> kotlinTasks = new ArrayList<TaskExecutionData>();
        for (TaskExecutionData taskExecutionData : build.getTaskExecutionData()) {
            long taskTimeMs = taskExecutionData.getTotalTimeMs();
            allTasksTimeMs += taskTimeMs;
            if (!taskExecutionData.isKotlinTask()) continue;
            kotlinTotalTimeMs += taskTimeMs;
            kotlinTasks.add(taskExecutionData);
        }
        if (kotlinTasks.isEmpty()) {
            String[] stringArray;
            Object object3 = this.p;
            if (object3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                stringArray = null;
            } else {
                stringArray = object3;
            }
            object3 = new String[]{"No Kotlin task was run"};
            stringArray.println((String)object3);
            return;
        }
        String ktTaskPercent = KotlinBuildReporterHandlerKt.asString((double)kotlinTotalTimeMs / (double)allTasksTimeMs * (double)100, 1);
        Printer printer2 = this.p;
        if (printer2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            printer = null;
        } else {
            printer = printer2;
        }
        String[] stringArray = new String[]{"Total time for Kotlin tasks: " + KotlinBuildReporterHandlerKt.formatTime(kotlinTotalTimeMs) + " (" + ktTaskPercent + " % of all tasks time)"};
        printer.println(stringArray);
        Object object3 = new String[]{"Time", "% of Kotlin time", "Task"};
        TextTable textTable = new TextTable((String[])object3);
        Iterable $this$sortedByDescending$iv = kotlinTasks;
        boolean $i$f$sortedByDescending = false;
        boolean bl = false;
        for (TaskExecutionData task3 : CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                TaskExecutionData it = (TaskExecutionData)b;
                boolean bl2 = false;
                Comparable comparable = Long.valueOf(it.getTotalTimeMs());
                it = (TaskExecutionData)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Long l = it.getTotalTimeMs();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
            }
        })) {
            long timeMs = task3.getTotalTimeMs();
            String percent = KotlinBuildReporterHandlerKt.asString((double)timeMs / (double)kotlinTotalTimeMs * (double)100, 1);
            String[] stringArray2 = new String[3];
            stringArray2[0] = KotlinBuildReporterHandlerKt.formatTime(timeMs);
            stringArray2[1] = Intrinsics.stringPlus((String)percent, (Object)" %");
            String string = task3.getTask().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"task.task.path");
            stringArray2[2] = string;
            textTable.addRow(stringArray2);
        }
        object3 = this.p;
        if (object3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            object2 = null;
        } else {
            object2 = object3;
        }
        textTable.printTo((Printer)object2);
        object3 = this.p;
        if (object3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            object = null;
        } else {
            object = object3;
        }
        ((Printer)object).println(new String[0]);
    }

    private final void printTasksLog(BuildExecutionData build) {
        for (TaskExecutionData task : build.getTaskExecutionData()) {
            Printer printer;
            this.printTaskLog(task);
            Printer printer2 = this.p;
            if (printer2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                printer = null;
            } else {
                printer = printer2;
            }
            printer.println(new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void printTaskLog(TaskExecutionData task) {
        Object object;
        String skipMessage = task.getResultState().getSkipMessage();
        if (skipMessage != null) {
            String[] stringArray;
            object = this.p;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                stringArray = null;
            } else {
                stringArray = object;
            }
            object = new String[]{"Task '" + task.getTask().getPath() + "' was skipped: " + skipMessage};
            stringArray.println((String)object);
        } else {
            String[] stringArray;
            object = this.p;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                stringArray = null;
            } else {
                stringArray = object;
            }
            object = new String[]{"Task '" + task.getTask().getPath() + "' finished in " + KotlinBuildReporterHandlerKt.formatTime(task.getTotalTimeMs())};
            stringArray.println((String)object);
        }
        if (!((Collection)task.getIcLogLines()).isEmpty()) {
            void this_$iv;
            String[] stringArray;
            Object object2;
            object = this.p;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                object2 = null;
            } else {
                object2 = object;
            }
            object = object2;
            String headLine$iv = "Compilation log for task '" + task.getTask().getPath() + "':";
            boolean $i$f$withIndent = false;
            if (headLine$iv != null) {
                stringArray = new String[]{headLine$iv};
                this_$iv.println(stringArray);
            }
            this_$iv.pushIndent();
            try {
                boolean bl = false;
                Iterable $this$forEach$iv = task.getIcLogLines();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String[] stringArray2;
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    String[] stringArray3 = this.p;
                    if (stringArray3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                        stringArray2 = null;
                    } else {
                        stringArray2 = stringArray3;
                    }
                    stringArray3 = new String[]{it};
                    stringArray2.println(stringArray3);
                }
                stringArray = Unit.INSTANCE;
            }
            finally {
                this_$iv.popIndent();
            }
        }
        this.printMetrics(task.getBuildMetrics());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void printBuildTimes$lambda-5$printBuildTime(HashSet<BuildTime> visitedBuildTimes, Map<BuildTime, Long> collectedBuildTimes, PlainTextBuildReportWriter this$0, BuildTime buildTime) {
        Object object;
        String[] stringArray;
        if (!visitedBuildTimes.add(buildTime)) {
            return;
        }
        Object object2 = collectedBuildTimes.get(buildTime);
        if (object2 == null) {
            return;
        }
        long timeMs = (Long)object2;
        object2 = this$0.p;
        if (object2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            stringArray = null;
        } else {
            stringArray = object2;
        }
        object2 = new String[]{buildTime.name() + ": " + KotlinBuildReporterHandlerKt.formatTime(timeMs)};
        stringArray.println((String[])object2);
        object2 = this$0.p;
        if (object2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            object = null;
        } else {
            object = object2;
        }
        Object this_$iv = object;
        Object headLine$iv = null;
        boolean $i$f$withIndent = false;
        ((Printer)this_$iv).pushIndent();
        try {
            Unit unit;
            boolean bl = false;
            List list2 = (List)BuildTime.Companion.getChildren().get(buildTime);
            if (list2 == null) {
                unit = null;
            } else {
                Iterable $this$forEach$iv = list2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    BuildTime it = (BuildTime)element$iv;
                    boolean bl2 = false;
                    PlainTextBuildReportWriter.printBuildTimes$lambda-5$printBuildTime(visitedBuildTimes, collectedBuildTimes, this$0, it);
                }
                unit = Unit.INSTANCE;
            }
            Unit unit2 = unit;
        }
        finally {
            ((Printer)this_$iv).popIndent();
        }
    }
}

