/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.statistics;

import com.gradle.scan.plugin.BuildScanExtension;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.report.metrics.BuildAttribute;
import org.jetbrains.kotlin.build.report.metrics.BuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.gradle.plugin.stat.CompileStatData;
import org.jetbrains.kotlin.gradle.plugin.stat.ReportStatistics;
import org.jetbrains.kotlin.gradle.plugin.statistics.ReportStatisticsToBuildScan;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/statistics/ReportStatisticsToBuildScan;", "Lorg/jetbrains/kotlin/gradle/plugin/stat/ReportStatistics;", "buildScan", "Lcom/gradle/scan/plugin/BuildScanExtension;", "buildUuid", "", "kotlinVersion", "(Lcom/gradle/scan/plugin/BuildScanExtension;Ljava/lang/String;Ljava/lang/String;)V", "readableString", "data", "Lorg/jetbrains/kotlin/gradle/plugin/stat/CompileStatData;", "report", "", "kotlin-gradle-plugin"})
public final class ReportStatisticsToBuildScan
implements ReportStatistics {
    @NotNull
    private final BuildScanExtension buildScan;
    @NotNull
    private final String buildUuid;
    @NotNull
    private final String kotlinVersion;

    public ReportStatisticsToBuildScan(@NotNull BuildScanExtension buildScan, @NotNull String buildUuid, @NotNull String kotlinVersion) {
        Intrinsics.checkNotNullParameter((Object)buildScan, (String)"buildScan");
        Intrinsics.checkNotNullParameter((Object)buildUuid, (String)"buildUuid");
        Intrinsics.checkNotNullParameter((Object)kotlinVersion, (String)"kotlinVersion");
        this.buildScan = buildScan;
        this.buildUuid = buildUuid;
        this.kotlinVersion = kotlinVersion;
    }

    @Override
    public void report(@NotNull CompileStatData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.buildScan.value(data.getTaskName(), this.readableString(data));
        Iterable $this$forEach$iv = data.getTags();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.buildScan.tag(it);
        }
    }

    private final String readableString(CompileStatData data) {
        long value;
        BuildTime key;
        Map.Entry<Object, Number> element$iv;
        Map<BuildAttribute, Integer> $this$filterValues$iv = data.getNonIncrementalAttributes();
        boolean $i$f$filterValues = false;
        LinkedHashMap<BuildAttribute, Integer> result$iv = new LinkedHashMap<BuildAttribute, Integer>();
        Map<Object, Number> map = $this$filterValues$iv;
        boolean bl = false;
        for (Map.Entry<BuildAttribute, Integer> entry$iv : map.entrySet()) {
            int it = ((Number)entry$iv.getValue()).intValue();
            boolean bl2 = false;
            if (!(it > 0)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Set nonIncrementalReasons = ((Map)result$iv).keySet();
        StringBuilder readableString2 = new StringBuilder();
        if (nonIncrementalReasons.isEmpty()) {
            readableString2.append("Incremental build; ");
        } else {
            CollectionsKt.joinTo$default((Iterable)nonIncrementalReasons, (Appendable)readableString2, null, (CharSequence)"Non incremental build because: [", (CharSequence)"]; ", (int)0, null, (Function1)readableString.1.INSTANCE, (int)50, null);
        }
        CollectionsKt.joinTo$default((Iterable)data.getChanges(), (Appendable)readableString2, null, (CharSequence)"Changes: [", (CharSequence)"]; ", (int)0, null, (Function1)readableString.2.INSTANCE, (int)50, null);
        readableString2.append("Performance: [");
        Map<BuildTime, Long> $this$forEach$iv = data.getTimeData();
        boolean $i$f$forEach = false;
        map = $this$forEach$iv;
        bl = false;
        Iterator<Map.Entry<Object, Number>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Number> $dstr$key$value = element$iv = iterator.next();
            boolean bl3 = false;
            key = (BuildTime)$dstr$key$value.getKey();
            value = $dstr$key$value.getValue().longValue();
            readableString2.append(key.getReadableString()).append(": ").append(value).append("ms, ");
        }
        $this$forEach$iv = data.getPerfData();
        $i$f$forEach = false;
        map = $this$forEach$iv;
        bl = false;
        iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Number> $dstr$key$value = element$iv = iterator.next();
            boolean bl4 = false;
            key = (BuildPerformanceMetric)$dstr$key$value.getKey();
            value = $dstr$key$value.getValue().longValue();
            readableString2.append(key.getReadableString()).append(": ").append(value).append("kb, ");
        }
        readableString2.append("]; ");
        String string = readableString2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readableString.toString()");
        return string;
    }
}

