/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.native.internal;

import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.tasks.Input;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.mpp.pm20.KotlinCompilationData;
import org.jetbrains.kotlin.gradle.utils.UnsafeApi;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\b\u0018\u00002\u00020\u0001:\u0001\u0017B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\b\u0010\u0016\u001a\u00020\u0005H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u00020\u00058G\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\b\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/native/internal/CInteropIdentifier;", "Ljava/io/Serializable;", "scope", "Lorg/jetbrains/kotlin/gradle/targets/native/internal/CInteropIdentifier$Scope;", "interopName", "", "(Lorg/jetbrains/kotlin/gradle/targets/native/internal/CInteropIdentifier$Scope;Ljava/lang/String;)V", "getInteropName", "()Ljava/lang/String;", "getScope", "()Lorg/jetbrains/kotlin/gradle/targets/native/internal/CInteropIdentifier$Scope;", "uniqueName", "getUniqueName", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Scope", "kotlin-gradle-plugin"})
public final class CInteropIdentifier
implements Serializable {
    @NotNull
    private final Scope scope;
    @NotNull
    private final String interopName;
    @NotNull
    private final String uniqueName;

    public CInteropIdentifier(@NotNull Scope scope, @NotNull String interopName) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)interopName, (String)"interopName");
        this.scope = scope;
        this.interopName = interopName;
        this.uniqueName = "cinterop:" + this.scope.getName() + '/' + this.interopName;
    }

    @NotNull
    public final Scope getScope() {
        return this.scope;
    }

    @NotNull
    public final String getInteropName() {
        return this.interopName;
    }

    @Input
    @NotNull
    public final String getUniqueName() {
        return this.uniqueName;
    }

    @NotNull
    public String toString() {
        return this.uniqueName;
    }

    @NotNull
    public final Scope component1() {
        return this.scope;
    }

    @NotNull
    public final String component2() {
        return this.interopName;
    }

    @NotNull
    public final CInteropIdentifier copy(@NotNull Scope scope, @NotNull String interopName) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)interopName, (String)"interopName");
        return new CInteropIdentifier(scope, interopName);
    }

    public static /* synthetic */ CInteropIdentifier copy$default(CInteropIdentifier cInteropIdentifier, Scope scope, String string, int n, Object object) {
        if ((n & 1) != 0) {
            scope = cInteropIdentifier.scope;
        }
        if ((n & 2) != 0) {
            string = cInteropIdentifier.interopName;
        }
        return cInteropIdentifier.copy(scope, string);
    }

    public int hashCode() {
        int result2 = this.scope.hashCode();
        result2 = result2 * 31 + this.interopName.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CInteropIdentifier)) {
            return false;
        }
        CInteropIdentifier cInteropIdentifier = (CInteropIdentifier)other;
        if (!Intrinsics.areEqual((Object)this.scope, (Object)cInteropIdentifier.scope)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.interopName, (Object)cInteropIdentifier.interopName);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0096\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/native/internal/CInteropIdentifier$Scope;", "Ljava/io/Serializable;", "name", "", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "kotlin-gradle-plugin"})
    public static final class Scope
    implements Serializable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String name;

        @UnsafeApi
        public Scope(@NotNull String name2) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            this.name = name2;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public String toString() {
            return this.name;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (!(other instanceof Scope)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.name, (Object)((Scope)other).name);
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/native/internal/CInteropIdentifier$Scope$Companion;", "", "()V", "create", "Lorg/jetbrains/kotlin/gradle/targets/native/internal/CInteropIdentifier$Scope;", "compilation", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/pm20/KotlinCompilationData;", "kotlin-gradle-plugin"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Scope create(@NotNull KotlinCompilationData<?> compilation2) {
                Intrinsics.checkNotNullParameter(compilation2, (String)"compilation");
                return new Scope(Intrinsics.stringPlus((String)"compilation/", (Object)compilation2.getCompileKotlinTaskName()));
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

