/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.utils;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.utils.CacheKlibUtilsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0012\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\n2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003\u001a\f\u0010\u000b\u001a\u00020\u0001*\u00020\fH\u0002\u00a8\u0006\r"}, d2={"computeDependenciesHash", "", "dependency", "Lorg/gradle/api/artifacts/ResolvedDependency;", "getAllDependencies", "", "getCacheDirectory", "Ljava/io/File;", "rootCacheDirectory", "getDependenciesCacheDirectories", "", "toHexString", "", "kotlin-gradle-plugin"})
public final class CacheKlibUtilsKt {
    @NotNull
    public static final File getCacheDirectory(@NotNull File rootCacheDirectory2, @NotNull ResolvedDependency dependency2) {
        Intrinsics.checkNotNullParameter((Object)rootCacheDirectory2, (String)"rootCacheDirectory");
        Intrinsics.checkNotNullParameter((Object)dependency2, (String)"dependency");
        File moduleCacheDirectory = new File(rootCacheDirectory2, dependency2.getModuleName());
        File versionCacheDirectory = new File(moduleCacheDirectory, dependency2.getModuleVersion());
        return new File(versionCacheDirectory, CacheKlibUtilsKt.computeDependenciesHash(dependency2));
    }

    private static final String toHexString(byte[] $this$toHexString) {
        return ArraysKt.joinToString$default((byte[])$this$toHexString, (CharSequence)"", null, null, (int)0, null, (Function1)toHexString.1.INSTANCE, (int)30, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final String computeDependenciesHash(ResolvedDependency dependency2) {
        void $this$mapTo$iv$iv;
        Iterable list$iv$iv;
        ResolvedDependency it;
        Iterable $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Iterable iterable = dependency2.getModuleArtifacts();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"dependency.moduleArtifacts");
        Set set2 = iterable;
        iterable = CacheKlibUtilsKt.getAllDependencies(dependency2);
        Collection<Object> collection = set2;
        boolean $i$f$flatMap = false;
        void var4_5 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (ResolvedDependency)element$iv$iv;
            boolean bl = false;
            Set set3 = it.getModuleArtifacts();
            Intrinsics.checkNotNullExpressionValue((Object)set3, (String)"it.moduleArtifacts");
            list$iv$iv = set3;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Object object = (List)destination$iv$iv;
        Iterable $this$map$iv = SetsKt.plus((Set)collection, (Iterable)((Iterable)object));
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (ResolvedArtifact)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = it.getFile().getAbsolutePath();
            collection.add(object);
        }
        Iterable $this$sortedBy$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        String allArtifactsPaths2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                String it = (String)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)it);
                it = (String)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string = it;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        }), (CharSequence)"|", null, null, (int)0, null, (Function1)computeDependenciesHash.allArtifactsPaths.4.INSTANCE, (int)30, null);
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        String string = allArtifactsPaths2;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] hash = digest.digest(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"hash");
        return CacheKlibUtilsKt.toHexString(hash);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final List<File> getDependenciesCacheDirectories(@NotNull File rootCacheDirectory2, @NotNull ResolvedDependency dependency2) {
        void $this$filterTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)rootCacheDirectory2, (String)"rootCacheDirectory");
        Intrinsics.checkNotNullParameter((Object)dependency2, (String)"dependency");
        Iterable $this$map$iv = CacheKlibUtilsKt.getAllDependencies(dependency2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            boolean bl;
            void childDependency;
            Collection collection;
            block6: {
                ResolvedDependency resolvedDependency = (ResolvedDependency)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                Set set2 = childDependency.getModuleArtifacts();
                Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"childDependency.moduleArtifacts");
                Iterable $this$any$iv = set2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ResolvedArtifact it = (ResolvedArtifact)element$iv;
                        boolean bl3 = false;
                        String string = it.getFile().getAbsolutePath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.file.absolutePath");
                        if (!StringsKt.endsWith$default((String)string, (String)".klib", (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            boolean hasKlibs = bl;
            File cacheDirectory = CacheKlibUtilsKt.getCacheDirectory(rootCacheDirectory2, (ResolvedDependency)childDependency);
            if (hasKlibs && !cacheDirectory.exists()) {
                return null;
            }
            File file = cacheDirectory;
            collection.add(file);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            if (!it.exists()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final Set<ResolvedDependency> getAllDependencies(@NotNull ResolvedDependency dependency2) {
        Intrinsics.checkNotNullParameter((Object)dependency2, (String)"dependency");
        Set allDependencies = new LinkedHashSet();
        Set set2 = dependency2.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"dependency.children");
        Iterable $this$forEach$iv = set2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ResolvedDependency it = (ResolvedDependency)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            CacheKlibUtilsKt.getAllDependencies$traverseAllDependencies(allDependencies, it);
        }
        return allDependencies;
    }

    private static final void getAllDependencies$traverseAllDependencies(Set<ResolvedDependency> allDependencies, ResolvedDependency dependency2) {
        if (allDependencies.contains(dependency2)) {
            return;
        }
        allDependencies.add(dependency2);
        Set set2 = dependency2.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"dependency.children");
        Iterable $this$forEach$iv = set2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ResolvedDependency it = (ResolvedDependency)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            CacheKlibUtilsKt.getAllDependencies$traverseAllDependencies(allDependencies, it);
        }
    }
}

