/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.js.nodejs;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.FileTree;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.hash.FileHasher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.logging.GradleLoggingUtilsKt;
import org.jetbrains.kotlin.gradle.plugin.statistics.KotlinBuildStatsService;
import org.jetbrains.kotlin.gradle.targets.js.UtilsKt;
import org.jetbrains.kotlin.gradle.targets.js.nodejs.NodeJsEnv;
import org.jetbrains.kotlin.gradle.targets.js.nodejs.NodeJsRootExtension;
import org.jetbrains.kotlin.gradle.targets.js.nodejs.NodeJsRootPlugin;
import org.jetbrains.kotlin.gradle.targets.js.nodejs.NodeJsSetupTask;
import org.jetbrains.kotlin.gradle.utils.ArchiveOperationsCompat;
import org.jetbrains.kotlin.statistics.metrics.IStatisticsValuesConsumer;
import org.jetbrains.kotlin.statistics.metrics.NumericalMetrics;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 32\u00020\u0001:\u00013B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010-\u001a\u00020.H\u0007J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\rH\u0002J\u0018\u00102\u001a\u00020.2\u0006\u00101\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068AX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8G\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\r8G\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\u00138G\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001b\u0010\u0016\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001c\u001a\u00020\u001d8QX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!8QX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020\u00138G\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0015R\u001b\u0010&\u001a\u00020\r8GX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010\u001b\u001a\u0004\b'\u0010\u000fR\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/nodejs/NodeJsSetupTask;", "Lorg/gradle/api/DefaultTask;", "()V", "archiveOperations", "Lorg/jetbrains/kotlin/gradle/utils/ArchiveOperationsCompat;", "configuration", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/artifacts/Configuration;", "getConfiguration$kotlin_gradle_plugin", "()Lorg/gradle/api/provider/Provider;", "setConfiguration$kotlin_gradle_plugin", "(Lorg/gradle/api/provider/Provider;)V", "destination", "Ljava/io/File;", "getDestination", "()Ljava/io/File;", "destinationHashFile", "getDestinationHashFile", "downloadBaseUrl", "", "getDownloadBaseUrl", "()Ljava/lang/String;", "env", "Lorg/jetbrains/kotlin/gradle/targets/js/nodejs/NodeJsEnv;", "getEnv", "()Lorg/jetbrains/kotlin/gradle/targets/js/nodejs/NodeJsEnv;", "env$delegate", "Lkotlin/Lazy;", "fileHasher", "Lorg/gradle/internal/hash/FileHasher;", "getFileHasher$kotlin_gradle_plugin", "()Lorg/gradle/internal/hash/FileHasher;", "fs", "Lorg/gradle/api/file/FileSystemOperations;", "getFs$kotlin_gradle_plugin", "()Lorg/gradle/api/file/FileSystemOperations;", "ivyDependency", "getIvyDependency", "nodeJsDist", "getNodeJsDist", "nodeJsDist$delegate", "settings", "Lorg/jetbrains/kotlin/gradle/targets/js/nodejs/NodeJsRootExtension;", "shouldDownload", "", "exec", "", "fileTree", "Lorg/gradle/api/file/FileTree;", "archive", "unpackNodeArchive", "Companion", "kotlin-gradle-plugin"})
public abstract class NodeJsSetupTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final transient NodeJsRootExtension settings;
    @NotNull
    private final Lazy env$delegate;
    private final boolean shouldDownload;
    @NotNull
    private final ArchiveOperationsCompat archiveOperations;
    public transient Provider<Configuration> configuration;
    @NotNull
    private final Lazy nodeJsDist$delegate;
    @NotNull
    public static final String NAME = "kotlinNodeJsSetup";

    public NodeJsSetupTask() {
        Project project = this.getProject().getRootProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project.rootProject");
        this.settings = NodeJsRootPlugin.Companion.apply(project);
        this.env$delegate = LazyKt.lazy((Function0)((Function0)new Function0<NodeJsEnv>(this){
            final /* synthetic */ NodeJsSetupTask this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final NodeJsEnv invoke() {
                return (NodeJsEnv)NodeJsSetupTask.access$getSettings$p(this.this$0).requireConfigured();
            }
        }));
        this.shouldDownload = this.settings.getDownload();
        project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        this.archiveOperations = new ArchiveOperationsCompat(project);
        this.nodeJsDist$delegate = LazyKt.lazy((Function0)((Function0)new Function0<File>(this){
            final /* synthetic */ NodeJsSetupTask this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final File invoke() {
                IStatisticsValuesConsumer iStatisticsValuesConsumer;
                IvyArtifactRepository repo2 = this.this$0.getProject().getRepositories().ivy(new Action(this.this$0){
                    final /* synthetic */ NodeJsSetupTask this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public final void execute(IvyArtifactRepository repo2) {
                        repo2.setName(Intrinsics.stringPlus((String)"Node Distributions at ", (Object)this.this$0.getDownloadBaseUrl()));
                        repo2.setUrl(new URI(this.this$0.getDownloadBaseUrl()));
                        repo2.patternLayout((Action)nodeJsDist.repo.1.INSTANCE);
                        repo2.metadataSources((Action)nodeJsDist.repo.2.INSTANCE);
                        repo2.content((Action)nodeJsDist.repo.3.INSTANCE);
                    }
                });
                long startDownloadTime = System.currentTimeMillis();
                Set set2 = ((Configuration)this.this$0.getConfiguration$kotlin_gradle_plugin().get()).getFiles();
                Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"configuration.get().files");
                File dist = (File)CollectionsKt.single((Iterable)set2);
                long downloadDuration = System.currentTimeMillis() - startDownloadTime;
                if (downloadDuration > 0L && (iStatisticsValuesConsumer = KotlinBuildStatsService.Companion.getInstance()) != null) {
                    IStatisticsValuesConsumer.DefaultImpls.report$default(iStatisticsValuesConsumer, NumericalMetrics.ARTIFACTS_DOWNLOAD_SPEED, dist.length() * (long)1000 / downloadDuration, null, 4, null);
                }
                this.this$0.getProject().getRepositories().remove((Object)repo2);
                return dist;
            }
        }));
        this.onlyIf(new Spec(){

            public final boolean isSatisfiedBy(Task it) {
                return shouldDownload;
            }
        });
    }

    private final NodeJsEnv getEnv() {
        Lazy lazy = this.env$delegate;
        Object var2_2 = null;
        return (NodeJsEnv)lazy.getValue();
    }

    @Inject
    @NotNull
    public FileHasher getFileHasher$kotlin_gradle_plugin() {
        throw (Throwable)new IllegalStateException("Should be injected".toString());
    }

    @Inject
    @NotNull
    public FileSystemOperations getFs$kotlin_gradle_plugin() {
        throw (Throwable)new IllegalStateException("Should be injected".toString());
    }

    @Input
    @NotNull
    public final String getIvyDependency() {
        return this.getEnv().getIvyDependency();
    }

    @Input
    @NotNull
    public final String getDownloadBaseUrl() {
        return this.getEnv().getDownloadBaseUrl();
    }

    @OutputDirectory
    @NotNull
    public final File getDestination() {
        return this.getEnv().getNodeDir();
    }

    @OutputFile
    @NotNull
    public final File getDestinationHashFile() {
        File file = this.getDestination().getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"destination.parentFile");
        return FilesKt.resolve((File)file, (String)Intrinsics.stringPlus((String)this.getDestination().getName(), (Object)".hash"));
    }

    @Internal
    @NotNull
    public final Provider<Configuration> getConfiguration$kotlin_gradle_plugin() {
        Provider<Configuration> provider = this.configuration;
        if (provider != null) {
            return provider;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"configuration");
        return null;
    }

    public final void setConfiguration$kotlin_gradle_plugin(@NotNull Provider<Configuration> provider) {
        Intrinsics.checkNotNullParameter(provider, (String)"<set-?>");
        this.configuration = provider;
    }

    @Classpath
    @NotNull
    public final File getNodeJsDist() {
        Lazy lazy = this.nodeJsDist$delegate;
        Object var3_2 = null;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-nodeJsDist>(...)");
        return (File)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @TaskAction
    public final void exec() {
        boolean bl;
        File file;
        Logger logger = this.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
        GradleLoggingUtilsKt.kotlinInfo(logger, "Using node distribution from '" + this.getNodeJsDist() + '\'');
        Object dirHash = null;
        File file2 = file = this.getDestinationHashFile();
        boolean bl2 = false;
        if (file2.exists()) {
            File $this$useLines$iv = file2;
            Charset charset$iv = Charsets.UTF_8;
            boolean $i$f$useLines = false;
            Object object = $this$useLines$iv;
            int n = 8192;
            boolean bl3 = false;
            Object object2 = object;
            boolean bl4 = false;
            Object object3 = object2;
            boolean bl5 = false;
            object3 = new FileInputStream((File)object3);
            bl5 = false;
            object2 = new InputStreamReader((InputStream)object3, charset$iv);
            bl4 = false;
            object = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
            n = 0;
            bl3 = false;
            Throwable throwable = null;
            try {
                void it;
                String string;
                BufferedReader it$iv = (BufferedReader)object;
                boolean bl6 = false;
                Sequence it2 = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                boolean bl7 = false;
                String string2 = string = UtilsKt.calculateDirHash(this.getFileHasher$kotlin_gradle_plugin(), this.getDestination());
                Object object4 = SequencesKt.single((Sequence)it2);
                boolean bl8 = false;
                dirHash = it;
                Unit unit = Unit.INSTANCE;
                boolean bl9 = Intrinsics.areEqual((Object)object4, (Object)string);
                bl = bl9;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        } else {
            bl = false;
        }
        boolean upToDate = bl;
        File tmpDir = this.getTemporaryDir();
        File file3 = this.getNodeJsDist();
        Intrinsics.checkNotNullExpressionValue((Object)tmpDir, (String)"tmpDir");
        this.unpackNodeArchive(file3, tmpDir);
        if (upToDate) {
            FileHasher fileHasher = this.getFileHasher$kotlin_gradle_plugin();
            String string = this.getDestination().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"destination.name");
            String string3 = UtilsKt.calculateDirHash(fileHasher, FilesKt.resolve((File)tmpDir, (String)string));
            Intrinsics.checkNotNull((Object)string3);
            if (Intrinsics.areEqual((Object)string3, dirHash)) {
                return;
            }
        }
        if (this.getDestination().isDirectory()) {
            FilesKt.deleteRecursively((File)this.getDestination());
        }
        this.getFs$kotlin_gradle_plugin().copy(new Action(tmpDir, this){
            final /* synthetic */ File $tmpDir;
            final /* synthetic */ NodeJsSetupTask this$0;
            {
                this.$tmpDir = $tmpDir;
                this.this$0 = $receiver;
            }

            public final void execute(CopySpec it) {
                Object[] objectArray = new Object[]{this.$tmpDir};
                it.from(objectArray);
                it.into((Object)this.this$0.getDestination().getParentFile());
            }
        });
        FilesKt.deleteRecursively((File)tmpDir);
        if (!this.getEnv().isWindows()) {
            new File(this.getEnv().getNodeExecutable()).setExecutable(true);
        }
        File file4 = this.getDestinationHashFile();
        String string = UtilsKt.calculateDirHash(this.getFileHasher$kotlin_gradle_plugin(), this.getDestination());
        Intrinsics.checkNotNull((Object)string);
        FilesKt.writeText$default((File)file4, (String)string, null, (int)2, null);
    }

    private final void unpackNodeArchive(File archive, File destination) {
        Logger logger = this.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
        GradleLoggingUtilsKt.kotlinInfo(logger, "Unpacking " + archive + " to " + destination);
        this.getFs$kotlin_gradle_plugin().copy(new Action(this, archive, destination){
            final /* synthetic */ NodeJsSetupTask this$0;
            final /* synthetic */ File $archive;
            final /* synthetic */ File $destination;
            {
                this.this$0 = $receiver;
                this.$archive = $archive;
                this.$destination = $destination;
            }

            public final void execute(CopySpec it) {
                Object[] objectArray = new Object[]{NodeJsSetupTask.access$fileTree(this.this$0, this.$archive)};
                it.from(objectArray);
                it.into((Object)this.$destination);
            }
        });
    }

    private final FileTree fileTree(File archive) {
        String string = archive.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"archive.name");
        return StringsKt.endsWith$default((String)string, (String)"zip", (boolean)false, (int)2, null) ? this.archiveOperations.zipTree(archive) : this.archiveOperations.tarTree(archive);
    }

    public static final /* synthetic */ FileTree access$fileTree(NodeJsSetupTask $this, File archive) {
        return $this.fileTree(archive);
    }

    public static final /* synthetic */ NodeJsRootExtension access$getSettings$p(NodeJsSetupTask $this) {
        return $this.settings;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/nodejs/NodeJsSetupTask$Companion;", "", "()V", "NAME", "", "kotlin-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

