/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.report.metrics.BuildAttribute;
import org.jetbrains.kotlin.build.report.metrics.BuildMetrics;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporterImpl;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.build.report.metrics.DoNothingBuildMetricsReporter;
import org.jetbrains.kotlin.cli.common.CompilerSystemProperties;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.PropertiesKt;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.compilerRunner.GradleCompilationResults;
import org.jetbrains.kotlin.compilerRunner.GradleCompilerRunner;
import org.jetbrains.kotlin.compilerRunner.GradleCompilerServicesFacadeImpl;
import org.jetbrains.kotlin.compilerRunner.GradleIncrementalCompilerServicesFacadeImpl;
import org.jetbrains.kotlin.compilerRunner.GradleKotlinCompilerRunnerKt;
import org.jetbrains.kotlin.compilerRunner.GradleKotlinCompilerWork;
import org.jetbrains.kotlin.compilerRunner.GradleKotlinCompilerWorkArguments;
import org.jetbrains.kotlin.compilerRunner.IncrementalCompilationEnvironment;
import org.jetbrains.kotlin.compilerRunner.KotlinLogger;
import org.jetbrains.kotlin.compilerRunner.OutputItemsCollector;
import org.jetbrains.kotlin.compilerRunner.OutputItemsCollectorImpl;
import org.jetbrains.kotlin.compilerRunner.ReportUtilsKt;
import org.jetbrains.kotlin.compilerRunner.UtilsKt;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.daemon.common.CompilationOptions;
import org.jetbrains.kotlin.daemon.common.CompilationResultCategory;
import org.jetbrains.kotlin.daemon.common.CompilationResults;
import org.jetbrains.kotlin.daemon.common.CompileService;
import org.jetbrains.kotlin.daemon.common.CompilerMode;
import org.jetbrains.kotlin.daemon.common.CompilerServicesFacadeBase;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptions;
import org.jetbrains.kotlin.daemon.common.IncrementalCompilationOptions;
import org.jetbrains.kotlin.daemon.common.MultiModuleICSettings;
import org.jetbrains.kotlin.daemon.common.PropMapper;
import org.jetbrains.kotlin.daemon.common.ReportCategory;
import org.jetbrains.kotlin.daemon.common.ReportSeverity;
import org.jetbrains.kotlin.gradle.logging.GradleBufferingMessageCollector;
import org.jetbrains.kotlin.gradle.logging.GradleKotlinLogger;
import org.jetbrains.kotlin.gradle.logging.GradlePrintingMessageCollector;
import org.jetbrains.kotlin.gradle.logging.SL4JKotlinLogger;
import org.jetbrains.kotlin.gradle.plugin.internal.state.TaskExecutionResults;
import org.jetbrains.kotlin.gradle.plugin.internal.state.TaskLoggers;
import org.jetbrains.kotlin.gradle.report.BuildReportMode;
import org.jetbrains.kotlin.gradle.report.ReportingSettings;
import org.jetbrains.kotlin.gradle.report.TaskExecutionInfo;
import org.jetbrains.kotlin.gradle.report.TaskExecutionProperties;
import org.jetbrains.kotlin.gradle.report.TaskExecutionResult;
import org.jetbrains.kotlin.gradle.tasks.TasksUtilsKt;
import org.jetbrains.kotlin.gradle.utils.ErrorUtilsKt;
import org.jetbrains.kotlin.incremental.ChangedFiles;
import org.jetbrains.kotlin.incremental.ClasspathChanges;
import org.jetbrains.kotlin.incremental.IncrementalModuleInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 A2\u00020\u0001:\u0001AB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\b\u0010*\u001a\u00020&H\u0002J\u0012\u0010+\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010,\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J.\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020/2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0002J.\u00107\u001a\b\u0012\u0004\u0012\u00020/0.2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020/2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0002J\u001b\u00108\u001a\b\u0012\u0004\u0012\u00020/0\u000b2\u0006\u00109\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010:J\u0010\u0010;\u001a\u00020/2\u0006\u00109\u001a\u00020\u0006H\u0002J\u000e\u0010<\u001a\b\u0012\u0004\u0012\u00020>0=H\u0002J\b\u0010?\u001a\u00020@H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/GradleKotlinCompilerWork;", "Ljava/lang/Runnable;", "config", "Lorg/jetbrains/kotlin/compilerRunner/GradleKotlinCompilerWorkArguments;", "(Lorg/jetbrains/kotlin/compilerRunner/GradleKotlinCompilerWorkArguments;)V", "allWarningsAsErrors", "", "buildDir", "Ljava/io/File;", "clientIsAliveFlagFile", "compilerArgs", "", "", "[Ljava/lang/String;", "compilerClassName", "compilerFullClasspath", "", "daemonJvmArgs", "icLogLines", "incrementalCompilationEnvironment", "Lorg/jetbrains/kotlin/compilerRunner/IncrementalCompilationEnvironment;", "incrementalModuleInfo", "Lorg/jetbrains/kotlin/incremental/IncrementalModuleInfo;", "isIncremental", "()Z", "isVerbose", "kotlinScriptExtensions", "log", "Lorg/jetbrains/kotlin/compilerRunner/KotlinLogger;", "metrics", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporter;", "outputFiles", "projectRootFile", "reportingSettings", "Lorg/jetbrains/kotlin/gradle/report/ReportingSettings;", "sessionFlagFile", "taskPath", "compileInProcess", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "compileInProcessImpl", "compileOutOfProcess", "compileWithDaemon", "compileWithDaemonOrFallbackImpl", "incrementalCompilationWithDaemon", "Lorg/jetbrains/kotlin/daemon/common/CompileService$CallResult;", "", "daemon", "Lorg/jetbrains/kotlin/daemon/common/CompileService;", "sessionId", "targetPlatform", "Lorg/jetbrains/kotlin/daemon/common/CompileService$TargetPlatform;", "bufferingMessageCollector", "Lorg/jetbrains/kotlin/gradle/logging/GradleBufferingMessageCollector;", "nonIncrementalCompilationWithDaemon", "reportCategories", "verbose", "(Z)[Ljava/lang/Integer;", "reportSeverity", "requestedCompilationResults", "Ljava/util/EnumSet;", "Lorg/jetbrains/kotlin/daemon/common/CompilationResultCategory;", "run", "", "Companion", "kotlin-gradle-plugin"})
public final class GradleKotlinCompilerWork
implements Runnable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File projectRootFile;
    @NotNull
    private final File clientIsAliveFlagFile;
    @NotNull
    private final File sessionFlagFile;
    @NotNull
    private final List<File> compilerFullClasspath;
    @NotNull
    private final String compilerClassName;
    @NotNull
    private final String[] compilerArgs;
    private final boolean isVerbose;
    @Nullable
    private final IncrementalCompilationEnvironment incrementalCompilationEnvironment;
    @Nullable
    private final IncrementalModuleInfo incrementalModuleInfo;
    @NotNull
    private final List<File> outputFiles;
    @NotNull
    private final String taskPath;
    @NotNull
    private final ReportingSettings reportingSettings;
    @NotNull
    private final String[] kotlinScriptExtensions;
    private final boolean allWarningsAsErrors;
    @NotNull
    private final File buildDir;
    @NotNull
    private final BuildMetricsReporter metrics;
    @NotNull
    private List<String> icLogLines;
    @Nullable
    private final List<String> daemonJvmArgs;
    @NotNull
    private final KotlinLogger log;

    /*
     * WARNING - void declaration
     */
    @Inject
    public GradleKotlinCompilerWork(@NotNull GradleKotlinCompilerWorkArguments config) {
        KotlinLogger kotlinLogger2;
        GradleKotlinCompilerWork gradleKotlinCompilerWork;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.projectRootFile = config.getProjectFiles().getProjectRootFile();
        this.clientIsAliveFlagFile = config.getProjectFiles().getClientIsAliveFlagFile();
        this.sessionFlagFile = config.getProjectFiles().getSessionFlagFile();
        this.compilerFullClasspath = config.getCompilerFullClasspath();
        this.compilerClassName = config.getCompilerClassName();
        this.compilerArgs = config.getCompilerArgs();
        this.isVerbose = config.isVerbose();
        this.incrementalCompilationEnvironment = config.getIncrementalCompilationEnvironment();
        this.incrementalModuleInfo = config.getIncrementalModuleInfo();
        this.outputFiles = config.getOutputFiles();
        this.taskPath = config.getTaskPath();
        this.reportingSettings = config.getReportingSettings();
        this.kotlinScriptExtensions = config.getKotlinScriptExtensions();
        this.allWarningsAsErrors = config.getAllWarningsAsErrors();
        this.buildDir = config.getProjectFiles().getBuildDir();
        this.metrics = this.reportingSettings.getReportMetrics() ? (BuildMetricsReporter)new BuildMetricsReporterImpl() : (BuildMetricsReporter)DoNothingBuildMetricsReporter.INSTANCE;
        this.icLogLines = CollectionsKt.emptyList();
        this.daemonJvmArgs = config.getDaemonJvmArgs();
        GradleKotlinCompilerWork gradleKotlinCompilerWork2 = this;
        org.gradle.api.logging.Logger logger = TaskLoggers.INSTANCE.get(this.taskPath);
        if (logger == null) {
            void $this$log_u24lambda_u2d3;
            KotlinLogger kotlinLogger3;
            KotlinLogger kotlinLogger4;
            KotlinLogger kotlinLogger5;
            GradleKotlinCompilerWork gradleKotlinCompilerWork3;
            GradleKotlinCompilerWork gradleKotlinCompilerWork4 = gradleKotlinCompilerWork3 = this;
            GradleKotlinCompilerWork gradleKotlinCompilerWork5 = gradleKotlinCompilerWork2;
            boolean bl = false;
            Logger logger2 = LoggerFactory.getLogger((String)"GradleKotlinCompilerWork");
            if (logger2 instanceof org.gradle.api.logging.Logger) {
                kotlinLogger5 = new GradleKotlinLogger((org.gradle.api.logging.Logger)logger2);
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"logger");
                kotlinLogger5 = new SL4JKotlinLogger(logger2);
            }
            KotlinLogger $this$log_u24lambda_u2d3_u24lambda_u2d2 = kotlinLogger4 = (kotlinLogger3 = kotlinLogger5);
            boolean bl2 = false;
            $this$log_u24lambda_u2d3_u24lambda_u2d2.debug("Could not get logger for '" + $this$log_u24lambda_u2d3.taskPath + "'. Falling back to sl4j logger");
            KotlinLogger kotlinLogger6 = kotlinLogger4;
            gradleKotlinCompilerWork = gradleKotlinCompilerWork5;
            kotlinLogger2 = kotlinLogger6;
        } else {
            void it;
            GradleKotlinLogger gradleKotlinLogger;
            org.gradle.api.logging.Logger logger3;
            org.gradle.api.logging.Logger $this$log_u24lambda_u2d3 = logger3 = logger;
            GradleKotlinCompilerWork gradleKotlinCompilerWork6 = gradleKotlinCompilerWork2;
            boolean bl = false;
            GradleKotlinLogger $this$log_u24lambda_u2d1_u24lambda_u2d0 = gradleKotlinLogger = new GradleKotlinLogger((org.gradle.api.logging.Logger)it);
            boolean bl3 = false;
            $this$log_u24lambda_u2d1_u24lambda_u2d0.debug("Using '" + this.taskPath + "' logger");
            GradleKotlinLogger gradleKotlinLogger2 = gradleKotlinLogger;
            gradleKotlinCompilerWork = gradleKotlinCompilerWork6;
            kotlinLogger2 = gradleKotlinLogger2;
        }
        gradleKotlinCompilerWork.log = kotlinLogger2;
    }

    private final boolean isIncremental() {
        return this.incrementalCompilationEnvironment != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean it;
        ArrayList<TaskExecutionProperties> properties2;
        IncrementalCompilationEnvironment incrementalCompilationEnvironment;
        Object exitCode;
        try {
            GradlePrintingMessageCollector messageCollector = new GradlePrintingMessageCollector(this.log, this.allWarningsAsErrors);
            exitCode = this.compileWithDaemonOrFallbackImpl(messageCollector);
            incrementalCompilationEnvironment = this.incrementalCompilationEnvironment;
            if (incrementalCompilationEnvironment == null ? false : incrementalCompilationEnvironment.getDisableMultiModuleIC()) {
                this.incrementalCompilationEnvironment.getMultiModuleICSettings().getBuildHistoryFile().delete();
            }
            TasksUtilsKt.throwGradleExceptionIfError(exitCode);
            properties2 = new ArrayList<TaskExecutionProperties>();
        }
        catch (Throwable throwable) {
            boolean it2;
            Boolean it3;
            ArrayList<TaskExecutionProperties> properties3 = new ArrayList<TaskExecutionProperties>();
            Boolean result2 = PropertiesKt.toBooleanLenient((String)CompilerSystemProperties.COMPILE_INCREMENTAL_WITH_CLASSPATH_SNAPSHOTS.getValue());
            if (result2 != null) {
                it3 = result2;
                it2 = it3;
                boolean bl = false;
                if (it2) {
                    properties3.add(TaskExecutionProperties.ABI_SNAPSHOT);
                }
            }
            result2 = PropertiesKt.toBooleanLenient((String)CompilerSystemProperties.COMPILE_INCREMENTAL_WITH_ARTIFACT_TRANSFORM.getValue());
            if (result2 != null) {
                it3 = result2;
                it2 = it3;
                boolean bl = false;
                if (it2) {
                    properties3.add(TaskExecutionProperties.ARTIFACT_TRANSFORM);
                }
            }
            IncrementalCompilationEnvironment incrementalCompilationEnvironment2 = this.incrementalCompilationEnvironment;
            it3 = incrementalCompilationEnvironment2 == null ? null : incrementalCompilationEnvironment2.getChangedFiles();
            TaskExecutionInfo taskInfo = new TaskExecutionInfo((List<? extends TaskExecutionProperties>)properties3, (ChangedFiles)it3);
            incrementalCompilationEnvironment2 = this.metrics.getMetrics();
            List<String> list2 = this.icLogLines;
            TaskExecutionResult result3 = new TaskExecutionResult((BuildMetrics)incrementalCompilationEnvironment2, taskInfo, list2);
            TaskExecutionResults.INSTANCE.set(this.taskPath, result3);
            throw throwable;
        }
        exitCode = PropertiesKt.toBooleanLenient((String)CompilerSystemProperties.COMPILE_INCREMENTAL_WITH_CLASSPATH_SNAPSHOTS.getValue());
        if (exitCode != null) {
            incrementalCompilationEnvironment = exitCode;
            it = (Boolean)((Object)incrementalCompilationEnvironment);
            boolean bl = false;
            if (it) {
                properties2.add(TaskExecutionProperties.ABI_SNAPSHOT);
            }
        }
        exitCode = PropertiesKt.toBooleanLenient((String)CompilerSystemProperties.COMPILE_INCREMENTAL_WITH_ARTIFACT_TRANSFORM.getValue());
        if (exitCode != null) {
            incrementalCompilationEnvironment = exitCode;
            it = (Boolean)((Object)incrementalCompilationEnvironment);
            boolean bl = false;
            if (it) {
                properties2.add(TaskExecutionProperties.ARTIFACT_TRANSFORM);
            }
        }
        IncrementalCompilationEnvironment it3 = this.incrementalCompilationEnvironment;
        incrementalCompilationEnvironment = it3 == null ? null : it3.getChangedFiles();
        TaskExecutionInfo taskInfo = new TaskExecutionInfo((List<? extends TaskExecutionProperties>)properties2, (ChangedFiles)incrementalCompilationEnvironment);
        it3 = this.metrics.getMetrics();
        List<String> bl = this.icLogLines;
        TaskExecutionResult result2 = new TaskExecutionResult((BuildMetrics)it3, taskInfo, bl);
        TaskExecutionResults.INSTANCE.set(this.taskPath, result2);
    }

    private final ExitCode compileWithDaemonOrFallbackImpl(MessageCollector messageCollector) {
        Boolean bl;
        String string;
        String msg$iv;
        KotlinLogger kotlinLogger2;
        KotlinLogger $this$compileWithDaemonOrFallbackImpl_u24lambda_u2d9 = kotlinLogger2 = this.log;
        boolean bl2 = false;
        KotlinLogger $this$kotlinDebug$iv = $this$compileWithDaemonOrFallbackImpl_u24lambda_u2d9;
        boolean $i$f$kotlinDebug = false;
        if ($this$kotlinDebug$iv.isDebugEnabled()) {
            boolean bl3 = false;
            msg$iv = Intrinsics.stringPlus((String)"Kotlin compiler class: ", (Object)this.compilerClassName);
            $this$kotlinDebug$iv.debug(Intrinsics.stringPlus((String)"[KOTLIN] ", (Object)msg$iv));
        }
        $this$kotlinDebug$iv = $this$compileWithDaemonOrFallbackImpl_u24lambda_u2d9;
        $i$f$kotlinDebug = false;
        if ($this$kotlinDebug$iv.isDebugEnabled()) {
            boolean bl4 = false;
            msg$iv = Intrinsics.stringPlus((String)"Kotlin compiler classpath: ", (Object)CollectionsKt.joinToString$default((Iterable)this.compilerFullClasspath, null, null, null, (int)0, null, (Function1)compileWithDaemonOrFallbackImpl.1.2.1.INSTANCE, (int)31, null));
            $this$kotlinDebug$iv.debug(Intrinsics.stringPlus((String)"[KOTLIN] ", (Object)msg$iv));
        }
        $this$kotlinDebug$iv = $this$compileWithDaemonOrFallbackImpl_u24lambda_u2d9;
        $i$f$kotlinDebug = false;
        if ($this$kotlinDebug$iv.isDebugEnabled()) {
            boolean bl5 = false;
            msg$iv = this.taskPath + " Kotlin compiler args: " + ArraysKt.joinToString$default((Object[])this.compilerArgs, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
            $this$kotlinDebug$iv.debug(Intrinsics.stringPlus((String)"[KOTLIN] ", (Object)msg$iv));
        }
        String executionStrategy = GradleKotlinCompilerRunnerKt.kotlinCompilerExecutionStrategy();
        if (Intrinsics.areEqual((Object)executionStrategy, (Object)"daemon")) {
            ExitCode daemonExitCode = this.compileWithDaemon(messageCollector);
            if (daemonExitCode != null) {
                return daemonExitCode;
            }
            this.log.warn("Could not connect to kotlin daemon. Using fallback strategy.");
        }
        if ((string = System.getProperty("org.gradle.daemon")) == null) {
            bl = null;
        } else {
            String string2;
            String p0 = string2 = string;
            boolean bl6 = false;
            bl = Boolean.parseBoolean(p0);
        }
        Boolean isGradleDaemonUsed = bl;
        return Intrinsics.areEqual((Object)executionStrategy, (Object)"in-process") || Intrinsics.areEqual((Object)isGradleDaemonUsed, (Object)false) ? this.compileInProcess(messageCollector) : this.compileOutOfProcess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final ExitCode compileWithDaemon(MessageCollector messageCollector) {
        ExitCode res;
        CompileService.TargetPlatform targetPlatform;
        long end$iv;
        GradleCompilerRunner.Companion companion;
        KotlinLogger kotlinLogger2;
        Object object;
        void $this$measure$iv;
        String string;
        boolean isDebugEnabled = this.log.isDebugEnabled() || ((string = System.getProperty("kotlin.daemon.debug.log")) == null ? true : Boolean.parseBoolean(string));
        MessageCollector daemonMessageCollector = isDebugEnabled ? messageCollector : MessageCollector.Companion.getNONE();
        Object object2 = this.metrics;
        BuildTime time$iv = BuildTime.CONNECT_TO_DAEMON;
        boolean $i$f$measure = false;
        long start$iv = System.nanoTime();
        $this$measure$iv.startMeasure(time$iv, start$iv);
        try {
            GradleCompilerRunner.Companion companion2;
            boolean bl = false;
            try {
                companion2 = GradleCompilerRunner.Companion;
                File file = this.clientIsAliveFlagFile;
                object = this.sessionFlagFile;
                kotlinLogger2 = this.compilerFullClasspath;
                List<String> list2 = this.daemonJvmArgs;
                companion2 = companion2.getDaemonConnectionImpl$kotlin_gradle_plugin(file, (File)object, (List<? extends File>)kotlinLogger2, daemonMessageCollector, list2, isDebugEnabled);
            }
            catch (Throwable e) {
                this.log.error("Caught an exception trying to connect to Kotlin Daemon:");
                this.log.error(ErrorUtilsKt.stackTraceAsString(e));
                companion2 = null;
            }
            companion = companion2;
        }
        finally {
            end$iv = System.nanoTime();
            $this$measure$iv.endMeasure(time$iv, end$iv);
        }
        GradleCompilerRunner.Companion connection = companion;
        if (connection == null) {
            if (this.isIncremental()) {
                this.log.warn("Could not perform incremental compilation: Could not connect to Kotlin compile daemon");
            } else {
                this.log.warn("Could not connect to Kotlin compile daemon");
            }
            return null;
        }
        object2 = connection;
        CompileService daemon = object2.component1();
        int sessionId = object2.component2();
        if (this.log.isDebugEnabled()) {
            Object object3;
            Object it = object3 = daemon.getDaemonJVMOptions();
            boolean bl = false;
            Object object4 = start$iv = it.isGood() ? object3 : null;
            if (start$iv != null) {
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                Object jvmOpts = object3 = start$iv;
                boolean bl2 = false;
                Iterable e = ((DaemonJVMOptions)jvmOpts.get()).getMappers();
                object = "Kotlin compile daemon JVM options: ";
                kotlinLogger2 = this.log;
                boolean $i$f$flatMap = false;
                companion = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    PropMapper it2 = (PropMapper)element$iv$iv;
                    boolean bl3 = false;
                    Iterable list$iv$iv = it2.toArgs("-");
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                List list3 = (List)destination$iv$iv;
                kotlinLogger2.debug(Intrinsics.stringPlus((String)object, (Object)list3));
            }
        }
        switch (this.compilerClassName) {
            case "org.jetbrains.kotlin.cli.jvm.K2JVMCompiler": {
                targetPlatform = CompileService.TargetPlatform.JVM;
                break;
            }
            case "org.jetbrains.kotlin.cli.js.K2JSCompiler": {
                targetPlatform = CompileService.TargetPlatform.JS;
                break;
            }
            case "org.jetbrains.kotlin.cli.metadata.K2MetadataCompiler": {
                targetPlatform = CompileService.TargetPlatform.METADATA;
                break;
            }
            default: {
                throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Unknown compiler type ", (Object)this.compilerClassName));
            }
        }
        CompileService.TargetPlatform targetPlatform2 = targetPlatform;
        GradleBufferingMessageCollector bufferingMessageCollector = new GradleBufferingMessageCollector();
        try {
            res = this.isIncremental() ? this.incrementalCompilationWithDaemon(daemon, sessionId, targetPlatform2, bufferingMessageCollector) : this.nonIncrementalCompilationWithDaemon(daemon, sessionId, targetPlatform2, bufferingMessageCollector);
            bufferingMessageCollector.flush(messageCollector);
            res = ReportUtilsKt.exitCodeFromProcessExitCode(this.log, ((Number)res.get()).intValue());
        }
        catch (Throwable e) {
            bufferingMessageCollector.flush(messageCollector);
            this.log.error("Compilation with Kotlin compile daemon was not successful");
            this.log.error(ErrorUtilsKt.stackTraceAsString(e));
            res = null;
        }
        ExitCode exitCode = res;
        try {
            void $this$measure$iv2;
            res = this.metrics;
            BuildTime time$iv2 = BuildTime.CLEAR_JAR_CACHE;
            boolean $i$f$measure2 = false;
            long start$iv2 = System.nanoTime();
            $this$measure$iv2.startMeasure(time$iv2, start$iv2);
            try {
                boolean bl = false;
                daemon.clearJarCache();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                end$iv = System.nanoTime();
                $this$measure$iv2.endMeasure(time$iv2, end$iv);
            }
        }
        catch (RemoteException e) {
            this.log.warn(Intrinsics.stringPlus((String)"Unable to clear jar cache after compilation, maybe daemon is already down: ", (Object)e));
        }
        ReportUtilsKt.logFinish(this.log, "daemon");
        return exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final CompileService.CallResult<Integer> nonIncrementalCompilationWithDaemon(CompileService daemon, int sessionId, CompileService.TargetPlatform targetPlatform, GradleBufferingMessageCollector bufferingMessageCollector) {
        CompileService.CallResult callResult;
        void $this$measure$iv;
        this.metrics.addAttribute(BuildAttribute.IC_IS_NOT_ENABLED);
        boolean $i$f$emptyArray = false;
        CompilationOptions compilationOptions = new CompilationOptions(CompilerMode.NON_INCREMENTAL_COMPILER, targetPlatform, this.reportCategories(this.isVerbose), this.reportSeverity(this.isVerbose), new Integer[0], this.kotlinScriptExtensions);
        GradleCompilerServicesFacadeImpl servicesFacade = new GradleCompilerServicesFacadeImpl(this.log, bufferingMessageCollector, 0, 4, null);
        GradleCompilationResults compilationResults = new GradleCompilationResults(this.log, this.projectRootFile);
        BuildMetricsReporter buildMetricsReporter = this.metrics;
        BuildTime time$iv = BuildTime.NON_INCREMENTAL_COMPILATION_DAEMON;
        boolean $i$f$measure = false;
        long start$iv = System.nanoTime();
        $this$measure$iv.startMeasure(time$iv, start$iv);
        try {
            boolean bl = false;
            callResult = daemon.compile(sessionId, this.compilerArgs, compilationOptions, (CompilerServicesFacadeBase)servicesFacade, (CompilationResults)compilationResults);
        }
        finally {
            long end$iv = System.nanoTime();
            $this$measure$iv.endMeasure(time$iv, end$iv);
        }
        BuildMetricsReporter it = buildMetricsReporter = callResult;
        boolean bl = false;
        this.metrics.addMetrics(compilationResults.getBuildMetrics());
        this.icLogLines = compilationResults.getIcLogLines();
        return buildMetricsReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final CompileService.CallResult<Integer> incrementalCompilationWithDaemon(CompileService daemon, int sessionId, CompileService.TargetPlatform targetPlatform, GradleBufferingMessageCollector bufferingMessageCollector) {
        void $this$measure$iv;
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        IncrementalCompilationEnvironment incrementalCompilationEnvironment = this.incrementalCompilationEnvironment;
        if (incrementalCompilationEnvironment == null) {
            throw (Throwable)new IllegalStateException("incrementalCompilationEnvironment is null!".toString());
        }
        IncrementalCompilationEnvironment icEnv = incrementalCompilationEnvironment;
        ChangedFiles changedFiles = icEnv.getChangedFiles();
        ChangedFiles.Known knownChangedFiles = changedFiles instanceof ChangedFiles.Known ? (ChangedFiles.Known)changedFiles : null;
        EnumSet<CompilationResultCategory> requestedCompilationResults = this.requestedCompilationResults();
        boolean bl = knownChangedFiles != null;
        Object object = knownChangedFiles;
        List list2 = object == null ? null : object.getModified();
        ChangedFiles.Known known = knownChangedFiles;
        object = known == null ? null : known.getRemoved();
        known = icEnv.getClasspathChanges();
        File file = icEnv.getWorkingDir();
        Integer[] integerArray = this.reportCategories(this.isVerbose);
        int n = this.reportSeverity(this.isVerbose);
        List<File> $this$map$iv = (List<File>)((Object)requestedCompilationResults);
        boolean $i$f$map = false;
        List<File> list3 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CompilationResultCategory compilationResultCategory = (CompilationResultCategory)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Integer n2 = it.getCode();
            collection.add(n2);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        Integer[] integerArray2 = thisCollection$iv.toArray(new Integer[0]);
        if (integerArray2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Integer[] integerArray3 = integerArray2;
        CompilerMode compilerMode = CompilerMode.INCREMENTAL_COMPILER;
        $i$f$toTypedArray = icEnv.getUsePreciseJavaTracking();
        list3 = this.outputFiles;
        MultiModuleICSettings multiModuleICSettings = icEnv.getMultiModuleICSettings();
        IncrementalModuleInfo incrementalModuleInfo = this.incrementalModuleInfo;
        Intrinsics.checkNotNull((Object)incrementalModuleInfo);
        IncrementalModuleInfo incrementalModuleInfo2 = incrementalModuleInfo;
        String[] stringArray = this.kotlinScriptExtensions;
        IncrementalCompilationOptions compilationOptions = new IncrementalCompilationOptions(bl, list2, (List)object, (ClasspathChanges)known, file, compilerMode, targetPlatform, integerArray, n, integerArray3, $i$f$toTypedArray, list3, multiModuleICSettings, incrementalModuleInfo2, stringArray);
        this.log.info(Intrinsics.stringPlus((String)"Options for KOTLIN DAEMON: ", (Object)compilationOptions));
        GradleIncrementalCompilerServicesFacadeImpl servicesFacade = new GradleIncrementalCompilerServicesFacadeImpl(this.log, bufferingMessageCollector, 0, 4, null);
        GradleCompilationResults compilationResults = new GradleCompilationResults(this.log, this.projectRootFile);
        object = this.metrics;
        BuildTime time$iv = BuildTime.RUN_COMPILER;
        boolean $i$f$measure = false;
        long start$iv = System.nanoTime();
        $this$measure$iv.startMeasure(time$iv, start$iv);
        try {
            boolean bl3 = false;
            compilerMode = daemon.compile(sessionId, this.compilerArgs, (CompilationOptions)compilationOptions, (CompilerServicesFacadeBase)servicesFacade, (CompilationResults)compilationResults);
        }
        finally {
            long end$iv = System.nanoTime();
            $this$measure$iv.endMeasure(time$iv, end$iv);
        }
        Object it = object = compilerMode;
        boolean bl4 = false;
        this.metrics.addMetrics(compilationResults.getBuildMetrics());
        this.icLogLines = compilationResults.getIcLogLines();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final ExitCode compileOutOfProcess() {
        ExitCode exitCode;
        void $this$measure$iv;
        this.metrics.addAttribute(BuildAttribute.OUT_OF_PROCESS_EXECUTION);
        TasksUtilsKt.clearLocalState((Iterable<? extends File>)this.outputFiles, this.log, this.metrics, "out-of-process execution strategy is non-incremental");
        BuildMetricsReporter buildMetricsReporter = this.metrics;
        BuildTime time$iv = BuildTime.NON_INCREMENTAL_COMPILATION_OUT_OF_PROCESS;
        boolean $i$f$measure = false;
        long start$iv = System.nanoTime();
        $this$measure$iv.startMeasure(time$iv, start$iv);
        try {
            boolean bl = false;
            exitCode = ReportUtilsKt.runToolInSeparateProcess$default(this.compilerArgs, this.compilerClassName, this.compilerFullClasspath, this.log, this.buildDir, null, 32, null);
        }
        finally {
            long end$iv = System.nanoTime();
            $this$measure$iv.endMeasure(time$iv, end$iv);
        }
        return exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ExitCode compileInProcess(MessageCollector messageCollector) {
        Object object;
        this.metrics.addAttribute(BuildAttribute.IN_PROCESS_EXECUTION);
        TasksUtilsKt.clearLocalState((Iterable<? extends File>)this.outputFiles, this.log, this.metrics, "in-process execution strategy is non-incremental");
        this.metrics.startMeasure(BuildTime.NON_INCREMENTAL_COMPILATION_IN_PROCESS, System.nanoTime());
        ExecutorService threadPool = Executors.newSingleThreadExecutor();
        GradleBufferingMessageCollector bufferingMessageCollector = new GradleBufferingMessageCollector();
        try {
            Future future2 = threadPool.submit(new Callable(this, bufferingMessageCollector){
                final /* synthetic */ GradleKotlinCompilerWork this$0;
                final /* synthetic */ GradleBufferingMessageCollector $bufferingMessageCollector;
                {
                    this.this$0 = $receiver;
                    this.$bufferingMessageCollector = $bufferingMessageCollector;
                }

                public final ExitCode call() {
                    return GradleKotlinCompilerWork.access$compileInProcessImpl(this.this$0, this.$bufferingMessageCollector);
                }
            });
            object = future2.get();
            Intrinsics.checkNotNullExpressionValue(object, (String)"private fun compileInPro\u2026noTime())\n        }\n    }");
            object = (ExitCode)object;
        }
        finally {
            bufferingMessageCollector.flush(messageCollector);
            threadPool.shutdown();
            this.metrics.endMeasure(BuildTime.NON_INCREMENTAL_COMPILATION_IN_PROCESS, System.nanoTime());
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final ExitCode compileInProcessImpl(MessageCollector messageCollector) {
        void $this$toTypedArray$iv;
        Collection<URL> collection;
        void $this$mapTo$iv$iv;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(stream);
        Iterable $this$map$iv = this.compilerFullClasspath;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            URL uRL = it.toURI().toURL();
            collection.add(uRL);
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = collection;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        URL[] uRLArray = thisCollection$iv.toArray(new URL[0]);
        if (uRLArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        URL[] uRLArray2 = uRLArray;
        URLClassLoader classLoader = new URLClassLoader(uRLArray2);
        Class<?> servicesClass = Class.forName(Services.class.getCanonicalName(), true, classLoader);
        Object emptyServices = servicesClass.getField("EMPTY").get(servicesClass);
        Class<?> compiler = Class.forName(this.compilerClassName, true, classLoader);
        Class[] $i$f$mapTo22 = new Class[]{PrintStream.class, servicesClass, String[].class};
        Method exec2 = compiler.getMethod("execAndOutputXml", $i$f$mapTo22);
        Object[] objectArray = new Object[]{out, emptyServices, this.compilerArgs};
        Object res = exec2.invoke(compiler.newInstance(), objectArray);
        ExitCode exitCode = ExitCode.valueOf((String)res.toString());
        UtilsKt.processCompilerOutput((MessageCollector)messageCollector, (OutputItemsCollector)((OutputItemsCollector)new OutputItemsCollectorImpl()), (ByteArrayOutputStream)stream, (ExitCode)exitCode);
        ReportUtilsKt.logFinish(this.log, "in-process");
        return exitCode;
    }

    private final EnumSet<CompilationResultCategory> requestedCompilationResults() {
        CompilationResultCategory compilationResultCategory;
        EnumSet<Enum> requestedCompilationResults = EnumSet.of((Enum)CompilationResultCategory.IC_COMPILE_ITERATION);
        BuildReportMode buildReportMode = this.reportingSettings.getBuildReportMode();
        int n = WhenMappings.$EnumSwitchMapping$0[buildReportMode.ordinal()];
        switch (n) {
            case 1: {
                compilationResultCategory = null;
                break;
            }
            case 2: {
                compilationResultCategory = CompilationResultCategory.BUILD_REPORT_LINES;
                break;
            }
            case 3: {
                compilationResultCategory = CompilationResultCategory.VERBOSE_BUILD_REPORT_LINES;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        CompilationResultCategory compilationResultCategory2 = compilationResultCategory;
        if (compilationResultCategory2 != null) {
            BuildReportMode it = buildReportMode = compilationResultCategory2;
            boolean bl = false;
            requestedCompilationResults.add(it);
        }
        if (this.reportingSettings.getReportMetrics()) {
            requestedCompilationResults.add((Enum)CompilationResultCategory.BUILD_METRICS);
        }
        Intrinsics.checkNotNullExpressionValue(requestedCompilationResults, (String)"requestedCompilationResults");
        return requestedCompilationResults;
    }

    /*
     * WARNING - void declaration
     */
    private final Integer[] reportCategories(boolean verbose) {
        Integer[] integerArray;
        if (!verbose) {
            Integer[] integerArray2 = new Integer[]{ReportCategory.COMPILER_MESSAGE.getCode()};
            integerArray = integerArray2;
        } else {
            void $this$mapTo$iv$iv;
            ReportCategory[] $this$map$iv = ReportCategory.values();
            boolean $i$f$map = false;
            ReportCategory[] reportCategoryArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            void var7_8 = $this$mapTo$iv$iv;
            int n = ((void)var7_8).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var11_12 = item$iv$iv = var7_8[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Integer n2 = it.getCode();
                collection.add(n2);
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Integer[] integerArray3 = thisCollection$iv.toArray(new Integer[0]);
            if (integerArray3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            integerArray = integerArray3;
        }
        return integerArray;
    }

    private final int reportSeverity(boolean verbose) {
        return !verbose ? ReportSeverity.INFO.getCode() : ReportSeverity.DEBUG.getCode();
    }

    public static final /* synthetic */ ExitCode access$compileInProcessImpl(GradleKotlinCompilerWork $this, MessageCollector messageCollector) {
        return $this.compileInProcessImpl(messageCollector);
    }

    static {
        if (Intrinsics.areEqual((Object)System.getProperty("org.jetbrains.kotlin.compilerRunner.GradleKotlinCompilerWork.trace.loading"), (Object)"true")) {
            System.out.println((Object)"Loaded GradleKotlinCompilerWork");
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/GradleKotlinCompilerWork$Companion;", "", "()V", "kotlin-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BuildReportMode.values().length];
            nArray[BuildReportMode.NONE.ordinal()] = 1;
            nArray[BuildReportMode.SIMPLE.ordinal()] = 2;
            nArray[BuildReportMode.VERBOSE.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

