/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.CharRange;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.jvm.tasks.Jar;
import org.gradle.workers.WorkQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.CommonToolArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArgumentsKt;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2MetadataCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.ParseCommandLineArgumentsKt;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.compilerRunner.ArgumentUtils;
import org.jetbrains.kotlin.compilerRunner.GradleCompilerEnvironment;
import org.jetbrains.kotlin.compilerRunner.GradleKotlinCompilerWork;
import org.jetbrains.kotlin.compilerRunner.GradleKotlinCompilerWorkArguments;
import org.jetbrains.kotlin.compilerRunner.IncrementalCompilationEnvironment;
import org.jetbrains.kotlin.compilerRunner.KotlinCompilerRunnerUtils;
import org.jetbrains.kotlin.compilerRunner.ProjectFilesForCompilation;
import org.jetbrains.kotlin.compilerRunner.ReportUtilsKt;
import org.jetbrains.kotlin.daemon.client.CompileServiceSession;
import org.jetbrains.kotlin.daemon.common.CompilerId;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptions;
import org.jetbrains.kotlin.daemon.common.DaemonParamsKt;
import org.jetbrains.kotlin.daemon.common.RestPropMapper;
import org.jetbrains.kotlin.gradle.dsl.KotlinCompile;
import org.jetbrains.kotlin.gradle.dsl.KotlinMultiplatformExtension;
import org.jetbrains.kotlin.gradle.dsl.KotlinProjectExtensionKt;
import org.jetbrains.kotlin.gradle.incremental.IncrementalModuleInfoProvider;
import org.jetbrains.kotlin.gradle.logging.GradleLoggingUtilsKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinCompilation;
import org.jetbrains.kotlin.gradle.plugin.KotlinTarget;
import org.jetbrains.kotlin.gradle.plugin.internal.state.TaskLoggers;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinWithJavaTarget;
import org.jetbrains.kotlin.gradle.plugin.statistics.KotlinBuildStatsService;
import org.jetbrains.kotlin.gradle.tasks.AbstractKotlinCompile;
import org.jetbrains.kotlin.gradle.tasks.GradleCompileTaskProvider;
import org.jetbrains.kotlin.gradle.tasks.InspectClassesForMultiModuleIC;
import org.jetbrains.kotlin.gradle.tasks.Kotlin2JsCompile;
import org.jetbrains.kotlin.gradle.tasks.KotlinCompilerExecutionStrategy;
import org.jetbrains.kotlin.gradle.tasks.TaskOutputsBackup;
import org.jetbrains.kotlin.gradle.utils.CompatibiltiyKt;
import org.jetbrains.kotlin.gradle.utils.FileUtilsKt;
import org.jetbrains.kotlin.incremental.IncrementalModuleEntry;
import org.jetbrains.kotlin.incremental.IncrementalModuleInfo;
import org.jetbrains.kotlin.statistics.metrics.BooleanMetrics;
import org.jetbrains.kotlin.statistics.metrics.IStatisticsValuesConsumer;
import org.jetbrains.kotlin.statistics.metrics.StringMetrics;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u0000 I2\u00020\u0001:\u0001IB7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ.\u0010/\u001a\u0004\u0018\u0001002\u0006\u00101\u001a\u00020\b2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\n\b\u0002\u00106\u001a\u0004\u0018\u000107H\u0002J\u001c\u0010/\u001a\u0004\u0018\u0001002\u0006\u00108\u001a\u0002092\b\u00106\u001a\u0004\u0018\u000107H\u0014J>\u0010:\u001a\u0004\u0018\u0001002\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u0010=\u001a\u00020>2\u0006\u00104\u001a\u0002052\b\u00106\u001a\u0004\u0018\u000107J^\u0010?\u001a\u0004\u0018\u0001002\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00050C2\b\u0010D\u001a\u0004\u0018\u00010\b2\u0006\u0010=\u001a\u00020E2\u0006\u00104\u001a\u0002052\u0006\u0010F\u001a\u00020\u00052\b\u00106\u001a\u0004\u0018\u000107J4\u0010G\u001a\u0004\u0018\u0001002\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u0010=\u001a\u00020H2\u0006\u00104\u001a\u000205R\u001c\u0010\u000e\u001a\n \u000f*\u0004\u0018\u00010\u00050\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u000b\u001a\u00020\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u0017X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0011R\u001c\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001c\u0010\u001e\u001a\n \u000f*\u0004\u0018\u00010\u001f0\u001fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001c\u0010\"\u001a\n \u000f*\u0004\u0018\u00010\b0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001c\u0010%\u001a\n \u000f*\u0004\u0018\u00010\u00050\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0011R\u001c\u0010'\u001a\n \u000f*\u0004\u0018\u00010\b0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010$R\u001c\u0010)\u001a\n \u000f*\u0004\u0018\u00010\u00050\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u0011R\u001c\u0010+\u001a\n \u000f*\u0004\u0018\u00010\u00050\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u0011R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.\u00a8\u0006J"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/GradleCompilerRunner;", "", "taskProvider", "Lorg/jetbrains/kotlin/gradle/tasks/GradleCompileTaskProvider;", "jdkToolsJar", "Ljava/io/File;", "kotlinDaemonJvmArgs", "", "", "buildMetrics", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporter;", "compilerExecutionStrategy", "Lorg/jetbrains/kotlin/gradle/tasks/KotlinCompilerExecutionStrategy;", "(Lorg/jetbrains/kotlin/gradle/tasks/GradleCompileTaskProvider;Ljava/io/File;Ljava/util/List;Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporter;Lorg/jetbrains/kotlin/gradle/tasks/KotlinCompilerExecutionStrategy;)V", "buildDirProvider", "kotlin.jvm.PlatformType", "getBuildDirProvider$kotlin_gradle_plugin", "()Ljava/io/File;", "getBuildMetrics", "()Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporter;", "getCompilerExecutionStrategy", "()Lorg/jetbrains/kotlin/gradle/tasks/KotlinCompilerExecutionStrategy;", "incrementalModuleInfoProvider", "Lorg/gradle/api/provider/Provider;", "Lorg/jetbrains/kotlin/gradle/incremental/IncrementalModuleInfoProvider;", "getIncrementalModuleInfoProvider$kotlin_gradle_plugin", "()Lorg/gradle/api/provider/Provider;", "getJdkToolsJar", "getKotlinDaemonJvmArgs", "()Ljava/util/List;", "loggerProvider", "Lorg/gradle/api/logging/Logger;", "getLoggerProvider$kotlin_gradle_plugin", "()Lorg/gradle/api/logging/Logger;", "pathProvider", "getPathProvider$kotlin_gradle_plugin", "()Ljava/lang/String;", "projectDirProvider", "getProjectDirProvider$kotlin_gradle_plugin", "projectNameProvider", "getProjectNameProvider$kotlin_gradle_plugin", "projectRootDirProvider", "getProjectRootDirProvider$kotlin_gradle_plugin", "sessionDirProvider", "getSessionDirProvider$kotlin_gradle_plugin", "getTaskProvider", "()Lorg/jetbrains/kotlin/gradle/tasks/GradleCompileTaskProvider;", "runCompilerAsync", "Lorg/gradle/workers/WorkQueue;", "compilerClassName", "compilerArgs", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "environment", "Lorg/jetbrains/kotlin/compilerRunner/GradleCompilerEnvironment;", "taskOutputsBackup", "Lorg/jetbrains/kotlin/gradle/tasks/TaskOutputsBackup;", "workArgs", "Lorg/jetbrains/kotlin/compilerRunner/GradleKotlinCompilerWorkArguments;", "runJsCompilerAsync", "kotlinSources", "kotlinCommonSources", "args", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JSCompilerArguments;", "runJvmCompilerAsync", "sourcesToCompile", "commonSources", "javaSourceRoots", "", "javaPackagePrefix", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;", "jdkHome", "runMetadataCompilerAsync", "Lorg/jetbrains/kotlin/cli/common/arguments/K2MetadataCompilerArguments;", "Companion", "kotlin-gradle-plugin"})
public class GradleCompilerRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GradleCompileTaskProvider taskProvider;
    @Nullable
    private final File jdkToolsJar;
    @Nullable
    private final List<String> kotlinDaemonJvmArgs;
    @NotNull
    private final BuildMetricsReporter buildMetrics;
    @NotNull
    private final KotlinCompilerExecutionStrategy compilerExecutionStrategy;
    private final String pathProvider;
    private final Logger loggerProvider;
    private final File buildDirProvider;
    private final File projectDirProvider;
    private final File projectRootDirProvider;
    private final File sessionDirProvider;
    private final String projectNameProvider;
    @NotNull
    private final Provider<? extends IncrementalModuleInfoProvider> incrementalModuleInfoProvider;
    @NotNull
    private static volatile WeakReference<Gradle> cachedGradle = new WeakReference<Object>(null);
    @Nullable
    private static volatile IncrementalModuleInfo cachedModulesInfo;
    @Nullable
    private static volatile File clientIsAliveFlagFile;
    @Nullable
    private static volatile File sessionFlagFile;

    public GradleCompilerRunner(@NotNull GradleCompileTaskProvider taskProvider, @Nullable File jdkToolsJar, @Nullable List<String> kotlinDaemonJvmArgs2, @NotNull BuildMetricsReporter buildMetrics, @NotNull KotlinCompilerExecutionStrategy compilerExecutionStrategy) {
        Intrinsics.checkNotNullParameter((Object)taskProvider, (String)"taskProvider");
        Intrinsics.checkNotNullParameter((Object)buildMetrics, (String)"buildMetrics");
        Intrinsics.checkNotNullParameter((Object)compilerExecutionStrategy, (String)"compilerExecutionStrategy");
        this.taskProvider = taskProvider;
        this.jdkToolsJar = jdkToolsJar;
        this.kotlinDaemonJvmArgs = kotlinDaemonJvmArgs2;
        this.buildMetrics = buildMetrics;
        this.compilerExecutionStrategy = compilerExecutionStrategy;
        this.pathProvider = (String)this.taskProvider.getPath().get();
        this.loggerProvider = (Logger)this.taskProvider.getLogger().get();
        this.buildDirProvider = ((Directory)this.taskProvider.getBuildDir().get()).getAsFile();
        this.projectDirProvider = (File)this.taskProvider.getProjectDir().get();
        this.projectRootDirProvider = (File)this.taskProvider.getRootDir().get();
        this.sessionDirProvider = (File)this.taskProvider.getSessionsDir().get();
        this.projectNameProvider = (String)this.taskProvider.getProjectName().get();
        this.incrementalModuleInfoProvider = this.taskProvider.getBuildModulesInfo();
    }

    @NotNull
    protected final GradleCompileTaskProvider getTaskProvider() {
        return this.taskProvider;
    }

    @Nullable
    protected final File getJdkToolsJar() {
        return this.jdkToolsJar;
    }

    @Nullable
    protected final List<String> getKotlinDaemonJvmArgs() {
        return this.kotlinDaemonJvmArgs;
    }

    @NotNull
    protected final BuildMetricsReporter getBuildMetrics() {
        return this.buildMetrics;
    }

    @NotNull
    protected final KotlinCompilerExecutionStrategy getCompilerExecutionStrategy() {
        return this.compilerExecutionStrategy;
    }

    public final String getPathProvider$kotlin_gradle_plugin() {
        return this.pathProvider;
    }

    public final Logger getLoggerProvider$kotlin_gradle_plugin() {
        return this.loggerProvider;
    }

    public final File getBuildDirProvider$kotlin_gradle_plugin() {
        return this.buildDirProvider;
    }

    public final File getProjectDirProvider$kotlin_gradle_plugin() {
        return this.projectDirProvider;
    }

    public final File getProjectRootDirProvider$kotlin_gradle_plugin() {
        return this.projectRootDirProvider;
    }

    public final File getSessionDirProvider$kotlin_gradle_plugin() {
        return this.sessionDirProvider;
    }

    public final String getProjectNameProvider$kotlin_gradle_plugin() {
        return this.projectNameProvider;
    }

    @NotNull
    public final Provider<? extends IncrementalModuleInfoProvider> getIncrementalModuleInfoProvider$kotlin_gradle_plugin() {
        return this.incrementalModuleInfoProvider;
    }

    @Nullable
    public final WorkQueue runJvmCompilerAsync(@NotNull List<? extends File> sourcesToCompile, @NotNull List<? extends File> commonSources, @NotNull Iterable<? extends File> javaSourceRoots, @Nullable String javaPackagePrefix, @NotNull K2JVMCompilerArguments args, @NotNull GradleCompilerEnvironment environment, @NotNull File jdkHome, @Nullable TaskOutputsBackup taskOutputsBackup) {
        Iterable<? extends File> $this$toTypedArray$iv;
        File it;
        boolean bl;
        Collection<String> collection;
        Iterable<? extends File> $this$mapTo$iv$iv;
        Iterable<? extends File> $this$map$iv;
        Intrinsics.checkNotNullParameter(sourcesToCompile, (String)"sourcesToCompile");
        Intrinsics.checkNotNullParameter(commonSources, (String)"commonSources");
        Intrinsics.checkNotNullParameter(javaSourceRoots, (String)"javaSourceRoots");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)((Object)environment), (String)"environment");
        Intrinsics.checkNotNullParameter((Object)jdkHome, (String)"jdkHome");
        Iterable iterable = sourcesToCompile;
        Collection collection2 = args.getFreeArgs();
        K2JVMCompilerArguments k2JVMCompilerArguments = args;
        boolean $i$f$map = false;
        void var11_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv) {
            File file = (File)t;
            collection = destination$iv$iv;
            bl = false;
            collection.add(it.getAbsolutePath());
        }
        collection = (List)destination$iv$iv;
        k2JVMCompilerArguments.setFreeArgs(CollectionsKt.plus((Collection)collection2, (Iterable)collection));
        $this$map$iv = (Iterable<? extends File>)commonSources;
        k2JVMCompilerArguments = args;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv) {
            it = (File)t;
            collection2 = destination$iv$iv;
            bl = false;
            collection2.add(it.getAbsolutePath());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Iterable<? extends File> thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        k2JVMCompilerArguments.setCommonSources(stringArray);
        $this$toTypedArray$iv = javaSourceRoots;
        k2JVMCompilerArguments = args;
        $i$f$map = false;
        thisCollection$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv) {
            it = (File)t;
            collection2 = destination$iv$iv;
            bl = false;
            collection2.add(it.getAbsolutePath());
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv.toArray((String[])new String[0]);
        if (stringArray2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        k2JVMCompilerArguments.setJavaSourceRoots(stringArray2);
        args.setJavaPackagePrefix(javaPackagePrefix);
        if (args.getJdkHome() == null && !args.getNoJdk()) {
            args.setJdkHome(jdkHome.getAbsolutePath());
        }
        Logger logger = this.loggerProvider;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"loggerProvider");
        GradleLoggingUtilsKt.kotlinInfo(logger, "Kotlin compilation 'jdkHome' argument: " + args.getJdkHome());
        return this.runCompilerAsync("org.jetbrains.kotlin.cli.jvm.K2JVMCompiler", (CommonCompilerArguments)args, environment, taskOutputsBackup);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final WorkQueue runJsCompilerAsync(@NotNull List<? extends File> kotlinSources, @NotNull List<? extends File> kotlinCommonSources, @NotNull K2JSCompilerArguments args, @NotNull GradleCompilerEnvironment environment, @Nullable TaskOutputsBackup taskOutputsBackup) {
        void $this$toTypedArray$iv;
        File it;
        Collection<String> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter(kotlinSources, (String)"kotlinSources");
        Intrinsics.checkNotNullParameter(kotlinCommonSources, (String)"kotlinCommonSources");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)((Object)environment), (String)"environment");
        Iterable iterable = kotlinSources;
        Collection collection2 = args.getFreeArgs();
        K2JSCompilerArguments k2JSCompilerArguments = args;
        boolean $i$f$map = false;
        void var8_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            File file = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getAbsolutePath());
        }
        collection = (List)destination$iv$iv;
        k2JSCompilerArguments.setFreeArgs(CollectionsKt.plus((Collection)collection2, (Iterable)collection));
        $this$map$iv = kotlinCommonSources;
        k2JSCompilerArguments = args;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (File)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getAbsolutePath());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        k2JSCompilerArguments.setCommonSources(stringArray);
        return this.runCompilerAsync("org.jetbrains.kotlin.cli.js.K2JSCompiler", (CommonCompilerArguments)args, environment, taskOutputsBackup);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final WorkQueue runMetadataCompilerAsync(@NotNull List<? extends File> kotlinSources, @NotNull List<? extends File> kotlinCommonSources, @NotNull K2MetadataCompilerArguments args, @NotNull GradleCompilerEnvironment environment) {
        void $this$toTypedArray$iv;
        File it;
        Collection<String> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter(kotlinSources, (String)"kotlinSources");
        Intrinsics.checkNotNullParameter(kotlinCommonSources, (String)"kotlinCommonSources");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)((Object)environment), (String)"environment");
        Iterable iterable = kotlinSources;
        Collection collection2 = args.getFreeArgs();
        K2MetadataCompilerArguments k2MetadataCompilerArguments = args;
        boolean $i$f$map = false;
        void var7_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            File file = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getAbsolutePath());
        }
        collection = (List)destination$iv$iv;
        k2MetadataCompilerArguments.setFreeArgs(CollectionsKt.plus((Collection)collection2, (Iterable)collection));
        $this$map$iv = kotlinCommonSources;
        k2MetadataCompilerArguments = args;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (File)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getAbsolutePath());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        k2MetadataCompilerArguments.setCommonSources(stringArray);
        return GradleCompilerRunner.runCompilerAsync$default(this, "org.jetbrains.kotlin.cli.metadata.K2MetadataCompiler", (CommonCompilerArguments)args, environment, null, 8, null);
    }

    private final WorkQueue runCompilerAsync(String compilerClassName, CommonCompilerArguments compilerArgs, GradleCompilerEnvironment environment, TaskOutputsBackup taskOutputsBackup) {
        IncrementalModuleInfo incrementalModuleInfo;
        IncrementalCompilationEnvironment incrementalCompilationEnvironment;
        if (compilerArgs.getVersion()) {
            this.loggerProvider.lifecycle("Kotlin version " + ReportUtilsKt.loadCompilerVersion(environment.getCompilerClasspath()) + " (JRE " + System.getProperty("java.runtime.version") + ')');
            compilerArgs.setVersion(false);
        }
        List list2 = ArgumentUtils.convertArgumentsToStringList((CommonToolArguments)((CommonToolArguments)compilerArgs));
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"convertArgumentsToStringList(compilerArgs)");
        Collection $this$toTypedArray$iv = list2;
        boolean $i$f$toTypedArray = false;
        Object thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] argsArray = stringArray;
        KotlinBuildStatsService.Companion.applyIfInitialised((Function1<? super IStatisticsValuesConsumer, Unit>)((Function1)new Function1<IStatisticsValuesConsumer, Unit>(compilerArgs, argsArray){
            final /* synthetic */ CommonCompilerArguments $compilerArgs;
            final /* synthetic */ String[] $argsArray;
            {
                this.$compilerArgs = $compilerArgs;
                this.$argsArray = $argsArray;
                super(1);
            }

            public final void invoke(@NotNull IStatisticsValuesConsumer it) {
                block4: {
                    CommonCompilerArguments commonCompilerArguments;
                    block3: {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        commonCompilerArguments = this.$compilerArgs;
                        if (!(commonCompilerArguments instanceof K2JVMCompilerArguments)) break block3;
                        IStatisticsValuesConsumer iStatisticsValuesConsumer = KotlinBuildStatsService.Companion.getInstance();
                        if (iStatisticsValuesConsumer == null) break block4;
                        IStatisticsValuesConsumer iStatisticsValuesConsumer2 = iStatisticsValuesConsumer;
                        Object[] objectArray = this.$argsArray;
                        IStatisticsValuesConsumer $this$invoke_u24lambda_u2d0 = iStatisticsValuesConsumer2;
                        boolean bl = false;
                        K2JVMCompilerArguments args = new K2JVMCompilerArguments();
                        ParseCommandLineArgumentsKt.parseCommandLineArguments((List)ArraysKt.toList((Object[])objectArray), (CommonToolArguments)((CommonToolArguments)args));
                        IStatisticsValuesConsumer.DefaultImpls.report$default($this$invoke_u24lambda_u2d0, BooleanMetrics.JVM_COMPILER_IR_MODE, args.getUseIR(), null, 4, null);
                        IStatisticsValuesConsumer.DefaultImpls.report$default($this$invoke_u24lambda_u2d0, StringMetrics.JVM_DEFAULTS, args.getJvmDefault(), null, 4, null);
                        IStatisticsValuesConsumer.DefaultImpls.report$default($this$invoke_u24lambda_u2d0, StringMetrics.USE_OLD_BACKEND, String.valueOf(args.getUseOldBackend()), null, 4, null);
                        IStatisticsValuesConsumer.DefaultImpls.report$default($this$invoke_u24lambda_u2d0, StringMetrics.USE_FIR, String.valueOf(args.getUseFir()), null, 4, null);
                        break block4;
                    }
                    if (!(commonCompilerArguments instanceof K2JSCompilerArguments)) break block4;
                    IStatisticsValuesConsumer iStatisticsValuesConsumer = KotlinBuildStatsService.Companion.getInstance();
                    if (iStatisticsValuesConsumer != null) {
                        IStatisticsValuesConsumer iStatisticsValuesConsumer3 = iStatisticsValuesConsumer;
                        Object[] objectArray = this.$argsArray;
                        IStatisticsValuesConsumer $this$invoke_u24lambda_u2d1 = iStatisticsValuesConsumer3;
                        boolean bl = false;
                        K2JSCompilerArguments args = new K2JSCompilerArguments();
                        ParseCommandLineArgumentsKt.parseCommandLineArguments((List)ArraysKt.toList((Object[])objectArray), (CommonToolArguments)((CommonToolArguments)args));
                        if (!K2JSCompilerArgumentsKt.isPreIrBackendDisabled((K2JSCompilerArguments)args) || args.getIrProduceJs()) {
                            IStatisticsValuesConsumer.DefaultImpls.report$default($this$invoke_u24lambda_u2d1, BooleanMetrics.JS_SOURCE_MAP, args.getSourceMap(), null, 4, null);
                        }
                        if (args.getIrProduceJs()) {
                            IStatisticsValuesConsumer.DefaultImpls.report$default($this$invoke_u24lambda_u2d1, StringMetrics.JS_PROPERTY_LAZY_INITIALIZATION, String.valueOf(args.getIrPropertyLazyInitialization()), null, 4, null);
                        }
                    }
                }
            }
        }));
        IncrementalCompilationEnvironment incrementalCompilationEnvironment2 = incrementalCompilationEnvironment = environment.getIncrementalCompilationEnvironment();
        if (incrementalCompilationEnvironment2 != null) {
            Object it = thisCollection$iv = incrementalCompilationEnvironment2;
            boolean bl = false;
            incrementalModuleInfo = ((IncrementalModuleInfoProvider)this.incrementalModuleInfoProvider.get()).getInfo();
        } else {
            incrementalModuleInfo = null;
        }
        IncrementalModuleInfo modulesInfo = incrementalModuleInfo;
        Logger logger = this.loggerProvider;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"loggerProvider");
        File file = this.projectDirProvider;
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"projectDirProvider");
        File file2 = this.buildDirProvider;
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"buildDirProvider");
        String string = this.projectNameProvider;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"projectNameProvider");
        File file3 = this.projectRootDirProvider;
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"projectRootDirProvider");
        File file4 = this.sessionDirProvider;
        Intrinsics.checkNotNullExpressionValue((Object)file4, (String)"sessionDirProvider");
        ProjectFilesForCompilation projectFilesForCompilation = new ProjectFilesForCompilation(logger, file, file2, string, file3, file4);
        List<File> list3 = environment.compilerFullClasspath(this.jdkToolsJar);
        boolean bl = compilerArgs.getVerbose();
        List list4 = CollectionsKt.toList((Iterable)environment.getOutputFiles());
        String string2 = this.pathProvider;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"pathProvider");
        GradleKotlinCompilerWorkArguments workArgs = new GradleKotlinCompilerWorkArguments(projectFilesForCompilation, list3, compilerClassName, argsArray, bl, incrementalCompilationEnvironment, modulesInfo, list4, string2, environment.getReportingSettings(), environment.getKotlinScriptExtensions(), compilerArgs.getAllWarningsAsErrors(), this.kotlinDaemonJvmArgs, this.compilerExecutionStrategy);
        String string3 = this.pathProvider;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"pathProvider");
        Logger logger2 = this.loggerProvider;
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"loggerProvider");
        TaskLoggers.INSTANCE.put(string3, logger2);
        return this.runCompilerAsync(workArgs, taskOutputsBackup);
    }

    static /* synthetic */ WorkQueue runCompilerAsync$default(GradleCompilerRunner gradleCompilerRunner, String string, CommonCompilerArguments commonCompilerArguments, GradleCompilerEnvironment gradleCompilerEnvironment, TaskOutputsBackup taskOutputsBackup, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: runCompilerAsync");
        }
        if ((n & 8) != 0) {
            taskOutputsBackup = null;
        }
        return gradleCompilerRunner.runCompilerAsync(string, commonCompilerArguments, gradleCompilerEnvironment, taskOutputsBackup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    protected WorkQueue runCompilerAsync(@NotNull GradleKotlinCompilerWorkArguments workArgs, @Nullable TaskOutputsBackup taskOutputsBackup) {
        Intrinsics.checkNotNullParameter((Object)workArgs, (String)"workArgs");
        try {
            GradleKotlinCompilerWork kotlinCompilerRunnable = new GradleKotlinCompilerWork(workArgs);
            kotlinCompilerRunnable.run();
        }
        catch (GradleException e) {
            if (taskOutputsBackup != null) {
                void $this$measure$iv;
                BuildMetricsReporter buildMetricsReporter = this.buildMetrics;
                BuildTime time$iv = BuildTime.RESTORE_OUTPUT_FROM_BACKUP;
                boolean $i$f$measure = false;
                long start$iv = System.nanoTime();
                $this$measure$iv.startMeasure(time$iv, start$iv);
                try {
                    boolean bl = false;
                    taskOutputsBackup.restoreOutputs();
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    long end$iv = System.nanoTime();
                    $this$measure$iv.endMeasure(time$iv, end$iv);
                }
            }
            throw e;
        }
        return null;
    }

    public static final /* synthetic */ File access$getClientIsAliveFlagFile$cp() {
        return clientIsAliveFlagFile;
    }

    public static final /* synthetic */ void access$setClientIsAliveFlagFile$cp(File file) {
        clientIsAliveFlagFile = file;
    }

    public static final /* synthetic */ File access$getSessionFlagFile$cp() {
        return sessionFlagFile;
    }

    public static final /* synthetic */ void access$setSessionFlagFile$cp(File file) {
        sessionFlagFile = file;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\rJ\r\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010JM\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b\u001cJ\u001d\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b!J%\u0010\"\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b%J\u001a\u0010&\u001a\u0004\u0018\u00010\t2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0019H\u0002J\u0015\u0010#\u001a\u00020\t2\u0006\u0010*\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b+J\u0011\u0010,\u001a\u00020\u0019*\u00020\u0019H\u0000\u00a2\u0006\u0002\b-R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/compilerRunner/GradleCompilerRunner$Companion;", "", "()V", "cachedGradle", "Ljava/lang/ref/WeakReference;", "Lorg/gradle/api/invocation/Gradle;", "cachedModulesInfo", "Lorg/jetbrains/kotlin/incremental/IncrementalModuleInfo;", "clientIsAliveFlagFile", "Ljava/io/File;", "sessionFlagFile", "buildModulesInfo", "gradle", "buildModulesInfo$kotlin_gradle_plugin", "clearBuildModulesInfo", "", "clearBuildModulesInfo$kotlin_gradle_plugin", "getDaemonConnectionImpl", "Lorg/jetbrains/kotlin/daemon/client/CompileServiceSession;", "sessionIsAliveFlagFile", "compilerFullClasspath", "", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "daemonJvmArgs", "", "isDebugEnabled", "", "getDaemonConnectionImpl$kotlin_gradle_plugin", "getOrCreateClientFlagFile", "log", "Lorg/gradle/api/logging/Logger;", "projectName", "getOrCreateClientFlagFile$kotlin_gradle_plugin", "getOrCreateSessionFlagFile", "sessionsDir", "projectRootDir", "getOrCreateSessionFlagFile$kotlin_gradle_plugin", "jarForSourceSet", "project", "Lorg/gradle/api/Project;", "sourceSetName", "rootProjectBuildDir", "sessionsDir$kotlin_gradle_plugin", "normalizeForFlagFile", "normalizeForFlagFile$kotlin_gradle_plugin", "kotlin-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final synchronized CompileServiceSession getDaemonConnectionImpl$kotlin_gradle_plugin(@NotNull File clientIsAliveFlagFile, @NotNull File sessionIsAliveFlagFile, @NotNull List<? extends File> compilerFullClasspath, @NotNull MessageCollector messageCollector, @Nullable List<String> daemonJvmArgs, boolean isDebugEnabled) {
            DaemonJVMOptions daemonJVMOptions;
            Intrinsics.checkNotNullParameter((Object)clientIsAliveFlagFile, (String)"clientIsAliveFlagFile");
            Intrinsics.checkNotNullParameter((Object)sessionIsAliveFlagFile, (String)"sessionIsAliveFlagFile");
            Intrinsics.checkNotNullParameter(compilerFullClasspath, (String)"compilerFullClasspath");
            Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
            CompilerId compilerId = CompilerId.Companion.makeCompilerId((Iterable)compilerFullClasspath);
            DaemonJVMOptions opts2 = daemonJVMOptions = DaemonParamsKt.configureDaemonJVMOptions((String[])new String[0], (boolean)true, (boolean)false, (boolean)true);
            boolean bl = false;
            Collection collection = daemonJvmArgs;
            if (!(collection == null || collection.isEmpty())) {
                CollectionsKt.addAll((Collection)opts2.getJvmParams(), (Iterable)DaemonParamsKt.filterExtractProps((Iterable)daemonJvmArgs, (List)opts2.getMappers(), (String)"", (RestPropMapper)opts2.getRestMapper()));
            }
            DaemonJVMOptions daemonJvmOptions = daemonJVMOptions;
            return KotlinCompilerRunnerUtils.newDaemonConnection$default((CompilerId)compilerId, (File)clientIsAliveFlagFile, (File)sessionIsAliveFlagFile, (MessageCollector)messageCollector, (boolean)isDebugEnabled, null, (DaemonJVMOptions)daemonJvmOptions, (int)32, null);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final synchronized IncrementalModuleInfo buildModulesInfo$kotlin_gradle_plugin(@NotNull Gradle gradle) {
            Intrinsics.checkNotNullParameter((Object)gradle, (String)"gradle");
            if (cachedGradle.get() == gradle && cachedModulesInfo != null) {
                IncrementalModuleInfo incrementalModuleInfo = cachedModulesInfo;
                Intrinsics.checkNotNull((Object)incrementalModuleInfo);
                return incrementalModuleInfo;
            }
            HashMap dirToModule = new HashMap();
            HashMap nameToModules = new HashMap();
            HashMap jarToClassListFile = new HashMap();
            HashMap jarToModule = new HashMap();
            HashMap jarToAbiSnapshot = new HashMap();
            Map multiplatformProjectTasks = new LinkedHashMap();
            List list2 = gradle.getTaskGraph().getAllTasks();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"gradle.taskGraph.allTasks");
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                Task task2 = (Task)element$iv;
                boolean bl = false;
                Project project = task2.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                if (KotlinProjectExtensionKt.getMultiplatformExtensionOrNull(project) != null) {
                    Set set2 = (Set)multiplatformProjectTasks.get(project);
                    if (set2 == null) {
                        set2 = new LinkedHashSet();
                    }
                    Set tasksInProject = set2;
                    String string = task2.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"task.name");
                    tasksInProject.add(string);
                    multiplatformProjectTasks.put(project, tasksInProject);
                }
                if (task2 instanceof AbstractKotlinCompile) {
                    Object object;
                    void $this$getOrPut$iv;
                    File file;
                    String string = project.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.path");
                    Object object2 = ((AbstractKotlinCompile)task2).getModuleName$kotlin_gradle_plugin().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"task.moduleName.get()");
                    String string2 = (String)object2;
                    File file2 = project.getBuildDir();
                    Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"project.buildDir");
                    File file3 = ((RegularFile)((AbstractKotlinCompile)task2).getBuildHistoryFile$kotlin_gradle_plugin().get()).getAsFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"task.buildHistoryFile.get().asFile");
                    File file4 = ((RegularFile)((AbstractKotlinCompile)task2).getAbiSnapshotFile().get()).getAsFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file4, (String)"task.abiSnapshotFile.get().asFile");
                    IncrementalModuleEntry module2 = new IncrementalModuleEntry(string, string2, file2, file3, file4);
                    Object object3 = dirToModule;
                    Intrinsics.checkNotNullExpressionValue((Object)((AbstractKotlinCompile)task2).getDestinationDir(), (String)"task.destinationDir");
                    object3.put(file, module2);
                    Object object4 = (Directory)((AbstractKotlinCompile)task2).getJavaOutputDir$kotlin_gradle_plugin().getOrNull();
                    if (object4 != null && (object4 = (file = object4.getAsFile())) != null) {
                        File file5;
                        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"asFile");
                        File it = file5 = file;
                        boolean bl2 = false;
                        ((Map)dirToModule).put(it, module2);
                    }
                    object3 = nameToModules;
                    Object key$iv = module2.getName();
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl3 = false;
                        HashSet answer$iv = new HashSet();
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    ((HashSet)object).add(module2);
                    if (!(task2 instanceof Kotlin2JsCompile)) continue;
                    Object object5 = ((AbstractKotlinCompile)task2).getSourceSetName$kotlin_gradle_plugin().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"task.sourceSetName.get()");
                    File file6 = Companion.jarForSourceSet(project, (String)object5);
                    if (file6 == null) continue;
                    Object it = key$iv = file6;
                    boolean bl4 = false;
                    ((Map)jarToModule).put(it, module2);
                    continue;
                }
                if (!(task2 instanceof InspectClassesForMultiModuleIC)) continue;
                ((Map)jarToClassListFile).put(new File((String)((InspectClassesForMultiModuleIC)task2).getArchivePath$kotlin_gradle_plugin().get()), ((InspectClassesForMultiModuleIC)task2).getClassesListFile$kotlin_gradle_plugin());
            }
            IncrementalModuleInfo incrementalModuleInfo = multiplatformProjectTasks.entrySet().iterator();
            while (incrementalModuleInfo.hasNext()) {
                KotlinMultiplatformExtension kotlinMultiplatformExtension;
                Map.Entry $i$f$forEach2 = incrementalModuleInfo.next();
                Project project = (Project)$i$f$forEach2.getKey();
                Set tasksInProject = (Set)$i$f$forEach2.getValue();
                if ((KotlinMultiplatformExtension)project.getExtensions().findByType(KotlinMultiplatformExtension.class) == null) continue;
                KotlinMultiplatformExtension kotlinExt = kotlinMultiplatformExtension;
                boolean bl = false;
                for (KotlinTarget target2 : kotlinExt.getTargets()) {
                    AbstractArchiveTask jarTask2;
                    AbstractKotlinCompile kotlinTask;
                    KotlinCompile bl4;
                    KotlinCompilation mainCompilation;
                    if ((KotlinCompilation)target2.getCompilations().findByName("main") == null || !tasksInProject.contains(mainCompilation.getCompileKotlinTaskName()) || !tasksInProject.contains(target2.getArtifactsTaskName()) || ((bl4 = mainCompilation.getCompileKotlinTask()) instanceof AbstractKotlinCompile ? (AbstractKotlinCompile)bl4 : null) == null) continue;
                    kotlinTask = kotlinTask;
                    String string = project.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.path");
                    Object object = kotlinTask.getModuleName$kotlin_gradle_plugin().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"kotlinTask.moduleName.get()");
                    String string3 = (String)object;
                    File file = project.getBuildDir();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.buildDir");
                    File file7 = ((RegularFile)kotlinTask.getBuildHistoryFile$kotlin_gradle_plugin().get()).getAsFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file7, (String)"kotlinTask.buildHistoryFile.get().asFile");
                    File file8 = ((RegularFile)kotlinTask.getAbiSnapshotFile().get()).getAsFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file8, (String)"kotlinTask.abiSnapshotFile.get().asFile");
                    IncrementalModuleEntry module3 = new IncrementalModuleEntry(string, string3, file, file7, file8);
                    Object object6 = project.getTasks().findByName(target2.getArtifactsTaskName());
                    if ((object6 instanceof AbstractArchiveTask ? (AbstractArchiveTask)object6 : null) == null) continue;
                    jarTask2 = jarTask2;
                    Map map = jarToModule;
                    File file9 = CompatibiltiyKt.getArchivePathCompatible(jarTask2).getCanonicalFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file9, (String)"jarTask.archivePathCompatible.canonicalFile");
                    object6 = file9;
                    map.put(object6, module3);
                    if (!(target2 instanceof KotlinWithJavaTarget)) continue;
                    Task task3 = project.getTasks().getByName(target2.getArtifactsTaskName());
                    if (task3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.gradle.jvm.tasks.Jar");
                    }
                    Jar jar = (Jar)task3;
                    object6 = jarToClassListFile;
                    File file10 = CompatibiltiyKt.getArchivePathCompatible((AbstractArchiveTask)jar).getCanonicalFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file10, (String)"jar.archivePathCompatible.canonicalFile");
                    File file11 = file10;
                    Object object7 = ((KotlinWithJavaTarget)target2).getDefaultArtifactClassesListFile$kotlin_gradle_plugin().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object7, (String)"target.defaultArtifactClassesListFile.get()");
                    Object object8 = object7;
                    object6.put(file11, object8);
                    object6 = jarToAbiSnapshot;
                    File file12 = CompatibiltiyKt.getArchivePathCompatible((AbstractArchiveTask)jar).getCanonicalFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file12, (String)"jar.archivePathCompatible.canonicalFile");
                    file11 = file12;
                    File file13 = ((RegularFile)((Directory)((KotlinWithJavaTarget)target2).getBuildDir$kotlin_gradle_plugin().get()).file((Provider)kotlinTask.getAbiSnapshotRelativePath()).get()).getAsFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file13, (String)"target.buildDir.get().fi\u2026elativePath).get().asFile");
                    object8 = file13;
                    object6.put(file11, object8);
                }
            }
            File file = gradle.getRootProject().getProjectDir();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"gradle.rootProject.projectDir");
            File file14 = gradle.getRootProject().getBuildDir();
            Intrinsics.checkNotNullExpressionValue((Object)file14, (String)"gradle.rootProject.buildDir");
            IncrementalModuleInfo it = incrementalModuleInfo = new IncrementalModuleInfo(file, file14, (Map)dirToModule, (Map)nameToModules, (Map)jarToClassListFile, (Map)jarToModule, (Map)jarToAbiSnapshot);
            boolean bl = false;
            cachedGradle = new WeakReference<Gradle>(gradle);
            cachedModulesInfo = it;
            return incrementalModuleInfo;
        }

        private final File jarForSourceSet(Project project, String sourceSetName) {
            JavaPluginConvention javaPluginConvention = (JavaPluginConvention)project.getConvention().findPlugin(JavaPluginConvention.class);
            if (javaPluginConvention == null) {
                return null;
            }
            JavaPluginConvention javaConvention = javaPluginConvention;
            SourceSet sourceSet = (SourceSet)javaConvention.getSourceSets().findByName(sourceSetName);
            if (sourceSet == null) {
                return null;
            }
            SourceSet sourceSet2 = sourceSet;
            Object object = project.getTasks().findByName(sourceSet2.getJarTaskName());
            Jar jarTask2 = object instanceof Jar ? (Jar)object : null;
            Jar jar = jarTask2;
            return jar != null && (jar = jar.getArchiveFile()) != null && (jar = (RegularFile)jar.get()) != null ? jar.getAsFile() : null;
        }

        public final synchronized void clearBuildModulesInfo$kotlin_gradle_plugin() {
            cachedGradle = new WeakReference<Object>(null);
            cachedModulesInfo = null;
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final synchronized File getOrCreateClientFlagFile$kotlin_gradle_plugin(@NotNull Logger log, @NotNull String projectName) {
            Intrinsics.checkNotNullParameter((Object)log, (String)"log");
            Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
            if (GradleCompilerRunner.access$getClientIsAliveFlagFile$cp() == null) ** GOTO lbl-1000
            v0 = GradleCompilerRunner.access$getClientIsAliveFlagFile$cp();
            Intrinsics.checkNotNull((Object)v0);
            if (!v0.exists()) lbl-1000:
            // 2 sources

            {
                GradleCompilerRunner.access$setClientIsAliveFlagFile$cp(FileUtilsKt.newTmpFile$default("kotlin-compiler-in-" + projectName + '-', ".alive", null, false, 12, null));
                $this$kotlinDebug$iv = log;
                $i$f$kotlinDebug = false;
                if ($this$kotlinDebug$iv.isDebugEnabled()) {
                    var6_7 = $this$kotlinDebug$iv;
                    $i$a$-kotlinDebug-GradleCompilerRunner$Companion$getOrCreateClientFlagFile$1 = false;
                    v1 = new StringBuilder().append("Created client-is-alive flag file: ");
                    v2 = GradleCompilerRunner.access$getClientIsAliveFlagFile$cp();
                    Intrinsics.checkNotNull((Object)v2);
                    GradleLoggingUtilsKt.kotlinDebug(var6_7, v1.append(v2.getCanonicalPath()).toString());
                }
            } else {
                $this$kotlinDebug$iv = log;
                $i$f$kotlinDebug = false;
                if ($this$kotlinDebug$iv.isDebugEnabled()) {
                    var6_8 = $this$kotlinDebug$iv;
                    $i$a$-kotlinDebug-GradleCompilerRunner$Companion$getOrCreateClientFlagFile$2 = false;
                    v3 = new StringBuilder().append("Existing client-is-alive flag file: ");
                    v4 = GradleCompilerRunner.access$getClientIsAliveFlagFile$cp();
                    Intrinsics.checkNotNull((Object)v4);
                    GradleLoggingUtilsKt.kotlinDebug(var6_8, v3.append(v4.getCanonicalPath()).toString());
                }
            }
            v5 = GradleCompilerRunner.access$getClientIsAliveFlagFile$cp();
            Intrinsics.checkNotNull((Object)v5);
            return v5;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final String normalizeForFlagFile$kotlin_gradle_plugin(@NotNull String $this$normalizeForFlagFile) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$this$normalizeForFlagFile, (String)"<this>");
            List validChars = CollectionsKt.plus((Collection)CollectionsKt.plus((Iterable)((Iterable)new CharRange('a', 'z')), (Iterable)((Iterable)new CharRange('0', '9'))), (Object)"-_");
            String $this$filter$iv = $this$normalizeForFlagFile;
            boolean $i$f$filter = false;
            CharSequence charSequence = $this$filter$iv;
            Appendable destination$iv$iv = new StringBuilder();
            boolean $i$f$filterTo = false;
            int n = 0;
            int n2 = $this$filterTo$iv$iv.length();
            while (n < n2) {
                void index$iv$iv;
                char element$iv$iv;
                char it = element$iv$iv = $this$filterTo$iv$iv.charAt((int)index$iv$iv);
                boolean bl = false;
                if (validChars.contains(Character.valueOf(it))) {
                    destination$iv$iv.append(element$iv$iv);
                }
                ++index$iv$iv;
            }
            String string = ((StringBuilder)destination$iv$iv).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"filterTo(StringBuilder(), predicate).toString()");
            return string;
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final synchronized File getOrCreateSessionFlagFile$kotlin_gradle_plugin(@NotNull Logger log, @NotNull File sessionsDir, @NotNull File projectRootDir) {
            Intrinsics.checkNotNullParameter((Object)log, (String)"log");
            Intrinsics.checkNotNullParameter((Object)sessionsDir, (String)"sessionsDir");
            Intrinsics.checkNotNullParameter((Object)projectRootDir, (String)"projectRootDir");
            if (GradleCompilerRunner.access$getSessionFlagFile$cp() == null) ** GOTO lbl-1000
            v0 = GradleCompilerRunner.access$getSessionFlagFile$cp();
            Intrinsics.checkNotNull((Object)v0);
            if (!v0.exists()) lbl-1000:
            // 2 sources

            {
                $this$getOrCreateSessionFlagFile_u24lambda_u2d10 = var5_4 = sessionsDir;
                $i$a$-apply-GradleCompilerRunner$Companion$getOrCreateSessionFlagFile$sessionFilesDir$1 = false;
                $this$getOrCreateSessionFlagFile_u24lambda_u2d10.mkdirs();
                sessionFilesDir = var5_4;
                GradleCompilerRunner.access$setSessionFlagFile$cp(FileUtilsKt.newTmpFile$default("kotlin-compiler-", ".salive", sessionFilesDir, false, 8, null));
                $this$kotlinDebug$iv = log;
                $i$f$kotlinDebug = false;
                if ($this$kotlinDebug$iv.isDebugEnabled()) {
                    var8_12 = $this$kotlinDebug$iv;
                    $i$a$-kotlinDebug-GradleCompilerRunner$Companion$getOrCreateSessionFlagFile$1 = false;
                    v1 = new StringBuilder().append("Created session-is-alive flag file: ");
                    v2 = GradleCompilerRunner.access$getSessionFlagFile$cp();
                    Intrinsics.checkNotNull((Object)v2);
                    GradleLoggingUtilsKt.kotlinDebug(var8_12, v1.append(FileUtilsKt.relativeOrCanonical(v2, projectRootDir)).toString());
                }
            } else {
                $this$kotlinDebug$iv = log;
                $i$f$kotlinDebug = false;
                if ($this$kotlinDebug$iv.isDebugEnabled()) {
                    var8_13 = $this$kotlinDebug$iv;
                    $i$a$-kotlinDebug-GradleCompilerRunner$Companion$getOrCreateSessionFlagFile$2 = false;
                    v3 = new StringBuilder().append("Existing session-is-alive flag file: ");
                    v4 = GradleCompilerRunner.access$getSessionFlagFile$cp();
                    Intrinsics.checkNotNull((Object)v4);
                    GradleLoggingUtilsKt.kotlinDebug(var8_13, v3.append(FileUtilsKt.relativeOrCanonical(v4, projectRootDir)).toString());
                }
            }
            v5 = GradleCompilerRunner.access$getSessionFlagFile$cp();
            Intrinsics.checkNotNull((Object)v5);
            return v5;
        }

        @NotNull
        public final File sessionsDir$kotlin_gradle_plugin(@NotNull File rootProjectBuildDir) {
            Intrinsics.checkNotNullParameter((Object)rootProjectBuildDir, (String)"rootProjectBuildDir");
            return new File(new File(rootProjectBuildDir, "kotlin"), "sessions");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

