/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.report.metrics.BuildAttribute;
import org.jetbrains.kotlin.build.report.metrics.BuildMetrics;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporterImpl;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.build.report.metrics.DoNothingBuildMetricsReporter;
import org.jetbrains.kotlin.cli.common.CompilerSystemProperties;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.PropertiesKt;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.compilerRunner.GradleCompilationResults;
import org.jetbrains.kotlin.compilerRunner.GradleCompilerRunner;
import org.jetbrains.kotlin.compilerRunner.GradleCompilerServicesFacadeImpl;
import org.jetbrains.kotlin.compilerRunner.GradleIncrementalCompilerServicesFacadeImpl;
import org.jetbrains.kotlin.compilerRunner.GradleKotlinCompilerWork;
import org.jetbrains.kotlin.compilerRunner.GradleKotlinCompilerWorkArguments;
import org.jetbrains.kotlin.compilerRunner.IncrementalCompilationEnvironment;
import org.jetbrains.kotlin.compilerRunner.KotlinLogger;
import org.jetbrains.kotlin.compilerRunner.OutputItemsCollector;
import org.jetbrains.kotlin.compilerRunner.OutputItemsCollectorImpl;
import org.jetbrains.kotlin.compilerRunner.ReportUtilsKt;
import org.jetbrains.kotlin.compilerRunner.UtilsKt;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.daemon.common.CompilationOptions;
import org.jetbrains.kotlin.daemon.common.CompilationResultCategory;
import org.jetbrains.kotlin.daemon.common.CompilationResults;
import org.jetbrains.kotlin.daemon.common.CompileService;
import org.jetbrains.kotlin.daemon.common.CompilerMode;
import org.jetbrains.kotlin.daemon.common.CompilerServicesFacadeBase;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptions;
import org.jetbrains.kotlin.daemon.common.IncrementalCompilationOptions;
import org.jetbrains.kotlin.daemon.common.MultiModuleICSettings;
import org.jetbrains.kotlin.daemon.common.PropMapper;
import org.jetbrains.kotlin.daemon.common.ReportCategory;
import org.jetbrains.kotlin.daemon.common.ReportSeverity;
import org.jetbrains.kotlin.gradle.logging.GradleBufferingMessageCollector;
import org.jetbrains.kotlin.gradle.logging.GradleKotlinLogger;
import org.jetbrains.kotlin.gradle.logging.GradlePrintingMessageCollector;
import org.jetbrains.kotlin.gradle.logging.SL4JKotlinLogger;
import org.jetbrains.kotlin.gradle.plugin.internal.state.TaskExecutionResults;
import org.jetbrains.kotlin.gradle.plugin.internal.state.TaskLoggers;
import org.jetbrains.kotlin.gradle.report.BuildReportMode;
import org.jetbrains.kotlin.gradle.report.ReportingSettings;
import org.jetbrains.kotlin.gradle.report.TaskExecutionInfo;
import org.jetbrains.kotlin.gradle.report.TaskExecutionProperties;
import org.jetbrains.kotlin.gradle.report.TaskExecutionResult;
import org.jetbrains.kotlin.gradle.tasks.KotlinCompilerExecutionStrategy;
import org.jetbrains.kotlin.gradle.tasks.TasksUtilsKt;
import org.jetbrains.kotlin.gradle.utils.ErrorUtilsKt;
import org.jetbrains.kotlin.incremental.ChangedFiles;
import org.jetbrains.kotlin.incremental.ClasspathChanges;
import org.jetbrains.kotlin.incremental.IncrementalModuleInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0002J\b\u0010,\u001a\u00020(H\u0002J\u0012\u0010-\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010.\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0002J.\u0010/\u001a\b\u0012\u0004\u0012\u000201002\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002012\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000208H\u0002J.\u00109\u001a\b\u0012\u0004\u0012\u000201002\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002012\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000208H\u0002J\u001b\u0010:\u001a\b\u0012\u0004\u0012\u0002010\u000b2\u0006\u0010;\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010<J\u0010\u0010=\u001a\u0002012\u0006\u0010;\u001a\u00020\u0006H\u0002J\u000e\u0010>\u001a\b\u0012\u0004\u0012\u00020@0?H\u0002J\b\u0010A\u001a\u00020BH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\b0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/GradleKotlinCompilerWork;", "Ljava/lang/Runnable;", "config", "Lorg/jetbrains/kotlin/compilerRunner/GradleKotlinCompilerWorkArguments;", "(Lorg/jetbrains/kotlin/compilerRunner/GradleKotlinCompilerWorkArguments;)V", "allWarningsAsErrors", "", "buildDir", "Ljava/io/File;", "clientIsAliveFlagFile", "compilerArgs", "", "", "[Ljava/lang/String;", "compilerClassName", "compilerExecutionStrategy", "Lorg/jetbrains/kotlin/gradle/tasks/KotlinCompilerExecutionStrategy;", "compilerFullClasspath", "", "daemonJvmArgs", "icLogLines", "incrementalCompilationEnvironment", "Lorg/jetbrains/kotlin/compilerRunner/IncrementalCompilationEnvironment;", "incrementalModuleInfo", "Lorg/jetbrains/kotlin/incremental/IncrementalModuleInfo;", "isIncremental", "()Z", "isVerbose", "kotlinScriptExtensions", "log", "Lorg/jetbrains/kotlin/compilerRunner/KotlinLogger;", "metrics", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporter;", "outputFiles", "projectRootFile", "reportingSettings", "Lorg/jetbrains/kotlin/gradle/report/ReportingSettings;", "sessionFlagFile", "taskPath", "compileInProcess", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "compileInProcessImpl", "compileOutOfProcess", "compileWithDaemon", "compileWithDaemonOrFallbackImpl", "incrementalCompilationWithDaemon", "Lorg/jetbrains/kotlin/daemon/common/CompileService$CallResult;", "", "daemon", "Lorg/jetbrains/kotlin/daemon/common/CompileService;", "sessionId", "targetPlatform", "Lorg/jetbrains/kotlin/daemon/common/CompileService$TargetPlatform;", "bufferingMessageCollector", "Lorg/jetbrains/kotlin/gradle/logging/GradleBufferingMessageCollector;", "nonIncrementalCompilationWithDaemon", "reportCategories", "verbose", "(Z)[Ljava/lang/Integer;", "reportSeverity", "requestedCompilationResults", "Ljava/util/EnumSet;", "Lorg/jetbrains/kotlin/daemon/common/CompilationResultCategory;", "run", "", "kotlin-gradle-plugin"})
public final class GradleKotlinCompilerWork
implements Runnable {
    @NotNull
    private final File projectRootFile;
    @NotNull
    private final File clientIsAliveFlagFile;
    @NotNull
    private final File sessionFlagFile;
    @NotNull
    private final List<File> compilerFullClasspath;
    @NotNull
    private final String compilerClassName;
    @NotNull
    private final String[] compilerArgs;
    private final boolean isVerbose;
    @Nullable
    private final IncrementalCompilationEnvironment incrementalCompilationEnvironment;
    @Nullable
    private final IncrementalModuleInfo incrementalModuleInfo;
    @NotNull
    private final List<File> outputFiles;
    @NotNull
    private final String taskPath;
    @NotNull
    private final ReportingSettings reportingSettings;
    @NotNull
    private final String[] kotlinScriptExtensions;
    private final boolean allWarningsAsErrors;
    @NotNull
    private final File buildDir;
    @NotNull
    private final BuildMetricsReporter metrics;
    @NotNull
    private List<String> icLogLines;
    @Nullable
    private final List<String> daemonJvmArgs;
    @NotNull
    private final KotlinCompilerExecutionStrategy compilerExecutionStrategy;
    @NotNull
    private final KotlinLogger log;

    /*
     * WARNING - void declaration
     */
    @Inject
    public GradleKotlinCompilerWork(@NotNull GradleKotlinCompilerWorkArguments config) {
        KotlinLogger kotlinLogger2;
        GradleKotlinCompilerWork gradleKotlinCompilerWork;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.projectRootFile = config.getProjectFiles().getProjectRootFile();
        this.clientIsAliveFlagFile = config.getProjectFiles().getClientIsAliveFlagFile();
        this.sessionFlagFile = config.getProjectFiles().getSessionFlagFile();
        this.compilerFullClasspath = config.getCompilerFullClasspath();
        this.compilerClassName = config.getCompilerClassName();
        this.compilerArgs = config.getCompilerArgs();
        this.isVerbose = config.isVerbose();
        this.incrementalCompilationEnvironment = config.getIncrementalCompilationEnvironment();
        this.incrementalModuleInfo = config.getIncrementalModuleInfo();
        this.outputFiles = config.getOutputFiles();
        this.taskPath = config.getTaskPath();
        this.reportingSettings = config.getReportingSettings();
        this.kotlinScriptExtensions = config.getKotlinScriptExtensions();
        this.allWarningsAsErrors = config.getAllWarningsAsErrors();
        this.buildDir = config.getProjectFiles().getBuildDir();
        this.metrics = this.reportingSettings.getReportMetrics() ? (BuildMetricsReporter)new BuildMetricsReporterImpl() : (BuildMetricsReporter)DoNothingBuildMetricsReporter.INSTANCE;
        this.icLogLines = CollectionsKt.emptyList();
        this.daemonJvmArgs = config.getDaemonJvmArgs();
        this.compilerExecutionStrategy = config.getCompilerExecutionStrategy();
        GradleKotlinCompilerWork gradleKotlinCompilerWork2 = this;
        org.gradle.api.logging.Logger logger = TaskLoggers.INSTANCE.get(this.taskPath);
        if (logger != null) {
            void it;
            GradleKotlinLogger gradleKotlinLogger;
            org.gradle.api.logging.Logger logger2;
            org.gradle.api.logging.Logger logger3 = logger2 = logger;
            GradleKotlinCompilerWork gradleKotlinCompilerWork3 = gradleKotlinCompilerWork2;
            boolean bl = false;
            GradleKotlinLogger $this$log_u24lambda_u2d1_u24lambda_u2d0 = gradleKotlinLogger = new GradleKotlinLogger((org.gradle.api.logging.Logger)it);
            boolean bl2 = false;
            $this$log_u24lambda_u2d1_u24lambda_u2d0.debug("Using '" + this.taskPath + "' logger");
            gradleKotlinCompilerWork = gradleKotlinCompilerWork3;
            kotlinLogger2 = gradleKotlinLogger;
        } else {
            void $this$log_u24lambda_u2d3;
            KotlinLogger kotlinLogger3;
            KotlinLogger kotlinLogger4;
            KotlinLogger kotlinLogger5;
            GradleKotlinCompilerWork gradleKotlinCompilerWork4;
            GradleKotlinCompilerWork it = gradleKotlinCompilerWork4 = this;
            GradleKotlinCompilerWork gradleKotlinCompilerWork5 = gradleKotlinCompilerWork2;
            boolean bl = false;
            Logger logger4 = LoggerFactory.getLogger((String)"GradleKotlinCompilerWork");
            if (logger4 instanceof org.gradle.api.logging.Logger) {
                kotlinLogger5 = new GradleKotlinLogger((org.gradle.api.logging.Logger)logger4);
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)logger4, (String)"logger");
                kotlinLogger5 = new SL4JKotlinLogger(logger4);
            }
            KotlinLogger $this$log_u24lambda_u2d3_u24lambda_u2d2 = kotlinLogger4 = (kotlinLogger3 = kotlinLogger5);
            boolean bl3 = false;
            $this$log_u24lambda_u2d3_u24lambda_u2d2.debug("Could not get logger for '" + $this$log_u24lambda_u2d3.taskPath + "'. Falling back to sl4j logger");
            kotlinLogger2 = kotlinLogger4;
            gradleKotlinCompilerWork = gradleKotlinCompilerWork5;
        }
        gradleKotlinCompilerWork.log = kotlinLogger2;
    }

    private final boolean isIncremental() {
        return this.incrementalCompilationEnvironment != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean it;
        Boolean bl;
        ArrayList<TaskExecutionProperties> properties2;
        try {
            GradlePrintingMessageCollector messageCollector = new GradlePrintingMessageCollector(this.log, this.allWarningsAsErrors);
            ExitCode exitCode = this.compileWithDaemonOrFallbackImpl(messageCollector);
            IncrementalCompilationEnvironment incrementalCompilationEnvironment = this.incrementalCompilationEnvironment;
            boolean bl2 = incrementalCompilationEnvironment != null ? incrementalCompilationEnvironment.getDisableMultiModuleIC() : false;
            if (bl2) {
                this.incrementalCompilationEnvironment.getMultiModuleICSettings().getBuildHistoryFile().delete();
            }
            TasksUtilsKt.throwGradleExceptionIfError(exitCode);
            properties2 = new ArrayList<TaskExecutionProperties>();
        }
        catch (Throwable throwable) {
            boolean it2;
            Boolean it3;
            ArrayList<TaskExecutionProperties> properties3 = new ArrayList<TaskExecutionProperties>();
            Boolean bl3 = PropertiesKt.toBooleanLenient((String)CompilerSystemProperties.COMPILE_INCREMENTAL_WITH_CLASSPATH_SNAPSHOTS.getValue());
            if (bl3 != null) {
                it3 = bl3;
                it2 = it3;
                boolean bl4 = false;
                if (it2) {
                    properties3.add(TaskExecutionProperties.ABI_SNAPSHOT);
                }
            }
            Boolean bl5 = PropertiesKt.toBooleanLenient((String)CompilerSystemProperties.COMPILE_INCREMENTAL_WITH_ARTIFACT_TRANSFORM.getValue());
            if (bl5 != null) {
                it3 = bl5;
                it2 = it3;
                boolean bl6 = false;
                if (it2) {
                    properties3.add(TaskExecutionProperties.ARTIFACT_TRANSFORM);
                }
            }
            IncrementalCompilationEnvironment incrementalCompilationEnvironment = this.incrementalCompilationEnvironment;
            it3 = incrementalCompilationEnvironment != null ? incrementalCompilationEnvironment.getChangedFiles() : null;
            TaskExecutionInfo taskInfo = new TaskExecutionInfo((List<? extends TaskExecutionProperties>)properties3, (ChangedFiles)it3);
            BuildMetrics buildMetrics = this.metrics.getMetrics();
            List<String> list2 = this.icLogLines;
            TaskExecutionResult result2 = new TaskExecutionResult(buildMetrics, taskInfo, list2);
            TaskExecutionResults.INSTANCE.set(this.taskPath, result2);
            throw throwable;
        }
        Boolean bl7 = PropertiesKt.toBooleanLenient((String)CompilerSystemProperties.COMPILE_INCREMENTAL_WITH_CLASSPATH_SNAPSHOTS.getValue());
        if (bl7 != null) {
            bl = bl7;
            it = bl;
            boolean bl8 = false;
            if (it) {
                properties2.add(TaskExecutionProperties.ABI_SNAPSHOT);
            }
        }
        Boolean bl9 = PropertiesKt.toBooleanLenient((String)CompilerSystemProperties.COMPILE_INCREMENTAL_WITH_ARTIFACT_TRANSFORM.getValue());
        if (bl9 != null) {
            bl = bl9;
            it = bl;
            boolean bl10 = false;
            if (it) {
                properties2.add(TaskExecutionProperties.ARTIFACT_TRANSFORM);
            }
        }
        IncrementalCompilationEnvironment incrementalCompilationEnvironment = this.incrementalCompilationEnvironment;
        bl = incrementalCompilationEnvironment != null ? incrementalCompilationEnvironment.getChangedFiles() : null;
        TaskExecutionInfo taskInfo = new TaskExecutionInfo((List<? extends TaskExecutionProperties>)properties2, (ChangedFiles)bl);
        BuildMetrics it3 = this.metrics.getMetrics();
        List<String> bl10 = this.icLogLines;
        TaskExecutionResult result3 = new TaskExecutionResult(it3, taskInfo, bl10);
        TaskExecutionResults.INSTANCE.set(this.taskPath, result3);
    }

    private final ExitCode compileWithDaemonOrFallbackImpl(MessageCollector messageCollector) {
        Boolean bl;
        String msg$iv;
        KotlinLogger kotlinLogger2;
        KotlinLogger $this$compileWithDaemonOrFallbackImpl_u24lambda_u2d9 = kotlinLogger2 = this.log;
        boolean bl2 = false;
        KotlinLogger $this$kotlinDebug$iv = $this$compileWithDaemonOrFallbackImpl_u24lambda_u2d9;
        boolean $i$f$kotlinDebug = false;
        if ($this$kotlinDebug$iv.isDebugEnabled()) {
            boolean bl3 = false;
            msg$iv = "Kotlin compiler class: " + this.compilerClassName;
            $this$kotlinDebug$iv.debug("[KOTLIN] " + msg$iv);
        }
        $this$kotlinDebug$iv = $this$compileWithDaemonOrFallbackImpl_u24lambda_u2d9;
        $i$f$kotlinDebug = false;
        if ($this$kotlinDebug$iv.isDebugEnabled()) {
            boolean bl4 = false;
            msg$iv = "Kotlin compiler classpath: " + CollectionsKt.joinToString$default((Iterable)this.compilerFullClasspath, null, null, null, (int)0, null, (Function1)compileWithDaemonOrFallbackImpl.1.2.1.INSTANCE, (int)31, null);
            $this$kotlinDebug$iv.debug("[KOTLIN] " + msg$iv);
        }
        $this$kotlinDebug$iv = $this$compileWithDaemonOrFallbackImpl_u24lambda_u2d9;
        $i$f$kotlinDebug = false;
        if ($this$kotlinDebug$iv.isDebugEnabled()) {
            boolean bl5 = false;
            msg$iv = this.taskPath + " Kotlin compiler args: " + ArraysKt.joinToString$default((Object[])this.compilerArgs, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
            $this$kotlinDebug$iv.debug("[KOTLIN] " + msg$iv);
        }
        if (this.compilerExecutionStrategy == KotlinCompilerExecutionStrategy.DAEMON) {
            ExitCode daemonExitCode = this.compileWithDaemon(messageCollector);
            if (daemonExitCode != null) {
                return daemonExitCode;
            }
            this.log.warn("Could not connect to kotlin daemon. Using fallback strategy.");
        }
        String string = System.getProperty("org.gradle.daemon");
        if (string != null) {
            String string2;
            String p0 = string2 = string;
            boolean bl6 = false;
            bl = Boolean.parseBoolean(p0);
        } else {
            bl = null;
        }
        Boolean isGradleDaemonUsed = bl;
        return this.compilerExecutionStrategy == KotlinCompilerExecutionStrategy.IN_PROCESS || Intrinsics.areEqual((Object)isGradleDaemonUsed, (Object)false) ? this.compileInProcess(messageCollector) : this.compileOutOfProcess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final ExitCode compileWithDaemon(MessageCollector messageCollector) {
        ExitCode res;
        CompileService.TargetPlatform targetPlatform;
        GradleCompilerRunner.Companion companion;
        List<String> list2;
        File file;
        Object object;
        void $this$measure$iv;
        String string;
        boolean isDebugEnabled = this.log.isDebugEnabled() || ((string = System.getProperty("kotlin.daemon.debug.log")) != null ? Boolean.parseBoolean(string) : true);
        MessageCollector daemonMessageCollector = isDebugEnabled ? messageCollector : MessageCollector.Companion.getNONE();
        BuildMetricsReporter buildMetricsReporter = this.metrics;
        BuildTime time$iv = BuildTime.CONNECT_TO_DAEMON;
        boolean $i$f$measure = false;
        long start$iv = System.nanoTime();
        $this$measure$iv.startMeasure(time$iv, start$iv);
        try {
            boolean bl = false;
            try {
                object = GradleCompilerRunner.Companion;
                File file2 = this.clientIsAliveFlagFile;
                file = this.sessionFlagFile;
                List<File> list3 = this.compilerFullClasspath;
                list2 = this.daemonJvmArgs;
                object = ((GradleCompilerRunner.Companion)object).getDaemonConnectionImpl$kotlin_gradle_plugin(file2, file, list3, daemonMessageCollector, list2, isDebugEnabled);
            }
            catch (Throwable e) {
                this.log.error("Caught an exception trying to connect to Kotlin Daemon:");
                this.log.error(ErrorUtilsKt.stackTraceAsString(e));
                object = null;
            }
            companion = object;
        }
        finally {
            long end$iv = System.nanoTime();
            $this$measure$iv.endMeasure(time$iv, end$iv);
        }
        GradleCompilerRunner.Companion connection = companion;
        if (connection == null) {
            if (this.isIncremental()) {
                this.log.warn("Could not perform incremental compilation: Could not connect to Kotlin compile daemon");
            } else {
                this.log.warn("Could not connect to Kotlin compile daemon");
            }
            return null;
        }
        CompileService daemon = connection.component1();
        int sessionId = connection.component2();
        if (this.log.isDebugEnabled()) {
            CompileService.CallResult it = start$iv = daemon.getDaemonJVMOptions();
            boolean bl = false;
            Object object2 = it.isGood() ? start$iv : null;
            if (object2 != null) {
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                CompileService.CallResult jvmOpts = start$iv = object2;
                boolean bl2 = false;
                object = ((DaemonJVMOptions)jvmOpts.get()).getMappers();
                StringBuilder e = new StringBuilder().append("Kotlin compile daemon JVM options: ");
                file = this.log;
                boolean $i$f$flatMap = false;
                list2 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    PropMapper it2 = (PropMapper)element$iv$iv;
                    boolean bl3 = false;
                    Iterable list$iv$iv = it2.toArgs("-");
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                List list4 = (List)destination$iv$iv;
                file.debug(e.append(list4).toString());
            }
        }
        switch (this.compilerClassName) {
            case "org.jetbrains.kotlin.cli.jvm.K2JVMCompiler": {
                targetPlatform = CompileService.TargetPlatform.JVM;
                break;
            }
            case "org.jetbrains.kotlin.cli.js.K2JSCompiler": {
                targetPlatform = CompileService.TargetPlatform.JS;
                break;
            }
            case "org.jetbrains.kotlin.cli.metadata.K2MetadataCompiler": {
                targetPlatform = CompileService.TargetPlatform.METADATA;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown compiler type " + this.compilerClassName);
            }
        }
        CompileService.TargetPlatform targetPlatform2 = targetPlatform;
        GradleBufferingMessageCollector bufferingMessageCollector = new GradleBufferingMessageCollector();
        try {
            res = this.isIncremental() ? this.incrementalCompilationWithDaemon(daemon, sessionId, targetPlatform2, bufferingMessageCollector) : this.nonIncrementalCompilationWithDaemon(daemon, sessionId, targetPlatform2, bufferingMessageCollector);
            bufferingMessageCollector.flush(messageCollector);
            res = ReportUtilsKt.exitCodeFromProcessExitCode(this.log, ((Number)res.get()).intValue());
        }
        catch (Throwable e) {
            bufferingMessageCollector.flush(messageCollector);
            this.log.error("Compilation with Kotlin compile daemon was not successful");
            this.log.error(ErrorUtilsKt.stackTraceAsString(e));
            res = null;
        }
        ExitCode exitCode = res;
        try {
            void $this$measure$iv2;
            res = this.metrics;
            BuildTime time$iv2 = BuildTime.CLEAR_JAR_CACHE;
            boolean $i$f$measure2 = false;
            long start$iv2 = System.nanoTime();
            $this$measure$iv2.startMeasure(time$iv2, start$iv2);
            try {
                boolean bl = false;
                daemon.clearJarCache();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                long end$iv = System.nanoTime();
                $this$measure$iv2.endMeasure(time$iv2, end$iv);
            }
        }
        catch (RemoteException e) {
            this.log.warn("Unable to clear jar cache after compilation, maybe daemon is already down: " + e);
        }
        ReportUtilsKt.logFinish(this.log, KotlinCompilerExecutionStrategy.DAEMON);
        return exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final CompileService.CallResult<Integer> nonIncrementalCompilationWithDaemon(CompileService daemon, int sessionId, CompileService.TargetPlatform targetPlatform, GradleBufferingMessageCollector bufferingMessageCollector) {
        CompileService.CallResult callResult;
        void $this$measure$iv;
        this.metrics.addAttribute(BuildAttribute.IC_IS_NOT_ENABLED);
        boolean $i$f$emptyArray = false;
        CompilationOptions compilationOptions = new CompilationOptions(CompilerMode.NON_INCREMENTAL_COMPILER, targetPlatform, this.reportCategories(this.isVerbose), this.reportSeverity(this.isVerbose), new Integer[0], this.kotlinScriptExtensions);
        GradleCompilerServicesFacadeImpl servicesFacade = new GradleCompilerServicesFacadeImpl(this.log, bufferingMessageCollector, 0, 4, null);
        GradleCompilationResults compilationResults = new GradleCompilationResults(this.log, this.projectRootFile);
        BuildMetricsReporter buildMetricsReporter = this.metrics;
        BuildTime time$iv = BuildTime.NON_INCREMENTAL_COMPILATION_DAEMON;
        boolean $i$f$measure = false;
        long start$iv = System.nanoTime();
        $this$measure$iv.startMeasure(time$iv, start$iv);
        try {
            boolean bl = false;
            callResult = daemon.compile(sessionId, this.compilerArgs, compilationOptions, (CompilerServicesFacadeBase)servicesFacade, (CompilationResults)compilationResults);
        }
        finally {
            long end$iv = System.nanoTime();
            $this$measure$iv.endMeasure(time$iv, end$iv);
        }
        BuildMetricsReporter it = buildMetricsReporter = callResult;
        boolean bl = false;
        this.metrics.addMetrics(compilationResults.getBuildMetrics());
        this.icLogLines = compilationResults.getIcLogLines();
        return buildMetricsReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final CompileService.CallResult<Integer> incrementalCompilationWithDaemon(CompileService daemon, int sessionId, CompileService.TargetPlatform targetPlatform, GradleBufferingMessageCollector bufferingMessageCollector) {
        void $this$measure$iv;
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        IncrementalCompilationEnvironment incrementalCompilationEnvironment = this.incrementalCompilationEnvironment;
        if (incrementalCompilationEnvironment == null) {
            throw (Throwable)new IllegalStateException("incrementalCompilationEnvironment is null!".toString());
        }
        IncrementalCompilationEnvironment icEnv = incrementalCompilationEnvironment;
        ChangedFiles changedFiles = icEnv.getChangedFiles();
        ChangedFiles.Known knownChangedFiles = changedFiles instanceof ChangedFiles.Known ? (ChangedFiles.Known)changedFiles : null;
        EnumSet<CompilationResultCategory> requestedCompilationResults = this.requestedCompilationResults();
        boolean bl = knownChangedFiles != null;
        ChangedFiles.Known known = knownChangedFiles;
        List list2 = known != null ? known.getModified() : null;
        ChangedFiles.Known known2 = knownChangedFiles;
        List list3 = known2 != null ? known2.getRemoved() : null;
        ClasspathChanges classpathChanges = icEnv.getClasspathChanges();
        File file = icEnv.getWorkingDir();
        Integer[] integerArray = this.reportCategories(this.isVerbose);
        int n = this.reportSeverity(this.isVerbose);
        List<File> $this$map$iv = (List<File>)((Object)requestedCompilationResults);
        boolean $i$f$map = false;
        List<File> list4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CompilationResultCategory compilationResultCategory = (CompilationResultCategory)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.getCode());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        Integer[] integerArray2 = thisCollection$iv.toArray(new Integer[0]);
        if (integerArray2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Integer[] integerArray3 = integerArray2;
        CompilerMode compilerMode = CompilerMode.INCREMENTAL_COMPILER;
        $i$f$toTypedArray = icEnv.getUsePreciseJavaTracking();
        list4 = this.outputFiles;
        MultiModuleICSettings multiModuleICSettings = icEnv.getMultiModuleICSettings();
        IncrementalModuleInfo incrementalModuleInfo = this.incrementalModuleInfo;
        Intrinsics.checkNotNull((Object)incrementalModuleInfo);
        IncrementalModuleInfo incrementalModuleInfo2 = incrementalModuleInfo;
        String[] stringArray = this.kotlinScriptExtensions;
        IncrementalCompilationOptions compilationOptions = new IncrementalCompilationOptions(bl, list2, list3, classpathChanges, file, compilerMode, targetPlatform, integerArray, n, integerArray3, $i$f$toTypedArray, list4, multiModuleICSettings, incrementalModuleInfo2, stringArray);
        this.log.info("Options for KOTLIN DAEMON: " + compilationOptions);
        GradleIncrementalCompilerServicesFacadeImpl servicesFacade = new GradleIncrementalCompilerServicesFacadeImpl(this.log, bufferingMessageCollector, 0, 4, null);
        GradleCompilationResults compilationResults = new GradleCompilationResults(this.log, this.projectRootFile);
        list3 = this.metrics;
        BuildTime time$iv = BuildTime.RUN_COMPILER;
        boolean $i$f$measure = false;
        long start$iv = System.nanoTime();
        $this$measure$iv.startMeasure(time$iv, start$iv);
        try {
            boolean bl3 = false;
            compilerMode = daemon.compile(sessionId, this.compilerArgs, (CompilationOptions)compilationOptions, (CompilerServicesFacadeBase)servicesFacade, (CompilationResults)compilationResults);
        }
        finally {
            long end$iv = System.nanoTime();
            $this$measure$iv.endMeasure(time$iv, end$iv);
        }
        List it = list3 = compilerMode;
        boolean bl4 = false;
        this.metrics.addMetrics(compilationResults.getBuildMetrics());
        this.icLogLines = compilationResults.getIcLogLines();
        return list3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final ExitCode compileOutOfProcess() {
        ExitCode exitCode;
        void $this$measure$iv;
        this.metrics.addAttribute(BuildAttribute.OUT_OF_PROCESS_EXECUTION);
        TasksUtilsKt.cleanOutputsAndLocalState((Iterable<? extends File>)this.outputFiles, this.log, this.metrics, "out-of-process execution strategy is non-incremental");
        BuildMetricsReporter buildMetricsReporter = this.metrics;
        BuildTime time$iv = BuildTime.NON_INCREMENTAL_COMPILATION_OUT_OF_PROCESS;
        boolean $i$f$measure = false;
        long start$iv = System.nanoTime();
        $this$measure$iv.startMeasure(time$iv, start$iv);
        try {
            boolean bl = false;
            exitCode = ReportUtilsKt.runToolInSeparateProcess$default(this.compilerArgs, this.compilerClassName, this.compilerFullClasspath, this.log, this.buildDir, null, 32, null);
        }
        finally {
            long end$iv = System.nanoTime();
            $this$measure$iv.endMeasure(time$iv, end$iv);
        }
        return exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ExitCode compileInProcess(MessageCollector messageCollector) {
        ExitCode exitCode;
        this.metrics.addAttribute(BuildAttribute.IN_PROCESS_EXECUTION);
        TasksUtilsKt.cleanOutputsAndLocalState((Iterable<? extends File>)this.outputFiles, this.log, this.metrics, "in-process execution strategy is non-incremental");
        this.metrics.startMeasure(BuildTime.NON_INCREMENTAL_COMPILATION_IN_PROCESS, System.nanoTime());
        ExecutorService threadPool = Executors.newSingleThreadExecutor();
        GradleBufferingMessageCollector bufferingMessageCollector = new GradleBufferingMessageCollector();
        try {
            Future future2 = threadPool.submit(new Callable(this, bufferingMessageCollector){
                final /* synthetic */ GradleKotlinCompilerWork this$0;
                final /* synthetic */ GradleBufferingMessageCollector $bufferingMessageCollector;
                {
                    this.this$0 = $receiver;
                    this.$bufferingMessageCollector = $bufferingMessageCollector;
                }

                public final ExitCode call() {
                    return GradleKotlinCompilerWork.access$compileInProcessImpl(this.this$0, this.$bufferingMessageCollector);
                }
            });
            Object t = future2.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"private fun compileInPro\u2026noTime())\n        }\n    }");
            exitCode = (ExitCode)t;
        }
        finally {
            bufferingMessageCollector.flush(messageCollector);
            threadPool.shutdown();
            this.metrics.endMeasure(BuildTime.NON_INCREMENTAL_COMPILATION_IN_PROCESS, System.nanoTime());
        }
        return exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final ExitCode compileInProcessImpl(MessageCollector messageCollector) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(stream);
        Iterable $this$map$iv = this.compilerFullClasspath;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toURI().toURL());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        URL[] uRLArray = thisCollection$iv.toArray(new URL[0]);
        if (uRLArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        URL[] uRLArray2 = uRLArray;
        URLClassLoader classLoader = new URLClassLoader(uRLArray2);
        Class<?> servicesClass = Class.forName(Services.class.getCanonicalName(), true, classLoader);
        Object emptyServices = servicesClass.getField("EMPTY").get(servicesClass);
        Class<?> compiler = Class.forName(this.compilerClassName, true, classLoader);
        Class[] $i$f$mapTo22 = new Class[]{PrintStream.class, servicesClass, String[].class};
        Method exec2 = compiler.getMethod("execAndOutputXml", $i$f$mapTo22);
        Object[] objectArray = new Object[]{out, emptyServices, this.compilerArgs};
        Object res = exec2.invoke(compiler.newInstance(), objectArray);
        ExitCode exitCode = ExitCode.valueOf((String)res.toString());
        UtilsKt.processCompilerOutput((MessageCollector)messageCollector, (OutputItemsCollector)((OutputItemsCollector)new OutputItemsCollectorImpl()), (ByteArrayOutputStream)stream, (ExitCode)exitCode);
        try {
            void $this$measure$iv;
            Object item$iv$iv;
            item$iv$iv = this.metrics;
            BuildTime time$iv = BuildTime.CLEAR_JAR_CACHE;
            boolean $i$f$measure = false;
            long start$iv = System.nanoTime();
            $this$measure$iv.startMeasure(time$iv, start$iv);
            try {
                boolean bl = false;
                Class<?> coreEnvironment = Class.forName("org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment", true, classLoader);
                Method dispose = coreEnvironment.getMethod("disposeApplicationEnvironment", new Class[0]);
                Object object = dispose.invoke(null, new Object[0]);
            }
            finally {
                long end$iv = System.nanoTime();
                $this$measure$iv.endMeasure(time$iv, end$iv);
            }
        }
        catch (Throwable e) {
            this.log.warn("Unable to clear jar cache after in-process compilation: " + e);
        }
        ReportUtilsKt.logFinish(this.log, KotlinCompilerExecutionStrategy.IN_PROCESS);
        return exitCode;
    }

    private final EnumSet<CompilationResultCategory> requestedCompilationResults() {
        CompilationResultCategory compilationResultCategory;
        EnumSet<Enum> requestedCompilationResults = EnumSet.of((Enum)CompilationResultCategory.IC_COMPILE_ITERATION);
        switch (WhenMappings.$EnumSwitchMapping$0[this.reportingSettings.getBuildReportMode().ordinal()]) {
            case 1: {
                compilationResultCategory = null;
                break;
            }
            case 2: {
                compilationResultCategory = CompilationResultCategory.BUILD_REPORT_LINES;
                break;
            }
            case 3: {
                compilationResultCategory = CompilationResultCategory.VERBOSE_BUILD_REPORT_LINES;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        CompilationResultCategory compilationResultCategory2 = compilationResultCategory;
        if (compilationResultCategory2 != null) {
            CompilationResultCategory compilationResultCategory3;
            CompilationResultCategory it = compilationResultCategory3 = compilationResultCategory2;
            boolean bl = false;
            requestedCompilationResults.add((Enum)it);
        }
        if (this.reportingSettings.getReportMetrics()) {
            requestedCompilationResults.add((Enum)CompilationResultCategory.BUILD_METRICS);
        }
        Intrinsics.checkNotNullExpressionValue(requestedCompilationResults, (String)"requestedCompilationResults");
        return requestedCompilationResults;
    }

    /*
     * WARNING - void declaration
     */
    private final Integer[] reportCategories(boolean verbose) {
        Integer[] integerArray;
        if (!verbose) {
            Integer[] integerArray2 = new Integer[]{ReportCategory.COMPILER_MESSAGE.getCode()};
            integerArray = integerArray2;
        } else {
            void $this$mapTo$iv$iv;
            ReportCategory[] $this$map$iv = ReportCategory.values();
            boolean $i$f$map = false;
            ReportCategory[] reportCategoryArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            void var7_8 = $this$mapTo$iv$iv;
            int n = ((void)var7_8).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var11_12 = item$iv$iv = var7_8[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getCode());
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Integer[] integerArray3 = thisCollection$iv.toArray(new Integer[0]);
            if (integerArray3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            integerArray = integerArray3;
        }
        return integerArray;
    }

    private final int reportSeverity(boolean verbose) {
        return !verbose ? ReportSeverity.INFO.getCode() : ReportSeverity.DEBUG.getCode();
    }

    public static final /* synthetic */ ExitCode access$compileInProcessImpl(GradleKotlinCompilerWork $this, MessageCollector messageCollector) {
        return $this.compileInProcessImpl(messageCollector);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BuildReportMode.values().length];
            nArray[BuildReportMode.NONE.ordinal()] = 1;
            nArray[BuildReportMode.SIMPLE.ordinal()] = 2;
            nArray[BuildReportMode.VERBOSE.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

