/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.testing.internal;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.testing.internal.TestReportService;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\b&\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0003J(\u0010\u000e\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u00060\u000bj\u0002`\f0\nj\u0002`\r0\u000f2\u0006\u0010\u0010\u001a\u00020\u0006J\u000e\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0006J\"\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00062\n\u0010\u0017\u001a\u00060\u000bj\u0002`\fJ\u000e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0006R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010\b\u001a(\u0012\u0004\u0012\u00020\u0006\u0012\u001e\u0012\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u00060\u000bj\u0002`\f0\nj\u0002`\r0\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/gradle/testing/internal/TestReportService;", "Lorg/gradle/api/services/BuildService;", "Lorg/gradle/api/services/BuildServiceParameters$None;", "()V", "taskHasFailedTests", "", "", "", "taskSuppressedFailures", "", "Lkotlin/Pair;", "Ljava/lang/Error;", "Lkotlin/Error;", "Lorg/jetbrains/kotlin/gradle/testing/internal/TaskError;", "getAggregatedTaskFailures", "", "taskPath", "hasFailedTests", "path", "reportFailure", "", "failedTaskPath", "parentTaskPath", "failure", "testFailed", "Companion", "kotlin-gradle-plugin"})
public abstract class TestReportService
implements BuildService<BuildServiceParameters.None> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Boolean> taskHasFailedTests = new LinkedHashMap();
    @NotNull
    private final Map<String, List<Pair<String, Error>>> taskSuppressedFailures = new LinkedHashMap();

    public final void testFailed(@NotNull String taskPath) {
        Intrinsics.checkNotNullParameter((Object)taskPath, (String)"taskPath");
        this.taskHasFailedTests.put(taskPath, true);
    }

    public final boolean hasFailedTests(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Boolean bl = this.taskHasFailedTests.get(path);
        return bl != null ? bl : false;
    }

    public final void reportFailure(@NotNull String failedTaskPath, @NotNull String parentTaskPath, @NotNull Error failure) {
        Intrinsics.checkNotNullParameter((Object)failedTaskPath, (String)"failedTaskPath");
        Intrinsics.checkNotNullParameter((Object)parentTaskPath, (String)"parentTaskPath");
        Intrinsics.checkNotNullParameter((Object)failure, (String)"failure");
        this.taskSuppressedFailures.computeIfAbsent(parentTaskPath, reportFailure.1.INSTANCE).add((Pair<String, Error>)TuplesKt.to((Object)failedTaskPath, (Object)failure));
    }

    @NotNull
    public final List<Pair<String, Error>> getAggregatedTaskFailures(@NotNull String taskPath) {
        Intrinsics.checkNotNullParameter((Object)taskPath, (String)"taskPath");
        List list2 = this.taskSuppressedFailures.get(taskPath);
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/testing/internal/TestReportService$Companion;", "", "()V", "registerIfAbsent", "Lorg/gradle/api/provider/Provider;", "Lorg/jetbrains/kotlin/gradle/testing/internal/TestReportService;", "gradle", "Lorg/gradle/api/invocation/Gradle;", "kotlin-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Provider<TestReportService> registerIfAbsent(@NotNull Gradle gradle) {
            Intrinsics.checkNotNullParameter((Object)gradle, (String)"gradle");
            Provider provider = gradle.getSharedServices().registerIfAbsent(TestReportService.class.getCanonicalName() + '_' + TestReportService.class.getClassLoader().hashCode(), TestReportService.class, (Action)registerIfAbsent.1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"gradle.sharedServices\n  \u2026java\n                ) {}");
            return provider;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

