/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.native.tasks.artifact;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.mpp.BitcodeEmbeddingMode;
import org.jetbrains.kotlin.gradle.plugin.mpp.NativeBuildType;
import org.jetbrains.kotlin.gradle.plugin.mpp.NativeOutputKind;
import org.jetbrains.kotlin.gradle.plugin.mpp.apple.AppleTarget;
import org.jetbrains.kotlin.gradle.plugin.mpp.apple.XCFrameworkTask;
import org.jetbrains.kotlin.gradle.plugin.mpp.apple.XCFrameworkTaskHolder;
import org.jetbrains.kotlin.gradle.targets.native.tasks.artifact.KotlinNativeArtifact;
import org.jetbrains.kotlin.gradle.targets.native.tasks.artifact.KotlinNativeFrameworkKt;
import org.jetbrains.kotlin.gradle.targets.native.tasks.artifact.KotlinNativeLinkArtifactTask;
import org.jetbrains.kotlin.gradle.targets.native.tasks.artifact.KotlinNativeXCFramework;
import org.jetbrains.kotlin.gradle.tasks.FatFrameworkTask;
import org.jetbrains.kotlin.gradle.tasks.FrameworkDescriptor;
import org.jetbrains.kotlin.gradle.tasks.TasksProviderKt;
import org.jetbrains.kotlin.gradle.utils.StringUtilsKt;
import org.jetbrains.kotlin.konan.target.KonanTarget;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0010\u00a2\u0006\u0002\b\u0018J\u001f\u0010\u000b\u001a\u00020\u00132\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\u0019\"\u00020\r\u00a2\u0006\u0002\u0010\u001aJ\u001d\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0010\u00a2\u0006\u0002\b\u001dR\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/native/tasks/artifact/KotlinNativeXCFramework;", "Lorg/jetbrains/kotlin/gradle/targets/native/tasks/artifact/KotlinNativeArtifact;", "()V", "embedBitcode", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/BitcodeEmbeddingMode;", "getEmbedBitcode", "()Lorg/jetbrains/kotlin/gradle/plugin/mpp/BitcodeEmbeddingMode;", "setEmbedBitcode", "(Lorg/jetbrains/kotlin/gradle/plugin/mpp/BitcodeEmbeddingMode;)V", "kind", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/NativeOutputKind;", "targets", "", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "getTargets", "()Ljava/util/Set;", "setTargets", "(Ljava/util/Set;)V", "registerAssembleTask", "", "project", "Lorg/gradle/api/Project;", "name", "", "registerAssembleTask$kotlin_gradle_plugin", "", "([Lorg/jetbrains/kotlin/konan/target/KonanTarget;)V", "validate", "", "validate$kotlin_gradle_plugin", "kotlin-gradle-plugin"})
public class KotlinNativeXCFramework
extends KotlinNativeArtifact {
    @NotNull
    private Set<? extends KonanTarget> targets = SetsKt.emptySet();
    @Nullable
    private BitcodeEmbeddingMode embedBitcode;
    @NotNull
    private final NativeOutputKind kind = NativeOutputKind.FRAMEWORK;

    @NotNull
    public final Set<KonanTarget> getTargets() {
        return this.targets;
    }

    public final void setTargets(@NotNull Set<? extends KonanTarget> set2) {
        Intrinsics.checkNotNullParameter(set2, (String)"<set-?>");
        this.targets = set2;
    }

    public final void targets(KonanTarget ... targets) {
        Intrinsics.checkNotNullParameter((Object)targets, (String)"targets");
        this.targets = ArraysKt.toSet((Object[])targets);
    }

    @Nullable
    public final BitcodeEmbeddingMode getEmbedBitcode() {
        return this.embedBitcode;
    }

    public final void setEmbedBitcode(@Nullable BitcodeEmbeddingMode bitcodeEmbeddingMode) {
        this.embedBitcode = bitcodeEmbeddingMode;
    }

    @Override
    public boolean validate$kotlin_gradle_plugin(@NotNull Project project, @NotNull String name2) {
        Object v0;
        Logger logger;
        block4: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            logger = project.getLogger();
            if (!super.validate$kotlin_gradle_plugin(project, name2)) {
                return false;
            }
            if (this.targets.isEmpty()) {
                logger.error("Native library '" + name2 + "' wasn't configured because it requires at least one target");
                return false;
            }
            Iterable $this$firstOrNull$iv = this.targets;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KonanTarget it = (KonanTarget)element$iv;
                boolean bl = false;
                if (!(!this.kind.availableFor(it))) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        KonanTarget konanTarget2 = v0;
        if (konanTarget2 != null) {
            KonanTarget konanTarget3;
            KonanTarget target2 = konanTarget3 = konanTarget2;
            boolean bl = false;
            logger.error("Native library '" + name2 + "' wasn't configured because " + this.kind.getDescription() + " is not available for " + target2.getVisibleName());
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void registerAssembleTask$kotlin_gradle_plugin(@NotNull Project project, @NotNull String name2) {
        void name$iv;
        void $this$registerTask_u24default$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Project project2 = project;
        Object object = new String[]{"assemble", name2, "XCFramework"};
        object = StringUtilsKt.lowerCamelCaseName(object);
        Function1 body$iv = (Function1)new Function1<Task, Unit>(name2){
            final /* synthetic */ String $name;
            {
                this.$name = $name;
                super(1);
            }

            public final void invoke(@NotNull Task it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.setGroup("build");
                it.setDescription("Assemble all types of registered '" + this.$name + "' XCFramework");
            }
        };
        List args$iv = CollectionsKt.emptyList();
        boolean $i$f$registerTask = false;
        TaskProvider<Task> parentTask2 = TasksProviderKt.registerTask((Project)$this$registerTask_u24default$iv, (String)name$iv, Task.class, args$iv, body$iv);
        TaskProvider taskProvider = project.getTasks().named("assemble");
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"project.tasks.named(Life\u2026lugin.ASSEMBLE_TASK_NAME)");
        TasksProviderKt.dependsOn(taskProvider, parentTask2);
        Iterable $this$forEach$iv = this.getModes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapTo$iv$iv;
            XCFrameworkTaskHolder xCFrameworkTaskHolder;
            NativeBuildType buildType = (NativeBuildType)element$iv;
            boolean bl = false;
            XCFrameworkTaskHolder it = xCFrameworkTaskHolder = XCFrameworkTaskHolder.Companion.create(project, name2, buildType);
            boolean bl2 = false;
            TasksProviderKt.dependsOn(parentTask2, it.getTask());
            XCFrameworkTaskHolder holder = xCFrameworkTaskHolder;
            String nameSuffix = "ForXCF";
            Iterable $this$map$iv = this.targets;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                AppleTarget appleTarget;
                FrameworkDescriptor descriptor2;
                TaskProvider<KotlinNativeLinkArtifactTask> targetTask2;
                Collection collection;
                block4: {
                    void target2;
                    KonanTarget konanTarget2 = (KonanTarget)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    String librariesConfigurationName = this.registerLibsDependencies(project, (KonanTarget)target2, name2 + nameSuffix, this.getModules$kotlin_gradle_plugin());
                    String exportConfigurationName = this.registerExportDependencies(project, (KonanTarget)target2, name2 + nameSuffix, this.getModules$kotlin_gradle_plugin());
                    targetTask2 = KotlinNativeFrameworkKt.registerLinkFrameworkTask(this, project, name2, (KonanTarget)target2, buildType, librariesConfigurationName, exportConfigurationName, this.embedBitcode, name2 + "XCFrameworkTemp", nameSuffix);
                    TasksProviderKt.dependsOn(holder.getTask(), targetTask2);
                    Provider frameworkFileProvider2 = targetTask2.map((Transformer)registerAssembleTask.1.frameworkDescriptors.1.frameworkFileProvider.1.INSTANCE);
                    Object object2 = frameworkFileProvider2.get();
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"frameworkFileProvider.get()");
                    descriptor2 = new FrameworkDescriptor((File)object2, this.isStatic, (KonanTarget)target2);
                    AppleTarget[] $this$firstOrNull$iv = AppleTarget.values();
                    boolean $i$f$firstOrNull = false;
                    AppleTarget[] appleTargetArray = $this$firstOrNull$iv;
                    int n = appleTargetArray.length;
                    for (int i = 0; i < n; ++i) {
                        AppleTarget element$iv2;
                        AppleTarget it2 = element$iv2 = appleTargetArray[i];
                        boolean bl4 = false;
                        if (!it2.getTargets().contains(target2)) continue;
                        appleTarget = element$iv2;
                        break block4;
                    }
                    appleTarget = null;
                }
                AppleTarget group2 = appleTarget;
                TaskProvider<FatFrameworkTask> taskProvider2 = holder.getFatTasks().get((Object)group2);
                if (taskProvider2 != null) {
                    taskProvider2.configure(new Action(name2, descriptor2, targetTask2){
                        final /* synthetic */ String $name;
                        final /* synthetic */ FrameworkDescriptor $descriptor;
                        final /* synthetic */ TaskProvider<KotlinNativeLinkArtifactTask> $targetTask;
                        {
                            this.$name = $name;
                            this.$descriptor = $descriptor;
                            this.$targetTask = $targetTask;
                        }

                        public final void execute(FatFrameworkTask fatTask2) {
                            fatTask2.setBaseName(this.$name);
                            fatTask2.fromFrameworkDescriptors(CollectionsKt.listOf((Object)this.$descriptor));
                            Object[] objectArray = new Object[]{this.$targetTask};
                            fatTask2.dependsOn(objectArray);
                        }
                    });
                }
                collection.add(descriptor2);
            }
            List frameworkDescriptors2 = (List)destination$iv$iv;
            holder.getTask().configure(new Action(frameworkDescriptors2, project){
                final /* synthetic */ List<FrameworkDescriptor> $frameworkDescriptors;
                final /* synthetic */ Project $project;
                {
                    this.$frameworkDescriptors = $frameworkDescriptors;
                    this.$project = $project;
                }

                public final void execute(XCFrameworkTask it) {
                    it.fromFrameworkDescriptors((Iterable<FrameworkDescriptor>)this.$frameworkDescriptors);
                    File file = this.$project.getBuildDir();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.buildDir");
                    it.setOutputDir(FilesKt.resolve((File)file, (String)"out/xcframework"));
                }
            });
        }
    }
}

