/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.report;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.report.metrics.BuildAttribute;
import org.jetbrains.kotlin.build.report.metrics.BuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.gradle.internal.build.metrics.GradleBuildMetricsData;
import org.jetbrains.kotlin.gradle.internal.build.metrics.TaskData;
import org.jetbrains.kotlin.gradle.logging.GradleLoggingUtilsKt;
import org.jetbrains.kotlin.gradle.report.data.BuildExecutionData;
import org.jetbrains.kotlin.gradle.report.data.BuildExecutionDataProcessor;
import org.jetbrains.kotlin.gradle.report.data.TaskExecutionData;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/gradle/report/MetricsWriter;", "Lorg/jetbrains/kotlin/gradle/report/data/BuildExecutionDataProcessor;", "outputFile", "Ljava/io/File;", "(Ljava/io/File;)V", "process", "", "build", "Lorg/jetbrains/kotlin/gradle/report/data/BuildExecutionData;", "log", "Lorg/gradle/api/logging/Logger;", "kotlin-gradle-plugin"})
public final class MetricsWriter
implements BuildExecutionDataProcessor {
    @NotNull
    private final File outputFile;

    public MetricsWriter(@NotNull File outputFile2) {
        Intrinsics.checkNotNullParameter((Object)outputFile2, (String)"outputFile");
        this.outputFile = outputFile2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void process(@NotNull BuildExecutionData build, @NotNull Logger log) {
        block15: {
            Intrinsics.checkNotNullParameter((Object)build, (String)"build");
            Intrinsics.checkNotNullParameter((Object)log, (String)"log");
            if (!((Collection)build.getFailureMessages()).isEmpty()) {
                return;
            }
            try {
                Object object;
                BuildTime[] buildTimeArray = this.outputFile.getParentFile();
                if (buildTimeArray != null) {
                    object = buildTimeArray;
                    BuildTime[] $this$process_u24lambda_u2d0 = object;
                    int n = 0;
                    $this$process_u24lambda_u2d0.mkdirs();
                }
                GradleBuildMetricsData buildMetricsData = new GradleBuildMetricsData();
                for (BuildTime buildTime : BuildTime.values()) {
                    Map<String, String> map = buildMetricsData.getParentMetric();
                    String string = buildTime.name();
                    BuildTime buildTime2 = buildTime.getParent();
                    String string2 = buildTime2 != null ? buildTime2.name() : null;
                    map.put(string, string2);
                }
                for (BuildTime buildTime : BuildAttribute.values()) {
                    buildMetricsData.getBuildAttributeKind().put(buildTime.name(), buildTime.getKind().name());
                }
                for (TaskExecutionData data232 : build.getTaskExecutionData()) {
                    void $this$mapKeysTo$iv$iv;
                    void $this$mapKeysTo$iv$iv2;
                    Object object2;
                    Object object3;
                    Map map;
                    Object element$iv$iv$iv22;
                    void $this$mapKeysTo$iv$iv3;
                    String path = data232.getTaskPath();
                    String string = data232.getType();
                    Map $this$mapKeys$iv = data232.getBuildMetrics().getBuildTimes().asMap();
                    boolean $i$f$mapKeys = false;
                    Map map2 = $this$mapKeys$iv;
                    Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
                    boolean $i$f$mapKeysTo = false;
                    Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv3.entrySet();
                    boolean $i$f$associateByTo = false;
                    for (Object element$iv$iv$iv22 : $this$associateByTo$iv$iv$iv) {
                        void it$iv$iv;
                        Object object4 = (Map.Entry)element$iv$iv$iv22;
                        map = destination$iv$iv;
                        boolean bl = false;
                        BuildTime k = (BuildTime)object4.getKey();
                        Map.Entry entry = (Map.Entry)element$iv$iv$iv22;
                        object3 = k.name();
                        object2 = map;
                        boolean bl2 = false;
                        object4 = it$iv$iv.getValue();
                        object2.put(object3, object4);
                    }
                    Map buildTimes = destination$iv$iv;
                    Map $this$mapKeys$iv2 = data232.getBuildMetrics().getBuildPerformanceMetrics().asMap();
                    boolean $i$f$mapKeys2 = false;
                    destination$iv$iv = $this$mapKeys$iv2;
                    Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv2.size()));
                    boolean $i$f$mapKeysTo2 = false;
                    Iterable $this$associateByTo$iv$iv$iv2 = $this$mapKeysTo$iv$iv2.entrySet();
                    boolean $i$f$associateByTo2 = false;
                    element$iv$iv$iv22 = $this$associateByTo$iv$iv$iv2.iterator();
                    while (element$iv$iv$iv22.hasNext()) {
                        void it$iv$iv;
                        Object element$iv$iv$iv3 = element$iv$iv$iv22.next();
                        Map.Entry bl = (Map.Entry)element$iv$iv$iv3;
                        map = destination$iv$iv2;
                        boolean bl3 = false;
                        BuildPerformanceMetric k = (BuildPerformanceMetric)bl.getKey();
                        object3 = (Map.Entry)element$iv$iv$iv3;
                        object2 = k.name();
                        Map map3 = map;
                        boolean bl4 = false;
                        bl = it$iv$iv.getValue();
                        map3.put(object2, bl);
                    }
                    Map buildPerfMetrics = destination$iv$iv2;
                    Map $this$mapKeys$iv3 = data232.getBuildMetrics().getBuildAttributes().asMap();
                    boolean $i$f$mapKeys3 = false;
                    destination$iv$iv2 = $this$mapKeys$iv3;
                    Map destination$iv$iv3 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv3.size()));
                    boolean $i$f$mapKeysTo3 = false;
                    Iterable $this$associateByTo$iv$iv$iv3 = $this$mapKeysTo$iv$iv.entrySet();
                    boolean $i$f$associateByTo3 = false;
                    for (Object element$iv$iv$iv4 : $this$associateByTo$iv$iv$iv3) {
                        void it$iv$iv;
                        Map.Entry entry = (Map.Entry)element$iv$iv$iv4;
                        map = destination$iv$iv3;
                        boolean bl = false;
                        BuildAttribute k = (BuildAttribute)entry.getKey();
                        object2 = (Map.Entry)element$iv$iv$iv4;
                        String string3 = k.name();
                        Map map4 = map;
                        boolean bl5 = false;
                        entry = it$iv$iv.getValue();
                        map4.put(string3, entry);
                    }
                    Map buildAttributes = destination$iv$iv3;
                    buildMetricsData.getTaskData().put(path, new TaskData(path, string, buildTimes, buildPerfMetrics, buildAttributes, data232.getDidWork()));
                }
                object = new FileOutputStream(this.outputFile);
                int data232 = 8192;
                object = new ObjectOutputStream(object instanceof BufferedOutputStream ? (BufferedOutputStream)object : new BufferedOutputStream((OutputStream)object, data232));
                Throwable data232 = null;
                try {
                    ObjectOutputStream out = (ObjectOutputStream)object;
                    boolean bl = false;
                    out.writeObject(buildMetricsData);
                    out = Unit.INSTANCE;
                }
                catch (Throwable out) {
                    data232 = out;
                    throw out;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)data232);
                }
            }
            catch (Exception e) {
                Logger $this$kotlinDebug$iv = log;
                boolean $i$f$kotlinDebug = false;
                if (!$this$kotlinDebug$iv.isDebugEnabled()) break block15;
                Logger logger = $this$kotlinDebug$iv;
                boolean bl = false;
                GradleLoggingUtilsKt.kotlinDebug(logger, "Could not write metrics to " + this.outputFile + ": " + e);
            }
        }
    }
}

