/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.tasks;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.tasks.FrameworkDsymLayout;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u001cR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0011\u0010\u0010\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u0011\u0010\u0012\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0007R\u0011\u0010\u0014\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0007R\u0011\u0010\u0016\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0007\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/gradle/tasks/FrameworkLayout;", "", "rootDir", "Ljava/io/File;", "(Ljava/io/File;)V", "binary", "getBinary", "()Ljava/io/File;", "dSYM", "Lorg/jetbrains/kotlin/gradle/tasks/FrameworkDsymLayout;", "getDSYM", "()Lorg/jetbrains/kotlin/gradle/tasks/FrameworkDsymLayout;", "frameworkName", "", "header", "getHeader", "headerDir", "getHeaderDir", "infoPlist", "getInfoPlist", "moduleFile", "getModuleFile", "modulesDir", "getModulesDir", "getRootDir", "exists", "", "mkdirs", "", "kotlin-gradle-plugin"})
public final class FrameworkLayout {
    @NotNull
    private final File rootDir;
    @NotNull
    private final String frameworkName;
    @NotNull
    private final File headerDir;
    @NotNull
    private final File modulesDir;
    @NotNull
    private final File binary;
    @NotNull
    private final File header;
    @NotNull
    private final File moduleFile;
    @NotNull
    private final File infoPlist;
    @NotNull
    private final FrameworkDsymLayout dSYM;

    public FrameworkLayout(@NotNull File rootDir2) {
        Intrinsics.checkNotNullParameter((Object)rootDir2, (String)"rootDir");
        this.rootDir = rootDir2;
        if (!Intrinsics.areEqual((Object)FilesKt.getExtension((File)this.rootDir), (Object)"framework")) {
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.frameworkName = FilesKt.getNameWithoutExtension((File)this.rootDir);
        this.headerDir = FilesKt.resolve((File)this.rootDir, (String)"Headers");
        this.modulesDir = FilesKt.resolve((File)this.rootDir, (String)"Modules");
        this.binary = FilesKt.resolve((File)this.rootDir, (String)this.frameworkName);
        this.header = FilesKt.resolve((File)this.headerDir, (String)(this.frameworkName + ".h"));
        this.moduleFile = FilesKt.resolve((File)this.modulesDir, (String)"module.modulemap");
        this.infoPlist = FilesKt.resolve((File)this.rootDir, (String)"Info.plist");
        File file = this.rootDir.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"rootDir.parentFile");
        this.dSYM = new FrameworkDsymLayout(FilesKt.resolve((File)file, (String)(this.frameworkName + ".framework.dSYM")));
    }

    @NotNull
    public final File getRootDir() {
        return this.rootDir;
    }

    @NotNull
    public final File getHeaderDir() {
        return this.headerDir;
    }

    @NotNull
    public final File getModulesDir() {
        return this.modulesDir;
    }

    @NotNull
    public final File getBinary() {
        return this.binary;
    }

    @NotNull
    public final File getHeader() {
        return this.header;
    }

    @NotNull
    public final File getModuleFile() {
        return this.moduleFile;
    }

    @NotNull
    public final File getInfoPlist() {
        return this.infoPlist;
    }

    @NotNull
    public final FrameworkDsymLayout getDSYM() {
        return this.dSYM;
    }

    public final void mkdirs() {
        this.rootDir.mkdirs();
        this.headerDir.mkdir();
        this.modulesDir.mkdir();
    }

    public final boolean exists() {
        return this.rootDir.exists();
    }
}

