/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.utils.StringUtilsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\u001a%\u0010\u0004\u001a\u00020\u00052\u0016\u0010\u0006\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00050\u0007\"\u0004\u0018\u00010\u0005H\u0000\u00a2\u0006\u0002\u0010\b\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\tH\u0000\u001a%\u0010\n\u001a\u00020\u00052\u0016\u0010\u0006\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00050\u0007\"\u0004\u0018\u00010\u0005H\u0000\u00a2\u0006\u0002\u0010\b\u001a\u0014\u0010\u000b\u001a\u00060\fj\u0002`\r*\u00060\fj\u0002`\rH\u0000\u001a\u001e\u0010\u000b\u001a\u00060\fj\u0002`\r*\u00060\fj\u0002`\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0000\u001a\f\u0010\u0010\u001a\u00020\u0005*\u00020\u0005H\u0000\u001a\f\u0010\u0011\u001a\u00020\u0005*\u00020\u0005H\u0000\u001a\f\u0010\u0012\u001a\u00020\u0005*\u00020\u0005H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"ANSI_COLOR_REGEX", "Lkotlin/text/Regex;", "invalidTaskNameCharacters", "upperCaseRegex", "dashSeparatedName", "", "nameParts", "", "([Ljava/lang/String;)Ljava/lang/String;", "", "lowerCamelCaseName", "appendLine", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "value", "", "asValidTaskName", "clearAnsiColor", "decamelize", "kotlin-gradle-plugin"})
public final class StringUtilsKt {
    @NotNull
    private static final Regex upperCaseRegex = new Regex("([A-Z])");
    @NotNull
    private static final Regex invalidTaskNameCharacters = new Regex("[/\\\\:<>\"?*|]");
    @NotNull
    private static final Regex ANSI_COLOR_REGEX = new Regex("\\x1b\\[[0-9;]*m");

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String lowerCamelCaseName(String ... nameParts) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)nameParts, (String)"nameParts");
        String[] $this$mapNotNull$iv = nameParts;
        boolean $i$f$mapNotNull = false;
        String[] stringArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        void var9_8 = $this$forEach$iv$iv$iv;
        int n = ((void)var9_8).length;
        for (int i = 0; i < n; ++i) {
            Object e;
            Object object;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = var9_8[i];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            if (it != null) {
                void var17_16;
                void p0 = var17_16;
                boolean bl3 = false;
                object = ((CharSequence)p0).length() > 0 ? var17_16 : null;
            } else {
                object = null;
            }
            if (object == null) continue;
            Object it$iv$iv = e = object;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List nonEmptyParts = (List)destination$iv$iv;
        Iterable iterable = CollectionsKt.drop((Iterable)nonEmptyParts, (int)1);
        CharSequence charSequence = "";
        String string = (String)CollectionsKt.firstOrNull((List)nonEmptyParts);
        if (string == null) {
            string = "";
        }
        return CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)charSequence, (CharSequence)string, null, (int)0, null, (Function1)lowerCamelCaseName.1.INSTANCE, (int)28, null);
    }

    @NotNull
    public static final String dashSeparatedName(@NotNull Iterable<String> nameParts) {
        Intrinsics.checkNotNullParameter(nameParts, (String)"nameParts");
        Collection $this$toTypedArray$iv = CollectionsKt.toList(nameParts);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] stringArray2 = stringArray;
        return StringUtilsKt.dashSeparatedName(Arrays.copyOf(stringArray2, stringArray2.length));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String dashSeparatedName(String ... nameParts) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)nameParts, (String)"nameParts");
        String[] $this$mapNotNull$iv = nameParts;
        boolean $i$f$mapNotNull = false;
        String[] stringArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        void var9_8 = $this$forEach$iv$iv$iv;
        int n = ((void)var9_8).length;
        for (int i = 0; i < n; ++i) {
            Object e;
            Object object;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = var9_8[i];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            if (it != null) {
                void var17_16;
                void p0 = var17_16;
                boolean bl3 = false;
                object = ((CharSequence)p0).length() > 0 ? var17_16 : null;
            } else {
                object = null;
            }
            if (object == null) continue;
            Object it$iv$iv = e = object;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List nonEmptyParts = (List)destination$iv$iv;
        return CollectionsKt.joinToString$default((Iterable)nonEmptyParts, (CharSequence)"-", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public static final String decamelize(@NotNull String $this$decamelize) {
        Intrinsics.checkNotNullParameter((Object)$this$decamelize, (String)"<this>");
        CharSequence charSequence = $this$decamelize;
        Regex regex = upperCaseRegex;
        Function1 function1 = decamelize.1.INSTANCE;
        return regex.replace(charSequence, function1);
    }

    @NotNull
    public static final String asValidTaskName(@NotNull String $this$asValidTaskName) {
        Intrinsics.checkNotNullParameter((Object)$this$asValidTaskName, (String)"<this>");
        CharSequence charSequence = $this$asValidTaskName;
        Regex regex = invalidTaskNameCharacters;
        String string = "_";
        return regex.replace(charSequence, string);
    }

    @NotNull
    public static final String clearAnsiColor(@NotNull String $this$clearAnsiColor) {
        Intrinsics.checkNotNullParameter((Object)$this$clearAnsiColor, (String)"<this>");
        CharSequence charSequence = $this$clearAnsiColor;
        Regex regex = ANSI_COLOR_REGEX;
        String string = "";
        return regex.replace(charSequence, string);
    }

    @NotNull
    public static final Appendable appendLine(@NotNull Appendable $this$appendLine, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)$this$appendLine, (String)"<this>");
        Appendable appendable = $this$appendLine.append(String.valueOf(value));
        Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(value.toString())");
        return StringUtilsKt.appendLine(appendable);
    }

    @NotNull
    public static final Appendable appendLine(@NotNull Appendable $this$appendLine) {
        Intrinsics.checkNotNullParameter((Object)$this$appendLine, (String)"<this>");
        Appendable appendable = $this$appendLine.append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append('\\n')");
        return appendable;
    }
}

