/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.tooling.core;

import java.util.List;
import kotlin.KotlinVersion;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.tooling.core.KotlinToolingVersion;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u001a\u001a\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u001a\u000e\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0015\u001a\u0015\u0010\u0017\u001a\u00020\u0001*\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0002H\u0086\u0002\u001a\u0015\u0010\u0017\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0015H\u0086\u0002\u001a\u0016\u0010\u0019\u001a\u00020\u0002*\u00020\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u001a\n\u0010\u001a\u001a\u00020\u0013*\u00020\u0002\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\"\u0015\u0010\u0007\u001a\u00020\b*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\t\"\u0015\u0010\n\u001a\u00020\b*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\t\"\u0015\u0010\u000b\u001a\u00020\b*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\"\u0015\u0010\f\u001a\u00020\b*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\t\"\u0015\u0010\r\u001a\u00020\b*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\t\"\u0015\u0010\u000e\u001a\u00020\b*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\t\"\u0015\u0010\u000f\u001a\u00020\b*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\t\"\u0015\u0010\u0010\u001a\u00020\b*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\t\u00a8\u0006\u001b"}, d2={"buildNumber", "", "Lorg/jetbrains/kotlin/tooling/core/KotlinToolingVersion;", "getBuildNumber", "(Lorg/jetbrains/kotlin/tooling/core/KotlinToolingVersion;)Ljava/lang/Integer;", "classifierNumber", "getClassifierNumber", "isAlpha", "", "(Lorg/jetbrains/kotlin/tooling/core/KotlinToolingVersion;)Z", "isBeta", "isDev", "isMilestone", "isPreRelease", "isRC", "isSnapshot", "isStable", "KotlinToolingVersion", "kotlinVersion", "Lkotlin/KotlinVersion;", "classifier", "", "kotlinVersionString", "compareTo", "version", "toKotlinToolingVersion", "toKotlinVersion", "kotlin-tooling-core"})
public final class KotlinToolingVersionKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final KotlinToolingVersion KotlinToolingVersion(@NotNull String kotlinVersionString) {
        int n;
        Intrinsics.checkNotNullParameter((Object)kotlinVersionString, (String)"kotlinVersionString");
        String[] stringArray = new String[]{"-"};
        String baseVersion = (String)StringsKt.split$default((CharSequence)kotlinVersionString, (String[])stringArray, (boolean)false, (int)2, (int)2, null).get(0);
        String[] stringArray2 = new String[]{"-"};
        String classifier = (String)CollectionsKt.getOrNull((List)StringsKt.split$default((CharSequence)kotlinVersionString, (String[])stringArray2, (boolean)false, (int)2, (int)2, null), (int)1);
        String[] stringArray3 = new String[]{"."};
        List baseVersionSplit = StringsKt.split$default((CharSequence)baseVersion, (String[])stringArray3, (boolean)false, (int)0, (int)6, null);
        if (baseVersionSplit.size() != 2 && baseVersionSplit.size() != 3) {
            KotlinToolingVersionKt.KotlinToolingVersion$throwInvalid(kotlinVersionString);
            throw null;
        }
        Integer n2 = StringsKt.toIntOrNull((String)((String)baseVersionSplit.get(0)));
        if (n2 == null) {
            KotlinToolingVersionKt.KotlinToolingVersion$throwInvalid(kotlinVersionString);
            throw null;
        }
        int n3 = n2;
        Integer n4 = StringsKt.toIntOrNull((String)((String)baseVersionSplit.get(1)));
        if (n4 == null) {
            KotlinToolingVersionKt.KotlinToolingVersion$throwInvalid(kotlinVersionString);
            throw null;
        }
        int n5 = n4;
        String string = (String)CollectionsKt.getOrNull((List)baseVersionSplit, (int)2);
        if (string != null) {
            void it;
            String string2 = string;
            int n6 = n5;
            int n7 = n3;
            boolean bl = false;
            Integer n8 = StringsKt.toIntOrNull((String)it);
            if (n8 == null) {
                KotlinToolingVersionKt.KotlinToolingVersion$throwInvalid(kotlinVersionString);
                throw null;
            }
            int n9 = n8;
            n3 = n7;
            n5 = n6;
            n = n9;
        } else {
            n = 0;
        }
        String string3 = classifier;
        int n10 = n;
        int n11 = n5;
        int n12 = n3;
        return new KotlinToolingVersion(n12, n11, n10, string3);
    }

    @NotNull
    public static final KotlinToolingVersion KotlinToolingVersion(@NotNull KotlinVersion kotlinVersion, @Nullable String classifier) {
        Intrinsics.checkNotNullParameter((Object)kotlinVersion, (String)"kotlinVersion");
        return new KotlinToolingVersion(kotlinVersion.getMajor(), kotlinVersion.getMinor(), kotlinVersion.getPatch(), classifier);
    }

    public static /* synthetic */ KotlinToolingVersion KotlinToolingVersion$default(KotlinVersion kotlinVersion, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return KotlinToolingVersionKt.KotlinToolingVersion(kotlinVersion, string);
    }

    @NotNull
    public static final KotlinVersion toKotlinVersion(@NotNull KotlinToolingVersion $this$toKotlinVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$toKotlinVersion, (String)"<this>");
        return new KotlinVersion($this$toKotlinVersion.getMajor(), $this$toKotlinVersion.getMinor(), $this$toKotlinVersion.getPatch());
    }

    @NotNull
    public static final KotlinToolingVersion toKotlinToolingVersion(@NotNull KotlinVersion $this$toKotlinToolingVersion, @Nullable String classifier) {
        Intrinsics.checkNotNullParameter((Object)$this$toKotlinToolingVersion, (String)"<this>");
        return KotlinToolingVersionKt.KotlinToolingVersion($this$toKotlinToolingVersion, classifier);
    }

    public static /* synthetic */ KotlinToolingVersion toKotlinToolingVersion$default(KotlinVersion kotlinVersion, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return KotlinToolingVersionKt.toKotlinToolingVersion(kotlinVersion, string);
    }

    public static final boolean isSnapshot(@NotNull KotlinToolingVersion $this$isSnapshot) {
        Intrinsics.checkNotNullParameter((Object)$this$isSnapshot, (String)"<this>");
        return $this$isSnapshot.getMaturity() == KotlinToolingVersion.Maturity.SNAPSHOT;
    }

    public static final boolean isDev(@NotNull KotlinToolingVersion $this$isDev) {
        Intrinsics.checkNotNullParameter((Object)$this$isDev, (String)"<this>");
        return $this$isDev.getMaturity() == KotlinToolingVersion.Maturity.DEV;
    }

    public static final boolean isMilestone(@NotNull KotlinToolingVersion $this$isMilestone) {
        Intrinsics.checkNotNullParameter((Object)$this$isMilestone, (String)"<this>");
        return $this$isMilestone.getMaturity() == KotlinToolingVersion.Maturity.MILESTONE;
    }

    public static final boolean isAlpha(@NotNull KotlinToolingVersion $this$isAlpha) {
        Intrinsics.checkNotNullParameter((Object)$this$isAlpha, (String)"<this>");
        return $this$isAlpha.getMaturity() == KotlinToolingVersion.Maturity.ALPHA;
    }

    public static final boolean isBeta(@NotNull KotlinToolingVersion $this$isBeta) {
        Intrinsics.checkNotNullParameter((Object)$this$isBeta, (String)"<this>");
        return $this$isBeta.getMaturity() == KotlinToolingVersion.Maturity.BETA;
    }

    public static final boolean isRC(@NotNull KotlinToolingVersion $this$isRC) {
        Intrinsics.checkNotNullParameter((Object)$this$isRC, (String)"<this>");
        return $this$isRC.getMaturity() == KotlinToolingVersion.Maturity.RC;
    }

    public static final boolean isStable(@NotNull KotlinToolingVersion $this$isStable) {
        Intrinsics.checkNotNullParameter((Object)$this$isStable, (String)"<this>");
        return $this$isStable.getMaturity() == KotlinToolingVersion.Maturity.STABLE;
    }

    public static final boolean isPreRelease(@NotNull KotlinToolingVersion $this$isPreRelease) {
        Intrinsics.checkNotNullParameter((Object)$this$isPreRelease, (String)"<this>");
        return !KotlinToolingVersionKt.isStable($this$isPreRelease);
    }

    @Nullable
    public static final Integer getBuildNumber(@NotNull KotlinToolingVersion $this$buildNumber) {
        Intrinsics.checkNotNullParameter((Object)$this$buildNumber, (String)"<this>");
        if ($this$buildNumber.getClassifier() == null) {
            return null;
        }
        Regex buildNumberOnlyClassifierRegex = new Regex("\\d+");
        if (buildNumberOnlyClassifierRegex.matches((CharSequence)$this$buildNumber.getClassifier())) {
            return StringsKt.toIntOrNull((String)$this$buildNumber.getClassifier());
        }
        Regex classifierRegex = new Regex("(.+?)(\\d*)?(-release)?-?(\\d*)?");
        MatchResult matchResult = classifierRegex.matchEntire((CharSequence)$this$buildNumber.getClassifier());
        if (matchResult == null) {
            return null;
        }
        MatchResult classifierMatch = matchResult;
        String string = (String)CollectionsKt.getOrNull((List)classifierMatch.getGroupValues(), (int)4);
        return string != null ? StringsKt.toIntOrNull((String)string) : null;
    }

    @Nullable
    public static final Integer getClassifierNumber(@NotNull KotlinToolingVersion $this$classifierNumber) {
        Intrinsics.checkNotNullParameter((Object)$this$classifierNumber, (String)"<this>");
        if ($this$classifierNumber.getClassifier() == null) {
            return null;
        }
        Regex buildNumberOnlyClassifierRegex = new Regex("\\d+");
        if (buildNumberOnlyClassifierRegex.matches((CharSequence)$this$classifierNumber.getClassifier())) {
            return null;
        }
        Regex classifierRegex = new Regex("(.+?)(\\d*)?(-release)?-?(\\d*)?");
        MatchResult matchResult = classifierRegex.matchEntire((CharSequence)$this$classifierNumber.getClassifier());
        if (matchResult == null) {
            return null;
        }
        MatchResult classifierMatch = matchResult;
        String string = (String)CollectionsKt.getOrNull((List)classifierMatch.getGroupValues(), (int)2);
        return string != null ? StringsKt.toIntOrNull((String)string) : null;
    }

    public static final int compareTo(@NotNull String $this$compareTo, @NotNull KotlinToolingVersion version2) {
        Intrinsics.checkNotNullParameter((Object)$this$compareTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        return KotlinToolingVersionKt.KotlinToolingVersion($this$compareTo).compareTo(version2);
    }

    public static final int compareTo(@NotNull KotlinToolingVersion $this$compareTo, @NotNull String kotlinVersionString) {
        Intrinsics.checkNotNullParameter((Object)$this$compareTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)kotlinVersionString, (String)"kotlinVersionString");
        return $this$compareTo.compareTo(KotlinToolingVersionKt.KotlinToolingVersion(kotlinVersionString));
    }

    private static final Void KotlinToolingVersion$throwInvalid(String $kotlinVersionString) {
        throw new IllegalArgumentException("Invalid Kotlin version: " + $kotlinVersionString);
    }
}

