/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.js.npm;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.targets.js.npm.AbstractNodeModulesCacheKt;
import org.jetbrains.kotlin.gradle.targets.js.npm.CompositeNodeModuleBuilderKt;
import org.jetbrains.kotlin.gradle.targets.js.npm.PackageJson;
import org.jetbrains.kotlin.gradle.targets.js.npm.PackageJsonKt;
import org.jetbrains.kotlin.gradle.targets.js.npm.SemverKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\r\u001a\u0004\u0018\u00010\u0003R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007R\u001a\u0010\t\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/npm/CompositeNodeModuleBuilder;", "", "srcDir", "Ljava/io/File;", "cacheDir", "(Ljava/io/File;Ljava/io/File;)V", "getCacheDir", "()Ljava/io/File;", "getSrcDir", "srcPackageJsonFile", "getSrcPackageJsonFile", "setSrcPackageJsonFile", "(Ljava/io/File;)V", "rebuild", "kotlin-gradle-plugin_common"})
public final class CompositeNodeModuleBuilder {
    @NotNull
    private final File srcDir;
    @NotNull
    private final File cacheDir;
    @NotNull
    private File srcPackageJsonFile;

    public CompositeNodeModuleBuilder(@NotNull File srcDir2, @NotNull File cacheDir) {
        Intrinsics.checkNotNullParameter((Object)srcDir2, (String)"srcDir");
        Intrinsics.checkNotNullParameter((Object)cacheDir, (String)"cacheDir");
        this.srcDir = srcDir2;
        this.cacheDir = cacheDir;
        this.srcPackageJsonFile = this.srcDir;
    }

    @NotNull
    public final File getSrcDir() {
        return this.srcDir;
    }

    @NotNull
    public final File getCacheDir() {
        return this.cacheDir;
    }

    @NotNull
    public final File getSrcPackageJsonFile() {
        return this.srcPackageJsonFile;
    }

    public final void setSrcPackageJsonFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        this.srcPackageJsonFile = file;
    }

    @Nullable
    public final File rebuild() {
        String string;
        boolean bl = this.srcPackageJsonFile.isFile();
        if (!bl) {
            boolean $i$a$-check-CompositeNodeModuleBuilder$rebuild$22 = false;
            String $i$a$-check-CompositeNodeModuleBuilder$rebuild$22 = "Unable to read package.json of composite build";
            throw (Throwable)new IllegalStateException($i$a$-check-CompositeNodeModuleBuilder$rebuild$22.toString());
        }
        PackageJson packageJson2 = PackageJsonKt.fromSrcPackageJson(this.srcPackageJsonFile);
        Intrinsics.checkNotNull((Object)packageJson2);
        PackageJson packageJson3 = packageJson2;
        packageJson3.setVersion(SemverKt.fixSemver(packageJson3.getVersion()));
        File importedPackageDir = AbstractNodeModulesCacheKt.importedPackageDir(this.cacheDir, packageJson3.getName(), packageJson3.getVersion());
        File file = this.srcDir.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"srcDir.parentFile");
        String string2 = packageJson3.getMain();
        Intrinsics.checkNotNull((Object)string2);
        File file2 = FilesKt.relativeToOrNull((File)FilesKt.resolve((File)file, (String)string2), (File)importedPackageDir);
        if (file2 == null || (string = file2.getPath()) == null) {
            throw new IllegalStateException("Unable to link composite builds for Kotlin/JS which have different roots");
        }
        packageJson3.setMain(string);
        return CompositeNodeModuleBuilderKt.access$makeNodeModule(this.cacheDir, packageJson3);
    }
}

