/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.logging;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.compilerRunner.KotlinLogger;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\u001a\u001e\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0080\b\u00f8\u0001\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0005H\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u0001*\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0080\b\u00f8\u0001\u0000\u001a\u0014\u0010\b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0005H\u0000\u001a\u0014\u0010\t\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0005H\u0000\u001a1\u0010\n\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b*\u00020\u00062\u0006\u0010\f\u001a\u00020\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0004H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\r\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u000e"}, d2={"kotlinDebug", "", "Lorg/gradle/api/logging/Logger;", "message", "Lkotlin/Function0;", "", "Lorg/jetbrains/kotlin/compilerRunner/KotlinLogger;", "fn", "kotlinInfo", "kotlinWarn", "logTime", "T", "action", "(Lorg/jetbrains/kotlin/compilerRunner/KotlinLogger;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "kotlin-gradle-plugin_common"})
public final class GradleLoggingUtilsKt {
    public static final void kotlinInfo(@NotNull Logger $this$kotlinInfo, @NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)$this$kotlinInfo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        $this$kotlinInfo.info("[KOTLIN] " + message2);
    }

    public static final void kotlinDebug(@NotNull Logger $this$kotlinDebug, @NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)$this$kotlinDebug, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        $this$kotlinDebug.debug("[KOTLIN] " + message2);
    }

    public static final void kotlinWarn(@NotNull Logger $this$kotlinWarn, @NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)$this$kotlinWarn, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        $this$kotlinWarn.warn("[KOTLIN] " + message2);
    }

    public static final void kotlinDebug(@NotNull Logger $this$kotlinDebug, @NotNull Function0<String> message2) {
        Intrinsics.checkNotNullParameter((Object)$this$kotlinDebug, (String)"<this>");
        Intrinsics.checkNotNullParameter(message2, (String)"message");
        boolean $i$f$kotlinDebug = false;
        if ($this$kotlinDebug.isDebugEnabled()) {
            GradleLoggingUtilsKt.kotlinDebug($this$kotlinDebug, (String)message2.invoke());
        }
    }

    public static final void kotlinDebug(@NotNull KotlinLogger $this$kotlinDebug, @NotNull Function0<String> fn2) {
        Intrinsics.checkNotNullParameter((Object)$this$kotlinDebug, (String)"<this>");
        Intrinsics.checkNotNullParameter(fn2, (String)"fn");
        boolean $i$f$kotlinDebug = false;
        if ($this$kotlinDebug.isDebugEnabled()) {
            String msg = (String)fn2.invoke();
            $this$kotlinDebug.debug("[KOTLIN] " + msg);
        }
    }

    public static final <T> T logTime(@NotNull KotlinLogger $this$logTime, @NotNull String action, @NotNull Function0<? extends T> fn2) {
        Intrinsics.checkNotNullParameter((Object)$this$logTime, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter(fn2, (String)"fn");
        boolean $i$f$logTime = false;
        long startNs = System.nanoTime();
        Object result2 = fn2.invoke();
        long endNs = System.nanoTime();
        long timeNs = endNs - startNs;
        double timeMs = (double)timeNs / (double)1000000;
        String string = "%s took %.2f ms";
        Object[] objectArray = new Object[]{action, timeMs};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        $this$logTime.debug(string2);
        return (T)result2;
    }
}

