/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import com.gradle.scan.plugin.BuildScanExtension;
import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.services.BuildServiceSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.logging.GradleLoggingUtilsKt;
import org.jetbrains.kotlin.gradle.plugin.BuildEventsListenerRegistryHolder;
import org.jetbrains.kotlin.gradle.plugin.KotlinGradleBuildServices;
import org.jetbrains.kotlin.gradle.plugin.KotlinGradleFinishBuildHandler;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginInMultipleProjectsHolder;
import org.jetbrains.kotlin.gradle.plugin.PropertiesProvider;
import org.jetbrains.kotlin.gradle.plugin.internal.state.TaskExecutionResults;
import org.jetbrains.kotlin.gradle.plugin.internal.state.TaskLoggers;
import org.jetbrains.kotlin.gradle.plugin.statistics.BuildScanStatisticsListener;
import org.jetbrains.kotlin.gradle.report.BuildReportType;
import org.jetbrains.kotlin.gradle.report.ConfigureReporingKt;
import org.jetbrains.kotlin.gradle.report.ReportingSettings;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b \u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0002\u0013\u0014B\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0007*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/KotlinGradleBuildServices;", "Lorg/gradle/api/services/BuildService;", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinGradleBuildServices$Parameters;", "Ljava/lang/AutoCloseable;", "()V", "CLASS_NAME", "", "kotlin.jvm.PlatformType", "DISPOSE_MESSAGE", "getDISPOSE_MESSAGE", "()Ljava/lang/String;", "INIT_MESSAGE", "getINIT_MESSAGE", "buildHandler", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinGradleFinishBuildHandler;", "log", "Lorg/gradle/api/logging/Logger;", "close", "", "Companion", "Parameters", "kotlin-gradle-plugin_common"})
public abstract class KotlinGradleBuildServices
implements BuildService<Parameters>,
AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Logger log = Logging.getLogger(this.getClass());
    @NotNull
    private final KotlinGradleFinishBuildHandler buildHandler = new KotlinGradleFinishBuildHandler();
    private final String CLASS_NAME = KotlinGradleBuildServices.class.getSimpleName();
    @NotNull
    private final String INIT_MESSAGE = "Initialized " + this.CLASS_NAME;
    @NotNull
    private final String DISPOSE_MESSAGE = "Disposed " + this.CLASS_NAME;
    @NotNull
    private static final KotlinPluginInMultipleProjectsHolder multipleProjectsHolder = new KotlinPluginInMultipleProjectsHolder(true);

    public KotlinGradleBuildServices() {
        Logger logger = this.log;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"log");
        GradleLoggingUtilsKt.kotlinDebug(logger, this.INIT_MESSAGE);
        this.buildHandler.buildStart();
    }

    @NotNull
    public final String getINIT_MESSAGE() {
        return this.INIT_MESSAGE;
    }

    @NotNull
    public final String getDISPOSE_MESSAGE() {
        return this.DISPOSE_MESSAGE;
    }

    @Override
    public void close() {
        this.buildHandler.buildFinished(((Parameters)this.getParameters()).getBuildDir(), ((Parameters)this.getParameters()).getRootDir());
        Logger logger = this.log;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"log");
        GradleLoggingUtilsKt.kotlinDebug(logger, this.DISPOSE_MESSAGE);
        TaskLoggers.INSTANCE.clear();
        TaskExecutionResults.INSTANCE.clear();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\u00020\u0003X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00020\u0003X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\u0005\"\u0004\b\n\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/KotlinGradleBuildServices$Parameters;", "Lorg/gradle/api/services/BuildServiceParameters;", "buildDir", "Ljava/io/File;", "getBuildDir", "()Ljava/io/File;", "setBuildDir", "(Ljava/io/File;)V", "rootDir", "getRootDir", "setRootDir", "kotlin-gradle-plugin_common"})
    public static interface Parameters
    extends BuildServiceParameters {
        @NotNull
        public File getBuildDir();

        public void setBuildDir(@NotNull File var1);

        @NotNull
        public File getRootDir();

        public void setRootDir(@NotNull File var1);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001d\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u000fJ\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/KotlinGradleBuildServices$Companion;", "", "()V", "multipleProjectsHolder", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinPluginInMultipleProjectsHolder;", "addListeners", "", "project", "Lorg/gradle/api/Project;", "reportingSettings", "Lorg/jetbrains/kotlin/gradle/report/ReportingSettings;", "kotlinVersion", "", "detectKotlinPluginLoadedInMultipleProjects", "kotlinPluginVersion", "detectKotlinPluginLoadedInMultipleProjects$kotlin_gradle_plugin_common", "registerIfAbsent", "Lorg/gradle/api/provider/Provider;", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinGradleBuildServices;", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Provider<KotlinGradleBuildServices> registerIfAbsent(@NotNull Project project, @NotNull String kotlinVersion) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)kotlinVersion, (String)"kotlinVersion");
            Provider provider = project.getGradle().getSharedServices().registerIfAbsent("kotlin-build-service-" + KotlinGradleBuildServices.class.getCanonicalName() + '_' + KotlinGradleBuildServices.class.getClassLoader().hashCode(), KotlinGradleBuildServices.class, new Action(project, kotlinVersion){
                final /* synthetic */ Project $project;
                final /* synthetic */ String $kotlinVersion;
                {
                    this.$project = $project;
                    this.$kotlinVersion = $kotlinVersion;
                }

                public final void execute(BuildServiceSpec<Parameters> service) {
                    Parameters parameters = (Parameters)service.getParameters();
                    File file = this.$project.getRootProject().getRootDir();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.rootProject.rootDir");
                    parameters.setRootDir(file);
                    Parameters parameters2 = (Parameters)service.getParameters();
                    File file2 = this.$project.getRootProject().getBuildDir();
                    Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"project.rootProject.buildDir");
                    parameters2.setBuildDir(file2);
                    Project project = this.$project.getRootProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project.rootProject");
                    ReportingSettings reportingSettings = ConfigureReporingKt.reportingSettings(project);
                    KotlinGradleBuildServices.Companion.addListeners(this.$project, reportingSettings, this.$kotlinVersion);
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"project: Project, kotlin\u2026linVersion)\n            }");
            return provider;
        }

        public final void addListeners(@NotNull Project project, @NotNull ReportingSettings reportingSettings, @NotNull String kotlinVersion) {
            block1: {
                Object object;
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)reportingSettings, (String)"reportingSettings");
                Intrinsics.checkNotNullParameter((Object)kotlinVersion, (String)"kotlinVersion");
                Object object2 = project.getRootProject().getExtensions().findByName("buildScan");
                if (object2 == null) break block1;
                Object it = object = object2;
                boolean bl = false;
                if (reportingSettings.getBuildReportOutputs().contains(BuildReportType.BUILD_SCAN)) {
                    BuildEventsListenerRegistryHolder listenerRegistryHolder = BuildEventsListenerRegistryHolder.Companion.getInstance(project);
                    listenerRegistryHolder.getListenerRegistry().onTaskCompletion(project.provider(new Callable(it, project, reportingSettings, kotlinVersion){
                        final /* synthetic */ Object $it;
                        final /* synthetic */ Project $project;
                        final /* synthetic */ ReportingSettings $reportingSettings;
                        final /* synthetic */ String $kotlinVersion;
                        {
                            this.$it = $it;
                            this.$project = $project;
                            this.$reportingSettings = $reportingSettings;
                            this.$kotlinVersion = $kotlinVersion;
                        }

                        public final BuildScanStatisticsListener call() {
                            Object object = this.$it;
                            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.gradle.scan.plugin.BuildScanExtension");
                            BuildScanExtension buildScanExtension = (BuildScanExtension)object;
                            String string = this.$project.getRootProject().getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.rootProject.name");
                            return new BuildScanStatisticsListener(buildScanExtension, string, this.$reportingSettings.getBuildReportLabel(), this.$kotlinVersion);
                        }
                    }));
                }
            }
        }

        public final synchronized void detectKotlinPluginLoadedInMultipleProjects$kotlin_gradle_plugin_common(@NotNull Project project, @NotNull String kotlinPluginVersion) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)kotlinPluginVersion, (String)"kotlinPluginVersion");
            Function0 onRegister2 = (Function0)new Function0<Unit>(project, kotlinPluginVersion){
                final /* synthetic */ Project $project;
                final /* synthetic */ String $kotlinPluginVersion;
                {
                    this.$project = $project;
                    this.$kotlinPluginVersion = $kotlinPluginVersion;
                    super(0);
                }

                public final void invoke() {
                    this.$project.getGradle().getTaskGraph().whenReady(new Action(this.$project, this.$kotlinPluginVersion){
                        final /* synthetic */ Project $project;
                        final /* synthetic */ String $kotlinPluginVersion;
                        {
                            this.$project = $project;
                            this.$kotlinPluginVersion = $kotlinPluginVersion;
                        }

                        public final void execute(TaskExecutionGraph it) {
                            if (KotlinGradleBuildServices.access$getMultipleProjectsHolder$cp().isInMultipleProjects(this.$project, this.$kotlinPluginVersion)) {
                                List<String> list2 = KotlinGradleBuildServices.access$getMultipleProjectsHolder$cp().getAffectedProjects(this.$project, this.$kotlinPluginVersion);
                                Intrinsics.checkNotNull(list2);
                                List<String> loadedInProjects = list2;
                                if (!Intrinsics.areEqual((Object)PropertiesProvider.Companion.invoke(this.$project).getIgnorePluginLoadedInMultipleProjects(), (Object)true)) {
                                    this.$project.getLogger().warn("\nThe Kotlin Gradle plugin was loaded multiple times in different subprojects, which is not supported and may break the build. \nThis might happen in subprojects that apply the Kotlin plugins with the Gradle 'plugins { ... }' DSL if they specify explicit versions, even if the versions are equal.\nPlease add the Kotlin plugin to the common parent project or the root project, then remove the versions in the subprojects.\nIf the parent project does not need the plugin, add 'apply false' to the plugin line.\nSee: https://docs.gradle.org/current/userguide/plugins.html#sec:subprojects_plugins_dsl");
                                    this.$project.getLogger().warn("The Kotlin plugin was loaded in the following projects: " + CollectionsKt.joinToString$default((Iterable)loadedInProjects, null, null, null, (int)4, null, (Function1)detectKotlinPluginLoadedInMultipleProjects.onRegister.1.INSTANCE, (int)23, null));
                                }
                                this.$project.getLogger().info("The full list of projects that loaded the Kotlin plugin is: : " + CollectionsKt.joinToString$default((Iterable)loadedInProjects, null, null, null, (int)0, null, (Function1)detectKotlinPluginLoadedInMultipleProjects.onRegister.2.INSTANCE, (int)31, null));
                            }
                        }
                    });
                }
            };
            multipleProjectsHolder.addProject(project, kotlinPluginVersion, (Function0<Unit>)onRegister2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

