/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.tasks;

import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.compilerRunner.KotlinLogger;
import org.jetbrains.kotlin.gradle.internal.tasks.TaskWithLocalState;
import org.jetbrains.kotlin.gradle.internal.tasks.TaskWithLocalStateKt;
import org.jetbrains.kotlin.gradle.logging.GradleKotlinLogger;
import org.jetbrains.kotlin.gradle.tasks.KotlinCompilerExecutionStrategy;
import org.jetbrains.kotlin.incremental.FileUtilsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a2\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u0000\u001a\u0016\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00102\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u0000\u00a8\u0006\u0011"}, d2={"cleanOutputsAndLocalState", "", "outputFiles", "", "Ljava/io/File;", "log", "Lorg/jetbrains/kotlin/compilerRunner/KotlinLogger;", "metrics", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporter;", "reason", "", "throwGradleExceptionIfError", "exitCode", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "executionStrategy", "Lorg/jetbrains/kotlin/gradle/tasks/KotlinCompilerExecutionStrategy;", "Lorg/jetbrains/kotlin/gradle/internal/tasks/TaskWithLocalState;", "kotlin-gradle-plugin_common"})
public final class TasksUtilsKt {
    public static final void throwGradleExceptionIfError(@NotNull ExitCode exitCode, @NotNull KotlinCompilerExecutionStrategy executionStrategy) {
        Intrinsics.checkNotNullParameter((Object)exitCode, (String)"exitCode");
        Intrinsics.checkNotNullParameter((Object)((Object)executionStrategy), (String)"executionStrategy");
        switch (WhenMappings.$EnumSwitchMapping$1[exitCode.ordinal()]) {
            case 1: {
                throw new GradleException("Compilation error. See log for more details");
            }
            case 2: {
                throw new GradleException("Internal compiler error. See log for more details");
            }
            case 3: {
                throw new GradleException("Script execution error. See log for more details");
            }
            case 4: {
                String exceptionMessage = "Not enough memory to run compilation.";
                switch (WhenMappings.$EnumSwitchMapping$0[executionStrategy.ordinal()]) {
                    case 1: {
                        exceptionMessage = exceptionMessage + " Try to increase it via 'gradle.properties':\nkotlin.daemon.jvmargs=-Xmx<size>";
                        break;
                    }
                    case 2: {
                        exceptionMessage = exceptionMessage + " Try to increase it via 'gradle.properties':\norg.gradle.jvmargs=-Xmx<size>";
                        break;
                    }
                    case 3: {
                    }
                }
                throw new GradleException(exceptionMessage);
            }
            case 5: {
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected exit code: " + exitCode);
            }
        }
    }

    public static final void cleanOutputsAndLocalState(@NotNull TaskWithLocalState $this$cleanOutputsAndLocalState, @Nullable String reason) {
        Intrinsics.checkNotNullParameter((Object)$this$cleanOutputsAndLocalState, (String)"<this>");
        Logger logger = $this$cleanOutputsAndLocalState.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
        GradleKotlinLogger log = new GradleKotlinLogger(logger);
        Iterable iterable = TaskWithLocalStateKt.allOutputFiles($this$cleanOutputsAndLocalState);
        KotlinLogger kotlinLogger2 = log;
        Object object = $this$cleanOutputsAndLocalState.getMetrics().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"metrics.get()");
        TasksUtilsKt.cleanOutputsAndLocalState(iterable, kotlinLogger2, (BuildMetricsReporter)object, reason);
    }

    public static /* synthetic */ void cleanOutputsAndLocalState$default(TaskWithLocalState taskWithLocalState, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        TasksUtilsKt.cleanOutputsAndLocalState(taskWithLocalState, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void cleanOutputsAndLocalState(@NotNull Iterable<? extends File> outputFiles, @NotNull KotlinLogger log, @NotNull BuildMetricsReporter metrics, @Nullable String reason) {
        void $this$measure$iv;
        Intrinsics.checkNotNullParameter(outputFiles, (String)"outputFiles");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)metrics, (String)"metrics");
        KotlinLogger $this$kotlinDebug$iv = log;
        boolean $i$f$kotlinDebug = false;
        if ($this$kotlinDebug$iv.isDebugEnabled()) {
            String string;
            String string2;
            StringBuilder stringBuilder = new StringBuilder().append("[KOTLIN] ");
            KotlinLogger kotlinLogger2 = $this$kotlinDebug$iv;
            boolean bl = false;
            String string3 = reason;
            if (string3 != null) {
                String it = string3;
                boolean bl2 = false;
                string2 = " (" + it + ')';
            } else {
                string2 = string = null;
            }
            if (string2 == null) {
                string = "";
            }
            String string4 = string;
            String string5 = "Cleaning output" + string4 + ':';
            kotlinLogger2.debug(stringBuilder.append(string5).toString());
        }
        $this$kotlinDebug$iv = metrics;
        BuildTime time$iv = BuildTime.CLEAR_OUTPUT;
        boolean $i$f$measure = false;
        $this$measure$iv.startMeasure(time$iv);
        try {
            boolean bl = false;
            for (File file : outputFiles) {
                if (file.isDirectory()) {
                    log.debug("Deleting contents of output directory: " + file);
                    FileUtilsKt.cleanDirectoryContents((File)file);
                    continue;
                }
                if (!file.isFile()) continue;
                log.debug("Deleting output file: " + file);
                FileUtilsKt.deleteRecursivelyOrThrow((File)file);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$measure$iv.endMeasure(time$iv);
        }
    }

    public static /* synthetic */ void cleanOutputsAndLocalState$default(Iterable iterable, KotlinLogger kotlinLogger2, BuildMetricsReporter buildMetricsReporter, String string, int n, Object object) {
        if ((n & 8) != 0) {
            string = null;
        }
        TasksUtilsKt.cleanOutputsAndLocalState(iterable, kotlinLogger2, buildMetricsReporter, string);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[KotlinCompilerExecutionStrategy.values().length];
            try {
                nArray[KotlinCompilerExecutionStrategy.DAEMON.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinCompilerExecutionStrategy.IN_PROCESS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinCompilerExecutionStrategy.OUT_OF_PROCESS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ExitCode.values().length];
            try {
                nArray[ExitCode.COMPILATION_ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExitCode.INTERNAL_ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExitCode.SCRIPT_EXECUTION_ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExitCode.OOM_ERROR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExitCode.OK.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

