/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.report;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.services.BuildServiceRegistration;
import org.gradle.api.services.BuildServiceSpec;
import org.gradle.tooling.Failure;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationCompletionListener;
import org.gradle.tooling.events.task.TaskFailureResult;
import org.gradle.tooling.events.task.TaskFinishEvent;
import org.gradle.tooling.events.task.TaskOperationResult;
import org.gradle.tooling.events.task.TaskSkippedResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.report.metrics.BuildMetrics;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.gradle.plugin.internal.state.TaskExecutionResults;
import org.jetbrains.kotlin.gradle.report.BuildMetricsReporterService;
import org.jetbrains.kotlin.gradle.report.ConfigureReporingKt;
import org.jetbrains.kotlin.gradle.report.FileReportSettings;
import org.jetbrains.kotlin.gradle.report.MetricsWriter;
import org.jetbrains.kotlin.gradle.report.PlainTextBuildReportWriterDataProcessor;
import org.jetbrains.kotlin.gradle.report.ReportingSettings;
import org.jetbrains.kotlin.gradle.report.TaskExecutionResult;
import org.jetbrains.kotlin.gradle.report.TaskRecord;
import org.jetbrains.kotlin.gradle.report.TransformRecord;
import org.jetbrains.kotlin.gradle.report.data.BuildExecutionData;
import org.jetbrains.kotlin.gradle.report.data.BuildExecutionDataProcessor;
import org.jetbrains.kotlin.gradle.report.data.BuildOperationRecord;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 '2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004:\u0002'(B\u0005\u00a2\u0006\u0002\u0010\u0005J$\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\n2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00162\u0006\u0010\u0017\u001a\u00020\u0010H\u0016JF\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\n2\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010#\u001a\u00020\u0013H\u0016J\u0012\u0010$\u001a\u00020\u00132\b\u0010%\u001a\u0004\u0018\u00010&H\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/gradle/report/BuildMetricsReporterService;", "Lorg/gradle/api/services/BuildService;", "Lorg/jetbrains/kotlin/gradle/report/BuildMetricsReporterService$Parameters;", "Lorg/gradle/tooling/events/OperationCompletionListener;", "Ljava/lang/AutoCloseable;", "()V", "buildOperationRecords", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lorg/jetbrains/kotlin/gradle/report/data/BuildOperationRecord;", "failureMessages", "", "log", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "taskPathToMetricsReporter", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporter;", "taskPathToTaskClass", "addTask", "", "taskPath", "taskClass", "Ljava/lang/Class;", "metricsReporter", "addTransformMetrics", "transformPath", "transformClass", "isKotlinTransform", "", "startTimeMs", "", "totalTimeMs", "buildMetrics", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetrics;", "failureMessage", "close", "onFinish", "event", "Lorg/gradle/tooling/events/FinishEvent;", "Companion", "Parameters", "kotlin-gradle-plugin_common"})
public abstract class BuildMetricsReporterService
implements BuildService<Parameters>,
OperationCompletionListener,
AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Logger log = Logging.getLogger(this.getClass());
    @NotNull
    private final ConcurrentLinkedQueue<BuildOperationRecord> buildOperationRecords = new ConcurrentLinkedQueue();
    @NotNull
    private final ConcurrentLinkedQueue<String> failureMessages = new ConcurrentLinkedQueue();
    @NotNull
    private final ConcurrentHashMap<String, BuildMetricsReporter> taskPathToMetricsReporter = new ConcurrentHashMap();
    @NotNull
    private final ConcurrentHashMap<String, String> taskPathToTaskClass = new ConcurrentHashMap();

    public void addTask(@NotNull String taskPath, @NotNull Class<?> taskClass, @NotNull BuildMetricsReporter metricsReporter) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)taskPath, (String)"taskPath");
        Intrinsics.checkNotNullParameter(taskClass, (String)"taskClass");
        Intrinsics.checkNotNullParameter((Object)metricsReporter, (String)"metricsReporter");
        Object it = object = this.taskPathToMetricsReporter.put(taskPath, metricsReporter);
        boolean bl = false;
        if (it != null) {
            this.log.warn("Duplicate task path: " + taskPath);
        }
        object = this.taskPathToTaskClass.put(taskPath, taskClass.getName());
        it = (String)object;
        boolean bl2 = false;
        if (it != null) {
            this.log.warn("Duplicate task path: " + taskPath);
        }
    }

    public void addTransformMetrics(@NotNull String transformPath, @NotNull Class<?> transformClass, boolean isKotlinTransform, long startTimeMs, long totalTimeMs, @NotNull BuildMetrics buildMetrics, @Nullable String failureMessage) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)transformPath, (String)"transformPath");
            Intrinsics.checkNotNullParameter(transformClass, (String)"transformClass");
            Intrinsics.checkNotNullParameter((Object)buildMetrics, (String)"buildMetrics");
            String string = transformClass.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"transformClass.name");
            this.buildOperationRecords.add(new TransformRecord(transformPath, string, isKotlinTransform, startTimeMs, totalTimeMs, buildMetrics));
            String string2 = failureMessage;
            if (string2 == null) break block0;
            String it = string2;
            boolean bl = false;
            this.failureMessages.add(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onFinish(@Nullable FinishEvent event) {
        if (event instanceof TaskFinishEvent) {
            String string;
            Object it;
            TaskOperationResult result2 = ((TaskFinishEvent)event).getResult();
            String taskPath = ((TaskFinishEvent)event).getDescriptor().getTaskPath();
            long totalTimeMs = result2.getEndTime() - result2.getStartTime();
            BuildMetrics buildMetrics = new BuildMetrics(null, null, null, 7, null);
            buildMetrics.getBuildTimes().addTimeMs(BuildTime.GRADLE_TASK, totalTimeMs);
            BuildMetricsReporter buildMetricsReporter = this.taskPathToMetricsReporter.get(taskPath);
            if (buildMetricsReporter != null) {
                it = buildMetricsReporter;
                boolean bl = false;
                buildMetrics.addAll(it.getMetrics());
            }
            Intrinsics.checkNotNullExpressionValue((Object)taskPath, (String)"taskPath");
            TaskExecutionResult taskExecutionResult = TaskExecutionResults.INSTANCE.get(taskPath);
            TaskExecutionResult taskExecutionResult2 = taskExecutionResult;
            if (taskExecutionResult2 != null && (taskExecutionResult2 = taskExecutionResult2.getBuildMetrics()) != null) {
                Object it2 = it = taskExecutionResult2;
                boolean bl = false;
                buildMetrics.addAll((BuildMetrics)it2);
            }
            if ((string = this.taskPathToTaskClass.get(taskPath)) == null) {
                string = "unknown";
            }
            long l = result2.getStartTime();
            boolean bl = result2 instanceof org.gradle.tooling.events.task.TaskExecutionResult;
            TaskSkippedResult taskSkippedResult = result2 instanceof TaskSkippedResult ? (TaskSkippedResult)result2 : null;
            String string2 = taskSkippedResult != null ? taskSkippedResult.getSkipMessage() : null;
            Object object = taskExecutionResult;
            if (object == null || (object = ((TaskExecutionResult)object).getIcLogLines()) == null) {
                object = CollectionsKt.emptyList();
            }
            this.buildOperationRecords.add(new TaskRecord(taskPath, string, l, totalTimeMs, buildMetrics, bl, string2, (List<String>)object));
            if (result2 instanceof TaskFailureResult) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                List list2 = ((TaskFailureResult)result2).getFailures();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"result.failures");
                Iterable iterable = list2;
                ConcurrentLinkedQueue<String> concurrentLinkedQueue = this.failureMessages;
                boolean $i$f$map = false;
                void it2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it3;
                    Failure failure = (Failure)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it3.getMessage());
                }
                concurrentLinkedQueue.addAll((List)destination$iv$iv);
            }
        }
    }

    @Override
    public void close() {
        Iterable $this$sortedBy$iv = this.buildOperationRecords;
        boolean $i$f$sortedBy = false;
        BuildExecutionData buildData = new BuildExecutionData((Collection<String>)((Parameters)this.getParameters()).getStartParameters(), CollectionsKt.toList((Iterable)this.failureMessages), CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                BuildOperationRecord it = (BuildOperationRecord)a;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getStartTimeMs());
                it = (BuildOperationRecord)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getStartTimeMs()));
            }
        }));
        Iterable $this$forEach$iv = ((Parameters)this.getParameters()).getBuildDataProcessors();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BuildExecutionDataProcessor it = (BuildExecutionDataProcessor)element$iv;
            boolean bl = false;
            Logger logger = this.log;
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"log");
            it.process(buildData, logger);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u001e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\u00020\nX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0003X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u0006\"\u0004\b\u0012\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/gradle/report/BuildMetricsReporterService$Parameters;", "Lorg/gradle/api/services/BuildServiceParameters;", "buildDataProcessors", "", "Lorg/jetbrains/kotlin/gradle/report/data/BuildExecutionDataProcessor;", "getBuildDataProcessors", "()Ljava/util/List;", "setBuildDataProcessors", "(Ljava/util/List;)V", "reportingSettings", "Lorg/jetbrains/kotlin/gradle/report/ReportingSettings;", "getReportingSettings", "()Lorg/jetbrains/kotlin/gradle/report/ReportingSettings;", "setReportingSettings", "(Lorg/jetbrains/kotlin/gradle/report/ReportingSettings;)V", "startParameters", "", "getStartParameters", "setStartParameters", "kotlin-gradle-plugin_common"})
    public static interface Parameters
    extends BuildServiceParameters {
        @NotNull
        public List<BuildExecutionDataProcessor> getBuildDataProcessors();

        public void setBuildDataProcessors(@NotNull List<? extends BuildExecutionDataProcessor> var1);

        @NotNull
        public List<String> getStartParameters();

        public void setStartParameters(@NotNull List<String> var1);

        @NotNull
        public ReportingSettings getReportingSettings();

        public void setReportingSettings(@NotNull ReportingSettings var1);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/gradle/report/BuildMetricsReporterService$Companion;", "", "()V", "getStartParameters", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "project", "Lorg/gradle/api/Project;", "registerIfAbsent", "Lorg/gradle/api/provider/Provider;", "Lorg/jetbrains/kotlin/gradle/report/BuildMetricsReporterService;", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ArrayList<String> getStartParameters(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            StartParameter it = project.getGradle().getStartParameter();
            boolean bl = false;
            ArrayList<String> startParameters = new ArrayList<String>();
            StringBuilder stringBuilder = new StringBuilder().append("tasks = ");
            List list2 = it.getTaskRequests();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"it.taskRequests");
            startParameters.add(stringBuilder.append(CollectionsKt.joinToString$default((Iterable)list2, null, null, null, (int)0, null, (Function1)getStartParameters.1.1.INSTANCE, (int)31, null)).toString());
            startParameters.add("excluded tasks = " + it.getExcludedTaskNames());
            startParameters.add("current dir = " + it.getCurrentDir());
            startParameters.add("project properties args = " + it.getProjectProperties());
            startParameters.add("system properties args = " + it.getSystemPropertiesArgs());
            return startParameters;
        }

        @Nullable
        public final Provider<BuildMetricsReporterService> registerIfAbsent(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Class<BuildMetricsReporterService> serviceClass = BuildMetricsReporterService.class;
            String serviceName = serviceClass.getName() + '_' + serviceClass.getClassLoader().hashCode();
            BuildServiceRegistration buildServiceRegistration = (BuildServiceRegistration)project.getGradle().getSharedServices().getRegistrations().findByName(serviceName);
            if (buildServiceRegistration != null) {
                BuildServiceRegistration it = buildServiceRegistration;
                boolean bl = false;
                Provider provider = it.getService();
                Intrinsics.checkNotNull((Object)provider, (String)"null cannot be cast to non-null type org.gradle.api.provider.Provider<org.jetbrains.kotlin.gradle.report.BuildMetricsReporterService>");
                return provider;
            }
            Project project2 = project.getRootProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project.rootProject");
            ReportingSettings reportingSettings = ConfigureReporingKt.reportingSettings(project2);
            if (reportingSettings.getBuildReportOutputs().isEmpty() && reportingSettings.getFileReportSettings() == null && reportingSettings.getMetricsOutputFile() == null) {
                return null;
            }
            Function1 function1 = (Function1)new Function1<BuildServiceSpec<Parameters>, Unit>(reportingSettings, project){
                final /* synthetic */ ReportingSettings $reportingSettings;
                final /* synthetic */ Project $project;
                {
                    this.$reportingSettings = $reportingSettings;
                    this.$project = $project;
                    super(1);
                }

                public final void invoke(BuildServiceSpec<Parameters> it) {
                    List buildDataProcessors = new ArrayList<E>();
                    FileReportSettings fileReportSettings = this.$reportingSettings.getFileReportSettings();
                    if (fileReportSettings != null) {
                        FileReportSettings fileReportSettings2 = fileReportSettings;
                        Project project = this.$project;
                        FileReportSettings fileReportSettings3 = fileReportSettings2;
                        boolean bl = false;
                        String string = project.getRootProject().getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.rootProject.name");
                        buildDataProcessors.add(new PlainTextBuildReportWriterDataProcessor(fileReportSettings3, string));
                    }
                    File file = this.$reportingSettings.getMetricsOutputFile();
                    if (file != null) {
                        File metricsOutputFile = file;
                        boolean bl = false;
                        File file2 = metricsOutputFile.getAbsoluteFile();
                        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"metricsOutputFile.absoluteFile");
                        buildDataProcessors.add(new MetricsWriter(file2));
                    }
                    ((Parameters)it.getParameters()).setStartParameters((List<String>)BuildMetricsReporterService.Companion.getStartParameters(this.$project));
                    ((Parameters)it.getParameters()).setBuildDataProcessors(buildDataProcessors);
                    ((Parameters)it.getParameters()).setReportingSettings(this.$reportingSettings);
                }
            };
            Provider provider = project.getGradle().getSharedServices().registerIfAbsent(serviceName, serviceClass, new Action(function1){
                private final /* synthetic */ Function1 function;
                {
                    Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                    this.function = function;
                }

                public final /* synthetic */ void execute(Object p0) {
                    this.function.invoke(p0);
                }
            });
            Intrinsics.checkNotNull((Object)provider);
            return provider;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

