/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.mpp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.plugins.ExtensionAware;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.dsl.KotlinProjectExtensionKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinMultiplatformPluginKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet;
import org.jetbrains.kotlin.gradle.plugin.mpp.CompilationSourceSetUtil;
import org.jetbrains.kotlin.gradle.plugin.mpp.UnusedSourceSetsChecker;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/UnusedSourceSetsChecker;", "", "()V", "WARNING_BOTTOM_LINE", "", "WARNING_INTRO", "WARNING_PREFIX_MANY", "WARNING_PREFIX_ONE", "checkSourceSets", "", "project", "Lorg/gradle/api/Project;", "reportUnusedSourceSets", "sourceSets", "", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinSourceSet;", "kotlin-gradle-plugin_common"})
public final class UnusedSourceSetsChecker {
    @NotNull
    public static final UnusedSourceSetsChecker INSTANCE = new UnusedSourceSetsChecker();
    @NotNull
    public static final String WARNING_PREFIX_ONE = "The Kotlin source set";
    @NotNull
    public static final String WARNING_PREFIX_MANY = "The following Kotlin source sets were";
    @NotNull
    public static final String WARNING_INTRO = "configured but not added to any Kotlin compilation";
    @NotNull
    public static final String WARNING_BOTTOM_LINE = "You can add a source set to a target's compilation by connecting it with the compilation's default source set using 'dependsOn'.\nSee https://kotlinlang.org/docs/reference/building-mpp-with-gradle.html#connecting-source-sets";

    private UnusedSourceSetsChecker() {
    }

    private final void reportUnusedSourceSets(Project project, Set<? extends KotlinSourceSet> sourceSets) {
        String string;
        if (!(!((Collection)sourceSets).isEmpty())) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (sourceSets.size() == 1) {
            string = "The Kotlin source set " + ((KotlinSourceSet)CollectionsKt.single((Iterable)sourceSets)).getName() + " was configured but not added to any Kotlin compilation. You can add a source set to a target's compilation by connecting it with the compilation's default source set using 'dependsOn'.\nSee https://kotlinlang.org/docs/reference/building-mpp-with-gradle.html#connecting-source-sets";
        } else {
            String list2 = CollectionsKt.joinToString$default((Iterable)sourceSets, (CharSequence)"\n", (CharSequence)"\n", (CharSequence)"\n", (int)0, null, (Function1)reportUnusedSourceSets.message.list.1.INSTANCE, (int)24, null);
            string = "The following Kotlin source sets were configured but not added to any Kotlin compilation:" + list2 + WARNING_BOTTOM_LINE;
        }
        String message2 = string;
        project.getLogger().warn('\n' + message2);
    }

    public final void checkSourceSets(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        KotlinMultiplatformPluginKt.whenEvaluated(project, (Function1)new Function1<Project, Unit>(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(1);
            }

            /*
             * Unable to fully structure code
             */
            public final void invoke(@NotNull Project $this$whenEvaluated) {
                Intrinsics.checkNotNullParameter((Object)$this$whenEvaluated, (String)"$this$whenEvaluated");
                compilationsBySourceSet = CompilationSourceSetUtil.INSTANCE.compilationsBySourceSets(this.$project);
                $this$filter$iv = (Iterable)KotlinProjectExtensionKt.getKotlinExtension(this.$project).getSourceSets();
                $i$f$filter = false;
                var6_5 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (KotlinSourceSet)element$iv$iv;
                    $i$a$-filter-UnusedSourceSetsChecker$checkSourceSets$1$unusedSourceSets$1 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    $this$extraProperties$iv = it;
                    $i$f$getExtraProperties = false;
                    v0 = ((ExtensionAware)$this$extraProperties$iv).getExtensions().getExtraProperties();
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"this as ExtensionAware).extensions.extraProperties");
                    if (!v0.has("android-source-set")) ** GOTO lbl-1000
                    $this$extraProperties$iv = it;
                    $i$f$getExtraProperties = false;
                    v1 = ((ExtensionAware)$this$extraProperties$iv).getExtensions().getExtraProperties();
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"this as ExtensionAware).extensions.extraProperties");
                    v2 = v1.get("android-source-set");
                    Intrinsics.checkNotNull((Object)v2, (String)"null cannot be cast to non-null type kotlin.Boolean");
                    if (((Boolean)v2).booleanValue()) {
                        v3 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v3 = isAndroidSourceSet = false;
                    }
                    if (isAndroidSourceSet) ** GOTO lbl-1000
                    v4 = compilationsBySourceSet.get(it);
                    if (v4 != null ? v4.isEmpty() : true) {
                        v5 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v5 = false;
                    }
                    if (!v5) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                unusedSourceSets = (List)destination$iv$iv;
                if (((Collection)unusedSourceSets).isEmpty() == false) {
                    UnusedSourceSetsChecker.access$reportUnusedSourceSets(UnusedSourceSetsChecker.INSTANCE, this.$project, CollectionsKt.toSet((Iterable)unusedSourceSets));
                }
            }
        });
    }

    public static final /* synthetic */ void access$reportUnusedSourceSets(UnusedSourceSetsChecker $this, Project project, Set sourceSets) {
        $this.reportUnusedSourceSets(project, sourceSets);
    }
}

