/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.native.internal;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.commonizer.CommonizerOutputFileLayout;
import org.jetbrains.kotlin.commonizer.CommonizerTarget;
import org.jetbrains.kotlin.commonizer.CommonizerTargetKt;
import org.jetbrains.kotlin.commonizer.KonanDistribution;
import org.jetbrains.kotlin.commonizer.KonanDistributionKt;
import org.jetbrains.kotlin.commonizer.LeafCommonizerTarget;
import org.jetbrains.kotlin.commonizer.SharedCommonizerTarget;
import org.jetbrains.kotlin.konan.target.KonanTarget;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\"B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0003H\u0002J\u0016\u0010\u000e\u001a\u00020\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u0014\u0010\u0012\u001a\u00020\b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0010J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00140\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0010H\u0002J=\u0010\u001d\u001a\u00020\u00162\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00102'\u0010\u001e\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00140\u0010\u00a2\u0006\f\b \u0012\b\b!\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00020\u00160\u001fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00060\u000bR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/native/internal/NativeDistributionCommonizerCache;", "Ljava/io/Serializable;", "outputDirectory", "Ljava/io/File;", "konanHome", "logger", "Lorg/gradle/api/logging/Logger;", "isCachingEnabled", "", "(Ljava/io/File;Ljava/io/File;Lorg/gradle/api/logging/Logger;Z)V", "lock", "Lorg/jetbrains/kotlin/gradle/targets/native/internal/NativeDistributionCommonizerCache$Lock;", "isCached", "directory", "isMissingPlatformLibraries", "missingOutputTargets", "", "Lorg/jetbrains/kotlin/commonizer/CommonizerTarget;", "isUpToDate", "outputTargets", "Lorg/jetbrains/kotlin/commonizer/SharedCommonizerTarget;", "logInfo", "", "message", "", "readObject", "input", "Ljava/io/ObjectInputStream;", "todoTargets", "writeCacheForUncachedTargets", "writeCacheAction", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "Lock", "kotlin-gradle-plugin_common"})
public final class NativeDistributionCommonizerCache
implements Serializable {
    @NotNull
    private final File outputDirectory;
    @NotNull
    private final File konanHome;
    @NotNull
    private final Logger logger;
    private final boolean isCachingEnabled;
    @NotNull
    private transient Lock lock;

    public NativeDistributionCommonizerCache(@NotNull File outputDirectory2, @NotNull File konanHome2, @NotNull Logger logger, boolean isCachingEnabled) {
        Intrinsics.checkNotNullParameter((Object)outputDirectory2, (String)"outputDirectory");
        Intrinsics.checkNotNullParameter((Object)konanHome2, (String)"konanHome");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.outputDirectory = outputDirectory2;
        this.konanHome = konanHome2;
        this.logger = logger;
        this.isCachingEnabled = isCachingEnabled;
        this.lock = new Lock();
    }

    public final boolean isUpToDate(@NotNull Set<SharedCommonizerTarget> outputTargets) {
        Intrinsics.checkNotNullParameter(outputTargets, (String)"outputTargets");
        return ((Set)this.lock.withLock((Function0)new Function0<Set<? extends SharedCommonizerTarget>>(this, outputTargets){
            final /* synthetic */ NativeDistributionCommonizerCache this$0;
            final /* synthetic */ Set<SharedCommonizerTarget> $outputTargets;
            {
                this.this$0 = $receiver;
                this.$outputTargets = $outputTargets;
                super(0);
            }

            @NotNull
            public final Set<SharedCommonizerTarget> invoke() {
                return NativeDistributionCommonizerCache.access$todoTargets(this.this$0, this.$outputTargets);
            }
        })).isEmpty();
    }

    public final void writeCacheForUncachedTargets(@NotNull Set<SharedCommonizerTarget> outputTargets, @NotNull Function1<? super Set<SharedCommonizerTarget>, Unit> writeCacheAction) {
        Intrinsics.checkNotNullParameter(outputTargets, (String)"outputTargets");
        Intrinsics.checkNotNullParameter(writeCacheAction, (String)"writeCacheAction");
        this.lock.withLock((Function0)new Function0<Unit>(this, outputTargets, writeCacheAction){
            final /* synthetic */ NativeDistributionCommonizerCache this$0;
            final /* synthetic */ Set<SharedCommonizerTarget> $outputTargets;
            final /* synthetic */ Function1<Set<SharedCommonizerTarget>, Unit> $writeCacheAction;
            {
                this.this$0 = $receiver;
                this.$outputTargets = $outputTargets;
                this.$writeCacheAction = $writeCacheAction;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$filterTo$iv$iv;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Set todoOutputTargets = NativeDistributionCommonizerCache.access$todoTargets(this.this$0, this.$outputTargets);
                if (todoOutputTargets.isEmpty()) {
                    return;
                }
                this.$writeCacheAction.invoke((Object)todoOutputTargets);
                Iterable iterable = todoOutputTargets;
                NativeDistributionCommonizerCache nativeDistributionCommonizerCache = this.this$0;
                boolean $i$f$map22 = false;
                void var5_7 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void outputTarget;
                    SharedCommonizerTarget sharedCommonizerTarget = (SharedCommonizerTarget)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(CommonizerOutputFileLayout.INSTANCE.resolveCommonizedDirectory(NativeDistributionCommonizerCache.access$getOutputDirectory$p(nativeDistributionCommonizerCache), (CommonizerTarget)outputTarget));
                }
                Iterable $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$filter = false;
                Iterable $i$f$map22 = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    File commonizedDirectory = (File)element$iv$iv;
                    boolean bl = false;
                    if (!commonizedDirectory.isDirectory()) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                Iterable $this$forEach$iv = (List)destination$iv$iv2;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    File commonizedDirectory = (File)element$iv;
                    boolean bl = false;
                    FilesKt.resolve((File)commonizedDirectory, (String)".success").createNewFile();
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final Set<SharedCommonizerTarget> todoTargets(Set<SharedCommonizerTarget> outputTargets) {
        SharedCommonizerTarget outputTarget;
        void $this$filterTo$iv$iv;
        this.lock.checkLocked(this.outputDirectory);
        this.logInfo("Calculating cache state for " + outputTargets);
        if (!this.isCachingEnabled) {
            this.logInfo("Cache disabled");
            if (this.isMissingPlatformLibraries(outputTargets)) {
                return SetsKt.emptySet();
            }
            return outputTargets;
        }
        Iterable $this$filter$iv = outputTargets;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            outputTarget = (SharedCommonizerTarget)element$iv$iv;
            boolean bl = false;
            if (!this.isCached(CommonizerOutputFileLayout.INSTANCE.resolveCommonizedDirectory(this.outputDirectory, (CommonizerTarget)outputTarget))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$onEach$iv = (List)destination$iv$iv;
        boolean $i$f$onEach = false;
        Iterable $this$onEach_u24lambda_u2416$iv = iterable = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2416$iv) {
            outputTarget = (SharedCommonizerTarget)element$iv;
            boolean bl2 = false;
            this.logInfo("Cache hit: " + outputTarget + " already commonized");
        }
        Set cachedOutputTargets = CollectionsKt.toSet((Iterable)iterable);
        Set todoOutputTargets = SetsKt.minus(outputTargets, (Iterable)cachedOutputTargets);
        if (todoOutputTargets.isEmpty() || this.isMissingPlatformLibraries(todoOutputTargets)) {
            this.logInfo("All available targets are commonized already - Nothing to do");
            if (!((Collection)todoOutputTargets).isEmpty()) {
                this.logInfo("Platforms cannot be commonized, because of missing platform libraries: " + todoOutputTargets);
            }
            return SetsKt.emptySet();
        }
        return todoOutputTargets;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isMissingPlatformLibraries(Set<? extends CommonizerTarget> missingOutputTargets) {
        boolean bl;
        block5: {
            KonanTarget target2;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv = CommonizerTargetKt.allLeaves((Iterable)missingOutputTargets);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                LeafCommonizerTarget leafCommonizerTarget = (LeafCommonizerTarget)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(target2.getKonanTarget());
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void konanTarget2;
                target2 = (KonanTarget)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(FilesKt.resolve((File)KonanDistributionKt.getPlatformLibsDir((KonanDistribution)new KonanDistribution(this.konanHome)), (String)konanTarget2.getName()));
            }
            Iterable $this$none$iv = (List)destination$iv$iv;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    File platformLibsDir = (File)element$iv;
                    boolean bl4 = false;
                    if (!platformLibsDir.exists()) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final boolean isCached(File directory2) {
        File successMarkerFile = FilesKt.resolve((File)directory2, (String)".success");
        return successMarkerFile.isFile();
    }

    private final void logInfo(String message2) {
        this.logger.info("Native Distribution Commonization: " + message2);
    }

    private final void readObject(ObjectInputStream input) {
        input.defaultReadObject();
        this.lock = new Lock();
    }

    public static final /* synthetic */ Set access$todoTargets(NativeDistributionCommonizerCache $this, Set outputTargets) {
        return $this.todoTargets(outputTargets);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\u001f\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0000\u0010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u000e\u00a2\u0006\u0002\u0010\u000fR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/native/internal/NativeDistributionCommonizerCache$Lock;", "", "(Lorg/jetbrains/kotlin/gradle/targets/native/internal/NativeDistributionCommonizerCache;)V", "lockedOutputDirectories", "", "Ljava/io/File;", "reentrantLock", "Ljava/util/concurrent/locks/ReentrantLock;", "checkLocked", "", "outputDirectory", "withLock", "T", "action", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "kotlin-gradle-plugin_common"})
    private final class Lock {
        @NotNull
        private final ReentrantLock reentrantLock = new ReentrantLock();
        @NotNull
        private final Set<File> lockedOutputDirectories = new LinkedHashSet();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final <T> T withLock(@NotNull Function0<? extends T> action) {
            Intrinsics.checkNotNullParameter(action, (String)"action");
            java.util.concurrent.locks.Lock lock = this.reentrantLock;
            NativeDistributionCommonizerCache nativeDistributionCommonizerCache = NativeDistributionCommonizerCache.this;
            lock.lock();
            try {
                Object object;
                boolean bl = false;
                if (this.lockedOutputDirectories.contains(nativeDistributionCommonizerCache.outputDirectory)) {
                    Object object2 = action.invoke();
                    return (T)object2;
                }
                nativeDistributionCommonizerCache.outputDirectory.mkdirs();
                File lockfile = FilesKt.resolve((File)nativeDistributionCommonizerCache.outputDirectory, (String)".lock");
                nativeDistributionCommonizerCache.logInfo("Acquire lock: " + lockfile.getPath() + " ...");
                Closeable closeable = new FileOutputStream(FilesKt.resolve((File)nativeDistributionCommonizerCache.outputDirectory, (String)".lock"));
                Throwable throwable = null;
                try {
                    Object object3;
                    FileOutputStream stream = (FileOutputStream)closeable;
                    boolean bl2 = false;
                    FileLock lock2 = stream.getChannel().lock();
                    boolean bl3 = lock2.isValid();
                    if (_Assertions.ENABLED && !bl3) {
                        String string = "Assertion failed";
                        throw new AssertionError((Object)string);
                    }
                    try {
                        nativeDistributionCommonizerCache.logInfo("Lock acquired: " + lockfile.getPath());
                        this.lockedOutputDirectories.add(nativeDistributionCommonizerCache.outputDirectory);
                        object3 = action.invoke();
                    }
                    finally {
                        this.lockedOutputDirectories.remove(nativeDistributionCommonizerCache.outputDirectory);
                        lock2.release();
                        nativeDistributionCommonizerCache.logInfo("Lock released: " + lockfile.getPath());
                    }
                    object = object3;
                }
                catch (Throwable throwable2) {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        CloseableKt.closeFinally((Closeable)closeable, throwable);
                        throw throwable3;
                    }
                }
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                Object object4 = object;
                return (T)object4;
            }
            finally {
                lock.unlock();
            }
        }

        public final void checkLocked(@NotNull File outputDirectory2) {
            Intrinsics.checkNotNullParameter((Object)outputDirectory2, (String)"outputDirectory");
            if (!this.reentrantLock.isHeldByCurrentThread()) {
                boolean $i$a$-check-NativeDistributionCommonizerCache$Lock$checkLocked$32 = false;
                String $i$a$-check-NativeDistributionCommonizerCache$Lock$checkLocked$32 = "Expected lock to be held by current thread " + Thread.currentThread().getName();
                throw new IllegalStateException($i$a$-check-NativeDistributionCommonizerCache$Lock$checkLocked$32.toString());
            }
            if (!this.lockedOutputDirectories.contains(outputDirectory2)) {
                boolean bl = false;
                String string = "Expected " + outputDirectory2 + " to be locked. Locked directories: " + this.lockedOutputDirectories;
                throw new IllegalStateException(string.toString());
            }
        }
    }
}

