/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.tasks.internal;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.dsl.KotlinJvmCompilerOptions;
import org.jetbrains.kotlin.gradle.dsl.KotlinJvmOptions;
import org.jetbrains.kotlin.gradle.tasks.AbstractKotlinCompile;
import org.jetbrains.kotlin.gradle.tasks.KotlinCompile;
import org.jetbrains.kotlin.gradle.tasks.internal.KotlinOptionsFreeArgsDeprecationKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R0\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/gradle/tasks/internal/KotlinJvmOptionsCompat;", "Lorg/jetbrains/kotlin/gradle/dsl/KotlinJvmOptions;", "task", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/gradle/tasks/KotlinCompile;", "options", "Lorg/jetbrains/kotlin/gradle/dsl/KotlinJvmCompilerOptions;", "(Lkotlin/jvm/functions/Function0;Lorg/jetbrains/kotlin/gradle/dsl/KotlinJvmCompilerOptions;)V", "value", "", "", "freeCompilerArgs", "getFreeCompilerArgs", "()Ljava/util/List;", "setFreeCompilerArgs", "(Ljava/util/List;)V", "isTaskExecuting", "", "()Z", "getOptions", "()Lorg/jetbrains/kotlin/gradle/dsl/KotlinJvmCompilerOptions;", "kotlin-gradle-plugin_common"})
public final class KotlinJvmOptionsCompat
implements KotlinJvmOptions {
    @NotNull
    private final Function0<KotlinCompile> task;
    @NotNull
    private final KotlinJvmCompilerOptions options;

    public KotlinJvmOptionsCompat(@NotNull Function0<? extends KotlinCompile> task2, @NotNull KotlinJvmCompilerOptions options) {
        Intrinsics.checkNotNullParameter(task2, (String)"task");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.task = task2;
        this.options = options;
    }

    @Override
    @NotNull
    public KotlinJvmCompilerOptions getOptions() {
        return this.options;
    }

    @Override
    @NotNull
    public List<String> getFreeCompilerArgs() {
        List list2;
        List executionTimeFreeCompilerArgs = ((KotlinCompile)this.task.invoke()).getExecutionTimeFreeCompilerArgs$kotlin_gradle_plugin_common();
        if (this.isTaskExecuting() && executionTimeFreeCompilerArgs != null) {
            list2 = executionTimeFreeCompilerArgs;
        } else {
            Object object = this.getOptions().getFreeCompilerArgs().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n                option\u2026rArgs.get()\n            }");
            list2 = (List)object;
        }
        return list2;
    }

    @Override
    public void setFreeCompilerArgs(@NotNull List<String> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        if (this.isTaskExecuting()) {
            KotlinOptionsFreeArgsDeprecationKt.nagUserFreeArgsModifiedOnExecution((AbstractKotlinCompile)this.task.invoke(), value);
            ((KotlinCompile)this.task.invoke()).setExecutionTimeFreeCompilerArgs$kotlin_gradle_plugin_common(value);
        } else {
            this.getOptions().getFreeCompilerArgs().set((Iterable)value);
        }
    }

    private final boolean isTaskExecuting() {
        return ((KotlinCompile)this.task.invoke()).getState().getExecuting();
    }

    @Override
    public boolean getAllWarningsAsErrors() {
        return KotlinJvmOptions.DefaultImpls.getAllWarningsAsErrors(this);
    }

    @Override
    public void setAllWarningsAsErrors(boolean value) {
        KotlinJvmOptions.DefaultImpls.setAllWarningsAsErrors(this, value);
    }

    @Override
    @Nullable
    public String getApiVersion() {
        return KotlinJvmOptions.DefaultImpls.getApiVersion(this);
    }

    @Override
    public void setApiVersion(@Nullable String value) {
        KotlinJvmOptions.DefaultImpls.setApiVersion(this, value);
    }

    @Override
    public boolean getJavaParameters() {
        return KotlinJvmOptions.DefaultImpls.getJavaParameters(this);
    }

    @Override
    public void setJavaParameters(boolean value) {
        KotlinJvmOptions.DefaultImpls.setJavaParameters(this, value);
    }

    @Override
    @Nullable
    public String getJvmTarget() {
        return KotlinJvmOptions.DefaultImpls.getJvmTarget(this);
    }

    @Override
    public void setJvmTarget(@Nullable String value) {
        KotlinJvmOptions.DefaultImpls.setJvmTarget(this, value);
    }

    @Override
    @Nullable
    public String getLanguageVersion() {
        return KotlinJvmOptions.DefaultImpls.getLanguageVersion(this);
    }

    @Override
    public void setLanguageVersion(@Nullable String value) {
        KotlinJvmOptions.DefaultImpls.setLanguageVersion(this, value);
    }

    @Override
    @Nullable
    public String getModuleName() {
        return KotlinJvmOptions.DefaultImpls.getModuleName(this);
    }

    @Override
    public void setModuleName(@Nullable String value) {
        KotlinJvmOptions.DefaultImpls.setModuleName(this, value);
    }

    @Override
    public boolean getNoJdk() {
        return KotlinJvmOptions.DefaultImpls.getNoJdk(this);
    }

    @Override
    public void setNoJdk(boolean value) {
        KotlinJvmOptions.DefaultImpls.setNoJdk(this, value);
    }

    @Override
    public boolean getSuppressWarnings() {
        return KotlinJvmOptions.DefaultImpls.getSuppressWarnings(this);
    }

    @Override
    public void setSuppressWarnings(boolean value) {
        KotlinJvmOptions.DefaultImpls.setSuppressWarnings(this, value);
    }

    @Override
    public boolean getUseK2() {
        return KotlinJvmOptions.DefaultImpls.getUseK2(this);
    }

    @Override
    public void setUseK2(boolean value) {
        KotlinJvmOptions.DefaultImpls.setUseK2(this, value);
    }

    @Override
    public boolean getVerbose() {
        return KotlinJvmOptions.DefaultImpls.getVerbose(this);
    }

    @Override
    public void setVerbose(boolean value) {
        KotlinJvmOptions.DefaultImpls.setVerbose(this, value);
    }
}

