/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.mpp.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectCollection;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.dsl.KotlinMultiplatformExtension;
import org.jetbrains.kotlin.gradle.dsl.KotlinProjectExtensionKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinMultiplatformPluginKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet;
import org.jetbrains.kotlin.gradle.plugin.KotlinTarget;
import org.jetbrains.kotlin.gradle.plugin.PropertiesProvider;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinNativeTarget;
import org.jetbrains.kotlin.gradle.plugin.mpp.internal.DeprecationDiagnosticsKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.internal.HierarchicalStructureMigrationHandlingKt;
import org.jetbrains.kotlin.gradle.plugin.sources.InternalKotlinSourceSetKt;
import org.jetbrains.kotlin.gradle.utils.RunProjectConfigurationHealthCheckKt;
import org.jetbrains.kotlin.gradle.utils.SingleWarningPerBuild;
import org.jetbrains.kotlin.konan.target.KonanTarget;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0002H\u0000\u001a\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\f\u0010\u0010\u001a\u00020\b*\u00020\nH\u0002\"\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"deprecatedMppProperties", "", "", "getDeprecatedMppProperties", "()Ljava/util/List;", "propertiesSetByPlugin", "", "checkAndReportDeprecatedMppProperties", "", "project", "Lorg/gradle/api/Project;", "checkAndReportDeprecatedNativeTargets", "checkAndReportDeprecatedSourceSetsLayouts", "getMppDeprecationWarningMessageForProperty", "property", "runDeprecationDiagnostics", "reportCommonMainDependsOnOtherSourceSets", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\ndeprecationDiagnostics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 deprecationDiagnostics.kt\norg/jetbrains/kotlin/gradle/plugin/mpp/internal/DeprecationDiagnosticsKt\n+ 2 runProjectConfigurationHealthCheck.kt\norg/jetbrains/kotlin/gradle/utils/RunProjectConfigurationHealthCheckKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,98:1\n100#2,4:99\n766#3:103\n857#3,2:104\n1603#3,9:106\n1855#3:115\n1856#3:118\n1612#3:119\n1855#3,2:120\n1#4:116\n1#4:117\n*E\n*S KotlinDebug\n*F\n+ 1 deprecationDiagnostics.kt\norg/jetbrains/kotlin/gradle/plugin/mpp/internal/DeprecationDiagnosticsKt\n*L\n29#1,4:99\n36#1:103\n36#1,2:104\n52#1,9:106\n52#1:115\n52#1:118\n52#1:119\n60#1,2:120\n52#1:117\n*E\n"})
public final class DeprecationDiagnosticsKt {
    @NotNull
    private static final List<String> deprecatedMppProperties;
    @NotNull
    private static final Set<String> propertiesSetByPlugin;

    public static final void runDeprecationDiagnostics(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DeprecationDiagnosticsKt.checkAndReportDeprecatedMppProperties(project);
        HierarchicalStructureMigrationHandlingKt.handleHierarchicalStructureFlagsMigration(project);
        DeprecationDiagnosticsKt.checkAndReportDeprecatedSourceSetsLayouts(project);
        Project $this$runProjectConfigurationHealthCheckWhenEvaluated$iv = project;
        boolean $i$f$runProjectConfigurationHealthCheckWhenEvaluated = false;
        KotlinMultiplatformPluginKt.whenEvaluated($this$runProjectConfigurationHealthCheckWhenEvaluated$iv, (Function1)new Function1<Project, Unit>(project){
            final /* synthetic */ Project $project$inlined;
            {
                this.$project$inlined = project;
                super(1);
            }

            public final void invoke(@NotNull Project $this$whenEvaluated) {
                Intrinsics.checkNotNullParameter((Object)$this$whenEvaluated, (String)"$this$whenEvaluated");
                Project $this$runProjectConfigurationHealthCheck$iv = $this$whenEvaluated;
                boolean $i$f$runProjectConfigurationHealthCheck = false;
                if (!($this$runProjectConfigurationHealthCheck$iv.getState().getFailure() != null || RunProjectConfigurationHealthCheckKt.access$inLenientMode($this$runProjectConfigurationHealthCheck$iv) && RunProjectConfigurationHealthCheckKt.access$syncExceptionsAreNotEmpty($this$runProjectConfigurationHealthCheck$iv))) {
                    Project $this$runDeprecationDiagnostics_u24lambda_u240 = $this$runProjectConfigurationHealthCheck$iv;
                    boolean bl = false;
                    DeprecationDiagnosticsKt.access$checkAndReportDeprecatedNativeTargets(this.$project$inlined);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private static final void checkAndReportDeprecatedNativeTargets(Project project) {
        void $this$filterTo$iv$iv;
        NamedDomainObjectCollection<KotlinTarget> targets = ((KotlinMultiplatformExtension)project.getExtensions().getByType(KotlinMultiplatformExtension.class)).getTargets();
        Iterable $this$filter$iv = (Iterable)targets;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KotlinTarget it = (KotlinTarget)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof KotlinNativeTarget && KonanTarget.Companion.getDeprecatedTargets().contains(((KotlinNativeTarget)it).getKonanTarget()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List usedDeprecatedTargets = (List)destination$iv$iv;
        if (usedDeprecatedTargets.isEmpty()) {
            return;
        }
        SingleWarningPerBuild.INSTANCE.show(project, "w: The following deprecated kotlin native targets were used in the project: " + CollectionsKt.joinToString$default((Iterable)usedDeprecatedTargets, null, null, null, (int)0, null, (Function1)checkAndReportDeprecatedNativeTargets.1.INSTANCE, (int)31, null));
    }

    /*
     * WARNING - void declaration
     */
    private static final void checkAndReportDeprecatedMppProperties(Project project) {
        void $this$mapNotNullTo$iv$iv;
        PropertiesProvider projectProperties = PropertiesProvider.Companion.getKotlinPropertiesProvider$kotlin_gradle_plugin_common(project);
        if (Intrinsics.areEqual((Object)projectProperties.getIgnoreHmppDeprecationWarnings(), (Object)true)) {
            return;
        }
        Iterable $this$mapNotNull$iv = deprecatedMppProperties;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String propertyName = (String)element$iv$iv;
            boolean bl2 = false;
            if (propertiesSetByPlugin.contains(propertyName) && projectProperties.getMpp13XFlagsSetByPlugin()) {
                string = null;
            } else if (projectProperties.property$kotlin_gradle_plugin_common(propertyName) != null) {
                boolean bl3 = false;
                string = DeprecationDiagnosticsKt.getMppDeprecationWarningMessageForProperty(propertyName);
            } else {
                string = null;
            }
            if (string == null) continue;
            String it$iv$iv = string;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List warnings = (List)destination$iv$iv;
        Iterable $this$forEach$iv = warnings;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            String message2 = (String)element$iv;
            boolean bl = false;
            SingleWarningPerBuild.INSTANCE.show(project, message2);
        }
    }

    private static final void checkAndReportDeprecatedSourceSetsLayouts(Project project) {
        DeprecationDiagnosticsKt.reportCommonMainDependsOnOtherSourceSets(project);
    }

    private static final void reportCommonMainDependsOnOtherSourceSets(Project $this$reportCommonMainDependsOnOtherSourceSets) {
        block0: {
            NamedDomainObjectContainer<KotlinSourceSet> namedDomainObjectContainer = KotlinProjectExtensionKt.getMultiplatformExtensionOrNull($this$reportCommonMainDependsOnOtherSourceSets);
            if (namedDomainObjectContainer == null || (namedDomainObjectContainer = namedDomainObjectContainer.getSourceSets()) == null) break block0;
            Function1 function1 = (Function1)new Function1<KotlinSourceSet, Unit>($this$reportCommonMainDependsOnOtherSourceSets){
                final /* synthetic */ Project $this_reportCommonMainDependsOnOtherSourceSets;
                {
                    this.$this_reportCommonMainDependsOnOtherSourceSets = $receiver;
                    super(1);
                }

                public final void invoke(KotlinSourceSet it) {
                    if (Intrinsics.areEqual((Object)it.getName(), (Object)"commonMain")) {
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        InternalKotlinSourceSetKt.getInternal(it).getDependsOn().forAll((Function1<KotlinSourceSet, Unit>)((Function1)new Function1<KotlinSourceSet, Unit>(this.$this_reportCommonMainDependsOnOtherSourceSets){
                            final /* synthetic */ Project $this_reportCommonMainDependsOnOtherSourceSets;
                            {
                                this.$this_reportCommonMainDependsOnOtherSourceSets = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull KotlinSourceSet it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                Project project = this.$this_reportCommonMainDependsOnOtherSourceSets.getProject();
                                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                                SingleWarningPerBuild.INSTANCE.show(project, "w: 'commonMain' source set can't depend on other source sets.");
                            }
                        }));
                    }
                }
            };
            namedDomainObjectContainer.all(new Action(function1){
                private final /* synthetic */ Function1 function;
                {
                    Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                    this.function = function;
                }

                public final /* synthetic */ void execute(Object p0) {
                    this.function.invoke(p0);
                }
            });
        }
    }

    @NotNull
    public static final List<String> getDeprecatedMppProperties() {
        return deprecatedMppProperties;
    }

    @NotNull
    public static final String getMppDeprecationWarningMessageForProperty(@NotNull String property2) {
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        return "w: The property '" + property2 + "' is obsolete and will be removed in Kotlin 1.9. Read the details here: https://kotlinlang.org/docs/multiplatform-compatibility-guide.html#deprecate-hmpp-properties";
    }

    public static final /* synthetic */ void access$checkAndReportDeprecatedNativeTargets(Project project) {
        DeprecationDiagnosticsKt.checkAndReportDeprecatedNativeTargets(project);
    }

    static {
        Object[] objectArray = new String[]{"kotlin.mpp.enableCompatibilityMetadataVariant", "kotlin.mpp.enableGranularSourceSetsMetadata", "kotlin.internal.mpp.hierarchicalStructureByDefault", "kotlin.mpp.hierarchicalStructureSupport", "kotlin.native.enableDependencyPropagation"};
        deprecatedMppProperties = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"kotlin.mpp.enableGranularSourceSetsMetadata", "kotlin.native.enableDependencyPropagation"};
        propertiesSetByPlugin = SetsKt.setOf((Object[])objectArray);
    }
}

