/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.report;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.invocation.Gradle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.PropertiesProvider;
import org.jetbrains.kotlin.gradle.report.BuildReportMode;
import org.jetbrains.kotlin.gradle.report.BuildReportType;
import org.jetbrains.kotlin.gradle.report.BuildScanSettings;
import org.jetbrains.kotlin.gradle.report.FileReportSettings;
import org.jetbrains.kotlin.gradle.report.HttpReportSettings;
import org.jetbrains.kotlin.gradle.report.ReportingSettings;
import org.jetbrains.kotlin.gradle.utils.ConfigurationCacheKt;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\u0004"}, d2={"reportingSettings", "Lorg/jetbrains/kotlin/gradle/report/ReportingSettings;", "project", "Lorg/gradle/api/Project;", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nconfigureReporing.kt\nKotlin\n*S Kotlin\n*F\n+ 1 configureReporing.kt\norg/jetbrains/kotlin/gradle/report/ConfigureReporingKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n1549#2:79\n1620#2,2:80\n1622#2:84\n1282#3,2:82\n1#4:85\n*E\n*S KotlinDebug\n*F\n+ 1 configureReporing.kt\norg/jetbrains/kotlin/gradle/report/ConfigureReporingKt\n*L\n18#1:79\n18#1,2:80\n18#1:84\n19#1,2:82\n*E\n"})
public final class ConfigureReporingKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ReportingSettings reportingSettings(@NotNull Project project) {
        Object object;
        File file;
        BuildScanSettings buildScanSettings;
        HttpReportSettings httpReportSettings;
        FileReportSettings fileReportSettings;
        FileReportSettings fileReportSettings2;
        BuildReportMode buildReportMode;
        Object object2;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PropertiesProvider properties2 = PropertiesProvider.Companion.invoke(project);
        Iterable $this$map$iv = properties2.getBuildReportOutputs();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            BuildReportType buildReportType;
            void it;
            Collection collection;
            block17: {
                object2 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                BuildReportType[] $this$firstOrNull$iv = BuildReportType.values();
                boolean $i$f$firstOrNull = false;
                int n = $this$firstOrNull$iv.length;
                for (int j = 0; j < n; ++j) {
                    BuildReportType element$iv;
                    BuildReportType brt = element$iv = $this$firstOrNull$iv[j];
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)brt.name(), (Object)CapitalizeDecapitalizeKt.toUpperCaseAsciiOnly((String)((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString()))) continue;
                    buildReportType = element$iv;
                    break block17;
                }
                buildReportType = null;
            }
            if (buildReportType == null) {
                throw new IllegalStateException("Unknown output type: " + (String)it);
            }
            collection.add(buildReportType);
        }
        List buildReportOutputTypes = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        BuildReportMode buildReportMode2 = buildReportMode = buildReportOutputTypes.isEmpty() ? BuildReportMode.NONE : BuildReportMode.VERBOSE;
        if (buildReportOutputTypes.contains(BuildReportType.FILE)) {
            File file2 = properties2.getBuildReportFileOutputDir();
            if (file2 == null) {
                File file3;
                Gradle gradle = project.getGradle();
                Intrinsics.checkNotNullExpressionValue((Object)gradle, (String)"project.gradle");
                if (ConfigurationCacheKt.isProjectIsolationEnabled(gradle)) {
                    File file4 = project.getRootDir();
                    Intrinsics.checkNotNullExpressionValue((Object)file4, (String)"project.rootDir");
                    file3 = FilesKt.resolve((File)file4, (String)"build");
                } else {
                    file3 = project.getRootProject().getBuildDir();
                }
                File $i$f$mapTo2 = file3;
                Intrinsics.checkNotNullExpressionValue((Object)$i$f$mapTo2, (String)"if (isProjectIsolationEn\u2026roject.buildDir\n        }");
                file2 = FilesKt.resolve((File)$i$f$mapTo2, (String)"reports/kotlin-build");
            }
            File buildReportDir = file2;
            boolean includeMetricsInReport = properties2.getBuildReportMetrics() || buildReportMode == BuildReportMode.VERBOSE;
            fileReportSettings2 = new FileReportSettings(buildReportDir, includeMetricsInReport);
        } else {
            fileReportSettings2 = fileReportSettings = null;
        }
        if (buildReportOutputTypes.contains(BuildReportType.HTTP)) {
            String string = properties2.getBuildReportHttpUrl();
            if (string == null) {
                throw new IllegalStateException("Can't configure http report: 'kotlin.build.report.http.url' property is mandatory");
            }
            String url = string;
            String password = properties2.getBuildReportHttpPassword();
            String user = properties2.getBuildReportHttpUser();
            boolean includeGitBranchName = properties2.getBuildReportHttpIncludeGitBranchName();
            httpReportSettings = new HttpReportSettings(url, password, user, properties2.getBuildReportHttpVerboseEnvironment(), includeGitBranchName);
        } else {
            httpReportSettings = null;
        }
        HttpReportSettings httpReportSettings2 = httpReportSettings;
        BuildScanSettings buildScanSettings2 = buildScanSettings = buildReportOutputTypes.contains(BuildReportType.BUILD_SCAN) ? new BuildScanSettings(properties2.getBuildReportBuildScanCustomValuesLimit()) : null;
        if (buildReportOutputTypes.contains(BuildReportType.SINGLE_FILE)) {
            file = properties2.getBuildReportSingleFile();
            if (file == null) {
                throw new IllegalStateException("Can't configure single file report: 'kotlin.build.report.single_file' property is mandatory");
            }
        } else {
            file = null;
        }
        File singleOutputFile = file;
        File file5 = properties2.getSingleBuildMetricsFile();
        if (file5 != null) {
            Object it = object2 = file5;
            boolean bl = false;
            buildReportOutputTypes.add(BuildReportType.SINGLE_FILE);
            object = object2;
        } else {
            object = null;
        }
        Object oldSingleBuildMetric = object;
        String string = properties2.getBuildReportLabel();
        Object object3 = singleOutputFile;
        if (object3 == null) {
            object3 = oldSingleBuildMetric;
        }
        object2 = object3;
        boolean bl = properties2.getBuildReportIncludeCompilerArguments();
        return new ReportingSettings(buildReportOutputTypes, buildReportMode, string, fileReportSettings, httpReportSettings2, buildScanSettings, (File)object2, bl);
    }
}

