/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.report;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.StartParameter;
import org.gradle.TaskExecutionRequest;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.tooling.events.task.TaskFinishEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.report.FileReportSettings;
import org.jetbrains.kotlin.build.report.HttpReportSettings;
import org.jetbrains.kotlin.build.report.metrics.BuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.build.report.metrics.ValueType;
import org.jetbrains.kotlin.build.report.statistics.BuildFinishStatisticsData;
import org.jetbrains.kotlin.build.report.statistics.BuildStartParameters;
import org.jetbrains.kotlin.build.report.statistics.CompileStatisticsData;
import org.jetbrains.kotlin.build.report.statistics.FormattingUtilsKt;
import org.jetbrains.kotlin.build.report.statistics.HttpReportService;
import org.jetbrains.kotlin.build.report.statistics.StatTag;
import org.jetbrains.kotlin.build.report.statistics.file.FileReportService;
import org.jetbrains.kotlin.compilerRunner.KotlinLogger;
import org.jetbrains.kotlin.gradle.dsl.KotlinVersion;
import org.jetbrains.kotlin.gradle.report.BuildReportParameters;
import org.jetbrains.kotlin.gradle.report.BuildReportsService;
import org.jetbrains.kotlin.gradle.report.BuildScanExtensionHolder;
import org.jetbrains.kotlin.gradle.report.BuildScanSettings;
import org.jetbrains.kotlin.gradle.report.GradleLoggerAdapter;
import org.jetbrains.kotlin.gradle.report.MetricsWriter;
import org.jetbrains.kotlin.gradle.report.ReportDataUtilKt;
import org.jetbrains.kotlin.gradle.report.ReportingSettings;
import org.jetbrains.kotlin.gradle.report.TaskRecord;
import org.jetbrains.kotlin.gradle.report.data.BuildExecutionData;
import org.jetbrains.kotlin.gradle.report.data.BuildOperationRecord;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010 \n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 ?2\u00020\u0001:\u0001?B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u001cH\u0002J \u0010!\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u0004H\u0002J\u0015\u0010#\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b$J \u0010%\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J*\u0010&\u001a\u00020\u00142\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00180(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00040*2\u0006\u0010\u0019\u001a\u00020\u001aJ\u001f\u0010+\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u001c2\b\u0010,\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0002\b-J(\u0010.\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010/\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010 \u001a\u0004\u0018\u00010\u001cJ\u0016\u00100\u001a\b\u0012\u0004\u0012\u00020\u00040*2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J \u00101\u001a\u00020\u00142\u0006\u00102\u001a\u00020\u00122\u0006\u00103\u001a\u00020\u00122\u0006\u00104\u001a\u00020\u0012H\u0002J\u0010\u00105\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u00106\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u000207H\u0002J\u001e\u00108\u001a\b\u0012\u0004\u0012\u00020\u00040*2\u0006\u00109\u001a\u00020\u00042\u0006\u0010:\u001a\u00020\u0006H\u0002J\u0014\u0010;\u001a\u00020<*\u00020<2\u0006\u0010=\u001a\u00020>H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lorg/jetbrains/kotlin/gradle/report/BuildReportsService;", "", "()V", "buildUuid", "", "customValues", "", "executorService", "Ljava/util/concurrent/ExecutorService;", "log", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "loggerAdapter", "Lorg/jetbrains/kotlin/gradle/report/GradleLoggerAdapter;", "startTime", "", "tags", "Ljava/util/LinkedHashSet;", "Lorg/jetbrains/kotlin/build/report/statistics/StatTag;", "addBuildScanReport", "", "event", "Lorg/gradle/tooling/events/task/TaskFinishEvent;", "buildOperationRecord", "Lorg/jetbrains/kotlin/gradle/report/data/BuildOperationRecord;", "parameters", "Lorg/jetbrains/kotlin/gradle/report/BuildReportParameters;", "buildScanExtension", "Lorg/jetbrains/kotlin/gradle/report/BuildScanExtensionHolder;", "data", "Lorg/jetbrains/kotlin/build/report/statistics/CompileStatisticsData;", "customValuesLimit", "buildScan", "addBuildScanValue", "customValue", "addCollectedTags", "addCollectedTags$kotlin_gradle_plugin_common", "addHttpReport", "close", "buildOperationRecords", "", "failureMessages", "", "initBuildScanTags", "label", "initBuildScanTags$kotlin_gradle_plugin_common", "onFinish", "buildOperation", "readableString", "replaceWithCombinedTag", "firstTag", "secondTag", "combinedTag", "reportBuildFinish", "reportTryK2ToConsole", "Lorg/jetbrains/kotlin/gradle/report/data/BuildExecutionData;", "splitStringIfNeed", "str", "lengthLimit", "includeVerboseEnvironment", "Lorg/jetbrains/kotlin/build/report/statistics/BuildStartParameters;", "verboseEnvironment", "", "Companion", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nBuildReportsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildReportsService.kt\norg/jetbrains/kotlin/gradle/report/BuildReportsService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 5 Timing.kt\nkotlin/system/TimingKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,390:1\n1045#2:391\n1603#2,9:392\n1855#2:401\n1856#2:403\n1612#2:404\n766#2:405\n857#2,2:406\n1855#2,2:417\n800#2,11:420\n766#2:431\n857#2,2:432\n1774#2,4:434\n1549#2:438\n1620#2,3:439\n1855#2,2:442\n1855#2,2:452\n1#3:402\n1#3:408\n183#4,3:409\n17#5,5:412\n22#5:419\n125#6:444\n152#6,3:445\n125#6:448\n152#6,3:449\n*E\n*S KotlinDebug\n*F\n+ 1 BuildReportsService.kt\norg/jetbrains/kotlin/gradle/report/BuildReportsService\n*L\n58#1:391\n71#1,9:392\n71#1:401\n71#1:403\n71#1:404\n87#1:405\n87#1,2:406\n208#1,2:417\n239#1,11:420\n240#1:431\n240#1,2:432\n249#1,4:434\n253#1:438\n253#1,3:439\n254#1,2:442\n332#1,2:452\n71#1:402\n188#1,3:409\n205#1,5:412\n205#1:419\n279#1:444\n279#1,3:445\n280#1:448\n280#1,3:449\n*E\n"})
public final class BuildReportsService {
    @NotNull
    public static final Companion Companion;
    private final Logger log;
    @NotNull
    private final GradleLoggerAdapter loggerAdapter;
    private final long startTime;
    @NotNull
    private final String buildUuid;
    @NotNull
    private final ExecutorService executorService;
    @NotNull
    private final LinkedHashSet<StatTag> tags;
    private int customValues;
    public static final int CUSTOM_VALUE_LENGTH_LIMIT = 100000;
    @NotNull
    private static final SimpleDateFormat DATE_FORMATTER;
    @Nullable
    private static final String hostName;

    public BuildReportsService() {
        Logger logger = this.log = Logging.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"log");
        this.loggerAdapter = new GradleLoggerAdapter(logger);
        this.startTime = System.nanoTime();
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        this.buildUuid = string;
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSingleThreadExecutor()");
        this.executorService = executorService;
        this.tags = new LinkedHashSet();
        this.log.info("Build report service is registered. Unique build id: " + this.buildUuid);
    }

    /*
     * WARNING - void declaration
     */
    public final void close(@NotNull Collection<? extends BuildOperationRecord> buildOperationRecords, @NotNull List<String> failureMessages, @NotNull BuildReportParameters parameters) {
        HttpReportSettings it;
        Object object;
        Intrinsics.checkNotNullParameter(buildOperationRecords, (String)"buildOperationRecords");
        Intrinsics.checkNotNullParameter(failureMessages, (String)"failureMessages");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Iterable $this$sortedBy$iv = buildOperationRecords;
        boolean $i$f$sortedBy = false;
        BuildExecutionData buildData = new BuildExecutionData(parameters.getStartParameters(), failureMessages, CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                BuildOperationRecord it = (BuildOperationRecord)a;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getStartTimeMs());
                it = (BuildOperationRecord)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getStartTimeMs()));
            }
        }));
        ReportingSettings reportingSettings = parameters.getReportingSettings();
        HttpReportSettings httpReportSettings = reportingSettings.getHttpReportSettings();
        if (httpReportSettings != null) {
            object = httpReportSettings;
            it = object;
            boolean bl = false;
            this.executorService.submit(new Runnable(this, parameters){
                final /* synthetic */ BuildReportsService this$0;
                final /* synthetic */ BuildReportParameters $parameters;
                {
                    this.this$0 = $receiver;
                    this.$parameters = $parameters;
                }

                public final void run() {
                    BuildReportsService.access$reportBuildFinish(this.this$0, this.$parameters);
                }
            });
        }
        FileReportSettings fileReportSettings = reportingSettings.getFileReportSettings();
        if (fileReportSettings != null) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            object = fileReportSettings;
            it = object;
            boolean bl = false;
            Iterable iterable = buildOperationRecords;
            boolean bl2 = it.getIncludeMetricsInReport();
            String string = parameters.getProjectName();
            File file = it.getBuildReportDir();
            FileReportService.Companion companion = FileReportService.Companion;
            boolean $i$f$mapNotNull = false;
            void var16_16 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                CompileStatisticsData it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl3 = false;
                BuildOperationRecord it2 = (BuildOperationRecord)element$iv$iv;
                boolean bl4 = false;
                if (ReportDataUtilKt.prepareData$default(null, it2.getPath(), it2.getStartTimeMs(), it2.getTotalTimeMs() + it2.getStartTimeMs(), parameters.getProjectName(), this.buildUuid, parameters.getLabel(), parameters.getKotlinVersion(), it2, false, parameters.getAdditionalTags(), null, 2048, null) == null) continue;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list2 = (List)destination$iv$iv;
            $this$mapNotNull$iv = failureMessages;
            BuildStartParameters buildStartParameters = parameters.getStartParameters();
            boolean $i$f$filter = false;
            $this$mapNotNullTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it3 = (String)element$iv$iv;
                boolean bl6 = false;
                boolean bl7 = ((CharSequence)it3).length() > 0;
                if (!bl7) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list3 = (List)destination$iv$iv;
            companion.reportBuildStatInFile(file, string, bl2, list2, buildStartParameters, list3, (KotlinLogger)this.loggerAdapter);
        }
        File file = reportingSettings.getSingleOutputFile();
        if (file != null) {
            Object singleOutputFile = object = file;
            boolean bl = false;
            File file2 = ((File)singleOutputFile).getAbsoluteFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"singleOutputFile.absoluteFile");
            MetricsWriter metricsWriter = new MetricsWriter(file2);
            Logger logger = this.log;
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"log");
            metricsWriter.process(buildData, logger);
        }
        if (reportingSettings.getExperimentalTryK2ConsoleOutput()) {
            this.reportTryK2ToConsole(buildData);
        }
        this.executorService.shutdown();
    }

    public final void onFinish(@NotNull TaskFinishEvent event, @NotNull BuildOperationRecord buildOperation, @NotNull BuildReportParameters parameters, @Nullable BuildScanExtensionHolder buildScan) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)buildOperation, (String)"buildOperation");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        BuildScanExtensionHolder buildScanExtensionHolder = buildScan;
        if (buildScanExtensionHolder != null) {
            BuildScanExtensionHolder buildScanExtensionHolder2;
            BuildScanExtensionHolder it = buildScanExtensionHolder2 = buildScanExtensionHolder;
            boolean bl = false;
            this.addBuildScanReport(event, buildOperation, parameters, it);
        }
        this.addHttpReport(event, buildOperation, parameters);
    }

    private final void reportBuildFinish(BuildReportParameters parameters) {
        block3: {
            String string;
            HttpReportSettings httpReportSettings = parameters.getReportingSettings().getHttpReportSettings();
            if (httpReportSettings == null) {
                return;
            }
            HttpReportSettings httpReportSettings2 = httpReportSettings;
            if (httpReportSettings2.getIncludeGitBranchName()) {
                Object object = new String[]{"git", "rev-parse", "--abbrev-ref", "HEAD"};
                Object it = object = new ProcessBuilder((String[])object).directory(parameters.getProjectDir()).start();
                boolean bl = false;
                ((Process)it).waitFor(5L, TimeUnit.SECONDS);
                Object process = object;
                InputStream inputStream = ((Process)process).getInputStream();
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"process.inputStream");
                object = inputStream;
                Charset charset = Charsets.UTF_8;
                string = TextStreamsKt.readText((Reader)new InputStreamReader((InputStream)object, charset));
            } else {
                string = "is not set";
            }
            String branchName = string;
            BuildFinishStatisticsData buildFinishData = new BuildFinishStatisticsData(parameters.getProjectName(), this.includeVerboseEnvironment(parameters.getStartParameters(), parameters.getReportingSettings().getHttpReportSettings().getVerboseEnvironment()), this.buildUuid, parameters.getLabel(), TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.startTime), null, System.currentTimeMillis(), null, hostName, (Set)this.tags, branchName, 160, null);
            HttpReportService httpReportService = parameters.getHttpService();
            if (httpReportService == null) break block3;
            httpReportService.sendData((Object)buildFinishData, (KotlinLogger)this.loggerAdapter);
        }
    }

    private final BuildStartParameters includeVerboseEnvironment(BuildStartParameters $this$includeVerboseEnvironment, boolean verboseEnvironment) {
        return verboseEnvironment ? $this$includeVerboseEnvironment : new BuildStartParameters($this$includeVerboseEnvironment.getTasks(), $this$includeVerboseEnvironment.getExcludedTasks(), null, CollectionsKt.emptyList(), CollectionsKt.emptyList());
    }

    private final void addHttpReport(TaskFinishEvent event, BuildOperationRecord buildOperationRecord, BuildReportParameters parameters) {
        block1: {
            CompileStatisticsData data;
            HttpReportService httpReportService;
            HttpReportService httpReportService2 = parameters.getHttpService();
            if (httpReportService2 == null) break block1;
            HttpReportService httpService = httpReportService = httpReportService2;
            boolean bl = false;
            CompileStatisticsData compileStatisticsData = data = ReportDataUtilKt.prepareData$default(event, parameters.getProjectName(), this.buildUuid, parameters.getLabel(), parameters.getKotlinVersion(), buildOperationRecord, true, parameters.getAdditionalTags(), null, 256, null);
            if (compileStatisticsData != null) {
                CompileStatisticsData compileStatisticsData2;
                CompileStatisticsData it = compileStatisticsData2 = compileStatisticsData;
                boolean bl2 = false;
                this.executorService.submit(new Runnable(httpService, data, this){
                    final /* synthetic */ HttpReportService $httpService;
                    final /* synthetic */ CompileStatisticsData $data;
                    final /* synthetic */ BuildReportsService this$0;
                    {
                        this.$httpService = $httpService;
                        this.$data = $data;
                        this.this$0 = $receiver;
                    }

                    public final void run() {
                        this.$httpService.sendData((Object)this.$data, (KotlinLogger)BuildReportsService.access$getLoggerAdapter$p(this.this$0));
                    }
                });
            }
        }
    }

    private final void addBuildScanReport(TaskFinishEvent event, BuildOperationRecord buildOperationRecord, BuildReportParameters parameters, BuildScanExtensionHolder buildScanExtension) {
        block1: {
            CompileStatisticsData compileStatisticsData;
            BuildScanSettings buildScanSettings = parameters.getReportingSettings().getBuildScanReportSettings();
            if (buildScanSettings == null) {
                return;
            }
            BuildScanSettings buildScanSettings2 = buildScanSettings;
            boolean $i$f$measureTimeMillisWithResult = false;
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            CompileStatisticsData result$iv = ReportDataUtilKt.prepareData$default(event, parameters.getProjectName(), this.buildUuid, parameters.getLabel(), parameters.getKotlinVersion(), buildOperationRecord, false, null, buildScanSettings2.getMetrics(), 192, null);
            Pair pair = new Pair((Object)(System.currentTimeMillis() - start$iv), (Object)result$iv);
            long collectDataDuration = ((Number)pair.component1()).longValue();
            CompileStatisticsData compileStatData = (CompileStatisticsData)pair.component2();
            this.log.debug("Collect data takes " + collectDataDuration + ": " + compileStatData);
            CompileStatisticsData compileStatisticsData2 = compileStatData;
            if (compileStatisticsData2 == null) break block1;
            CompileStatisticsData it = compileStatisticsData = compileStatisticsData2;
            boolean bl2 = false;
            this.addBuildScanReport(it, buildScanSettings2.getCustomValueLimit(), buildScanExtension);
        }
    }

    private final void addBuildScanReport(CompileStatisticsData data, int customValuesLimit, BuildScanExtensionHolder buildScan) {
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        this.tags.addAll(data.getTags());
        if (this.customValues < customValuesLimit) {
            Iterable $this$forEach$iv = this.readableString(data);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl2 = false;
                if (this.customValues < customValuesLimit) {
                    this.addBuildScanValue(buildScan, data, it);
                    continue;
                }
                this.log.debug("Can't add any more custom values into build scan. Statistic data for " + data.getTaskName() + " was cut due to custom values limit.");
            }
        } else {
            this.log.debug("Can't add any more custom values into build scan.");
        }
        long elapsedTime = System.currentTimeMillis() - start$iv;
        this.log.debug("Report statistic to build scan takes " + elapsedTime + " ms");
    }

    private final void addBuildScanValue(BuildScanExtensionHolder buildScan, CompileStatisticsData data, String customValue) {
        buildScan.getBuildScan().value(data.getTaskName(), customValue);
        int n = this.customValues;
        this.customValues = n + 1;
    }

    /*
     * WARNING - void declaration
     */
    private final void reportTryK2ToConsole(BuildExecutionData data) {
        void $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = data.getBuildOperationRecord();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof TaskRecord)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TaskRecord it = (TaskRecord)element$iv$iv;
            boolean bl = false;
            if (!(it.isFromKotlinPlugin() && it.getKotlinLanguageVersion() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List tasksData = (List)destination$iv$iv;
        this.log.warn("##### 'kotlin.experimental.tryK2' results (Kotlin/Native not checked) #####");
        if (tasksData.isEmpty()) {
            this.log.warn("No Kotlin compilation tasks have run");
            this.log.warn("#####");
        } else {
            void $this$mapTo$iv$iv;
            Object element$iv2;
            int n;
            Iterable $this$count$iv = tasksData;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv2 : $this$count$iv) {
                    TaskRecord it = (TaskRecord)element$iv2;
                    boolean bl = false;
                    if (!(it.getKotlinLanguageVersion() != null && it.getKotlinLanguageVersion().compareTo((Enum)KotlinVersion.KOTLIN_2_0) >= 0) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            int tasksCountWithKotlin2 = n;
            int taskWithK2Percent = tasksCountWithKotlin2 * 100 / ((Collection)tasksData).size();
            Iterable $this$map$iv = tasksData;
            boolean $i$f$map = false;
            element$iv2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TaskRecord taskRecord = (TaskRecord)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl = false;
                KotlinVersion kotlinVersion = it.getKotlinLanguageVersion();
                collection.add(TuplesKt.to((Object)it.getPath(), (Object)(kotlinVersion != null ? kotlinVersion.getVersion() : null)));
            }
            List statsData = (List)destination$iv$iv2;
            Iterable $this$forEach$iv = statsData;
            boolean $i$f$forEach = false;
            for (Object element$iv3 : $this$forEach$iv) {
                Pair record = (Pair)element$iv3;
                boolean bl = false;
                this.log.warn((String)record.getFirst() + ": " + (String)record.getSecond() + " language version");
            }
            this.log.warn("##### " + taskWithK2Percent + "% (" + tasksCountWithKotlin2 + '/' + ((Collection)tasksData).size() + ") tasks have compiled with Kotlin 2 #####");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> readableString(CompileStatisticsData data) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        StringBuilder readableString2 = new StringBuilder();
        if (data.getNonIncrementalAttributes().isEmpty()) {
            readableString2.append("Incremental build; ");
            CollectionsKt.joinTo$default((Iterable)data.getChanges(), (Appendable)readableString2, null, (CharSequence)"Changes: [", (CharSequence)"]; ", (int)0, null, (Function1)readableString.1.INSTANCE, (int)50, null);
        } else {
            CollectionsKt.joinTo$default((Iterable)data.getNonIncrementalAttributes(), (Appendable)readableString2, null, (CharSequence)"Non incremental build because: [", (CharSequence)"]; ", (int)0, null, (Function1)readableString.2.INSTANCE, (int)50, null);
        }
        String string = data.getKotlinLanguageVersion();
        if (string != null) {
            String string2;
            String it = string2 = string;
            boolean bl = false;
            readableString2.append("Kotlin language version: " + it + "; ");
        }
        Map $this$map$iv = data.getBuildTimesMetrics();
        boolean $i$f$map = false;
        Map bl = $this$map$iv;
        Object destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry2 = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            boolean bl2 = false;
            BuildTime key = (BuildTime)entry2.getKey();
            long value = ((Number)entry2.getValue()).longValue();
            collection.add(key.getReadableString() + ": " + value + "ms");
        }
        List timeData = (List)destination$iv$iv;
        Map $this$map$iv2 = data.getPerformanceMetrics();
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv2.size());
        boolean $i$f$mapTo2 = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            String string3;
            Map.Entry item$iv$iv;
            Map.Entry entry3 = item$iv$iv = iterator2.next();
            collection = destination$iv$iv2;
            boolean bl3 = false;
            BuildPerformanceMetric key = (BuildPerformanceMetric)entry3.getKey();
            long value = ((Number)entry3.getValue()).longValue();
            switch (WhenMappings.$EnumSwitchMapping$0[key.getType().ordinal()]) {
                case 1: {
                    string3 = key.getReadableString() + ": " + FormattingUtilsKt.formatSize((long)value);
                    break;
                }
                case 2: {
                    string3 = DATE_FORMATTER.format(value);
                    break;
                }
                default: {
                    string3 = key.getReadableString() + ": " + value;
                }
            }
            collection.add(string3);
        }
        List perfData = (List)destination$iv$iv2;
        CollectionsKt.joinTo$default((Iterable)CollectionsKt.union((Iterable)timeData, (Iterable)perfData), (Appendable)readableString2, (CharSequence)",", (CharSequence)"Performance: [", (CharSequence)"]", (int)0, null, null, (int)112, null);
        String string4 = readableString2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"readableString.toString()");
        return this.splitStringIfNeed(string4, 100000);
    }

    private final List<String> splitStringIfNeed(String str, int lengthLimit) {
        ArrayList<String> splattedString = new ArrayList<String>();
        String tempStr = str;
        while (tempStr.length() > lengthLimit) {
            String subSequence;
            Intrinsics.checkNotNullExpressionValue((Object)tempStr.substring(lengthLimit), (String)"this as java.lang.String).substring(startIndex)");
            int index = StringsKt.lastIndexOf$default((CharSequence)subSequence, (char)';', (int)0, (boolean)false, (int)6, null);
            if (index == -1 && (index = StringsKt.lastIndexOf$default((CharSequence)subSequence, (char)',', (int)0, (boolean)false, (int)6, null)) == -1) {
                index = lengthLimit;
            }
            String string = tempStr.substring(index);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            splattedString.add(string);
            Intrinsics.checkNotNullExpressionValue((Object)tempStr.substring(index), (String)"this as java.lang.String).substring(startIndex)");
        }
        splattedString.add(tempStr);
        return splattedString;
    }

    public final void initBuildScanTags$kotlin_gradle_plugin_common(@NotNull BuildScanExtensionHolder buildScan, @Nullable String label) {
        block0: {
            String string;
            Intrinsics.checkNotNullParameter((Object)buildScan, (String)"buildScan");
            buildScan.getBuildScan().tag(this.buildUuid);
            String string2 = label;
            if (string2 == null) break block0;
            String it = string = string2;
            boolean bl = false;
            buildScan.getBuildScan().tag(it);
        }
    }

    public final void addCollectedTags$kotlin_gradle_plugin_common(@NotNull BuildScanExtensionHolder buildScan) {
        Intrinsics.checkNotNullParameter((Object)buildScan, (String)"buildScan");
        this.replaceWithCombinedTag(StatTag.KOTLIN_1, StatTag.KOTLIN_2, StatTag.KOTLIN_1_AND_2);
        this.replaceWithCombinedTag(StatTag.INCREMENTAL, StatTag.NON_INCREMENTAL, StatTag.INCREMENTAL_AND_NON_INCREMENTAL);
        Iterable $this$forEach$iv = this.tags;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StatTag it = (StatTag)element$iv;
            boolean bl = false;
            buildScan.getBuildScan().tag(it.getReadableString());
        }
    }

    private final void replaceWithCombinedTag(StatTag firstTag, StatTag secondTag, StatTag combinedTag) {
        boolean containsFirstTag = this.tags.remove(firstTag);
        boolean containsSecondTag = this.tags.remove(secondTag);
        if (containsFirstTag && containsSecondTag) {
            this.tags.add(combinedTag);
        } else if (containsFirstTag) {
            this.tags.add(firstTag);
        } else if (containsSecondTag) {
            this.tags.add(secondTag);
        }
    }

    public static final /* synthetic */ void access$reportBuildFinish(BuildReportsService $this, BuildReportParameters parameters) {
        $this.reportBuildFinish(parameters);
    }

    public static final /* synthetic */ GradleLoggerAdapter access$getLoggerAdapter$p(BuildReportsService $this) {
        return $this.loggerAdapter;
    }

    static {
        String string;
        Companion = new Companion(null);
        DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception _) {
            string = null;
        }
        hostName = string;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/gradle/report/BuildReportsService$Companion;", "", "()V", "CUSTOM_VALUE_LENGTH_LIMIT", "", "DATE_FORMATTER", "Ljava/text/SimpleDateFormat;", "hostName", "", "getHostName", "()Ljava/lang/String;", "getStartParameters", "Lorg/jetbrains/kotlin/build/report/statistics/BuildStartParameters;", "project", "Lorg/gradle/api/Project;", "kotlin-gradle-plugin_common"})
    @SourceDebugExtension(value={"SMAP\nBuildReportsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildReportsService.kt\norg/jetbrains/kotlin/gradle/report/BuildReportsService$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,390:1\n1360#2:391\n1446#2,5:392\n125#3:397\n152#3,3:398\n125#3:401\n152#3,3:402\n*E\n*S KotlinDebug\n*F\n+ 1 BuildReportsService.kt\norg/jetbrains/kotlin/gradle/report/BuildReportsService$Companion\n*L\n352#1:391\n352#1,5:392\n355#1:397\n355#1,3:398\n356#1:401\n356#1,3:402\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final BuildStartParameters getStartParameters(@NotNull Project project) {
            Collection<String> collection;
            String value;
            String key;
            Collection<String> collection2;
            Map.Entry entry2;
            Map.Entry item$iv$iv;
            Map $this$mapTo$iv$iv;
            Map $this$map$iv;
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            StartParameter it = project.getGradle().getStartParameter();
            boolean bl = false;
            List list2 = it.getTaskRequests();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"it.taskRequests");
            Object $this$flatMap$iv = list2;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                TaskExecutionRequest it2 = (TaskExecutionRequest)element$iv$iv;
                boolean bl2 = false;
                List list3 = it2.getArgs();
                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"it.args");
                Iterable list$iv$iv = list3;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List list4 = (List)destination$iv$iv;
            Set set2 = it.getExcludedTaskNames();
            Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"it.excludedTaskNames");
            String string = it.getCurrentDir().getPath();
            Map map2 = it.getProjectProperties();
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"it.projectProperties");
            $this$flatMap$iv = map2;
            String string2 = string;
            Set set3 = set2;
            List list5 = list4;
            boolean $i$f$map = false;
            $this$flatMapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator<Object> iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                entry2 = item$iv$iv = (Map.Entry)iterator.next();
                collection2 = destination$iv$iv;
                boolean bl3 = false;
                key = (String)entry2.getKey();
                value = (String)entry2.getValue();
                collection2.add(key + ": " + value);
            }
            collection2 = (List)destination$iv$iv;
            Map map3 = it.getSystemPropertiesArgs();
            Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"it.systemPropertiesArgs");
            $this$map$iv = map3;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            $i$f$mapTo = false;
            iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                entry2 = item$iv$iv = (Map.Entry)iterator.next();
                collection = destination$iv$iv;
                boolean bl4 = false;
                key = (String)entry2.getKey();
                value = (String)entry2.getValue();
                collection.add(key + ": " + value);
            }
            Collection<String> collection3 = collection = (List)destination$iv$iv;
            Collection<String> collection4 = collection2;
            String string3 = string2;
            Set set4 = set3;
            List list6 = list5;
            return new BuildStartParameters(list6, set4, string3, collection4, (List)collection3);
        }

        @Nullable
        public final String getHostName() {
            return hostName;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ValueType.values().length];
            try {
                nArray[ValueType.BYTES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.MILLISECONDS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

