/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.utils;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.compilerRunner.KotlinNativeToolRunner;
import org.jetbrains.kotlin.compilerRunner.NativeToolRunnersKt;
import org.jetbrains.kotlin.gradle.logging.GradleLoggingUtilsKt;
import org.jetbrains.kotlin.gradle.plugin.PropertiesProvider;
import org.jetbrains.kotlin.gradle.targets.native.internal.NativeDistributionType;
import org.jetbrains.kotlin.gradle.targets.native.internal.NativeDistributionTypeProvider;
import org.jetbrains.kotlin.gradle.utils.ConfigurationsKt;
import org.jetbrains.kotlin.gradle.utils.FormattingUtilsKt;
import org.jetbrains.kotlin.gradle.utils.NativeCompilerDownloader;
import org.jetbrains.kotlin.gradle.utils.ResourceUtilsKt;
import org.jetbrains.kotlin.konan.target.HostManager;
import org.jetbrains.kotlin.konan.util.DependencyDirectories;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 62\u00020\u0001:\u00016B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u000bH\u0002J\b\u0010/\u001a\u000200H\u0002J\u0006\u00101\u001a\u000200J\u0010\u00102\u001a\u0002002\u0006\u00103\u001a\u000204H\u0002J\u0010\u00105\u001a\u0002042\u0006\u0010\"\u001a\u00020\u0005H\u0002R\u0014\u0010\u0007\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\tR\u0014\u0010\u0010\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\tR\u0014\u0010\u0012\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\tR\u0014\u0010\u0014\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001b\u0010\"\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b#\u0010\tR\u0014\u0010&\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\tR\u0014\u0010(\u001a\u00020)8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u00067"}, d2={"Lorg/jetbrains/kotlin/gradle/utils/NativeCompilerDownloader;", "", "project", "Lorg/gradle/api/Project;", "compilerVersion", "", "(Lorg/gradle/api/Project;Ljava/lang/String;)V", "archiveExtension", "getArchiveExtension", "()Ljava/lang/String;", "compilerDirectory", "Ljava/io/File;", "getCompilerDirectory", "()Ljava/io/File;", "dependencyFileName", "getDependencyFileName", "dependencyName", "getDependencyName", "dependencyNameWithOsAndVersion", "getDependencyNameWithOsAndVersion", "distributionType", "Lorg/jetbrains/kotlin/gradle/targets/native/internal/NativeDistributionType;", "getDistributionType", "()Lorg/jetbrains/kotlin/gradle/targets/native/internal/NativeDistributionType;", "kotlinProperties", "Lorg/jetbrains/kotlin/gradle/plugin/PropertiesProvider;", "getKotlinProperties", "()Lorg/jetbrains/kotlin/gradle/plugin/PropertiesProvider;", "logger", "Lorg/gradle/api/logging/Logger;", "getLogger", "()Lorg/gradle/api/logging/Logger;", "getProject", "()Lorg/gradle/api/Project;", "repoUrl", "getRepoUrl", "repoUrl$delegate", "Lkotlin/Lazy;", "simpleOsName", "getSimpleOsName", "useZip", "", "getUseZip", "()Z", "archiveFileTree", "Lorg/gradle/api/file/FileTree;", "archive", "downloadAndExtract", "", "downloadIfNeeded", "removeRepo", "repo", "Lorg/gradle/api/artifacts/repositories/ArtifactRepository;", "setupRepo", "Companion", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nNativeCompilerDownloader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NativeCompilerDownloader.kt\norg/jetbrains/kotlin/gradle/utils/NativeCompilerDownloader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 formattingUtils.kt\norg/jetbrains/kotlin/gradle/utils/FormattingUtilsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,211:1\n1#2:212\n38#3,7:213\n38#3,7:220\n1747#4,3:227\n*E\n*S KotlinDebug\n*F\n+ 1 NativeCompilerDownloader.kt\norg/jetbrains/kotlin/gradle/utils/NativeCompilerDownloader\n*L\n150#1,7:213\n157#1,7:220\n185#1,3:227\n*E\n"})
public final class NativeCompilerDownloader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final String compilerVersion;
    @NotNull
    private final Lazy repoUrl$delegate;
    @NotNull
    private static final Lazy<String> DEFAULT_KONAN_VERSION$delegate = LazyKt.lazy((Function0)Companion.DEFAULT_KONAN_VERSION.2.INSTANCE);
    @NotNull
    public static final String BASE_DOWNLOAD_URL = "https://download.jetbrains.com/kotlin/native/builds";
    @NotNull
    public static final String KOTLIN_GROUP_ID = "org.jetbrains.kotlin";

    public NativeCompilerDownloader(@NotNull Project project, @NotNull String compilerVersion2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)compilerVersion2, (String)"compilerVersion");
        this.project = project;
        this.compilerVersion = compilerVersion2;
        this.repoUrl$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ NativeCompilerDownloader this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                StringBuilder stringBuilder;
                NativeCompilerDownloader nativeCompilerDownloader = this.this$0;
                StringBuilder $this$invoke_u24lambda_u240 = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$invoke_u24lambda_u240.append(NativeCompilerDownloader.access$getKotlinProperties(nativeCompilerDownloader).getNativeBaseDownloadUrl() + '/');
                $this$invoke_u24lambda_u240.append(StringsKt.contains$default((CharSequence)NativeCompilerDownloader.access$getCompilerVersion$p(nativeCompilerDownloader), (CharSequence)"-dev-", (boolean)false, (int)2, null) ? "dev/" : "releases/");
                $this$invoke_u24lambda_u240.append(NativeCompilerDownloader.access$getCompilerVersion$p(nativeCompilerDownloader) + '/');
                $this$invoke_u24lambda_u240.append(NativeCompilerDownloader.access$getSimpleOsName(nativeCompilerDownloader));
                String string = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
                return string;
            }
        }));
    }

    public /* synthetic */ NativeCompilerDownloader(Project project, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = NativeToolRunnersKt.getKonanVersion(project);
        }
        this(project, string);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final File getCompilerDirectory() {
        return FilesKt.resolve((File)DependencyDirectories.INSTANCE.getLocalKonanDir(), (String)this.getDependencyNameWithOsAndVersion());
    }

    private final Logger getLogger() {
        Logger logger = this.project.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"project.logger");
        return logger;
    }

    private final PropertiesProvider getKotlinProperties() {
        return PropertiesProvider.Companion.invoke(this.project);
    }

    private final NativeDistributionType getDistributionType() {
        return new NativeDistributionTypeProvider(this.project).getDistributionType(this.compilerVersion);
    }

    private final String getSimpleOsName() {
        return HostManager.Companion.platformName();
    }

    private final String getDependencyName() {
        String dependencySuffix = this.getDistributionType().getSuffix();
        return dependencySuffix != null ? "kotlin-native-" + dependencySuffix : "kotlin-native";
    }

    private final String getDependencyNameWithOsAndVersion() {
        return this.getDependencyName() + '-' + this.getSimpleOsName() + '-' + this.compilerVersion;
    }

    private final String getDependencyFileName() {
        return this.getDependencyNameWithOsAndVersion() + '.' + this.getArchiveExtension();
    }

    private final boolean getUseZip() {
        return HostManager.Companion.getHostIsMingw();
    }

    private final String getArchiveExtension() {
        return this.getUseZip() ? "zip" : "tar.gz";
    }

    private final FileTree archiveFileTree(File archive) {
        FileTree fileTree;
        if (this.getUseZip()) {
            FileTree fileTree2 = this.project.zipTree((Object)archive);
            fileTree = fileTree2;
            Intrinsics.checkNotNullExpressionValue((Object)fileTree2, (String)"{\n            project.zipTree(archive)\n        }");
        } else {
            FileTree fileTree3 = this.project.tarTree((Object)archive);
            fileTree = fileTree3;
            Intrinsics.checkNotNullExpressionValue((Object)fileTree3, (String)"{\n            project.tarTree(archive)\n        }");
        }
        return fileTree;
    }

    private final ArtifactRepository setupRepo(String repoUrl2) {
        Function1 function1 = (Function1)new Function1<IvyArtifactRepository, Unit>(repoUrl2){
            final /* synthetic */ String $repoUrl;
            {
                this.$repoUrl = $repoUrl;
                super(1);
            }

            public final void invoke(IvyArtifactRepository repo2) {
                repo2.setUrl((Object)this.$repoUrl);
                Function1 function1 = setupRepo.1.INSTANCE;
                repo2.patternLayout(new Action(function1){
                    private final /* synthetic */ Function1 function;
                    {
                        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                        this.function = function;
                    }

                    public final /* synthetic */ void execute(Object p0) {
                        this.function.invoke(p0);
                    }
                });
                function1 = setupRepo.2.INSTANCE;
                repo2.metadataSources(new /* invalid duplicate definition of identical inner class */);
            }
        };
        IvyArtifactRepository ivyArtifactRepository = this.project.getRepositories().ivy(new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue((Object)ivyArtifactRepository, (String)"repoUrl: String): Artifa\u2026)\n            }\n        }");
        return (ArtifactRepository)ivyArtifactRepository;
    }

    private final void removeRepo(ArtifactRepository repo2) {
        this.project.getRepositories().remove((Object)repo2);
    }

    private final String getRepoUrl() {
        Lazy lazy = this.repoUrl$delegate;
        return (String)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void downloadAndExtract() {
        Logger $this$lifecycleWithDuration$iv;
        Logger lengthSuffix;
        Dependency dependency2;
        Pair[] pairArray;
        ArtifactRepository repo2;
        ArtifactRepository artifactRepository = repo2 = !this.getKotlinProperties().getNativeDownloadFromMaven() ? this.setupRepo(this.getRepoUrl()) : null;
        if (this.getKotlinProperties().getNativeDownloadFromMaven()) {
            pairArray = new Pair[]{TuplesKt.to((Object)"group", (Object)KOTLIN_GROUP_ID), TuplesKt.to((Object)"name", (Object)this.getDependencyName()), TuplesKt.to((Object)"version", (Object)this.compilerVersion.toString()), TuplesKt.to((Object)"classifier", (Object)this.getSimpleOsName()), TuplesKt.to((Object)"ext", (Object)this.getArchiveExtension())};
            dependency2 = this.project.getDependencies().create((Object)MapsKt.mapOf((Pair[])pairArray));
        } else {
            pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)(this.getDependencyName() + '-' + this.getSimpleOsName())), TuplesKt.to((Object)"version", (Object)this.compilerVersion.toString()), TuplesKt.to((Object)"ext", (Object)this.getArchiveExtension())};
            dependency2 = this.project.getDependencies().create((Object)MapsKt.mapOf((Pair[])pairArray));
        }
        Dependency compilerDependency = dependency2;
        Dependency[] dependencyArray = new Dependency[]{compilerDependency};
        Configuration configuration = this.project.getConfigurations().detachedConfiguration(dependencyArray);
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"project.configurations.d\u2026ation(compilerDependency)");
        Configuration configuration2 = ConfigurationsKt.markResolvable(configuration);
        this.getLogger().lifecycle("\nPlease wait while Kotlin/Native compiler " + this.compilerVersion + " is being installed.");
        if (!this.getKotlinProperties().getNativeDownloadFromMaven()) {
            String string;
            String string2;
            String dependencyUrl = this.getRepoUrl() + '/' + this.getDependencyFileName();
            Long l = ResourceUtilsKt.probeRemoteFileLength(this.project, dependencyUrl, 200);
            if (l != null) {
                long it = ((Number)l).longValue();
                boolean bl = false;
                string2 = " (" + FormattingUtilsKt.formatContentLength(it) + ')';
            } else {
                string2 = string = null;
            }
            if (string2 == null) {
                string = "";
            }
            lengthSuffix = string;
            this.getLogger().lifecycle("Download " + dependencyUrl + (String)lengthSuffix);
        }
        lengthSuffix = this.getLogger();
        String messagePrefix$iv = "Download " + this.getDependencyFileName() + " finished,";
        boolean $i$f$lifecycleWithDuration = false;
        long startTime$iv = System.currentTimeMillis();
        boolean bl = false;
        Set set2 = configuration2.getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"configuration.files");
        File result$iv = (File)CollectionsKt.single((Iterable)set2);
        long finishTime$iv = System.currentTimeMillis();
        $this$lifecycleWithDuration$iv.lifecycle(messagePrefix$iv + " took " + FormattingUtilsKt.formatDuration(finishTime$iv - startTime$iv));
        File archive = result$iv;
        GradleLoggingUtilsKt.kotlinInfo(this.getLogger(), "Using Kotlin/Native compiler archive: " + archive.getAbsolutePath());
        this.getLogger().lifecycle("Unpack Kotlin/Native compiler to " + this.getCompilerDirectory());
        $this$lifecycleWithDuration$iv = this.getLogger();
        messagePrefix$iv = "Unpack Kotlin/Native compiler to " + this.getCompilerDirectory() + " finished,";
        $i$f$lifecycleWithDuration = false;
        startTime$iv = System.currentTimeMillis();
        boolean bl2 = false;
        File it = finishTime$iv = this.getCompilerDirectory().getParentFile();
        boolean bl3 = false;
        it.mkdirs();
        File kotlinNativeDir = finishTime$iv;
        File tmpDir = Files.createTempDirectory(kotlinNativeDir.toPath(), "compiler-", new FileAttribute[0]).toFile();
        try {
            this.getLogger().debug("Unpacking Kotlin/Native compiler to tmp directory " + tmpDir);
            it = (Function1)new Function1<CopySpec, Unit>(this, archive, tmpDir){
                final /* synthetic */ NativeCompilerDownloader this$0;
                final /* synthetic */ File $archive;
                final /* synthetic */ File $tmpDir;
                {
                    this.this$0 = $receiver;
                    this.$archive = $archive;
                    this.$tmpDir = $tmpDir;
                    super(1);
                }

                public final void invoke(CopySpec it) {
                    Object[] objectArray = new Object[1];
                    File file = this.$archive;
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"archive");
                    objectArray[0] = NativeCompilerDownloader.access$archiveFileTree(this.this$0, file);
                    it.from(objectArray);
                    it.into((Object)this.$tmpDir);
                }
            };
            this.project.copy(new /* invalid duplicate definition of identical inner class */);
            Intrinsics.checkNotNullExpressionValue((Object)tmpDir, (String)"tmpDir");
            File compilerTmp = FilesKt.resolve((File)tmpDir, (String)this.getDependencyNameWithOsAndVersion());
            if (!compilerTmp.renameTo(this.getCompilerDirectory())) {
                Function1 function1 = (Function1)new Function1<CopySpec, Unit>(compilerTmp, this){
                    final /* synthetic */ File $compilerTmp;
                    final /* synthetic */ NativeCompilerDownloader this$0;
                    {
                        this.$compilerTmp = $compilerTmp;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(CopySpec it) {
                        Object[] objectArray = new Object[]{this.$compilerTmp};
                        it.from(objectArray);
                        it.into((Object)this.this$0.getCompilerDirectory());
                    }
                };
                this.project.copy(new /* invalid duplicate definition of identical inner class */);
            }
            this.getLogger().debug("Moved Kotlin/Native compiler from " + tmpDir + " to " + this.getCompilerDirectory());
        }
        catch (Throwable throwable) {
            Intrinsics.checkNotNullExpressionValue((Object)tmpDir, (String)"tmpDir");
            FilesKt.deleteRecursively((File)tmpDir);
            throw throwable;
        }
        FilesKt.deleteRecursively((File)tmpDir);
        Unit result$iv2 = Unit.INSTANCE;
        long finishTime$iv2 = System.currentTimeMillis();
        $this$lifecycleWithDuration$iv.lifecycle(messagePrefix$iv + " took " + FormattingUtilsKt.formatDuration(finishTime$iv2 - startTime$iv));
        if (repo2 != null) {
            this.removeRepo(repo2);
        }
    }

    public final void downloadIfNeeded() {
        block9: {
            block8: {
                boolean bl;
                block7: {
                    FileCollection classpath = KotlinNativeToolRunner.Settings.Companion.fromProject(this.project).getClasspath();
                    if (classpath.isEmpty()) break block8;
                    Iterable $this$any$iv = (Iterable)classpath;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            File it = (File)element$iv;
                            boolean bl2 = false;
                            if (!(!it.exists())) continue;
                            bl = true;
                            break block7;
                        }
                        bl = false;
                    }
                }
                if (!bl) break block9;
            }
            this.downloadAndExtract();
        }
    }

    public static final /* synthetic */ FileTree access$archiveFileTree(NativeCompilerDownloader $this, File archive) {
        return $this.archiveFileTree(archive);
    }

    public static final /* synthetic */ PropertiesProvider access$getKotlinProperties(NativeCompilerDownloader $this) {
        return $this.getKotlinProperties();
    }

    public static final /* synthetic */ String access$getCompilerVersion$p(NativeCompilerDownloader $this) {
        return $this.compilerVersion;
    }

    public static final /* synthetic */ String access$getSimpleOsName(NativeCompilerDownloader $this) {
        return $this.getSimpleOsName();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/gradle/utils/NativeCompilerDownloader$Companion;", "", "()V", "BASE_DOWNLOAD_URL", "", "DEFAULT_KONAN_VERSION", "getDEFAULT_KONAN_VERSION", "()Ljava/lang/String;", "DEFAULT_KONAN_VERSION$delegate", "Lkotlin/Lazy;", "KOTLIN_GROUP_ID", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getDEFAULT_KONAN_VERSION() {
            Lazy lazy = DEFAULT_KONAN_VERSION$delegate;
            return (String)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

