/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.mpp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.dsl.KotlinProjectExtensionKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginLifecycle;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginLifecycleKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet;
import org.jetbrains.kotlin.gradle.plugin.mpp.UnusedSourceSetsChecker;
import org.jetbrains.kotlin.gradle.plugin.sources.InternalKotlinSourceSetKt;
import org.jetbrains.kotlin.gradle.plugin.sources.android.KotlinAndroidSourceSetInfoKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/UnusedSourceSetsChecker;", "", "()V", "WARNING_BOTTOM_LINE", "", "WARNING_INTRO", "WARNING_PREFIX_MANY", "WARNING_PREFIX_ONE", "checkSourceSets", "", "project", "Lorg/gradle/api/Project;", "reportUnusedSourceSets", "sourceSets", "", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinSourceSet;", "kotlin-gradle-plugin_common"})
public final class UnusedSourceSetsChecker {
    @NotNull
    public static final UnusedSourceSetsChecker INSTANCE = new UnusedSourceSetsChecker();
    @NotNull
    public static final String WARNING_PREFIX_ONE = "The Kotlin source set";
    @NotNull
    public static final String WARNING_PREFIX_MANY = "The following Kotlin source sets were";
    @NotNull
    public static final String WARNING_INTRO = "configured but not added to any Kotlin compilation";
    @NotNull
    public static final String WARNING_BOTTOM_LINE = "You can add a source set to a target's compilation by connecting it with the compilation's default source set using 'dependsOn'.\nSee https://kotl.in/connecting-source-sets";

    private UnusedSourceSetsChecker() {
    }

    private final void reportUnusedSourceSets(Project project, Set<? extends KotlinSourceSet> sourceSets) {
        String string;
        if (!(!((Collection)sourceSets).isEmpty())) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (sourceSets.size() == 1) {
            string = "The Kotlin source set " + ((KotlinSourceSet)CollectionsKt.single((Iterable)sourceSets)).getName() + " was configured but not added to any Kotlin compilation. You can add a source set to a target's compilation by connecting it with the compilation's default source set using 'dependsOn'.\nSee https://kotl.in/connecting-source-sets";
        } else {
            String list2 = CollectionsKt.joinToString$default((Iterable)sourceSets, (CharSequence)"\n", (CharSequence)"\n", (CharSequence)"\n", (int)0, null, (Function1)reportUnusedSourceSets.message.list.1.INSTANCE, (int)24, null);
            string = "The following Kotlin source sets were configured but not added to any Kotlin compilation:" + list2 + WARNING_BOTTOM_LINE;
        }
        String message2 = string;
        project.getLogger().warn('\n' + message2);
    }

    public final void checkSourceSets(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        KotlinPluginLifecycleKt.launchInStage(project, KotlinPluginLifecycle.Stage.ReadyForExecution, (Function2<? super KotlinPluginLifecycle, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<KotlinPluginLifecycle, Continuation<? super Unit>, Object>(project, null){
            int label;
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        KotlinSourceSet it;
                        Iterable $this$filterTo$iv$iv;
                        ResultKt.throwOnFailure((Object)object);
                        Iterable $this$filter$iv = (Iterable)KotlinProjectExtensionKt.getKotlinExtension(this.$project).getSourceSets();
                        boolean $i$f$filter = false;
                        Iterable iterable = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (KotlinSourceSet)element$iv$iv;
                            boolean bl = false;
                            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                            if (!(KotlinAndroidSourceSetInfoKt.getAndroidSourceSetInfoOrNull(it) == null)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filter$iv = (List)destination$iv$iv;
                        $i$f$filter = false;
                        $this$filterTo$iv$iv = $this$filter$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (KotlinSourceSet)element$iv$iv;
                            boolean bl = false;
                            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                            if (!InternalKotlinSourceSetKt.getInternal(it).getCompilations().isEmpty()) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        List unusedSourceSets = (List)destination$iv$iv;
                        if (!((Collection)unusedSourceSets).isEmpty()) {
                            UnusedSourceSetsChecker.access$reportUnusedSourceSets(UnusedSourceSetsChecker.INSTANCE, this.$project, CollectionsKt.toSet((Iterable)unusedSourceSets));
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull KotlinPluginLifecycle p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public static final /* synthetic */ void access$reportUnusedSourceSets(UnusedSourceSetsChecker $this, Project project, Set sourceSets) {
        $this.reportUnusedSourceSets(project, sourceSets);
    }
}

