/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.js;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.targets.js.UtilsKt;
import org.jetbrains.kotlin.gradle.utils.StringUtilsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\u001a@\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00060\u000e\u001a\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bH\u0000\u001a\u0012\u0010\u0011\u001a\u00020\u0006*\b\u0012\u0004\u0012\u00020\u00010\u0012H\u0000\u001a\u0016\u0010\u0013\u001a\u00020\u0006*\u00060\u0014j\u0002`\u00152\u0006\u0010\u0016\u001a\u00020\b\u001a\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u0001*\u00020\f2\u0006\u0010\u0018\u001a\u00020\b\u001a\n\u0010\u0019\u001a\u00020\u0001*\u00020\u001a\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"HTML", "", "JS", "JS_MAP", "META_JS", "extractWithUpToDate", "", "destination", "Ljava/io/File;", "destinationHashFile", "dist", "fileHasher", "Lorg/gradle/internal/hash/FileHasher;", "extract", "Lkotlin/Function2;", "writeWasmUnitTestRunner", "compiledFile", "addWasmExperimentalArguments", "", "appendConfigsFromDir", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "confDir", "calculateDirHash", "dir", "toHex", "", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nutils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 utils.kt\norg/jetbrains/kotlin/gradle/targets/js/UtilsKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 FileReadWrite.kt\nkotlin/io/FilesKt__FileReadWriteKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,118:1\n603#2:119\n1313#2,2:120\n1313#2,2:128\n13316#3,2:122\n230#4,2:124\n1#5:126\n1#5:127\n*E\n*S KotlinDebug\n*F\n+ 1 utils.kt\norg/jetbrains/kotlin/gradle/targets/js/UtilsKt\n*L\n20#1:119\n21#1,2:120\n83#1,2:128\n32#1,2:122\n50#1,2:124\n50#1:126\n*E\n"})
public final class UtilsKt {
    @NotNull
    public static final String JS = "js";
    @NotNull
    public static final String JS_MAP = "js.map";
    @NotNull
    public static final String META_JS = "meta.js";
    @NotNull
    public static final String HTML = "html";

    public static final void appendConfigsFromDir(@NotNull Appendable $this$appendConfigsFromDir, @NotNull File confDir) {
        Intrinsics.checkNotNullParameter((Object)$this$appendConfigsFromDir, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)confDir, (String)"confDir");
        Object[] objectArray = confDir.listFiles();
        if (objectArray == null) {
            return;
        }
        Object[] files = objectArray;
        Sequence $this$sortedBy$iv = SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])files), (Function1)appendConfigsFromDir.1.INSTANCE), (Function1)appendConfigsFromDir.2.INSTANCE);
        boolean $i$f$sortedBy = false;
        Sequence $this$forEach$iv = SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                File it = (File)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (File)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            StringUtilsKt.appendLine($this$appendConfigsFromDir, "// " + it.getName());
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            $this$appendConfigsFromDir.append(FilesKt.readText$default((File)it, null, (int)1, null));
            StringUtilsKt.appendLine($this$appendConfigsFromDir);
            StringUtilsKt.appendLine($this$appendConfigsFromDir);
        }
    }

    @NotNull
    public static final String toHex(@NotNull byte[] $this$toHex) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$toHex, (String)"<this>");
        int n2 = 0;
        int n3 = $this$toHex.length * 2;
        char[] cArray = new char[n3];
        while (n2 < n3) {
            n = n2++;
            cArray[n] = 32;
        }
        char[] result2 = cArray;
        int i2 = 0;
        byte[] $this$forEach$iv = $this$toHex;
        boolean $i$f$forEach = false;
        int n4 = $this$forEach$iv.length;
        for (n = 0; n < n4; ++n) {
            byte element$iv;
            byte it = element$iv = $this$forEach$iv[n];
            boolean bl = false;
            byte n5 = it;
            int n6 = i2;
            i2 = n6 + 1;
            result2[n6] = Character.forDigit(n5 >> 4 & 0xF, 16);
            n6 = i2;
            i2 = n6 + 1;
            result2[n6] = Character.forDigit(n5 & 0xF, 16);
        }
        return new String(result2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static final void extractWithUpToDate(@NotNull File destination, @NotNull File destinationHashFile, @NotNull File dist, @NotNull FileHasher fileHasher, @NotNull Function2<? super File, ? super File, Unit> extract) {
        block10: {
            Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
            Intrinsics.checkNotNullParameter((Object)destinationHashFile, (String)"destinationHashFile");
            Intrinsics.checkNotNullParameter((Object)dist, (String)"dist");
            Intrinsics.checkNotNullParameter((Object)fileHasher, (String)"fileHasher");
            Intrinsics.checkNotNullParameter(extract, (String)"extract");
            distHash = null;
            file = destinationHashFile;
            $i$a$-let-UtilsKt$extractWithUpToDate$upToDate$1 = false;
            if (!file.exists()) break block10;
            $this$useLines_u24default$iv = file;
            charset$iv = Charsets.UTF_8;
            var11_10 = $this$useLines_u24default$iv;
            charset$iv$iv = charset$iv;
            $i$f$useLines = false;
            var14_13 = $this$useLines$iv$iv;
            var15_14 = 8192;
            var16_16 = var14_13;
            var14_13 = (var16_16 = (Reader)new InputStreamReader((InputStream)new FileInputStream((File)var16_16), charset$iv$iv)) instanceof BufferedReader != false ? (BufferedReader)var16_16 : new BufferedReader(var16_16, var15_14);
            var15_15 = null;
            try {
                it$iv$iv = (BufferedReader)var14_13;
                $i$a$-use-FilesKt__FileReadWriteKt$useLines$1$iv$iv = false;
                seq = TextStreamsKt.lineSequence((BufferedReader)it$iv$iv);
                $i$a$-useLines$default-UtilsKt$extractWithUpToDate$upToDate$1$1 = false;
                var20_23 /* !! */  = new String[]{" "};
                list = StringsKt.split$default((CharSequence)((CharSequence)SequencesKt.first((Sequence)seq)), (String[])var20_23 /* !! */ , (boolean)false, (int)0, (int)6, null);
                if (list.size() != 2 || !Intrinsics.areEqual(list.get(0), (Object)UtilsKt.calculateDirHash(fileHasher, destination))) ** GOTO lbl-1000
                v0 = list.get(1);
                v1 = fileHasher.hash(dist).toByteArray();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"fileHasher.hash(dist).toByteArray()");
                var22_25 /* !! */  = var20_23 /* !! */  = UtilsKt.toHex(v1);
                var23_26 = v0;
                $i$a$-also-UtilsKt$extractWithUpToDate$upToDate$1$1$1 = false;
                distHash = it;
                if (Intrinsics.areEqual(var23_26, (Object)var20_23 /* !! */ )) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = false;
                }
                var16_17 = v2;
                v3 = var16_17;
            }
            catch (Throwable var16_18) {
                var15_15 = var16_18;
                throw var16_18;
            }
            finally {
                CloseableKt.closeFinally((Closeable)var14_13, (Throwable)var15_15);
            }
        }
        v3 = false;
        if (upToDate = v3) {
            return;
        }
        if (destination.isDirectory()) {
            FilesKt.deleteRecursively((File)destination);
        }
        v4 = destination.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"destination.parentFile");
        extract.invoke((Object)dist, (Object)v4);
        v5 = new StringBuilder();
        v6 = UtilsKt.calculateDirHash(fileHasher, destination);
        Intrinsics.checkNotNull((Object)v6);
        v7 = v5.append(v6).append(' ');
        v8 = distHash;
        if (v8 == null) {
            v9 = fileHasher.hash(dist).toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"fileHasher.hash(dist).toByteArray()");
            v8 = UtilsKt.toHex(v9);
        }
        FilesKt.writeText$default((File)destinationHashFile, (String)v7.append(v8).toString(), null, (int)2, null);
    }

    @Nullable
    public static final String calculateDirHash(@NotNull FileHasher $this$calculateDirHash, @NotNull File dir2) {
        Intrinsics.checkNotNullParameter((Object)$this$calculateDirHash, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dir2, (String)"dir");
        if (!dir2.isDirectory()) {
            return null;
        }
        Hasher hasher = Hashing.defaultFunction().newHasher();
        Sequence $this$forEach$iv = (Sequence)FilesKt.walk$default((File)dir2, null, (int)1, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File file = (File)element$iv;
            boolean bl = false;
            hasher.putString((CharSequence)FilesKt.toRelativeString((File)file, (File)dir2));
            if (!file.isFile() || Files.isSymbolicLink(file.toPath())) continue;
            if (!Files.isSymbolicLink(file.toPath())) {
                hasher.putHash($this$calculateDirHash.hash(file));
                continue;
            }
            File canonicalFile = file.getCanonicalFile();
            hasher.putHash($this$calculateDirHash.hash(canonicalFile));
            Intrinsics.checkNotNullExpressionValue((Object)canonicalFile, (String)"canonicalFile");
            hasher.putString((CharSequence)FilesKt.toRelativeString((File)canonicalFile, (File)dir2));
        }
        byte[] byArray = hasher.hash().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"hasher.hash().toByteArray()");
        return UtilsKt.toHex(byArray);
    }

    @NotNull
    public static final File writeWasmUnitTestRunner(@NotNull File compiledFile) {
        Intrinsics.checkNotNullParameter((Object)compiledFile, (String)"compiledFile");
        File file = compiledFile.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"compiledFile.parentFile");
        File testRunnerFile = FilesKt.resolve((File)file, (String)"runUnitTests.mjs");
        FilesKt.writeText$default((File)testRunnerFile, (String)StringsKt.trimIndent((String)("\n        import exports from './" + compiledFile.getName() + "';\n        exports.startUnitTests?.();\n        ")), null, (int)2, null);
        return testRunnerFile;
    }

    public static final void addWasmExperimentalArguments(@NotNull List<String> $this$addWasmExperimentalArguments) {
        Intrinsics.checkNotNullParameter($this$addWasmExperimentalArguments, (String)"<this>");
        $this$addWasmExperimentalArguments.add("--experimental-wasm-gc");
    }
}

