/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.js.testing.mocha;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.process.ProcessForkOptions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.internal.testing.TCServiceMessagesClientSettings;
import org.jetbrains.kotlin.gradle.internal.testing.TCServiceMessagesTestExecutionSpec;
import org.jetbrains.kotlin.gradle.plugin.KotlinPlatformType;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinJsCompilation;
import org.jetbrains.kotlin.gradle.targets.js.NpmPackageVersion;
import org.jetbrains.kotlin.gradle.targets.js.NpmVersions;
import org.jetbrains.kotlin.gradle.targets.js.RequiredKotlinJsDependency;
import org.jetbrains.kotlin.gradle.targets.js.nodejs.NodeJsRootPlugin;
import org.jetbrains.kotlin.gradle.targets.js.npm.NpmProject;
import org.jetbrains.kotlin.gradle.targets.js.npm.NpmProjectKt;
import org.jetbrains.kotlin.gradle.targets.js.testing.KotlinJsTest;
import org.jetbrains.kotlin.gradle.targets.js.testing.KotlinJsTestFramework;
import org.jetbrains.kotlin.gradle.targets.js.testing.KotlinTestRunnerCliArgs;
import org.jetbrains.kotlin.gradle.targets.js.testing.mocha.KotlinMocha;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 /2\u00020\u0001:\u0001/B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050!2\u0006\u0010\"\u001a\u00020\u00052\b\u0010#\u001a\u0004\u0018\u00010\u0005H\u0002J.\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00050+2\u0006\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR2\u0010\t\u001a&\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00050\u0005 \u000b*\u0012\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0019\"\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/testing/mocha/KotlinMocha;", "Lorg/jetbrains/kotlin/gradle/targets/js/testing/KotlinJsTestFramework;", "compilation", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinJsCompilation;", "basePath", "", "(Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinJsCompilation;Ljava/lang/String;)V", "getCompilation", "()Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinJsCompilation;", "isTeamCity", "Lorg/gradle/api/provider/Provider;", "kotlin.jvm.PlatformType", "npmProject", "Lorg/jetbrains/kotlin/gradle/targets/js/npm/NpmProject;", "platformType", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinPlatformType;", "project", "Lorg/gradle/api/Project;", "requiredNpmDependencies", "", "Lorg/jetbrains/kotlin/gradle/targets/js/RequiredKotlinJsDependency;", "getRequiredNpmDependencies", "()Ljava/util/Set;", "settingsState", "getSettingsState", "()Ljava/lang/String;", "timeout", "getTimeout", "setTimeout", "(Ljava/lang/String;)V", "versions", "Lorg/jetbrains/kotlin/gradle/targets/js/NpmVersions;", "cliArg", "", "cli", "value", "createTestExecutionSpec", "Lorg/jetbrains/kotlin/gradle/internal/testing/TCServiceMessagesTestExecutionSpec;", "task", "Lorg/jetbrains/kotlin/gradle/targets/js/testing/KotlinJsTest;", "forkOptions", "Lorg/gradle/process/ProcessForkOptions;", "nodeJsArgs", "", "debug", "", "getPath", "Companion", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nKotlinMocha.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinMocha.kt\norg/jetbrains/kotlin/gradle/targets/js/testing/mocha/KotlinMocha\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,127:1\n1#2:128\n*E\n"})
public final class KotlinMocha
implements KotlinJsTestFramework {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final transient KotlinJsCompilation compilation;
    @NotNull
    private final String basePath;
    @NotNull
    private final transient Project project;
    @NotNull
    private final NpmProject npmProject;
    @NotNull
    private final NpmVersions versions;
    private final Provider<String> isTeamCity;
    @NotNull
    private String timeout;
    @NotNull
    private final KotlinPlatformType platformType;
    @NotNull
    private static final String DEFAULT_TIMEOUT = "2s";

    public KotlinMocha(@NotNull KotlinJsCompilation compilation2, @NotNull String basePath) {
        Intrinsics.checkNotNullParameter((Object)compilation2, (String)"compilation");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        this.compilation = compilation2;
        this.basePath = basePath;
        this.project = this.getCompilation().getTarget().getProject();
        this.npmProject = NpmProjectKt.getNpmProject(this.getCompilation());
        Project project = this.project.getRootProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project.rootProject");
        this.versions = NodeJsRootPlugin.Companion.getKotlinNodeJsExtension(project).getVersions();
        this.isTeamCity = this.project.getProviders().gradleProperty("teamcity");
        this.timeout = DEFAULT_TIMEOUT;
        this.platformType = this.getCompilation().getPlatformType();
    }

    @Override
    @NotNull
    public KotlinJsCompilation getCompilation() {
        return this.compilation;
    }

    @Override
    @NotNull
    public String getSettingsState() {
        return "mocha";
    }

    @Override
    @NotNull
    public Set<RequiredKotlinJsDependency> getRequiredNpmDependencies() {
        Object[] objectArray = new NpmPackageVersion[]{this.versions.getMocha(), this.versions.getSourceMapSupport()};
        return SetsKt.setOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public String getPath() {
        return this.basePath + ":kotlinMocha";
    }

    @NotNull
    public final String getTimeout() {
        return this.timeout;
    }

    public final void setTimeout(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.timeout = string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public TCServiceMessagesTestExecutionSpec createTestExecutionSpec(@NotNull KotlinJsTest task2, @NotNull ProcessForkOptions forkOptions, @NotNull List<String> nodeJsArgs, boolean debug) {
        List list2;
        void $this$createTestExecutionSpec_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        Intrinsics.checkNotNullParameter((Object)forkOptions, (String)"forkOptions");
        Intrinsics.checkNotNullParameter(nodeJsArgs, (String)"nodeJsArgs");
        String string = task2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"task.name");
        TCServiceMessagesClientSettings clientSettings2 = new TCServiceMessagesClientSettings(string, task2.getTargetName(), true, false, createTestExecutionSpec.clientSettings.1.INSTANCE, true, false, this.isTeamCity.isPresent(), 72, null);
        KotlinTestRunnerCliArgs cliArgs = new KotlinTestRunnerCliArgs(null, task2.getIncludePatterns(), task2.getExcludePatterns(), null, 9, null);
        String mocha = this.npmProject.require("mocha/bin/mocha");
        String string2 = ((RegularFile)task2.getInputFileProperty().get()).getAsFile().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"task.inputFileProperty.get().asFile.toString()");
        String file = string2;
        Object[] objectArray = new String[]{"--require", this.npmProject.require("source-map-support/register.js")};
        Object object = objectArray = CollectionsKt.mutableListOf((Object[])objectArray);
        Collection collection = nodeJsArgs;
        boolean bl2 = false;
        if (debug) {
            $this$createTestExecutionSpec_u24lambda_u240.add("--inspect-brk");
        }
        $this$createTestExecutionSpec_u24lambda_u240.add(mocha);
        $this$createTestExecutionSpec_u24lambda_u240.add(file);
        $this$createTestExecutionSpec_u24lambda_u240.addAll((Collection)cliArgs.toList());
        $this$createTestExecutionSpec_u24lambda_u240.addAll((Collection)this.cliArg("--reporter", "kotlin-test-js-runner/mocha-kotlin-reporter.js"));
        $this$createTestExecutionSpec_u24lambda_u240.addAll((Collection)this.cliArg("--require", this.npmProject.require("kotlin-test-js-runner/kotlin-test-nodejs-runner.js")));
        if (debug) {
            $this$createTestExecutionSpec_u24lambda_u240.add("--no-timeout");
        } else {
            $this$createTestExecutionSpec_u24lambda_u240.addAll((Collection)this.cliArg("--timeout", this.timeout));
        }
        if (this.platformType == KotlinPlatformType.wasm) {
            $this$createTestExecutionSpec_u24lambda_u240.addAll((Collection)this.cliArg("-n", "experimental-wasm-typed-funcref,experimental-wasm-gc,experimental-wasm-eh"));
        }
        List args2 = CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)objectArray));
        if (this.platformType == KotlinPlatformType.wasm) {
            list2 = null;
        } else {
            void $this$createTestExecutionSpec_u24lambda_u241;
            object = new String[]{"--require", this.npmProject.require("source-map-support/register.js")};
            Object bl2 = object = CollectionsKt.mutableListOf((Object[])object);
            collection = nodeJsArgs;
            boolean bl3 = false;
            $this$createTestExecutionSpec_u24lambda_u241.add(mocha);
            $this$createTestExecutionSpec_u24lambda_u241.add(file);
            $this$createTestExecutionSpec_u24lambda_u241.addAll((Collection)cliArgs.toList());
            $this$createTestExecutionSpec_u24lambda_u241.addAll((Collection)this.cliArg("--require", this.npmProject.require("kotlin-test-js-runner/kotlin-test-nodejs-empty-runner.js")));
            list2 = CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)object));
        }
        List dryRunArgs = list2;
        return new TCServiceMessagesTestExecutionSpec(forkOptions, args2, false, clientSettings2, dryRunArgs);
    }

    private final List<String> cliArg(String cli, String value) {
        Object object;
        block3: {
            block2: {
                object = value;
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                Object[] objectArray = new String[]{cli, it};
                List list2 = CollectionsKt.listOf((Object[])objectArray);
                object = list2;
                if (list2 != null) break block3;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/testing/mocha/KotlinMocha$Companion;", "", "()V", "DEFAULT_TIMEOUT", "", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

