/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.statistics;

import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.services.BuildServiceRegistration;
import org.gradle.api.services.BuildServiceSpec;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationCompletionListener;
import org.gradle.tooling.events.task.TaskFailureResult;
import org.gradle.tooling.events.task.TaskFinishEvent;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.logging.GradleLoggingUtilsKt;
import org.jetbrains.kotlin.gradle.plugin.BuildEventsListenerRegistryHolder;
import org.jetbrains.kotlin.gradle.plugin.StatisticsBuildFlowManager;
import org.jetbrains.kotlin.gradle.plugin.internal.ConfigurationCacheStartParameterAccessorKt;
import org.jetbrains.kotlin.gradle.plugin.internal.ProjectIsolationStartParameterAccessorKt;
import org.jetbrains.kotlin.gradle.plugin.statistics.BuildFlowService;
import org.jetbrains.kotlin.gradle.plugin.statistics.KotlinBuildStatsService;
import org.jetbrains.kotlin.gradle.plugin.statistics.MetricContainer;
import org.jetbrains.kotlin.gradle.report.BuildReportType;
import org.jetbrains.kotlin.gradle.report.ConfigureReporingKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b \u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004:\u0002\u0014\u0015B\u0005\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u001f\u0010\u0010\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u0013R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/statistics/BuildFlowService;", "Lorg/gradle/api/services/BuildService;", "Lorg/jetbrains/kotlin/gradle/plugin/statistics/BuildFlowService$Parameters;", "Ljava/lang/AutoCloseable;", "Lorg/gradle/tooling/events/OperationCompletionListener;", "()V", "buildFailed", "", "log", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "close", "", "onFinish", "event", "Lorg/gradle/tooling/events/FinishEvent;", "recordBuildFinished", "action", "", "recordBuildFinished$kotlin_gradle_plugin_common", "Companion", "Parameters", "kotlin-gradle-plugin_common"})
public abstract class BuildFlowService
implements BuildService<Parameters>,
AutoCloseable,
OperationCompletionListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean buildFailed;
    private final Logger log = Logging.getLogger(this.getClass());
    @NotNull
    private static final String serviceName = Reflection.getOrCreateKotlinClass(BuildFlowService.class).getSimpleName() + '_' + BuildFlowService.class.getClassLoader().hashCode();

    public BuildFlowService() {
        Logger logger = this.log;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"log");
        GradleLoggingUtilsKt.kotlinDebug(logger, "Initialize " + this.getClass().getSimpleName());
    }

    public void onFinish(@Nullable FinishEvent event) {
        ((Parameters)this.getParameters()).getFusStatisticsAvailable().get();
        if (event instanceof TaskFinishEvent && ((TaskFinishEvent)event).getResult() instanceof TaskFailureResult) {
            this.buildFailed = true;
        }
    }

    @Override
    public void close() {
        Object object = ((Parameters)this.getParameters()).getFusStatisticsAvailable().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.fusStatisticsAvailable.get()");
        if (((Boolean)object).booleanValue()) {
            this.recordBuildFinished$kotlin_gradle_plugin_common(null, this.buildFailed);
        }
        KotlinBuildStatsService.Companion.applyIfInitialised((Function1<? super KotlinBuildStatsService, Unit>)((Function1)close.1.INSTANCE));
        Logger logger = this.log;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"log");
        GradleLoggingUtilsKt.kotlinDebug(logger, "Close " + this.getClass().getSimpleName());
    }

    public final void recordBuildFinished$kotlin_gradle_plugin_common(@Nullable String action2, boolean buildFailed) {
        KotlinBuildStatsService.Companion.applyIfInitialised((Function1<? super KotlinBuildStatsService, Unit>)((Function1)new Function1<KotlinBuildStatsService, Unit>(action2, buildFailed, this){
            final /* synthetic */ String $action;
            final /* synthetic */ boolean $buildFailed;
            final /* synthetic */ BuildFlowService this$0;
            {
                this.$action = $action;
                this.$buildFailed = $buildFailed;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull KotlinBuildStatsService it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Object object = ((Parameters)this.this$0.getParameters()).getConfigurationMetrics().orElse((Object)new MetricContainer()).get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.configuration\u2026(MetricContainer()).get()");
                it.recordBuildFinish(this.$action, this.$buildFailed, (MetricContainer)object);
            }
        }));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/statistics/BuildFlowService$Companion;", "", "()V", "serviceName", "", "fusStatisticsAvailable", "", "project", "Lorg/gradle/api/Project;", "registerIfAbsent", "Lorg/gradle/api/provider/Provider;", "Lorg/jetbrains/kotlin/gradle/plugin/statistics/BuildFlowService;", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean fusStatisticsAvailable(Project project) {
            return GradleVersion.current().getBaseVersion().compareTo(GradleVersion.version((String)"7.4")) < 0 ? !ConfigurationCacheStartParameterAccessorKt.isConfigurationCacheRequested(project) : (GradleVersion.current().getBaseVersion().compareTo(GradleVersion.version((String)"8.1")) < 0 ? true : !ConfigurationCacheStartParameterAccessorKt.isConfigurationCacheRequested(project));
        }

        @NotNull
        public final Provider<BuildFlowService> registerIfAbsent(@NotNull Project project) {
            Provider provider;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            BuildServiceRegistration buildServiceRegistration = (BuildServiceRegistration)project.getGradle().getSharedServices().getRegistrations().findByName(serviceName);
            if (buildServiceRegistration != null) {
                BuildServiceRegistration it = buildServiceRegistration;
                boolean bl = false;
                Provider provider2 = it.getService();
                Intrinsics.checkNotNull((Object)provider2, (String)"null cannot be cast to non-null type org.gradle.api.provider.Provider<org.jetbrains.kotlin.gradle.plugin.statistics.BuildFlowService>");
                return provider2;
            }
            boolean fusStatisticsAvailable = this.fusStatisticsAvailable(project);
            boolean buildScanReportEnabled = ConfigureReporingKt.reportingSettings(project).getBuildReportOutputs().contains(BuildReportType.BUILD_SCAN);
            boolean isProjectIsolationEnabled2 = ProjectIsolationStartParameterAccessorKt.isProjectIsolationEnabled(project);
            Provider buildService = provider = project.getGradle().getSharedServices().registerIfAbsent(serviceName, BuildFlowService.class, new Action(fusStatisticsAvailable, project, isProjectIsolationEnabled2){
                final /* synthetic */ boolean $fusStatisticsAvailable;
                final /* synthetic */ Project $project;
                final /* synthetic */ boolean $isProjectIsolationEnabled;
                {
                    this.$fusStatisticsAvailable = $fusStatisticsAvailable;
                    this.$project = $project;
                    this.$isProjectIsolationEnabled = $isProjectIsolationEnabled;
                }

                public final void execute(BuildServiceSpec<Parameters> spec) {
                    if (this.$fusStatisticsAvailable) {
                        KotlinBuildStatsService.Companion.applyIfInitialised((Function1<? super KotlinBuildStatsService, Unit>)((Function1)new Function1<KotlinBuildStatsService, Unit>(this.$project){
                            final /* synthetic */ Project $project;
                            {
                                this.$project = $project;
                                super(1);
                            }

                            public final void invoke(@NotNull KotlinBuildStatsService it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                Gradle gradle = this.$project.getGradle();
                                Intrinsics.checkNotNullExpressionValue((Object)gradle, (String)"project.gradle");
                                it.recordProjectsEvaluated(gradle);
                            }
                        }));
                    }
                    ((Parameters)spec.getParameters()).getConfigurationMetrics().set(this.$project.provider(new Callable(this.$project, this.$isProjectIsolationEnabled){
                        final /* synthetic */ Project $project;
                        final /* synthetic */ boolean $isProjectIsolationEnabled;
                        {
                            this.$project = $project;
                            this.$isProjectIsolationEnabled = $isProjectIsolationEnabled;
                        }

                        @Nullable
                        public final MetricContainer call() {
                            KotlinBuildStatsService kotlinBuildStatsService = KotlinBuildStatsService.Companion.getInstance();
                            return kotlinBuildStatsService != null ? kotlinBuildStatsService.collectStartMetrics(this.$project, this.$isProjectIsolationEnabled) : null;
                        }
                    }));
                    ((Parameters)spec.getParameters()).getFusStatisticsAvailable().set((Object)this.$fusStatisticsAvailable);
                }
            });
            boolean bl = false;
            if (fusStatisticsAvailable) {
                if (GradleVersion.current().getBaseVersion().compareTo(GradleVersion.version((String)"8.1")) < 0) {
                    BuildEventsListenerRegistryHolder.Companion.getInstance(project).getListenerRegistry().onTaskCompletion(buildService);
                } else {
                    StatisticsBuildFlowManager.Companion.getInstance(project).subscribeForBuildResult();
                }
            }
            if (buildScanReportEnabled && GradleVersion.current().getBaseVersion().compareTo(GradleVersion.version((String)"8.1")) >= 0) {
                StatisticsBuildFlowManager.Companion.getInstance(project).subscribeForBuildScan(project);
            }
            Provider provider3 = provider;
            Intrinsics.checkNotNullExpressionValue((Object)provider3, (String)"project: Project,\n      \u2026          }\n            }");
            return provider3;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0006\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/statistics/BuildFlowService$Parameters;", "Lorg/gradle/api/services/BuildServiceParameters;", "configurationMetrics", "Lorg/gradle/api/provider/Property;", "Lorg/jetbrains/kotlin/gradle/plugin/statistics/MetricContainer;", "getConfigurationMetrics", "()Lorg/gradle/api/provider/Property;", "fusStatisticsAvailable", "", "getFusStatisticsAvailable", "kotlin-gradle-plugin_common"})
    public static interface Parameters
    extends BuildServiceParameters {
        @NotNull
        public Property<MetricContainer> getConfigurationMetrics();

        @NotNull
        public Property<Boolean> getFusStatisticsAvailable();
    }
}

