/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.mpp.apple;

import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.internal.TaskInputsInternal;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.dsl.KotlinNativeBinaryContainer;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.KotlinToolingDiagnostics;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.KotlinToolingDiagnosticsCollectorKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.Framework;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinNativeTarget;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinNativeTargetPresetKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.NativeBuildType;
import org.jetbrains.kotlin.gradle.plugin.mpp.apple.AppleXcodeTasksKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.apple.FrameworkCopy;
import org.jetbrains.kotlin.gradle.plugin.mpp.apple.XcodeEnvironment;
import org.jetbrains.kotlin.gradle.tasks.FatFrameworkTask;
import org.jetbrains.kotlin.gradle.tasks.TasksProviderKt;
import org.jetbrains.kotlin.gradle.utils.StringUtilsKt;
import org.jetbrains.kotlin.konan.target.KonanTarget;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u001a\u0014\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\u0006H\u0002\u001a\u001e\u0010\t\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000b\u0018\u00010\n*\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0002\u001a\u0014\u0010\r\u001a\u00020\u000e*\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0000\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u000f"}, d2={"namePrefix", "", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/Framework;", "getNamePrefix", "(Lorg/jetbrains/kotlin/gradle/plugin/mpp/Framework;)Ljava/lang/String;", "appleFrameworkDir", "Ljava/io/File;", "Lorg/gradle/api/Project;", "frameworkSearchDir", "registerAssembleAppleFrameworkTask", "Lorg/gradle/api/tasks/TaskProvider;", "Lorg/gradle/api/Task;", "framework", "registerEmbedAndSignAppleFrameworkTask", "", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nAppleXcodeTasks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppleXcodeTasks.kt\norg/jetbrains/kotlin/gradle/plugin/mpp/apple/AppleXcodeTasksKt\n+ 2 TasksProvider.kt\norg/jetbrains/kotlin/gradle/tasks/TasksProviderKt\n*L\n1#1,264:1\n81#2:265\n68#2,7:266\n81#2:273\n68#2,7:274\n37#2,6:281\n81#2:287\n68#2,7:288\n81#2:295\n68#2,7:296\n*S KotlinDebug\n*F\n+ 1 AppleXcodeTasks.kt\norg/jetbrains/kotlin/gradle/plugin/mpp/apple/AppleXcodeTasksKt\n*L\n120#1:265\n120#1:266,7\n124#1:273\n124#1:274,7\n132#1:281,6\n152#1:287\n152#1:288,7\n175#1:295\n175#1:296,7\n*E\n"})
public final class AppleXcodeTasksKt {
    /*
     * WARNING - void declaration
     */
    private static final TaskProvider<? extends Task> registerAssembleAppleFrameworkTask(Project $this$registerAssembleAppleFrameworkTask, Framework framework2) {
        TaskProvider taskProvider2;
        if (!framework2.getKonanTarget$kotlin_gradle_plugin_common().getFamily().isAppleFamily() || !KotlinNativeTargetPresetKt.getEnabledOnCurrentHost(framework2.getKonanTarget$kotlin_gradle_plugin_common())) {
            return null;
        }
        List<KonanTarget> envTargets = XcodeEnvironment.INSTANCE.getTargets();
        boolean needFatFramework = envTargets.size() > 1;
        NativeBuildType frameworkBuildType = framework2.getBuildType();
        KotlinNativeTarget frameworkTarget = framework2.getTarget();
        boolean isRequestedFramework = envTargets.contains(frameworkTarget.getKonanTarget());
        String[] stringArray = new String[]{"assemble", AppleXcodeTasksKt.getNamePrefix(framework2), frameworkBuildType.getName(), "AppleFrameworkForXcode", isRequestedFramework && needFatFramework ? null : frameworkTarget.getName()};
        String frameworkTaskName = StringUtilsKt.lowerCamelCaseName(stringArray);
        NativeBuildType envBuildType = XcodeEnvironment.INSTANCE.getBuildType();
        File envFrameworkSearchDir = XcodeEnvironment.INSTANCE.getFrameworkSearchDir();
        if (envBuildType == null || envTargets.isEmpty() || envFrameworkSearchDir == null) {
            String envConfiguration = System.getenv("CONFIGURATION");
            if (!((Collection)envTargets).isEmpty() && envConfiguration != null) {
                Project project = $this$registerAssembleAppleFrameworkTask.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                KotlinToolingDiagnosticsCollectorKt.reportDiagnostic(project, KotlinToolingDiagnostics.UnknownAppleFrameworkBuildType.INSTANCE.invoke(envConfiguration));
            } else {
                $this$registerAssembleAppleFrameworkTask.getLogger().debug("Not registering " + frameworkTaskName + ", since not called from Xcode");
            }
            return null;
        }
        if (!isRequestedFramework) {
            void $this$locateOrRegisterTask$iv;
            Project envConfiguration = $this$registerAssembleAppleFrameworkTask;
            Function1 body$iv = (Function1)new Function1<DefaultTask, Unit>(frameworkBuildType, frameworkTarget){
                final /* synthetic */ NativeBuildType $frameworkBuildType;
                final /* synthetic */ KotlinNativeTarget $frameworkTarget;
                {
                    this.$frameworkBuildType = $frameworkBuildType;
                    this.$frameworkTarget = $frameworkTarget;
                    super(1);
                }

                public final void invoke(@NotNull DefaultTask task2) {
                    Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
                    task2.setDescription("Packs " + this.$frameworkBuildType + ' ' + this.$frameworkTarget.getName() + " framework for Xcode");
                    task2.setEnabled(false);
                }
            };
            boolean $i$f$locateOrRegisterTask = false;
            Project project = $this$locateOrRegisterTask$iv.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
            Project $this$locateTask$iv$iv = project;
            boolean $i$f$locateTask = false;
            TaskContainer taskContainer = $this$locateTask$iv$iv.getTasks();
            Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"tasks");
            TaskContainer $this$locateTask$iv$iv$iv = taskContainer;
            boolean $i$f$locateTask2 = false;
            TaskProvider taskProvider3 = $this$locateTask$iv$iv$iv.getNames().contains(frameworkTaskName) ? $this$locateTask$iv$iv$iv.named(frameworkTaskName, DefaultTask.class) : null;
            taskProvider2 = taskProvider3;
            if (taskProvider3 == null) {
                Project project2 = $this$locateOrRegisterTask$iv.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
                taskProvider2 = TasksProviderKt.registerTask$default(project2, frameworkTaskName, DefaultTask.class, null, body$iv, 4, null);
            }
        } else if (needFatFramework) {
            Project $this$locateOrRegisterTask$iv = $this$registerAssembleAppleFrameworkTask;
            Function1 body$iv = (Function1)new Function1<FatFrameworkTask, Unit>(frameworkBuildType, framework2, $this$registerAssembleAppleFrameworkTask, envFrameworkSearchDir, envBuildType){
                final /* synthetic */ NativeBuildType $frameworkBuildType;
                final /* synthetic */ Framework $framework;
                final /* synthetic */ Project $this_registerAssembleAppleFrameworkTask;
                final /* synthetic */ File $envFrameworkSearchDir;
                final /* synthetic */ NativeBuildType $envBuildType;
                {
                    this.$frameworkBuildType = $frameworkBuildType;
                    this.$framework = $framework;
                    this.$this_registerAssembleAppleFrameworkTask = $receiver;
                    this.$envFrameworkSearchDir = $envFrameworkSearchDir;
                    this.$envBuildType = $envBuildType;
                    super(1);
                }

                public final void invoke(@NotNull FatFrameworkTask task2) {
                    Intrinsics.checkNotNullParameter((Object)((Object)task2), (String)"task");
                    task2.setDescription("Packs " + this.$frameworkBuildType + " fat framework for Xcode");
                    task2.setBaseName(this.$framework.getBaseName());
                    task2.setDestinationDir(AppleXcodeTasksKt.access$appleFrameworkDir(this.$this_registerAssembleAppleFrameworkTask, this.$envFrameworkSearchDir));
                    task2.setEnabled(this.$frameworkBuildType == this.$envBuildType);
                }
            };
            boolean $i$f$locateOrRegisterTask = false;
            Project project = $this$locateOrRegisterTask$iv.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
            Project $this$locateTask$iv$iv = project;
            boolean $i$f$locateTask = false;
            TaskContainer taskContainer = $this$locateTask$iv$iv.getTasks();
            Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"tasks");
            TaskContainer $this$locateTask$iv$iv$iv = taskContainer;
            boolean $i$f$locateTask3 = false;
            TaskProvider taskProvider4 = $this$locateTask$iv$iv$iv.getNames().contains(frameworkTaskName) ? $this$locateTask$iv$iv$iv.named(frameworkTaskName, FatFrameworkTask.class) : null;
            TaskProvider taskProvider5 = taskProvider4;
            if (taskProvider4 == null) {
                Project project3 = $this$locateOrRegisterTask$iv.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
                taskProvider5 = TasksProviderKt.registerTask$default(project3, frameworkTaskName, FatFrameworkTask.class, null, body$iv, 4, null);
            }
            Project it = $this$locateOrRegisterTask$iv = taskProvider5;
            boolean bl = false;
            it.configure(new Action(framework2){
                final /* synthetic */ Framework $framework;
                {
                    this.$framework = $framework;
                }

                public final void execute(FatFrameworkTask task2) {
                    Framework[] frameworkArray = new Framework[]{this.$framework};
                    task2.from(frameworkArray);
                }
            });
            taskProvider2 = $this$locateOrRegisterTask$iv;
        } else {
            void $this$registerTask_u24default$iv;
            Project $this$locateOrRegisterTask$iv = $this$registerAssembleAppleFrameworkTask;
            Function1 body$iv = (Function1)new Function1<FrameworkCopy, Unit>(frameworkBuildType, frameworkTarget, envBuildType, framework2, $this$registerAssembleAppleFrameworkTask, envFrameworkSearchDir){
                final /* synthetic */ NativeBuildType $frameworkBuildType;
                final /* synthetic */ KotlinNativeTarget $frameworkTarget;
                final /* synthetic */ NativeBuildType $envBuildType;
                final /* synthetic */ Framework $framework;
                final /* synthetic */ Project $this_registerAssembleAppleFrameworkTask;
                final /* synthetic */ File $envFrameworkSearchDir;
                {
                    this.$frameworkBuildType = $frameworkBuildType;
                    this.$frameworkTarget = $frameworkTarget;
                    this.$envBuildType = $envBuildType;
                    this.$framework = $framework;
                    this.$this_registerAssembleAppleFrameworkTask = $receiver;
                    this.$envFrameworkSearchDir = $envFrameworkSearchDir;
                    super(1);
                }

                public final void invoke(@NotNull FrameworkCopy task2) {
                    Intrinsics.checkNotNullParameter((Object)((Object)task2), (String)"task");
                    task2.setDescription("Packs " + this.$frameworkBuildType + ' ' + this.$frameworkTarget.getName() + " framework for Xcode");
                    task2.setEnabled(this.$frameworkBuildType == this.$envBuildType);
                    task2.getSourceFramework().fileProvider(this.$framework.getLinkTaskProvider().flatMap((Transformer)registerAssembleAppleFrameworkTask.1.INSTANCE));
                    Object[] objectArray = new Object[]{this.$framework.getLinkTaskProvider()};
                    task2.dependsOn(objectArray);
                    task2.getDestinationDirectory().set(AppleXcodeTasksKt.access$appleFrameworkDir(this.$this_registerAssembleAppleFrameworkTask, this.$envFrameworkSearchDir));
                }
            };
            List args$iv = CollectionsKt.emptyList();
            boolean $i$f$registerTask = false;
            taskProvider2 = TasksProviderKt.registerTask((Project)$this$registerTask_u24default$iv, frameworkTaskName, FrameworkCopy.class, args$iv, body$iv);
        }
        return taskProvider2;
    }

    /*
     * WARNING - void declaration
     */
    public static final void registerEmbedAndSignAppleFrameworkTask(@NotNull Project $this$registerEmbedAndSignAppleFrameworkTask, @NotNull Framework framework2) {
        void $this$locateOrRegisterTask$iv;
        Intrinsics.checkNotNullParameter((Object)$this$registerEmbedAndSignAppleFrameworkTask, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)framework2, (String)"framework");
        NativeBuildType envBuildType = XcodeEnvironment.INSTANCE.getBuildType();
        List<KonanTarget> envTargets = XcodeEnvironment.INSTANCE.getTargets();
        File envEmbeddedFrameworksDir = XcodeEnvironment.INSTANCE.getEmbeddedFrameworksDir();
        File envFrameworkSearchDir = XcodeEnvironment.INSTANCE.getFrameworkSearchDir();
        String envSign = XcodeEnvironment.INSTANCE.getSign();
        String[] stringArray = new String[]{"embedAndSign", AppleXcodeTasksKt.getNamePrefix(framework2), "AppleFrameworkForXcode"};
        String frameworkTaskName = StringUtilsKt.lowerCamelCaseName(stringArray);
        if (envBuildType == null || envTargets.isEmpty() || envEmbeddedFrameworksDir == null || envFrameworkSearchDir == null) {
            void $this$locateOrRegisterTask$iv2;
            stringArray = $this$registerEmbedAndSignAppleFrameworkTask;
            Function1 body$iv = (Function1)new Function1<DefaultTask, Unit>(framework2, envBuildType, frameworkTaskName){
                final /* synthetic */ Framework $framework;
                final /* synthetic */ NativeBuildType $envBuildType;
                final /* synthetic */ String $frameworkTaskName;
                {
                    this.$framework = $framework;
                    this.$envBuildType = $envBuildType;
                    this.$frameworkTaskName = $frameworkTaskName;
                    super(1);
                }

                public final void invoke(@NotNull DefaultTask task2) {
                    Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
                    task2.setGroup("build");
                    task2.setDescription("Embed and sign " + AppleXcodeTasksKt.access$getNamePrefix(this.$framework) + " framework as requested by Xcode's environment variables");
                    task2.doFirst(new Action(this.$envBuildType, this.$frameworkTaskName){
                        final /* synthetic */ NativeBuildType $envBuildType;
                        final /* synthetic */ String $frameworkTaskName;
                        {
                            this.$envBuildType = $envBuildType;
                            this.$frameworkTaskName = $frameworkTaskName;
                        }

                        public final void execute(Task it) {
                            String envConfiguration = System.getenv("CONFIGURATION");
                            if (envConfiguration != null && this.$envBuildType == null) {
                                throw new IllegalStateException("Unable to detect Kotlin framework build type for CONFIGURATION=" + envConfiguration + " automatically. Specify 'KOTLIN_FRAMEWORK_BUILD_TYPE' to 'debug' or 'release'\n" + XcodeEnvironment.INSTANCE);
                            }
                            throw new IllegalStateException("Please run the " + this.$frameworkTaskName + " task from Xcode ('SDK_NAME', 'CONFIGURATION', 'TARGET_BUILD_DIR', 'ARCHS' and 'FRAMEWORKS_FOLDER_PATH' not provided)\n" + XcodeEnvironment.INSTANCE);
                        }
                    });
                }
            };
            boolean $i$f$locateOrRegisterTask = false;
            Project project = $this$locateOrRegisterTask$iv2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
            Project $this$locateTask$iv$iv = project;
            boolean $i$f$locateTask = false;
            TaskContainer taskContainer = $this$locateTask$iv$iv.getTasks();
            Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"tasks");
            TaskContainer $this$locateTask$iv$iv$iv = taskContainer;
            boolean $i$f$locateTask2 = false;
            TaskProvider taskProvider2 = $this$locateTask$iv$iv$iv.getNames().contains(frameworkTaskName) ? $this$locateTask$iv$iv$iv.named(frameworkTaskName, DefaultTask.class) : null;
            TaskProvider taskProvider3 = taskProvider2;
            if (taskProvider2 == null) {
                Project project2 = $this$locateOrRegisterTask$iv2.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
                taskProvider3 = TasksProviderKt.registerTask$default(project2, frameworkTaskName, DefaultTask.class, null, body$iv, 4, null);
            }
            return;
        }
        String[] body$iv = $this$registerEmbedAndSignAppleFrameworkTask;
        Function1 body$iv2 = (Function1)new Function1<FrameworkCopy, Unit>(framework2, envBuildType, envTargets, envEmbeddedFrameworksDir, envSign){
            final /* synthetic */ Framework $framework;
            final /* synthetic */ NativeBuildType $envBuildType;
            final /* synthetic */ List<KonanTarget> $envTargets;
            final /* synthetic */ File $envEmbeddedFrameworksDir;
            final /* synthetic */ String $envSign;
            {
                this.$framework = $framework;
                this.$envBuildType = $envBuildType;
                this.$envTargets = $envTargets;
                this.$envEmbeddedFrameworksDir = $envEmbeddedFrameworksDir;
                this.$envSign = $envSign;
                super(1);
            }

            public final void invoke(@NotNull FrameworkCopy task2) {
                Intrinsics.checkNotNullParameter((Object)((Object)task2), (String)"task");
                task2.setGroup("build");
                task2.setDescription("Embed and sign " + AppleXcodeTasksKt.access$getNamePrefix(this.$framework) + " framework as requested by Xcode's environment variables");
                task2.setEnabled(!this.$framework.isStatic());
                TaskInputsInternal taskInputsInternal = task2.getInputs();
                NativeBuildType nativeBuildType = this.$envBuildType;
                List<KonanTarget> list = this.$envTargets;
                File file = this.$envEmbeddedFrameworksDir;
                String string = this.$envSign;
                TaskInputsInternal $this$invoke_u24lambda_u240 = taskInputsInternal;
                boolean bl = false;
                $this$invoke_u24lambda_u240.property("type", (Object)nativeBuildType);
                $this$invoke_u24lambda_u240.property("targets", list);
                $this$invoke_u24lambda_u240.property("embeddedFrameworksDir", (Object)file);
                if (string != null) {
                    $this$invoke_u24lambda_u240.property("sign", (Object)string);
                }
            }
        };
        boolean $i$f$locateOrRegisterTask = false;
        Project project = $this$locateOrRegisterTask$iv.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Project $this$locateTask$iv$iv = project;
        boolean $i$f$locateTask = false;
        TaskContainer taskContainer = $this$locateTask$iv$iv.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"tasks");
        TaskContainer $this$locateTask$iv$iv$iv = taskContainer;
        boolean $i$f$locateTask3 = false;
        TaskProvider taskProvider4 = $this$locateTask$iv$iv$iv.getNames().contains(frameworkTaskName) ? $this$locateTask$iv$iv$iv.named(frameworkTaskName, FrameworkCopy.class) : null;
        TaskProvider taskProvider5 = taskProvider4;
        if (taskProvider4 == null) {
            Project project3 = $this$locateOrRegisterTask$iv.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
            taskProvider5 = TasksProviderKt.registerTask$default(project3, frameworkTaskName, FrameworkCopy.class, null, body$iv2, 4, null);
        }
        TaskProvider embedAndSignTask2 = taskProvider5;
        TaskProvider<? extends Task> taskProvider6 = AppleXcodeTasksKt.registerAssembleAppleFrameworkTask((Project)$this$registerEmbedAndSignAppleFrameworkTask, framework2);
        if (taskProvider6 == null) {
            return;
        }
        TaskProvider<? extends Task> assembleTask = taskProvider6;
        if (framework2.getBuildType() != envBuildType || !envTargets.contains(framework2.getKonanTarget$kotlin_gradle_plugin_common())) {
            return;
        }
        embedAndSignTask2.configure(new Action(framework2, assembleTask, (Project)$this$registerEmbedAndSignAppleFrameworkTask, envFrameworkSearchDir, envEmbeddedFrameworksDir, envSign){
            final /* synthetic */ Framework $framework;
            final /* synthetic */ TaskProvider<? extends Task> $assembleTask;
            final /* synthetic */ Project $this_registerEmbedAndSignAppleFrameworkTask;
            final /* synthetic */ File $envFrameworkSearchDir;
            final /* synthetic */ File $envEmbeddedFrameworksDir;
            final /* synthetic */ String $envSign;
            {
                this.$framework = $framework;
                this.$assembleTask = $assembleTask;
                this.$this_registerEmbedAndSignAppleFrameworkTask = $receiver;
                this.$envFrameworkSearchDir = $envFrameworkSearchDir;
                this.$envEmbeddedFrameworksDir = $envEmbeddedFrameworksDir;
                this.$envSign = $envSign;
            }

            public final void execute(FrameworkCopy task2) {
                File frameworkFile = this.$framework.getOutputFile();
                Object[] objectArray = new Object[]{this.$assembleTask};
                task2.dependsOn(objectArray);
                task2.getSourceFramework().set(new File(AppleXcodeTasksKt.access$appleFrameworkDir(this.$this_registerEmbedAndSignAppleFrameworkTask, this.$envFrameworkSearchDir), frameworkFile.getName()));
                task2.getDestinationDirectory().set(this.$envEmbeddedFrameworksDir);
                if (this.$envSign != null) {
                    task2.doLast(new Action(this.$envEmbeddedFrameworksDir, frameworkFile, task2, this.$envSign){
                        final /* synthetic */ File $envEmbeddedFrameworksDir;
                        final /* synthetic */ File $frameworkFile;
                        final /* synthetic */ FrameworkCopy $task;
                        final /* synthetic */ String $envSign;
                        {
                            this.$envEmbeddedFrameworksDir = $envEmbeddedFrameworksDir;
                            this.$frameworkFile = $frameworkFile;
                            this.$task = $task;
                            this.$envSign = $envSign;
                        }

                        public final void execute(Task it) {
                            String string = this.$frameworkFile.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"frameworkFile.name");
                            File binary = FilesKt.resolve((File)FilesKt.resolve((File)this.$envEmbeddedFrameworksDir, (String)string), (String)FilesKt.getNameWithoutExtension((File)this.$frameworkFile));
                            this.$task.getExecOperations().exec(new Action(this.$envSign, binary){
                                final /* synthetic */ String $envSign;
                                final /* synthetic */ File $binary;
                                {
                                    this.$envSign = $envSign;
                                    this.$binary = $binary;
                                }

                                public final void execute(ExecSpec it) {
                                    Object[] objectArray = new Object[]{"codesign", "--force", "--sign", this.$envSign, "--", this.$binary};
                                    it.commandLine(objectArray);
                                }
                            });
                        }
                    });
                }
            }
        });
    }

    private static final String getNamePrefix(Framework $this$namePrefix) {
        return KotlinNativeBinaryContainer.Companion.extractPrefixFromBinaryName$kotlin_gradle_plugin_common($this$namePrefix.getName(), $this$namePrefix.getBuildType(), $this$namePrefix.getOutputKind().getTaskNameClassifier());
    }

    private static final File appleFrameworkDir(Project $this$appleFrameworkDir, File frameworkSearchDir) {
        File file = $this$appleFrameworkDir.getBuildDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"buildDir");
        return FilesKt.resolve((File)FilesKt.resolve((File)file, (String)"xcode-frameworks"), (File)frameworkSearchDir);
    }

    public static final /* synthetic */ File access$appleFrameworkDir(Project $receiver, File frameworkSearchDir) {
        return AppleXcodeTasksKt.appleFrameworkDir($receiver, frameworkSearchDir);
    }

    public static final /* synthetic */ String access$getNamePrefix(Framework $receiver) {
        return AppleXcodeTasksKt.getNamePrefix($receiver);
    }
}

