/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.statistics;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.statistics.metrics.BooleanMetrics;
import org.jetbrains.kotlin.statistics.metrics.IStatisticsValuesConsumer;
import org.jetbrains.kotlin.statistics.metrics.NumericalMetrics;
import org.jetbrains.kotlin.statistics.metrics.StringMetrics;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0011J\u001d\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0012J\u0018\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\rJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016R*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u0004j\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u0004j\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/statistics/MetricContainer;", "Ljava/io/Serializable;", "()V", "booleanMetrics", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/statistics/metrics/BooleanMetrics;", "", "Lkotlin/collections/HashMap;", "numericalMetrics", "Lorg/jetbrains/kotlin/statistics/metrics/NumericalMetrics;", "", "stringMetrics", "Lorg/jetbrains/kotlin/statistics/metrics/StringMetrics;", "", "put", "metric", "value", "(Lorg/jetbrains/kotlin/statistics/metrics/BooleanMetrics;Z)Ljava/lang/Boolean;", "(Lorg/jetbrains/kotlin/statistics/metrics/NumericalMetrics;J)Ljava/lang/Long;", "report", "", "sessionLogger", "Lorg/jetbrains/kotlin/statistics/metrics/IStatisticsValuesConsumer;", "kotlin-gradle-plugin_common"})
public final class MetricContainer
implements Serializable {
    @NotNull
    private final HashMap<NumericalMetrics, Long> numericalMetrics = new HashMap();
    @NotNull
    private final HashMap<BooleanMetrics, Boolean> booleanMetrics = new HashMap();
    @NotNull
    private final HashMap<StringMetrics, String> stringMetrics = new HashMap();

    public final void report(@NotNull IStatisticsValuesConsumer sessionLogger) {
        Enum key;
        Intrinsics.checkNotNullParameter((Object)sessionLogger, (String)"sessionLogger");
        for (Map.Entry entry2 : ((Map)this.numericalMetrics).entrySet()) {
            key = (NumericalMetrics)((Object)entry2.getKey());
            long value = ((Number)entry2.getValue()).longValue();
            IStatisticsValuesConsumer.DefaultImpls.report$default(sessionLogger, (NumericalMetrics)key, value, null, null, 12, null);
        }
        for (Map.Entry entry2 : ((Map)this.booleanMetrics).entrySet()) {
            key = (BooleanMetrics)((Object)entry2.getKey());
            boolean value = (Boolean)entry2.getValue();
            IStatisticsValuesConsumer.DefaultImpls.report$default(sessionLogger, (BooleanMetrics)key, value, null, null, 12, null);
        }
        for (Map.Entry entry2 : ((Map)this.stringMetrics).entrySet()) {
            key = (StringMetrics)((Object)entry2.getKey());
            String value = (String)entry2.getValue();
            IStatisticsValuesConsumer.DefaultImpls.report$default(sessionLogger, (StringMetrics)key, value, null, null, 12, null);
        }
    }

    @Nullable
    public final String put(@NotNull StringMetrics metric, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)((Object)metric), (String)"metric");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.stringMetrics.put(metric, value);
    }

    @Nullable
    public final Boolean put(@NotNull BooleanMetrics metric, boolean value) {
        Intrinsics.checkNotNullParameter((Object)((Object)metric), (String)"metric");
        return this.booleanMetrics.put(metric, value);
    }

    @Nullable
    public final Long put(@NotNull NumericalMetrics metric, long value) {
        Intrinsics.checkNotNullParameter((Object)((Object)metric), (String)"metric");
        return this.numericalMetrics.put(metric, value);
    }
}

