/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.utils;

import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.InternalKotlinGradlePluginApi;
import org.jetbrains.kotlin.gradle.plugin.mpp.BitcodeEmbeddingMode;
import org.jetbrains.kotlin.gradle.utils.XcodeUtils;
import org.jetbrains.kotlin.gradle.utils.XcodeUtilsKt;
import org.jetbrains.kotlin.konan.target.Architecture;
import org.jetbrains.kotlin.konan.target.CompilerOutputKind;
import org.jetbrains.kotlin.konan.target.Family;
import org.jetbrains.kotlin.konan.target.KonanTarget;
import org.jetbrains.kotlin.konan.target.XcodeVersion;

@InternalKotlinGradlePluginApi
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u001e\u0010\u0017\u001a\u00020\u00162\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0013\u001a\u00020\u0014R'\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/gradle/utils/XcodeUtils;", "", "()V", "defaultTestDevices", "", "Lorg/jetbrains/kotlin/konan/target/Family;", "", "getDefaultTestDevices", "()Ljava/util/Map;", "defaultTestDevices$delegate", "Lkotlin/Lazy;", "bitcodeEmbeddingMode", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/BitcodeEmbeddingMode;", "outputKind", "Lorg/jetbrains/kotlin/konan/target/CompilerOutputKind;", "userMode", "xcodeVersion", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/RegularFile;", "target", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "debuggable", "", "bitcodeSupported", "getDefaultTestDeviceId", "kotlin-gradle-plugin_common"})
public final class XcodeUtils {
    @NotNull
    public static final XcodeUtils INSTANCE = new XcodeUtils();
    @NotNull
    private static final Lazy defaultTestDevices$delegate = LazyKt.lazy((Function0)defaultTestDevices.2.INSTANCE);

    private XcodeUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final BitcodeEmbeddingMode bitcodeEmbeddingMode(@NotNull CompilerOutputKind outputKind2, @Nullable BitcodeEmbeddingMode userMode, @NotNull Provider<RegularFile> xcodeVersion, @NotNull KonanTarget target2, boolean debuggable2) {
        BitcodeEmbeddingMode bitcodeEmbeddingMode;
        Intrinsics.checkNotNullParameter((Object)outputKind2, (String)"outputKind");
        Intrinsics.checkNotNullParameter(xcodeVersion, (String)"xcodeVersion");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        if (outputKind2 != CompilerOutputKind.FRAMEWORK) {
            bitcodeEmbeddingMode = BitcodeEmbeddingMode.DISABLE;
            return bitcodeEmbeddingMode;
        } else {
            bitcodeEmbeddingMode = userMode;
            if (bitcodeEmbeddingMode != null) return bitcodeEmbeddingMode;
            if (this.bitcodeSupported(xcodeVersion, target2)) {
                boolean bl = debuggable2;
                if (bl) {
                    bitcodeEmbeddingMode = BitcodeEmbeddingMode.MARKER;
                    return bitcodeEmbeddingMode;
                } else {
                    if (bl) throw new NoWhenBranchMatchedException();
                    bitcodeEmbeddingMode = BitcodeEmbeddingMode.BITCODE;
                }
                return bitcodeEmbeddingMode;
            } else {
                bitcodeEmbeddingMode = BitcodeEmbeddingMode.DISABLE;
            }
        }
        return bitcodeEmbeddingMode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean bitcodeSupported(Provider<RegularFile> xcodeVersion, KonanTarget target2) {
        if (XcodeUtilsKt.parse(XcodeVersion.Companion, xcodeVersion).getMajor() >= 14) return false;
        Object[] objectArray = new Family[]{Family.IOS, Family.WATCHOS, Family.TVOS};
        if (!CollectionsKt.listOf((Object[])objectArray).contains(target2.getFamily())) return false;
        objectArray = new Architecture[]{Architecture.ARM32, Architecture.ARM64};
        if (!CollectionsKt.listOf((Object[])objectArray).contains(target2.getArchitecture())) return false;
        return true;
    }

    @Nullable
    public final String getDefaultTestDeviceId(@NotNull KonanTarget target2) {
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        return this.getDefaultTestDevices().get(target2.getFamily());
    }

    private final Map<Family, String> getDefaultTestDevices() {
        Lazy lazy = defaultTestDevices$delegate;
        return (Map)lazy.getValue();
    }
}

