/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.impl.cookie;

import java.util.Date;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.annotation.Contract;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.annotation.ThreadingBehavior;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.client.utils.DateUtils;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.cookie.CommonCookieAttributeHandler;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.cookie.MalformedCookieException;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.cookie.SetCookie;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicExpiresHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    private final String[] datepatterns;

    public BasicExpiresHandler(String[] datepatterns) {
        Args.notNull(datepatterns, "Array of date patterns");
        this.datepatterns = datepatterns;
    }

    @Override
    public void parse(SetCookie cookie, String value2) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value2 == null) {
            throw new MalformedCookieException("Missing value for 'expires' attribute");
        }
        Date expiry = DateUtils.parseDate(value2, this.datepatterns);
        if (expiry == null) {
            throw new MalformedCookieException("Invalid 'expires' attribute: " + value2);
        }
        cookie.setExpiryDate(expiry);
    }

    @Override
    public String getAttributeName() {
        return "expires";
    }
}

