/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import java.io.File;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.report.metrics.BuildMetrics;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporterImpl;
import org.jetbrains.kotlin.build.report.metrics.BuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.BuildPerformanceMetrics;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildTime;
import org.jetbrains.kotlin.buildtools.api.KotlinLogger;
import org.jetbrains.kotlin.daemon.common.CompilationResultCategory;
import org.jetbrains.kotlin.daemon.common.CompilationResults;
import org.jetbrains.kotlin.daemon.common.CompileIterationResult;
import org.jetbrains.kotlin.daemon.common.LoopbackNetworkInterface;
import org.jetbrains.kotlin.gradle.utils.FileUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/GradleCompilationResults;", "Lorg/jetbrains/kotlin/daemon/common/CompilationResults;", "Ljava/rmi/server/UnicastRemoteObject;", "log", "Lorg/jetbrains/kotlin/buildtools/api/KotlinLogger;", "projectRootFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/buildtools/api/KotlinLogger;Ljava/io/File;)V", "buildMetrics", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetrics;", "Lorg/jetbrains/kotlin/build/report/metrics/GradleBuildTime;", "Lorg/jetbrains/kotlin/build/report/metrics/GradleBuildPerformanceMetric;", "getBuildMetrics", "()Lorg/jetbrains/kotlin/build/report/metrics/BuildMetrics;", "buildMetricsReporter", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporterImpl;", "icLogLines", "", "", "getIcLogLines", "()Ljava/util/List;", "setIcLogLines", "(Ljava/util/List;)V", "add", "", "compilationResultCategory", "", "value", "Ljava/io/Serializable;", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nGradleCompilationResults.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleCompilationResults.kt\norg/jetbrains/kotlin/compilerRunner/GradleCompilationResults\n+ 2 gradleLoggingUtils.kt\norg/jetbrains/kotlin/gradle/logging/GradleLoggingUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,54:1\n42#2,4:55\n42#2,4:59\n1#3:63\n*S KotlinDebug\n*F\n+ 1 GradleCompilationResults.kt\norg/jetbrains/kotlin/compilerRunner/GradleCompilationResults\n*L\n37#1:55,4\n41#1:59,4\n*E\n"})
public final class GradleCompilationResults
extends UnicastRemoteObject
implements CompilationResults {
    @NotNull
    private final KotlinLogger log;
    @NotNull
    private final File projectRootFile;
    @NotNull
    private List<String> icLogLines;
    @NotNull
    private final BuildMetricsReporterImpl<GradleBuildTime, GradleBuildPerformanceMetric> buildMetricsReporter;

    public GradleCompilationResults(@NotNull KotlinLogger log, @NotNull File projectRootFile) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)projectRootFile, (String)"projectRootFile");
        super(0, (RMIClientSocketFactory)LoopbackNetworkInterface.INSTANCE.getClientLoopbackSocketFactory(), (RMIServerSocketFactory)LoopbackNetworkInterface.INSTANCE.getServerLoopbackSocketFactory());
        this.log = log;
        this.projectRootFile = projectRootFile;
        this.icLogLines = CollectionsKt.emptyList();
        this.buildMetricsReporter = new BuildMetricsReporterImpl();
    }

    @NotNull
    public final List<String> getIcLogLines() {
        return this.icLogLines;
    }

    public final void setIcLogLines(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.icLogLines = list;
    }

    @NotNull
    public final BuildMetrics<GradleBuildTime, GradleBuildPerformanceMetric> getBuildMetrics() {
        return this.buildMetricsReporter.getMetrics();
    }

    public void add(int compilationResultCategory, @NotNull Serializable value2) throws RemoteException {
        block5: {
            int n;
            block6: {
                block4: {
                    String string;
                    KotlinLogger kotlinLogger2;
                    StringBuilder stringBuilder;
                    CompileIterationResult compileIterationResult;
                    Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                    n = compilationResultCategory;
                    if (n != CompilationResultCategory.IC_COMPILE_ITERATION.getCode()) break block4;
                    CompileIterationResult compileIterationResult2 = compileIterationResult = value2 instanceof CompileIterationResult ? (CompileIterationResult)value2 : null;
                    if (compileIterationResult == null) break block5;
                    Iterable sourceFiles2 = compileIterationResult.getSourceFiles();
                    if (CollectionsKt.any((Iterable)sourceFiles2)) {
                        KotlinLogger $this$kotlinDebug$iv = this.log;
                        boolean $i$f$kotlinDebug = false;
                        if ($this$kotlinDebug$iv.isDebugEnabled()) {
                            stringBuilder = new StringBuilder().append("[KOTLIN] ");
                            kotlinLogger2 = $this$kotlinDebug$iv;
                            boolean bl = false;
                            string = "compile iteration: " + FileUtilsKt.pathsAsStringRelativeTo(sourceFiles2, this.projectRootFile);
                            kotlinLogger2.debug(stringBuilder.append(string).toString());
                        }
                        BuildPerformanceMetrics.add$default((BuildPerformanceMetrics)this.getBuildMetrics().getBuildPerformanceMetrics(), (BuildPerformanceMetric)((BuildPerformanceMetric)GradleBuildPerformanceMetric.COMPILE_ITERATION), (long)0L, (int)2, null);
                    }
                    String exitCode = compileIterationResult.getExitCode();
                    KotlinLogger $this$kotlinDebug$iv = this.log;
                    boolean $i$f$kotlinDebug = false;
                    if ($this$kotlinDebug$iv.isDebugEnabled()) {
                        stringBuilder = new StringBuilder().append("[KOTLIN] ");
                        kotlinLogger2 = $this$kotlinDebug$iv;
                        boolean bl = false;
                        string = "compiler exit code: " + exitCode;
                        kotlinLogger2.debug(stringBuilder.append(string).toString());
                    }
                    break block5;
                }
                if (!(n == CompilationResultCategory.BUILD_REPORT_LINES.getCode() ? true : n == CompilationResultCategory.VERBOSE_BUILD_REPORT_LINES.getCode())) break block6;
                List list = value2 instanceof List ? (List)((Object)value2) : null;
                if (list == null) break block5;
                List it = list;
                boolean bl = false;
                this.icLogLines = it;
                break block5;
            }
            if (n != CompilationResultCategory.BUILD_METRICS.getCode()) break block5;
            BuildMetrics buildMetrics = value2 instanceof BuildMetrics ? (BuildMetrics)value2 : null;
            if (buildMetrics != null) {
                BuildMetrics it = buildMetrics;
                boolean bl = false;
                this.buildMetricsReporter.addMetrics(it);
            }
        }
    }
}

