/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildTime;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;
import org.jetbrains.kotlin.compilerRunner.KotlinNativeToolRunner;
import org.jetbrains.kotlin.compilerRunner.KotlinToolRunner;
import org.jetbrains.kotlin.compilerRunner.NativeToolRunnersKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.apple.XcodeMessageReportingKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\f\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\b \u0018\u00002\u00020\u0001:\u000212B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0002\u0010\fJ\u0006\u0010)\u001a\u00020*J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00030,H\u0014J\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00030,J\u0014\u0010.\u001a\u00020*2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00030,J\u001c\u00100\u001a\b\u0012\u0004\u0012\u00020\u00030,2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00030,H\u0016R5\u0010\r\u001a&\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f \u0010*\u0012\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f\u0018\u00010\u00110\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R!\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001a\u0010\u0013R/\u0010\u001d\u001a\u0016\u0012\u0004\u0012\u00020\u0003\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00030\u00030\u001e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\u001c\u001a\u0004\b\u001f\u0010 R\u0011\u0010\"\u001a\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0016\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/KotlinNativeToolRunner;", "Lorg/jetbrains/kotlin/compilerRunner/KotlinToolRunner;", "toolName", "", "settings", "Lorg/jetbrains/kotlin/compilerRunner/KotlinNativeToolRunner$Settings;", "executionContext", "Lorg/jetbrains/kotlin/compilerRunner/KotlinToolRunner$GradleExecutionContext;", "metricsReporter", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporter;", "Lorg/jetbrains/kotlin/build/report/metrics/GradleBuildTime;", "Lorg/jetbrains/kotlin/build/report/metrics/GradleBuildPerformanceMetric;", "(Ljava/lang/String;Lorg/jetbrains/kotlin/compilerRunner/KotlinNativeToolRunner$Settings;Lorg/jetbrains/kotlin/compilerRunner/KotlinToolRunner$GradleExecutionContext;Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporter;)V", "classpath", "", "Ljava/io/File;", "kotlin.jvm.PlatformType", "", "getClasspath", "()Ljava/util/Set;", "daemonEntryPoint", "getDaemonEntryPoint", "()Ljava/lang/String;", "displayName", "getDisplayName", "execEnvironmentBlacklist", "getExecEnvironmentBlacklist", "execEnvironmentBlacklist$delegate", "Lkotlin/Lazy;", "execSystemProperties", "", "getExecSystemProperties", "()Ljava/util/Map;", "execSystemProperties$delegate", "isolatedClassLoaderCacheKey", "Lorg/jetbrains/kotlin/compilerRunner/KotlinNativeToolRunner$IsolatedClassLoaderCacheKey;", "getIsolatedClassLoaderCacheKey", "()Lorg/jetbrains/kotlin/compilerRunner/KotlinNativeToolRunner$IsolatedClassLoaderCacheKey;", "mainClass", "getMainClass", "getToolName", "checkClasspath", "", "extractArgsFromSettings", "", "getCustomJvmArgs", "run", "args", "transformArgs", "IsolatedClassLoaderCacheKey", "Settings", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nnativeToolRunners.kt\nKotlin\n*S Kotlin\n*F\n+ 1 nativeToolRunners.kt\norg/jetbrains/kotlin/compilerRunner/KotlinNativeToolRunner\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,276:1\n1#2:277\n*E\n"})
public abstract class KotlinNativeToolRunner
extends KotlinToolRunner {
    @NotNull
    private final String toolName;
    @NotNull
    private final Settings settings;
    @NotNull
    private final Lazy execEnvironmentBlacklist$delegate;
    @NotNull
    private final Lazy execSystemProperties$delegate;

    public KotlinNativeToolRunner(@NotNull String toolName, @NotNull Settings settings, @NotNull KotlinToolRunner.GradleExecutionContext executionContext, @NotNull BuildMetricsReporter<GradleBuildTime, GradleBuildPerformanceMetric> metricsReporter) {
        Intrinsics.checkNotNullParameter((Object)toolName, (String)"toolName");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
        Intrinsics.checkNotNullParameter(metricsReporter, (String)"metricsReporter");
        super(executionContext, metricsReporter);
        this.toolName = toolName;
        this.settings = settings;
        this.execEnvironmentBlacklist$delegate = LazyKt.lazy((Function0)execEnvironmentBlacklist.2.INSTANCE);
        this.execSystemProperties$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<String, ? extends String>>(this){
            final /* synthetic */ KotlinNativeToolRunner this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Map<String, String> invoke() {
                MessageRenderer messageRenderer = KotlinNativeToolRunner.access$getSettings$p(this.this$0).getUseXcodeMessageStyle() ? MessageRenderer.XCODE_STYLE : MessageRenderer.GRADLE_STYLE;
                return MapsKt.mapOf((Pair)TuplesKt.to((Object)"org.jetbrains.kotlin.cliMessageRenderer", (Object)messageRenderer.getName()));
            }
        }));
    }

    @NotNull
    protected final String getToolName() {
        return this.toolName;
    }

    @Override
    @NotNull
    public final String getDisplayName() {
        return this.toolName;
    }

    @Override
    @NotNull
    public final String getMainClass() {
        return "org.jetbrains.kotlin.cli.utilities.MainKt";
    }

    @Override
    @NotNull
    public final String getDaemonEntryPoint() {
        return !this.settings.getUseXcodeMessageStyle() ? "daemonMain" : "daemonMainWithXcodeRenderer";
    }

    @Override
    @NotNull
    public final Set<String> getExecEnvironmentBlacklist() {
        Lazy lazy = this.execEnvironmentBlacklist$delegate;
        return (Set)lazy.getValue();
    }

    @Override
    @NotNull
    public final Map<String, String> getExecSystemProperties() {
        Lazy lazy = this.execSystemProperties$delegate;
        return (Map)lazy.getValue();
    }

    @Override
    public final Set<File> getClasspath() {
        return this.settings.getClasspath().getFiles();
    }

    @Override
    public final void checkClasspath() {
        Set<File> set2 = this.getClasspath();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"classpath");
        if (!(!((Collection)set2).isEmpty())) {
            boolean bl = false;
            String string = StringsKt.trimIndent((String)("\n                Classpath of the tool is empty: " + this.toolName + "\n                Probably the 'kotlin.native.home' project property contains an incorrect path.\n                Please change it to the compiler root directory and rerun the build.\n            "));
            throw new IllegalStateException(string.toString());
        }
    }

    @Override
    @NotNull
    public final IsolatedClassLoaderCacheKey getIsolatedClassLoaderCacheKey() {
        Set<File> set2 = this.getClasspath();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"classpath");
        return new IsolatedClassLoaderCacheKey(set2);
    }

    @Override
    @NotNull
    public List<String> transformArgs(@NotNull List<String> args2) {
        Intrinsics.checkNotNullParameter(args2, (String)"args");
        return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)this.toolName), (Iterable)args2);
    }

    @Override
    @NotNull
    public final List<String> getCustomJvmArgs() {
        return this.settings.getJvmArgs();
    }

    @Override
    public final void run(@NotNull List<String> args2) {
        Intrinsics.checkNotNullParameter(args2, (String)"args");
        super.run(CollectionsKt.plus((Collection)args2, (Iterable)this.extractArgsFromSettings()));
    }

    @NotNull
    protected List<String> extractArgsFromSettings() {
        Object object;
        block3: {
            block2: {
                object = this.settings.getKonanDataDir();
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                List list = CollectionsKt.listOf((Object)("-Xkonan-data-dir=" + it));
                object = list;
                if (list != null) break block3;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    public static final /* synthetic */ Settings access$getSettings$p(KotlinNativeToolRunner $this) {
        return $this.settings;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/KotlinNativeToolRunner$IsolatedClassLoaderCacheKey;", "", "classpath", "", "Ljava/io/File;", "(Ljava/util/Set;)V", "getClasspath", "()Ljava/util/Set;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin-gradle-plugin_common"})
    public static final class IsolatedClassLoaderCacheKey {
        @NotNull
        private final Set<File> classpath;

        public IsolatedClassLoaderCacheKey(@NotNull Set<? extends File> classpath2) {
            Intrinsics.checkNotNullParameter(classpath2, (String)"classpath");
            this.classpath = classpath2;
        }

        @NotNull
        public final Set<File> getClasspath() {
            return this.classpath;
        }

        @NotNull
        public final Set<File> component1() {
            return this.classpath;
        }

        @NotNull
        public final IsolatedClassLoaderCacheKey copy(@NotNull Set<? extends File> classpath2) {
            Intrinsics.checkNotNullParameter(classpath2, (String)"classpath");
            return new IsolatedClassLoaderCacheKey(classpath2);
        }

        public static /* synthetic */ IsolatedClassLoaderCacheKey copy$default(IsolatedClassLoaderCacheKey isolatedClassLoaderCacheKey, Set set2, int n, Object object) {
            if ((n & 1) != 0) {
                set2 = isolatedClassLoaderCacheKey.classpath;
            }
            return isolatedClassLoaderCacheKey.copy(set2);
        }

        @NotNull
        public String toString() {
            return "IsolatedClassLoaderCacheKey(classpath=" + this.classpath + ')';
        }

        public int hashCode() {
            return ((Object)this.classpath).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IsolatedClassLoaderCacheKey)) {
                return false;
            }
            IsolatedClassLoaderCacheKey isolatedClassLoaderCacheKey = (IsolatedClassLoaderCacheKey)other;
            return Intrinsics.areEqual(this.classpath, isolatedClassLoaderCacheKey.classpath);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bBE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u000eR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\r\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0014R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/KotlinNativeToolRunner$Settings;", "", "konanVersion", "", "konanHome", "konanPropertiesFile", "Ljava/io/File;", "useXcodeMessageStyle", "", "jvmArgs", "", "classpath", "Lorg/gradle/api/file/FileCollection;", "konanDataDir", "(Ljava/lang/String;Ljava/lang/String;Ljava/io/File;ZLjava/util/List;Lorg/gradle/api/file/FileCollection;Ljava/lang/String;)V", "getClasspath", "()Lorg/gradle/api/file/FileCollection;", "getJvmArgs", "()Ljava/util/List;", "getKonanDataDir", "()Ljava/lang/String;", "getKonanHome", "getKonanPropertiesFile", "()Ljava/io/File;", "getKonanVersion", "getUseXcodeMessageStyle", "()Z", "Companion", "kotlin-gradle-plugin_common"})
    public static final class Settings {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String konanVersion;
        @NotNull
        private final String konanHome;
        @NotNull
        private final File konanPropertiesFile;
        private final boolean useXcodeMessageStyle;
        @NotNull
        private final List<String> jvmArgs;
        @NotNull
        private final FileCollection classpath;
        @Nullable
        private final String konanDataDir;

        public Settings(@NotNull String konanVersion, @NotNull String konanHome2, @NotNull File konanPropertiesFile, boolean useXcodeMessageStyle, @NotNull List<String> jvmArgs2, @NotNull FileCollection classpath2, @Nullable String konanDataDir2) {
            Intrinsics.checkNotNullParameter((Object)konanVersion, (String)"konanVersion");
            Intrinsics.checkNotNullParameter((Object)konanHome2, (String)"konanHome");
            Intrinsics.checkNotNullParameter((Object)konanPropertiesFile, (String)"konanPropertiesFile");
            Intrinsics.checkNotNullParameter(jvmArgs2, (String)"jvmArgs");
            Intrinsics.checkNotNullParameter((Object)classpath2, (String)"classpath");
            this.konanVersion = konanVersion;
            this.konanHome = konanHome2;
            this.konanPropertiesFile = konanPropertiesFile;
            this.useXcodeMessageStyle = useXcodeMessageStyle;
            this.jvmArgs = jvmArgs2;
            this.classpath = classpath2;
            this.konanDataDir = konanDataDir2;
        }

        @NotNull
        public final String getKonanVersion() {
            return this.konanVersion;
        }

        @NotNull
        public final String getKonanHome() {
            return this.konanHome;
        }

        @NotNull
        public final File getKonanPropertiesFile() {
            return this.konanPropertiesFile;
        }

        public final boolean getUseXcodeMessageStyle() {
            return this.useXcodeMessageStyle;
        }

        @NotNull
        public final List<String> getJvmArgs() {
            return this.jvmArgs;
        }

        @NotNull
        public final FileCollection getClasspath() {
            return this.classpath;
        }

        @Nullable
        public final String getKonanDataDir() {
            return this.konanDataDir;
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/KotlinNativeToolRunner$Settings$Companion;", "", "()V", "of", "Lorg/jetbrains/kotlin/compilerRunner/KotlinNativeToolRunner$Settings;", "konanHome", "", "konanDataDir", "project", "Lorg/gradle/api/Project;", "kotlin-gradle-plugin_common"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Settings of(@NotNull String konanHome2, @Nullable String konanDataDir2, @NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)konanHome2, (String)"konanHome");
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                String string = NativeToolRunnersKt.getKonanVersion(project);
                File file = project.file((Object)(konanHome2 + "/konan/konan.properties"));
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.file(\"${konanHom\u2026/konan/konan.properties\")");
                boolean bl = XcodeMessageReportingKt.getUseXcodeMessageStyle(project);
                List list = NativeToolRunnersKt.access$getJvmArgs(project);
                Object[] objectArray = new Object[]{NativeToolRunnersKt.access$getKotlinNativeCompilerJar(project), konanHome2 + "/konan/lib/trove4j.jar"};
                ConfigurableFileCollection configurableFileCollection = project.files(objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"project.files(project.ko\u2026}/konan/lib/trove4j.jar\")");
                return new Settings(string, konanHome2, file, bl, list, (FileCollection)configurableFileCollection, konanDataDir2);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

