/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.native.tasks;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.targets.native.tasks.AbstractPodInstallTask;
import org.jetbrains.kotlin.gradle.targets.native.tasks.CocoapodsTask;
import org.jetbrains.kotlin.gradle.utils.CompatibilityKt;
import org.jetbrains.kotlin.gradle.utils.ProcessUtilsKt;

@DisableCachingByDefault(because="Abstract super-class, not to be instantiated directly")
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0017J\"\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H&J0\u0010\u0019\u001a\u0004\u0018\u00010\u00132\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u001c\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t8AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\t8AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\t8EX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/native/tasks/AbstractPodInstallTask;", "Lorg/jetbrains/kotlin/gradle/targets/native/tasks/CocoapodsTask;", "()V", "podfile", "Lorg/gradle/api/provider/Property;", "Ljava/io/File;", "getPodfile", "()Lorg/gradle/api/provider/Property;", "podsDir", "Lorg/gradle/api/provider/Provider;", "getPodsDir$kotlin_gradle_plugin_common", "()Lorg/gradle/api/provider/Provider;", "podsXcodeProjDirProvider", "getPodsXcodeProjDirProvider$kotlin_gradle_plugin_common", "workingDir", "getWorkingDir", "doPodInstall", "", "handleError", "", "retCode", "", "error", "process", "Ljava/lang/Process;", "sharedHandleError", "podInstallCommand", "", "kotlin-gradle-plugin_common"})
public abstract class AbstractPodInstallTask
extends CocoapodsTask {
    @NotNull
    private final Provider<File> workingDir;
    @NotNull
    private final Provider<File> podsDir;
    @NotNull
    private final Provider<File> podsXcodeProjDirProvider;

    public AbstractPodInstallTask() {
        CompatibilityKt.onlyIfCompat((Task)this, "Podfile location is set", (Spec<? super Task>)new Spec(){

            public final boolean isSatisfiedBy(Task it) {
                return this.getPodfile().isPresent();
            }
        });
        Provider provider = this.getPodfile().map((Transformer)workingDir.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"podfile.map { file: File\u2026ipped\" }.parentFile\n    }");
        this.workingDir = provider;
        Provider provider2 = this.workingDir.map((Transformer)podsDir.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"workingDir.map { it.resolve(\"Pods\") }");
        this.podsDir = provider2;
        Provider provider3 = this.podsDir.map((Transformer)podsXcodeProjDirProvider.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)provider3, (String)"podsDir.map { it.resolve(\"Pods.xcodeproj\") }");
        this.podsXcodeProjDirProvider = provider3;
    }

    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFile
    @NotNull
    public abstract Property<File> getPodfile();

    @Internal
    @NotNull
    protected final Provider<File> getWorkingDir() {
        return this.workingDir;
    }

    @OutputDirectory
    @NotNull
    public final Provider<File> getPodsDir$kotlin_gradle_plugin_common() {
        return this.podsDir;
    }

    @Internal
    @NotNull
    public final Provider<File> getPodsXcodeProjDirProvider$kotlin_gradle_plugin_common() {
        return this.podsXcodeProjDirProvider;
    }

    @TaskAction
    public void doPodInstall() {
        Object[] objectArray = new String[]{"env", "pod", "install"};
        List podInstallCommand = CollectionsKt.listOf((Object[])objectArray);
        ProcessUtilsKt.runCommand(podInstallCommand, this.getLogger(), (Function3<? super Integer, ? super String, ? super Process, String>)((Function3)new Function3<Integer, String, Process, String>(this, (List<String>)podInstallCommand){
            final /* synthetic */ AbstractPodInstallTask this$0;
            final /* synthetic */ List<String> $podInstallCommand;
            {
                this.this$0 = $receiver;
                this.$podInstallCommand = $podInstallCommand;
                super(3);
            }

            public final String invoke(int retCode, String output, Process process) {
                Intrinsics.checkNotNullParameter((Object)output, (String)"output");
                Intrinsics.checkNotNullParameter((Object)process, (String)"process");
                return AbstractPodInstallTask.access$sharedHandleError(this.this$0, this.$podInstallCommand, retCode, output, process);
            }
        }), (Function1<? super ProcessBuilder, Unit>)((Function1)new Function1<ProcessBuilder, Unit>(this){
            final /* synthetic */ AbstractPodInstallTask this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(ProcessBuilder $this$runCommand) {
                Intrinsics.checkNotNullParameter((Object)$this$runCommand, (String)"$this$runCommand");
                $this$runCommand.directory((File)this.this$0.getWorkingDir().get());
                $this$runCommand.environment().putIfAbsent("LC_ALL", "en_US.UTF-8");
            }
        }));
        File $this$doPodInstall_u24lambda_u241 = (File)this.podsXcodeProjDirProvider.get();
        boolean bl = false;
        if (!($this$doPodInstall_u24lambda_u241.exists() && $this$doPodInstall_u24lambda_u241.isDirectory())) {
            boolean bl2 = false;
            String string = "The directory 'Pods/Pods.xcodeproj' was not created as a result of the `pod install` call.";
            throw new IllegalStateException(string.toString());
        }
    }

    private final String sharedHandleError(List<String> podInstallCommand, int retCode, String error, Process process) {
        String string;
        if (StringsKt.contains$default((CharSequence)error, (CharSequence)"No such file or directory", (boolean)false, (int)2, null)) {
            String command = CollectionsKt.joinToString$default((Iterable)podInstallCommand, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
            string = StringsKt.trimMargin$default((String)(" \n               |'" + command + "' command failed with an exception:\n               | " + error + "\n               |        \n               |        Full command: " + command + "\n               |        \n               |        Possible reason: CocoaPods is not installed\n               |        Please check that CocoaPods v1.10 or above is installed.\n               |        \n               |        To check CocoaPods version type 'pod --version' in the terminal\n               |        \n               |        To install CocoaPods execute 'sudo gem install cocoapods'\n               |\n            "), null, (int)1, null);
        } else {
            string = this.handleError(retCode, error, process);
        }
        return string;
    }

    @Nullable
    public abstract String handleError(int var1, @NotNull String var2, @NotNull Process var3);

    public static final /* synthetic */ String access$sharedHandleError(AbstractPodInstallTask $this, List podInstallCommand, int retCode, String error, Process process) {
        return $this.sharedHandleError(podInstallCommand, retCode, error, process);
    }
}

