/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal.transforms;

import java.io.File;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.artifacts.transform.CacheableTransform;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.artifacts.transform.TransformParameters;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.buildtools.api.CompilationService;
import org.jetbrains.kotlin.buildtools.api.jvm.ClassSnapshotGranularity;
import org.jetbrains.kotlin.buildtools.api.jvm.ClasspathEntrySnapshot;
import org.jetbrains.kotlin.compilerRunner.btapi.SharedApiClassesClassLoaderProvider;
import org.jetbrains.kotlin.gradle.internal.ClassLoadersCachingBuildService;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.KotlinToolingDiagnostics;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.ToolingDiagnostic;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.TransformActionUsingKotlinToolingDiagnostics;

@CacheableTransform
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/transforms/BuildToolsApiClasspathEntrySnapshotTransform;", "Lorg/gradle/api/artifacts/transform/TransformAction;", "Lorg/jetbrains/kotlin/gradle/internal/transforms/BuildToolsApiClasspathEntrySnapshotTransform$Parameters;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/TransformActionUsingKotlinToolingDiagnostics;", "()V", "inputArtifact", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/FileSystemLocation;", "getInputArtifact", "()Lorg/gradle/api/provider/Provider;", "checkVersionConsistency", "", "getClassSnapshotGranularity", "Lorg/jetbrains/kotlin/buildtools/api/jvm/ClassSnapshotGranularity;", "classpathEntryDirOrJar", "Ljava/io/File;", "gradleUserHomeDir", "transform", "outputs", "Lorg/gradle/api/artifacts/transform/TransformOutputs;", "Parameters", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nBuildToolsApiClasspathEntrySnapshotTransform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildToolsApiClasspathEntrySnapshotTransform.kt\norg/jetbrains/kotlin/gradle/internal/transforms/BuildToolsApiClasspathEntrySnapshotTransform\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n1#2:105\n*E\n"})
public abstract class BuildToolsApiClasspathEntrySnapshotTransform
implements TransformAction<Parameters>,
TransformActionUsingKotlinToolingDiagnostics<Parameters> {
    @Classpath
    @InputArtifact
    @NotNull
    public abstract Provider<FileSystemLocation> getInputArtifact();

    private final void checkVersionConsistency() {
        Object object = ((Parameters)this.getParameters()).getSuppressVersionInconsistencyChecks$kotlin_gradle_plugin_common().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.suppressVersi\u2026InconsistencyChecks.get()");
        if (((Boolean)object).booleanValue()) {
            return;
        }
        String kgpVersion = (String)((Parameters)this.getParameters()).getKgpVersion$kotlin_gradle_plugin_common().get();
        Object object2 = ((Parameters)this.getParameters()).getBuildToolsImplVersion$kotlin_gradle_plugin_common().getOrNull();
        String it = (String)object2;
        boolean bl = false;
        String buildToolsImplVersion = (String)(!Intrinsics.areEqual((Object)it, (Object)"null") ? object2 : null);
        if (!Intrinsics.areEqual((Object)kgpVersion, (Object)buildToolsImplVersion)) {
            Intrinsics.checkNotNullExpressionValue((Object)kgpVersion, (String)"kgpVersion");
            this.reportDiagnostic(KotlinToolingDiagnostics.BuildToolsApiVersionInconsistency.INSTANCE.invoke(kgpVersion, buildToolsImplVersion));
        }
    }

    public void transform(@NotNull TransformOutputs outputs) {
        Intrinsics.checkNotNullParameter((Object)outputs, (String)"outputs");
        if (!((Boolean)((Parameters)this.getParameters()).getCompilationViaBuildToolsApi$kotlin_gradle_plugin_common().get()).booleanValue()) {
            this.checkVersionConsistency();
        }
        File classpathEntryInputDirOrJar = ((FileSystemLocation)this.getInputArtifact().get()).getAsFile();
        StringBuilder stringBuilder = new StringBuilder();
        String string = classpathEntryInputDirOrJar.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"classpathEntryInputDirOrJar.name");
        File snapshotOutputFile = outputs.file((Object)stringBuilder.append(StringsKt.replace$default((String)string, (char)'.', (char)'_', (boolean)false, (int)4, null)).append("-snapshot.bin").toString());
        Intrinsics.checkNotNullExpressionValue((Object)classpathEntryInputDirOrJar, (String)"classpathEntryInputDirOrJar");
        File file = ((Directory)((Parameters)this.getParameters()).getGradleUserHomeDir().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"parameters.gradleUserHomeDir.get().asFile");
        ClassSnapshotGranularity granularity = this.getClassSnapshotGranularity(classpathEntryInputDirOrJar, file);
        ClassLoader classLoader = ((ClassLoadersCachingBuildService)((Parameters)this.getParameters()).getClassLoadersCachingService$kotlin_gradle_plugin_common().get()).getClassLoader(CollectionsKt.toList((Iterable)((Iterable)((Parameters)this.getParameters()).getClasspath$kotlin_gradle_plugin_common())), SharedApiClassesClassLoaderProvider.INSTANCE);
        CompilationService compilationService = CompilationService.Companion.loadImplementation(classLoader);
        ClasspathEntrySnapshot snapshot = compilationService.calculateClasspathSnapshot(classpathEntryInputDirOrJar, granularity);
        Intrinsics.checkNotNullExpressionValue((Object)snapshotOutputFile, (String)"snapshotOutputFile");
        snapshot.saveSnapshot(snapshotOutputFile);
    }

    private final ClassSnapshotGranularity getClassSnapshotGranularity(File classpathEntryDirOrJar, File gradleUserHomeDir) {
        return FilesKt.startsWith((File)classpathEntryDirOrJar, (File)gradleUserHomeDir) || Intrinsics.areEqual((Object)classpathEntryDirOrJar.getName(), (Object)"android.jar") ? ClassSnapshotGranularity.CLASS_LEVEL : ClassSnapshotGranularity.CLASS_MEMBER_LEVEL;
    }

    @Override
    public void reportDiagnostic(@NotNull ToolingDiagnostic diagnostic) {
        TransformActionUsingKotlinToolingDiagnostics.DefaultImpls.reportDiagnostic(this, diagnostic);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00058aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\bR\u0014\u0010\f\u001a\u00020\r8aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00058aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\bR\u0014\u0010\u0013\u001a\u00020\u00148gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\bR\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u00058aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\b\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/transforms/BuildToolsApiClasspathEntrySnapshotTransform$Parameters;", "Lorg/gradle/api/artifacts/transform/TransformParameters;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/TransformActionUsingKotlinToolingDiagnostics$Parameters;", "()V", "buildToolsImplVersion", "Lorg/gradle/api/provider/Property;", "", "getBuildToolsImplVersion$kotlin_gradle_plugin_common", "()Lorg/gradle/api/provider/Property;", "classLoadersCachingService", "Lorg/jetbrains/kotlin/gradle/internal/ClassLoadersCachingBuildService;", "getClassLoadersCachingService$kotlin_gradle_plugin_common", "classpath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getClasspath$kotlin_gradle_plugin_common", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "compilationViaBuildToolsApi", "", "getCompilationViaBuildToolsApi$kotlin_gradle_plugin_common", "gradleUserHomeDir", "Lorg/gradle/api/file/DirectoryProperty;", "getGradleUserHomeDir", "()Lorg/gradle/api/file/DirectoryProperty;", "kgpVersion", "getKgpVersion$kotlin_gradle_plugin_common", "suppressVersionInconsistencyChecks", "getSuppressVersionInconsistencyChecks$kotlin_gradle_plugin_common", "kotlin-gradle-plugin_common"})
    public static abstract class Parameters
    implements TransformParameters,
    TransformActionUsingKotlinToolingDiagnostics.Parameters {
        @Internal
        @NotNull
        public abstract DirectoryProperty getGradleUserHomeDir();

        @Internal
        @NotNull
        public abstract Property<ClassLoadersCachingBuildService> getClassLoadersCachingService$kotlin_gradle_plugin_common();

        @Classpath
        @NotNull
        public abstract ConfigurableFileCollection getClasspath$kotlin_gradle_plugin_common();

        @Input
        @NotNull
        public abstract Property<Boolean> getCompilationViaBuildToolsApi$kotlin_gradle_plugin_common();

        @Internal
        @NotNull
        public abstract Property<String> getBuildToolsImplVersion$kotlin_gradle_plugin_common();

        @Internal
        @NotNull
        public abstract Property<String> getKgpVersion$kotlin_gradle_plugin_common();

        @Internal
        @NotNull
        public abstract Property<Boolean> getSuppressVersionInconsistencyChecks$kotlin_gradle_plugin_common();
    }
}

