/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.statistics;

import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.services.BuildServiceRegistration;
import org.gradle.api.services.BuildServiceSpec;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationCompletionListener;
import org.gradle.tooling.events.task.TaskFailureResult;
import org.gradle.tooling.events.task.TaskFinishEvent;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.logging.GradleLoggingUtilsKt;
import org.jetbrains.kotlin.gradle.plugin.BuildEventsListenerRegistryHolder;
import org.jetbrains.kotlin.gradle.plugin.StatisticsBuildFlowManager;
import org.jetbrains.kotlin.gradle.plugin.internal.ConfigurationCacheStartParameterAccessorKt;
import org.jetbrains.kotlin.gradle.plugin.internal.ProjectIsolationStartParameterAccessorKt;
import org.jetbrains.kotlin.gradle.plugin.statistics.KotlinBuildStatHandler;
import org.jetbrains.kotlin.gradle.plugin.statistics.KotlinBuildStatsService;
import org.jetbrains.kotlin.gradle.plugin.statistics.MetricContainer;
import org.jetbrains.kotlin.gradle.plugin.statistics.NonSynchronizedMetricsContainer;
import org.jetbrains.kotlin.gradle.plugin.statistics.UsesBuildFusService;
import org.jetbrains.kotlin.gradle.report.BuildReportType;
import org.jetbrains.kotlin.gradle.report.ConfigureReporingKt;
import org.jetbrains.kotlin.gradle.utils.SingleActionPerProject;
import org.jetbrains.kotlin.statistics.metrics.StatisticsValuesConsumer;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004:\u0002\u001f B\u0005\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u00020\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u001f\u0010\u0016\u001a\u00020\u00122\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u0019J!\u0010\u001a\u001a\u00020\u00122\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00120\u001cH\u0000\u00a2\u0006\u0002\b\u001eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010\b\u001a\u0004\u0018\u00010\t8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/statistics/BuildFusService;", "Lorg/gradle/api/services/BuildService;", "Lorg/jetbrains/kotlin/gradle/plugin/statistics/BuildFusService$Parameters;", "Ljava/lang/AutoCloseable;", "Lorg/gradle/tooling/events/OperationCompletionListener;", "()V", "buildFailed", "", "fusMetricsConsumer", "Lorg/jetbrains/kotlin/gradle/plugin/statistics/NonSynchronizedMetricsContainer;", "getFusMetricsConsumer$kotlin_gradle_plugin_common", "()Lorg/jetbrains/kotlin/gradle/plugin/statistics/NonSynchronizedMetricsContainer;", "fusMetricsConsumer$delegate", "Lkotlin/Lazy;", "log", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "close", "", "onFinish", "event", "Lorg/gradle/tooling/events/FinishEvent;", "recordBuildFinished", "action", "", "recordBuildFinished$kotlin_gradle_plugin_common", "reportFusMetrics", "reportAction", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/statistics/metrics/StatisticsValuesConsumer;", "reportFusMetrics$kotlin_gradle_plugin_common", "Companion", "Parameters", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nBuildFusService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildFusService.kt\norg/jetbrains/kotlin/gradle/plugin/statistics/BuildFusService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,187:1\n1#2:188\n1853#3,2:189\n*S KotlinDebug\n*F\n+ 1 BuildFusService.kt\norg/jetbrains/kotlin/gradle/plugin/statistics/BuildFusService\n*L\n158#1:189,2\n*E\n"})
public abstract class BuildFusService
implements BuildService<Parameters>,
AutoCloseable,
OperationCompletionListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean buildFailed;
    private final Logger log = Logging.getLogger(this.getClass());
    @NotNull
    private final Lazy fusMetricsConsumer$delegate;
    @NotNull
    private static final String serviceName = Reflection.getOrCreateKotlinClass(BuildFusService.class).getSimpleName() + '_' + BuildFusService.class.getClassLoader().hashCode();

    public BuildFusService() {
        Logger logger = this.log;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"log");
        GradleLoggingUtilsKt.kotlinDebug(logger, "Initialize " + this.getClass().getSimpleName());
        this.fusMetricsConsumer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<NonSynchronizedMetricsContainer>(this){
            final /* synthetic */ BuildFusService this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final NonSynchronizedMetricsContainer invoke() {
                Object object = ((Parameters)this.this$0.getParameters()).getFusStatisticsAvailable().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.fusStatisticsAvailable.get()");
                return (Boolean)object != false ? new NonSynchronizedMetricsContainer() : null;
            }
        }));
    }

    @Nullable
    public final NonSynchronizedMetricsContainer getFusMetricsConsumer$kotlin_gradle_plugin_common() {
        Lazy lazy = this.fusMetricsConsumer$delegate;
        return (NonSynchronizedMetricsContainer)lazy.getValue();
    }

    public final void reportFusMetrics$kotlin_gradle_plugin_common(@NotNull Function1<? super StatisticsValuesConsumer, Unit> reportAction) {
        block0: {
            Intrinsics.checkNotNullParameter(reportAction, (String)"reportAction");
            NonSynchronizedMetricsContainer nonSynchronizedMetricsContainer = this.getFusMetricsConsumer$kotlin_gradle_plugin_common();
            if (nonSynchronizedMetricsContainer == null) break block0;
            NonSynchronizedMetricsContainer it = nonSynchronizedMetricsContainer;
            boolean bl = false;
            reportAction.invoke((Object)it);
        }
    }

    public void onFinish(@Nullable FinishEvent event) {
        ((Parameters)this.getParameters()).getFusStatisticsAvailable().get();
        if (event instanceof TaskFinishEvent && ((TaskFinishEvent)event).getResult() instanceof TaskFailureResult) {
            this.buildFailed = true;
        }
    }

    @Override
    public void close() {
        Object object = ((Parameters)this.getParameters()).getFusStatisticsAvailable().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.fusStatisticsAvailable.get()");
        if (((Boolean)object).booleanValue()) {
            this.recordBuildFinished$kotlin_gradle_plugin_common(null, this.buildFailed);
        }
        KotlinBuildStatsService.Companion.closeServices();
        Logger logger = this.log;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"log");
        GradleLoggingUtilsKt.kotlinDebug(logger, "Close " + this.getClass().getSimpleName());
    }

    public final void recordBuildFinished$kotlin_gradle_plugin_common(@Nullable String action2, boolean buildFailed) {
        block1: {
            NonSynchronizedMetricsContainer nonSynchronizedMetricsContainer = this.getFusMetricsConsumer$kotlin_gradle_plugin_common();
            if (nonSynchronizedMetricsContainer == null) break block1;
            NonSynchronizedMetricsContainer metricsConsumer = nonSynchronizedMetricsContainer;
            boolean bl = false;
            KotlinBuildStatHandler.Companion.reportGlobalMetrics$kotlin_gradle_plugin_common(metricsConsumer);
            Object object = ((Parameters)this.getParameters()).getConfigurationMetrics().orElse((Object)CollectionsKt.emptyList()).get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.configuration\u2026orElse(emptyList()).get()");
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MetricContainer it = (MetricContainer)element$iv;
                boolean bl2 = false;
                it.addToConsumer(metricsConsumer);
            }
            KotlinBuildStatsService.Companion.applyIfInitialised((Function1<? super KotlinBuildStatsService, Unit>)((Function1)new Function1<KotlinBuildStatsService, Unit>(action2, buildFailed, metricsConsumer){
                final /* synthetic */ String $action;
                final /* synthetic */ boolean $buildFailed;
                final /* synthetic */ NonSynchronizedMetricsContainer $metricsConsumer;
                {
                    this.$action = $action;
                    this.$buildFailed = $buildFailed;
                    this.$metricsConsumer = $metricsConsumer;
                    super(1);
                }

                public final void invoke(KotlinBuildStatsService it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    it.recordBuildFinish(this.$action, this.$buildFailed, this.$metricsConsumer);
                }
            }));
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0004J\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/statistics/BuildFusService$Companion;", "", "()V", "serviceName", "", "fusStatisticsAvailable", "", "project", "Lorg/gradle/api/Project;", "registerIfAbsent", "Lorg/gradle/api/provider/Provider;", "Lorg/jetbrains/kotlin/gradle/plugin/statistics/BuildFusService;", "pluginVersion", "registerIfAbsentImpl", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean fusStatisticsAvailable(Project project) {
            return GradleVersion.current().getBaseVersion().compareTo(GradleVersion.version((String)"7.4")) < 0 ? !ConfigurationCacheStartParameterAccessorKt.isConfigurationCacheRequested(project) : (GradleVersion.current().getBaseVersion().compareTo(GradleVersion.version((String)"8.1")) < 0 ? true : !ConfigurationCacheStartParameterAccessorKt.isConfigurationCacheRequested(project));
        }

        @NotNull
        public final Provider<BuildFusService> registerIfAbsent(@NotNull Project project, @NotNull String pluginVersion) {
            Provider<BuildFusService> provider;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)pluginVersion, (String)"pluginVersion");
            Provider<BuildFusService> serviceProvider = provider = this.registerIfAbsentImpl(project, pluginVersion);
            boolean bl = false;
            String string = UsesBuildFusService.class.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UsesBuildFusService::class.java.name");
            SingleActionPerProject.INSTANCE.run(project, string, (Function0<Unit>)((Function0)new Function0<Unit>(project, serviceProvider){
                final /* synthetic */ Project $project;
                final /* synthetic */ Provider<BuildFusService> $serviceProvider;
                {
                    this.$project = $project;
                    this.$serviceProvider = $serviceProvider;
                    super(0);
                }

                public final void invoke() {
                    TaskContainer taskContainer = this.$project.getTasks();
                    Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
                    TaskCollection $this$withType$iv = (TaskCollection)taskContainer;
                    boolean $i$f$withType = false;
                    TaskCollection taskCollection = $this$withType$iv.withType(UsesBuildFusService.class);
                    Intrinsics.checkNotNullExpressionValue((Object)taskCollection, (String)"withType(S::class.java)");
                    taskCollection.configureEach(new Action(this.$serviceProvider){
                        final /* synthetic */ Provider<BuildFusService> $serviceProvider;
                        {
                            this.$serviceProvider = $serviceProvider;
                        }

                        public final void execute(UsesBuildFusService task2) {
                            task2.getBuildFusService().value(this.$serviceProvider).disallowChanges();
                            task2.usesService(this.$serviceProvider);
                        }
                    });
                }
            }));
            return provider;
        }

        private final Provider<BuildFusService> registerIfAbsentImpl(Project project, String pluginVersion) {
            Provider provider;
            boolean isProjectIsolationEnabled2 = ProjectIsolationStartParameterAccessorKt.isProjectIsolationEnabled(project);
            BuildServiceRegistration buildServiceRegistration = (BuildServiceRegistration)project.getGradle().getSharedServices().getRegistrations().findByName(serviceName);
            if (buildServiceRegistration != null) {
                Provider provider2;
                BuildServiceRegistration it = buildServiceRegistration;
                boolean bl = false;
                Provider provider3 = it.getService();
                Intrinsics.checkNotNull((Object)provider3, (String)"null cannot be cast to non-null type org.gradle.api.provider.Provider<org.jetbrains.kotlin.gradle.plugin.statistics.BuildFusService>");
                Provider it2 = provider2 = provider3;
                boolean bl2 = false;
                ((Parameters)((BuildFusService)it2.get()).getParameters()).getConfigurationMetrics().add(project.provider(new Callable(project, isProjectIsolationEnabled2){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ boolean $isProjectIsolationEnabled;
                    {
                        this.$project = $project;
                        this.$isProjectIsolationEnabled = $isProjectIsolationEnabled;
                    }

                    public final MetricContainer call() {
                        return KotlinBuildStatHandler.Companion.collectProjectConfigurationTimeMetrics$kotlin_gradle_plugin_common(this.$project, this.$isProjectIsolationEnabled);
                    }
                }));
                return provider2;
            }
            KotlinBuildStatsService.Companion.getOrCreateInstance$kotlin_gradle_plugin_common(project);
            boolean fusStatisticsAvailable = this.fusStatisticsAvailable(project);
            List<BuildReportType> buildReportOutputs = ConfigureReporingKt.reportingSettings(project).getBuildReportOutputs();
            Provider buildService = provider = project.getGradle().getSharedServices().registerIfAbsent(serviceName, BuildFusService.class, new Action(fusStatisticsAvailable, project, isProjectIsolationEnabled2, buildReportOutputs, pluginVersion){
                final /* synthetic */ boolean $fusStatisticsAvailable;
                final /* synthetic */ Project $project;
                final /* synthetic */ boolean $isProjectIsolationEnabled;
                final /* synthetic */ List<BuildReportType> $buildReportOutputs;
                final /* synthetic */ String $pluginVersion;
                {
                    this.$fusStatisticsAvailable = $fusStatisticsAvailable;
                    this.$project = $project;
                    this.$isProjectIsolationEnabled = $isProjectIsolationEnabled;
                    this.$buildReportOutputs = $buildReportOutputs;
                    this.$pluginVersion = $pluginVersion;
                }

                public final void execute(BuildServiceSpec<Parameters> spec) {
                    if (this.$fusStatisticsAvailable) {
                        KotlinBuildStatsService.Companion.applyIfInitialised((Function1<? super KotlinBuildStatsService, Unit>)((Function1)new Function1<KotlinBuildStatsService, Unit>(this.$project){
                            final /* synthetic */ Project $project;
                            {
                                this.$project = $project;
                                super(1);
                            }

                            public final void invoke(KotlinBuildStatsService it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                Gradle gradle = this.$project.getGradle();
                                Intrinsics.checkNotNullExpressionValue((Object)gradle, (String)"project.gradle");
                                it.recordProjectsEvaluated(gradle);
                            }
                        }));
                    }
                    ((Parameters)spec.getParameters()).getConfigurationMetrics().add(this.$project.provider(new Callable(this.$project, this.$isProjectIsolationEnabled, this.$buildReportOutputs, this.$pluginVersion){
                        final /* synthetic */ Project $project;
                        final /* synthetic */ boolean $isProjectIsolationEnabled;
                        final /* synthetic */ List<BuildReportType> $buildReportOutputs;
                        final /* synthetic */ String $pluginVersion;
                        {
                            this.$project = $project;
                            this.$isProjectIsolationEnabled = $isProjectIsolationEnabled;
                            this.$buildReportOutputs = $buildReportOutputs;
                            this.$pluginVersion = $pluginVersion;
                        }

                        public final MetricContainer call() {
                            return KotlinBuildStatHandler.Companion.collectGeneralConfigurationTimeMetrics$kotlin_gradle_plugin_common(this.$project, this.$isProjectIsolationEnabled, this.$buildReportOutputs, this.$pluginVersion);
                        }
                    }));
                    ((Parameters)spec.getParameters()).getConfigurationMetrics().add(this.$project.provider(new Callable(this.$project, this.$isProjectIsolationEnabled){
                        final /* synthetic */ Project $project;
                        final /* synthetic */ boolean $isProjectIsolationEnabled;
                        {
                            this.$project = $project;
                            this.$isProjectIsolationEnabled = $isProjectIsolationEnabled;
                        }

                        public final MetricContainer call() {
                            return KotlinBuildStatHandler.Companion.collectProjectConfigurationTimeMetrics$kotlin_gradle_plugin_common(this.$project, this.$isProjectIsolationEnabled);
                        }
                    }));
                    ((Parameters)spec.getParameters()).getFusStatisticsAvailable().set((Object)this.$fusStatisticsAvailable);
                }
            });
            boolean bl = false;
            if (fusStatisticsAvailable) {
                if (GradleVersion.current().getBaseVersion().compareTo(GradleVersion.version((String)"8.1")) < 0) {
                    BuildEventsListenerRegistryHolder.Companion.getInstance(project).getListenerRegistry().onTaskCompletion(buildService);
                } else {
                    StatisticsBuildFlowManager.Companion.getInstance(project).subscribeForBuildResult();
                }
            }
            Provider provider4 = provider;
            Intrinsics.checkNotNullExpressionValue((Object)provider4, (String)"project: Project,\n      \u2026          }\n            }");
            return provider4;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/statistics/BuildFusService$Parameters;", "Lorg/gradle/api/services/BuildServiceParameters;", "configurationMetrics", "Lorg/gradle/api/provider/ListProperty;", "Lorg/jetbrains/kotlin/gradle/plugin/statistics/MetricContainer;", "getConfigurationMetrics", "()Lorg/gradle/api/provider/ListProperty;", "fusStatisticsAvailable", "Lorg/gradle/api/provider/Property;", "", "getFusStatisticsAvailable", "()Lorg/gradle/api/provider/Property;", "kotlin-gradle-plugin_common"})
    public static interface Parameters
    extends BuildServiceParameters {
        @NotNull
        public ListProperty<MetricContainer> getConfigurationMetrics();

        @NotNull
        public Property<Boolean> getFusStatisticsAvailable();
    }
}

