/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.cache;

import java.util.concurrent.ExecutionException;
import org.jetbrains.kotlin.com.google.common.annotations.GwtIncompatible;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;
import org.jetbrains.kotlin.com.google.common.cache.ElementTypesAreNonnullByDefault;
import org.jetbrains.kotlin.com.google.common.cache.ForwardingCache;
import org.jetbrains.kotlin.com.google.common.cache.LoadingCache;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableMap;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public abstract class ForwardingLoadingCache<K, V>
extends ForwardingCache<K, V>
implements LoadingCache<K, V> {
    protected ForwardingLoadingCache() {
    }

    @Override
    protected abstract LoadingCache<K, V> delegate();

    @Override
    public V get(K key) throws ExecutionException {
        return this.delegate().get(key);
    }

    @Override
    public V getUnchecked(K key) {
        return this.delegate().getUnchecked(key);
    }

    @Override
    public ImmutableMap<K, V> getAll(Iterable<? extends K> keys) throws ExecutionException {
        return this.delegate().getAll(keys);
    }

    @Override
    public V apply(K key) {
        return this.delegate().apply(key);
    }

    @Override
    public void refresh(K key) {
        this.delegate().refresh(key);
    }

    public static abstract class SimpleForwardingLoadingCache<K, V>
    extends ForwardingLoadingCache<K, V> {
        private final LoadingCache<K, V> delegate;

        protected SimpleForwardingLoadingCache(LoadingCache<K, V> delegate2) {
            this.delegate = Preconditions.checkNotNull(delegate2);
        }

        @Override
        protected final LoadingCache<K, V> delegate() {
            return this.delegate;
        }
    }
}

