/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.js.npm;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.KotlinTarget;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinCompilationsKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinJsCompilationKt;
import org.jetbrains.kotlin.gradle.targets.js.dsl.KotlinJsTargetDsl;
import org.jetbrains.kotlin.gradle.targets.js.ir.KotlinJsIrCompilation;
import org.jetbrains.kotlin.gradle.targets.js.nodejs.NodeJsEnv;
import org.jetbrains.kotlin.gradle.targets.js.nodejs.NodeJsRootExtension;
import org.jetbrains.kotlin.gradle.targets.js.nodejs.NodeJsRootPlugin;
import org.jetbrains.kotlin.gradle.targets.js.npm.NpmProject;
import org.jetbrains.kotlin.gradle.targets.js.npm.NpmProjectModules;
import org.jetbrains.kotlin.gradle.targets.js.npm.tasks.KotlinPackageJsonTask;
import org.jetbrains.kotlin.gradle.utils.FileUtilsKt;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\b\u0016\u0018\u0000 N2\u00020\u0001:\u0001NB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010?\u001a\u00020\bH\u0002J\u000e\u0010@\u001a\u00020\b2\u0006\u0010A\u001a\u00020\bJ\u0017\u0010B\u001a\u0004\u0018\u00010C2\u0006\u0010\u001b\u001a\u00020\bH\u0000\u00a2\u0006\u0002\bDJ\b\u0010E\u001a\u00020\bH\u0016J4\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020\b2\u000e\b\u0002\u0010K\u001a\b\u0012\u0004\u0012\u00020\b0L2\f\u0010M\u001a\b\u0012\u0004\u0012\u00020\b0LR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u001b\u0010\u0015\u001a\u00020\u00168@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018R\u001b\u0010\u001b\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001a\u001a\u0004\b\u001c\u0010\nR\u001b\u0010\u001e\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\u001a\u001a\u0004\b\u001f\u0010\nR\u001b\u0010!\u001a\u00020\"8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010\u001a\u001a\u0004\b#\u0010$R5\u0010&\u001a&\u0012\f\u0012\n '*\u0004\u0018\u00010\r0\r '*\u0012\u0012\f\u0012\n '*\u0004\u0018\u00010\r0\r\u0018\u00010\f0\f8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u000fR\u0017\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\f8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u000fR\u0011\u0010,\u001a\u00020-8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u0011\u00100\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b1\u0010\nR#\u00102\u001a\n '*\u0004\u0018\u00010\b0\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b4\u0010\u001a\u001a\u0004\b3\u0010\nR\u0011\u00105\u001a\u0002068F\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u0011\u00109\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b:\u0010\nR\u0011\u0010;\u001a\u00020<8F\u00a2\u0006\u0006\u001a\u0004\b=\u0010>\u00a8\u0006O"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/npm/NpmProject;", "Ljava/io/Serializable;", "compilation", "Lorg/jetbrains/kotlin/gradle/targets/js/ir/KotlinJsIrCompilation;", "(Lorg/jetbrains/kotlin/gradle/targets/js/ir/KotlinJsIrCompilation;)V", "getCompilation", "()Lorg/jetbrains/kotlin/gradle/targets/js/ir/KotlinJsIrCompilation;", "compilationName", "", "getCompilationName", "()Ljava/lang/String;", "dir", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "getDir", "()Lorg/gradle/api/provider/Provider;", "dist", "getDist", "extension", "main", "getMain", "modules", "Lorg/jetbrains/kotlin/gradle/targets/js/npm/NpmProjectModules;", "getModules$kotlin_gradle_plugin_common", "()Lorg/jetbrains/kotlin/gradle/targets/js/npm/NpmProjectModules;", "modules$delegate", "Lkotlin/Lazy;", "name", "getName", "name$delegate", "nodeExecutable", "getNodeExecutable", "nodeExecutable$delegate", "nodeJs", "Lorg/jetbrains/kotlin/gradle/targets/js/nodejs/NodeJsRootExtension;", "getNodeJs", "()Lorg/jetbrains/kotlin/gradle/targets/js/nodejs/NodeJsRootExtension;", "nodeJs$delegate", "nodeModulesDir", "kotlin.jvm.PlatformType", "getNodeModulesDir", "packageJsonFile", "Lorg/gradle/api/file/RegularFile;", "getPackageJsonFile", "packageJsonTask", "Lorg/jetbrains/kotlin/gradle/targets/js/npm/tasks/KotlinPackageJsonTask;", "getPackageJsonTask", "()Lorg/jetbrains/kotlin/gradle/targets/js/npm/tasks/KotlinPackageJsonTask;", "packageJsonTaskName", "getPackageJsonTaskName", "packageJsonTaskPath", "getPackageJsonTaskPath", "packageJsonTaskPath$delegate", "project", "Lorg/gradle/api/Project;", "getProject", "()Lorg/gradle/api/Project;", "publicPackageJsonTaskName", "getPublicPackageJsonTaskName", "target", "Lorg/jetbrains/kotlin/gradle/targets/js/dsl/KotlinJsTargetDsl;", "getTarget", "()Lorg/jetbrains/kotlin/gradle/targets/js/dsl/KotlinJsTargetDsl;", "buildNpmProjectName", "require", "request", "resolve", "Ljava/io/File;", "resolve$kotlin_gradle_plugin_common", "toString", "useTool", "", "exec", "Lorg/gradle/process/ExecSpec;", "tool", "nodeArgs", "", "args", "Companion", "kotlin-gradle-plugin_common"})
public class NpmProject
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final transient KotlinJsIrCompilation compilation;
    @NotNull
    private final String compilationName;
    @NotNull
    private final Provider<String> extension;
    @NotNull
    private final Lazy name$delegate;
    @NotNull
    private final transient Lazy nodeJs$delegate;
    @NotNull
    private final Provider<Directory> dir;
    @NotNull
    private final Lazy packageJsonTaskPath$delegate;
    @NotNull
    private final Provider<String> main;
    @NotNull
    private final Lazy modules$delegate;
    @NotNull
    private final Lazy nodeExecutable$delegate;
    @NotNull
    public static final String PACKAGE_JSON = "package.json";
    @NotNull
    public static final String NODE_MODULES = "node_modules";
    @NotNull
    public static final String DIST_FOLDER = "kotlin";
    @NotNull
    private static final Regex DECAMELIZE_REGEX = new Regex("([A-Z])");

    public NpmProject(@NotNull KotlinJsIrCompilation compilation2) {
        Intrinsics.checkNotNullParameter((Object)compilation2, (String)"compilation");
        this.compilation = compilation2;
        this.compilationName = this.compilation.getDisambiguatedName();
        this.extension = KotlinJsCompilationKt.getFileExtension(this.compilation);
        this.name$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ NpmProject this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final String invoke() {
                return NpmProject.access$buildNpmProjectName(this.this$0);
            }
        }));
        this.nodeJs$delegate = LazyKt.lazy((Function0)((Function0)new Function0<NodeJsRootExtension>(this){
            final /* synthetic */ NpmProject this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final NodeJsRootExtension invoke() {
                Project project = this.this$0.getProject().getRootProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project.rootProject");
                return NodeJsRootPlugin.Companion.getKotlinNodeJsExtension(project);
            }
        }));
        Provider provider = this.getNodeJs().getProjectPackagesDirectory().map(new Transformer(this){
            final /* synthetic */ NpmProject this$0;
            {
                this.this$0 = $receiver;
            }

            public final Directory transform(Directory it) {
                return it.dir(this.this$0.getName());
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"nodeJs.projectPackagesDi\u2026tory.map { it.dir(name) }");
        this.dir = provider;
        this.packageJsonTaskPath$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ NpmProject this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final String invoke() {
                return this.this$0.getPackageJsonTask().getPath();
            }
        }));
        Provider provider2 = this.extension.map(new Transformer(this){
            final /* synthetic */ NpmProject this$0;
            {
                this.this$0 = $receiver;
            }

            public final String transform(String it) {
                return "kotlin/" + this.this$0.getName() + '.' + it;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"extension.map { \"${DIST_FOLDER}/$name.$it\" }");
        this.main = provider2;
        this.modules$delegate = LazyKt.lazy((Function0)((Function0)new Function0<NpmProjectModules>(this){
            final /* synthetic */ NpmProject this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final NpmProjectModules invoke() {
                return new NpmProjectModules(FileUtilsKt.getDirectoryAsFile(this.this$0.getDir()), null, null, null, 14, null);
            }
        }));
        this.nodeExecutable$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ NpmProject this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final String invoke() {
                return ((NodeJsEnv)this.this$0.getNodeJs().requireConfigured()).getNodeExecutable();
            }
        }));
    }

    @NotNull
    public final KotlinJsIrCompilation getCompilation() {
        return this.compilation;
    }

    @NotNull
    public final String getCompilationName() {
        return this.compilationName;
    }

    @NotNull
    public final String getName() {
        Lazy lazy = this.name$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final NodeJsRootExtension getNodeJs() {
        Lazy lazy = this.nodeJs$delegate;
        return (NodeJsRootExtension)lazy.getValue();
    }

    @NotNull
    public final Provider<Directory> getDir() {
        return this.dir;
    }

    @NotNull
    public final KotlinJsTargetDsl getTarget() {
        KotlinTarget kotlinTarget = this.compilation.getTarget();
        Intrinsics.checkNotNull((Object)kotlinTarget, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.gradle.targets.js.dsl.KotlinJsTargetDsl");
        return (KotlinJsTargetDsl)kotlinTarget;
    }

    @NotNull
    public final Project getProject() {
        return this.getTarget().getProject();
    }

    public final Provider<Directory> getNodeModulesDir() {
        return this.dir.map((Transformer)nodeModulesDir.1.INSTANCE);
    }

    @NotNull
    public final Provider<RegularFile> getPackageJsonFile() {
        Provider provider = this.dir.map((Transformer)packageJsonFile.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"dir.map { it.file(PACKAGE_JSON) }");
        return provider;
    }

    @NotNull
    public final String getPackageJsonTaskName() {
        return KotlinCompilationsKt.disambiguateName(this.compilation, "packageJson");
    }

    @NotNull
    public final KotlinPackageJsonTask getPackageJsonTask() {
        Task task2 = this.getProject().getTasks().getByName(this.getPackageJsonTaskName());
        Intrinsics.checkNotNull((Object)task2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.gradle.targets.js.npm.tasks.KotlinPackageJsonTask");
        return (KotlinPackageJsonTask)task2;
    }

    public final String getPackageJsonTaskPath() {
        Lazy lazy = this.packageJsonTaskPath$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final Provider<Directory> getDist() {
        Provider provider = this.dir.map((Transformer)dist.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"dir.map { it.dir(DIST_FOLDER) }");
        return provider;
    }

    @NotNull
    public final Provider<String> getMain() {
        return this.main;
    }

    @NotNull
    public final String getPublicPackageJsonTaskName() {
        return KotlinCompilationsKt.disambiguateName(this.compilation, "publicPackageJson");
    }

    @NotNull
    public final NpmProjectModules getModules$kotlin_gradle_plugin_common() {
        Lazy lazy = this.modules$delegate;
        return (NpmProjectModules)lazy.getValue();
    }

    private final String getNodeExecutable() {
        Lazy lazy = this.nodeExecutable$delegate;
        return (String)lazy.getValue();
    }

    public final void useTool(@NotNull ExecSpec exec2, @NotNull String tool, @NotNull List<String> nodeArgs, @NotNull List<String> args2) {
        Intrinsics.checkNotNullParameter((Object)exec2, (String)"exec");
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        Intrinsics.checkNotNullParameter(nodeArgs, (String)"nodeArgs");
        Intrinsics.checkNotNullParameter(args2, (String)"args");
        exec2.workingDir(this.dir);
        exec2.executable((Object)this.getNodeExecutable());
        exec2.setArgs(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)nodeArgs, (Object)this.require(tool)), (Iterable)args2));
    }

    public static /* synthetic */ void useTool$default(NpmProject npmProject, ExecSpec execSpec, String string, List list, List list2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: useTool");
        }
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        npmProject.useTool(execSpec, string, list, list2);
    }

    @NotNull
    public final String require(@NotNull String request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return this.getModules$kotlin_gradle_plugin_common().require(request);
    }

    @Nullable
    public final File resolve$kotlin_gradle_plugin_common(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return NpmProjectModules.resolve$kotlin_gradle_plugin_common$default(this.getModules$kotlin_gradle_plugin_common(), name2, null, 2, null);
    }

    private final String buildNpmProjectName() {
        String string;
        Object[] objectArray;
        String compilationName;
        String string2 = this.compilation.getOutputModuleName();
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            return it;
        }
        Project project = this.getTarget().getProject();
        String moduleName = this.getTarget().getModuleName();
        String string3 = compilationName = !Intrinsics.areEqual((Object)this.compilation.getName(), (Object)"main") ? this.compilation.getName() : null;
        if (moduleName != null) {
            Object[] bl = new String[]{moduleName, compilationName};
            return SequencesKt.joinToString$default((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.sequenceOf((Object[])bl)), (CharSequence)"-", null, null, (int)0, null, null, (int)62, null);
        }
        String rootProjectName = project.getRootProject().getName();
        String localName = !Intrinsics.areEqual((Object)project, (Object)project.getRootProject()) ? StringsKt.replace$default((String)(rootProjectName + project.getPath()), (String)":", (String)"-", (boolean)false, (int)4, null) : rootProjectName;
        if (((CharSequence)this.getTarget().getName()).length() > 0 && !Intrinsics.areEqual((Object)CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly((String)this.getTarget().getName()), (Object)"js")) {
            objectArray = this.getTarget().getName();
            Regex regex = DECAMELIZE_REGEX;
            Function1 function1 = buildNpmProjectName.targetName.1.INSTANCE;
            string = CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly((String)regex.replace((CharSequence)objectArray, function1));
        } else {
            string = null;
        }
        String targetName2 = string;
        objectArray = new String[]{localName, targetName2, compilationName};
        return SequencesKt.joinToString$default((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.sequenceOf((Object[])objectArray)), (CharSequence)"-", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public String toString() {
        return "NpmProject(" + this.getName() + ')';
    }

    public static final /* synthetic */ String access$buildNpmProjectName(NpmProject $this) {
        return $this.buildNpmProjectName();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/npm/NpmProject$Companion;", "", "()V", "DECAMELIZE_REGEX", "Lkotlin/text/Regex;", "DIST_FOLDER", "", "NODE_MODULES", "PACKAGE_JSON", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

