/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.collect;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.ObjIntConsumer;
import javax.annotation.CheckForNull;
import org.jetbrains.kotlin.com.google.common.annotations.Beta;
import org.jetbrains.kotlin.com.google.common.annotations.GwtCompatible;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;
import org.jetbrains.kotlin.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.jetbrains.kotlin.com.google.common.collect.Multisets;
import org.jetbrains.kotlin.com.google.common.collect.ParametricNullness;
import org.jetbrains.kotlin.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.jetbrains.kotlin.com.google.errorprone.annotations.CompatibleWith;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public interface Multiset<E>
extends Collection<E> {
    @Override
    public int size();

    public int count(@CheckForNull @CompatibleWith(value="E") Object var1);

    @CanIgnoreReturnValue
    public int add(@ParametricNullness E var1, int var2);

    @Override
    @CanIgnoreReturnValue
    public boolean add(@ParametricNullness E var1);

    @CanIgnoreReturnValue
    public int remove(@CheckForNull @CompatibleWith(value="E") Object var1, int var2);

    @Override
    @CanIgnoreReturnValue
    public boolean remove(@CheckForNull Object var1);

    @CanIgnoreReturnValue
    public int setCount(@ParametricNullness E var1, int var2);

    @CanIgnoreReturnValue
    public boolean setCount(@ParametricNullness E var1, int var2, int var3);

    public Set<E> elementSet();

    public Set<Entry<E>> entrySet();

    @Beta
    default public void forEachEntry(ObjIntConsumer<? super E> action2) {
        Preconditions.checkNotNull(action2);
        this.entrySet().forEach((? super T entry2) -> action2.accept((Object)entry2.getElement(), entry2.getCount()));
    }

    @Override
    public boolean equals(@CheckForNull Object var1);

    @Override
    public int hashCode();

    public String toString();

    @Override
    public Iterator<E> iterator();

    @Override
    public boolean contains(@CheckForNull Object var1);

    @Override
    public boolean containsAll(Collection<?> var1);

    @Override
    @CanIgnoreReturnValue
    public boolean removeAll(Collection<?> var1);

    @Override
    @CanIgnoreReturnValue
    public boolean retainAll(Collection<?> var1);

    @Override
    default public void forEach(Consumer<? super E> action2) {
        Preconditions.checkNotNull(action2);
        this.entrySet().forEach((? super T entry2) -> {
            Object elem = entry2.getElement();
            int count = entry2.getCount();
            for (int i2 = 0; i2 < count; ++i2) {
                action2.accept((Object)elem);
            }
        });
    }

    @Override
    default public Spliterator<E> spliterator() {
        return Multisets.spliteratorImpl(this);
    }

    public static interface Entry<E> {
        @ParametricNullness
        public E getElement();

        public int getCount();

        public boolean equals(@CheckForNull Object var1);

        public int hashCode();

        public String toString();
    }
}

