/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.native.toolchain;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.ArchiveOperations;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinNativeTargetPresetKt;
import org.jetbrains.kotlin.gradle.targets.native.internal.NativeDistributionCommonizerLock;
import org.jetbrains.kotlin.gradle.targets.native.internal.NativeDistributionType;
import org.jetbrains.kotlin.gradle.targets.native.internal.NativeDistributionTypeProvider;
import org.jetbrains.kotlin.gradle.targets.native.internal.PlatformLibrariesGenerator;
import org.jetbrains.kotlin.gradle.targets.native.toolchain.KotlinNativeBundleBuildService;
import org.jetbrains.kotlin.gradle.targets.native.toolchain.UsesKotlinNativeBundleBuildService;
import org.jetbrains.kotlin.gradle.utils.SingleActionPerProject;
import org.jetbrains.kotlin.konan.properties.KonanPropertiesLoader;
import org.jetbrains.kotlin.konan.target.Configurables;
import org.jetbrains.kotlin.konan.target.ConfigurablesImplKt;
import org.jetbrains.kotlin.konan.target.Distribution;
import org.jetbrains.kotlin.konan.target.KonanTarget;
import org.jetbrains.kotlin.konan.util.ArchiveExtractor;
import org.jetbrains.kotlin.konan.util.ArchiveType;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.tar.TarArchiveInputStream;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b \u0018\u0000 &2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002&'B\u0005\u00a2\u0006\u0002\u0010\u0003J;\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u0018JC\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\t2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000fH\u0000\u00a2\u0006\u0002\b!J\u0018\u0010\"\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010#\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u001eH\u0002J\u001a\u0010%\u001a\u00020\u001a*\u00020\u001c2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000fH\u0002R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/gradle/targets/native/toolchain/KotlinNativeBundleBuildService;", "Lorg/gradle/api/services/BuildService;", "Lorg/gradle/api/services/BuildServiceParameters$None;", "()V", "archiveOperations", "Lorg/gradle/api/file/ArchiveOperations;", "getArchiveOperations", "()Lorg/gradle/api/file/ArchiveOperations;", "canBeReinstalled", "", "fso", "Lorg/gradle/api/file/FileSystemOperations;", "getFso", "()Lorg/gradle/api/file/FileSystemOperations;", "downloadNativeDependencies", "", "", "bundleDir", "Ljava/io/File;", "konanDataDir", "konanTargets", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "logger", "Lorg/gradle/api/logging/Logger;", "downloadNativeDependencies$kotlin_gradle_plugin_common", "prepareKotlinNativeBundle", "", "project", "Lorg/gradle/api/Project;", "kotlinNativeBundleConfiguration", "Lorg/gradle/api/file/ConfigurableFileCollection;", "kotlinNativeVersion", "reinstallFlag", "prepareKotlinNativeBundle$kotlin_gradle_plugin_common", "removeBundleIfNeeded", "resolveKotlinNativeConfiguration", "kotlinNativeCompilerConfiguration", "setupKotlinNativePlatformLibraries", "Companion", "DependencyExtractor", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nKotlinNativeBundleBuildService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinNativeBundleBuildService.kt\norg/jetbrains/kotlin/gradle/targets/native/toolchain/KotlinNativeBundleBuildService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,247:1\n1863#2,2:248\n1863#2,2:250\n*S KotlinDebug\n*F\n+ 1 KotlinNativeBundleBuildService.kt\norg/jetbrains/kotlin/gradle/targets/native/toolchain/KotlinNativeBundleBuildService\n*L\n131#1:248,2\n180#1:250,2\n*E\n"})
public abstract class KotlinNativeBundleBuildService
implements BuildService<BuildServiceParameters.None> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean canBeReinstalled = true;

    @Inject
    @NotNull
    public abstract FileSystemOperations getFso();

    @Inject
    @NotNull
    public abstract ArchiveOperations getArchiveOperations();

    public final void prepareKotlinNativeBundle$kotlin_gradle_plugin_common(@NotNull Project project, @NotNull ConfigurableFileCollection kotlinNativeBundleConfiguration, @NotNull String kotlinNativeVersion, @NotNull File bundleDir, boolean reinstallFlag, @NotNull Set<? extends KonanTarget> konanTargets) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)kotlinNativeBundleConfiguration, (String)"kotlinNativeBundleConfiguration");
        Intrinsics.checkNotNullParameter((Object)kotlinNativeVersion, (String)"kotlinNativeVersion");
        Intrinsics.checkNotNullParameter((Object)bundleDir, (String)"bundleDir");
        Intrinsics.checkNotNullParameter(konanTargets, (String)"konanTargets");
        NativeDistributionCommonizerLock lock2 = new NativeDistributionCommonizerLock(bundleDir, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(1);
            }

            public final void invoke(String message2) {
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                this.$project.getLogger().info("Kotlin Native Bundle: " + message2);
            }
        }));
        lock2.withLock((Function1)new Function1<File, Unit>(this, reinstallFlag, bundleDir, kotlinNativeVersion, kotlinNativeBundleConfiguration, project){
            final /* synthetic */ KotlinNativeBundleBuildService this$0;
            final /* synthetic */ boolean $reinstallFlag;
            final /* synthetic */ File $bundleDir;
            final /* synthetic */ String $kotlinNativeVersion;
            final /* synthetic */ ConfigurableFileCollection $kotlinNativeBundleConfiguration;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$reinstallFlag = $reinstallFlag;
                this.$bundleDir = $bundleDir;
                this.$kotlinNativeVersion = $kotlinNativeVersion;
                this.$kotlinNativeBundleConfiguration = $kotlinNativeBundleConfiguration;
                this.$project = $project;
                super(1);
            }

            public final void invoke(File it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                KotlinNativeBundleBuildService.access$removeBundleIfNeeded(this.this$0, this.$reinstallFlag, this.$bundleDir);
                if (!FilesKt.resolve((File)this.$bundleDir, (String)"konan").exists()) {
                    File gradleCachesKotlinNativeDir = KotlinNativeBundleBuildService.access$resolveKotlinNativeConfiguration(this.this$0, this.$kotlinNativeVersion, this.$kotlinNativeBundleConfiguration);
                    this.$project.getLogger().info("Moving Kotlin/Native bundle from tmp directory " + gradleCachesKotlinNativeDir + " to " + this.$bundleDir.getAbsolutePath());
                    this.this$0.getFso().copy(new Action(gradleCachesKotlinNativeDir, this.$bundleDir){
                        final /* synthetic */ File $gradleCachesKotlinNativeDir;
                        final /* synthetic */ File $bundleDir;
                        {
                            this.$gradleCachesKotlinNativeDir = $gradleCachesKotlinNativeDir;
                            this.$bundleDir = $bundleDir;
                        }

                        public final void execute(CopySpec it) {
                            Object[] objectArray = new Object[]{this.$gradleCachesKotlinNativeDir};
                            it.from(objectArray);
                            it.into((Object)this.$bundleDir);
                        }
                    });
                    this.$project.getLogger().info("Moved Kotlin/Native bundle from " + gradleCachesKotlinNativeDir + " to " + this.$bundleDir.getAbsolutePath());
                }
            }
        });
        this.setupKotlinNativePlatformLibraries(project, konanTargets);
    }

    @NotNull
    public final Set<String> downloadNativeDependencies$kotlin_gradle_plugin_common(@NotNull File bundleDir, @Nullable String konanDataDir2, @NotNull Set<? extends KonanTarget> konanTargets, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)bundleDir, (String)"bundleDir");
        Intrinsics.checkNotNullParameter(konanTargets, (String)"konanTargets");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Set requiredDependencies = new LinkedHashSet();
        String string = bundleDir.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"bundleDir.absolutePath");
        Distribution distribution2 = new Distribution(string, false, null, null, konanDataDir2, 14, null);
        Iterable $this$forEach$iv = konanTargets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KonanTarget konanTarget2 = (KonanTarget)element$iv;
            boolean bl = false;
            if (!KotlinNativeTargetPresetKt.getEnabledOnCurrentHost(konanTarget2)) continue;
            Configurables configurables = ConfigurablesImplKt.loadConfigurables((KonanTarget)konanTarget2, (Properties)distribution2.getProperties(), (String)distribution2.getDependenciesDir(), (Function3)((Function3)new Function3<String, Long, Long, Unit>(logger){
                final /* synthetic */ Logger $logger;
                {
                    this.$logger = $logger;
                    super(3);
                }

                public final void invoke(String url, long currentBytes, long totalBytes) {
                    Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                    this.$logger.info("Downloading dependency for Kotlin Native: " + url + " (" + currentBytes + '/' + totalBytes + "). ");
                }
            }));
            Intrinsics.checkNotNull((Object)configurables, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.konan.properties.KonanPropertiesLoader");
            KonanPropertiesLoader konanPropertiesLoader2 = (KonanPropertiesLoader)configurables;
            requiredDependencies.addAll(konanPropertiesLoader2.getDependencies());
            konanPropertiesLoader2.downloadDependencies((ArchiveExtractor)new DependencyExtractor());
        }
        return requiredDependencies;
    }

    private final void removeBundleIfNeeded(boolean reinstallFlag, File bundleDir) {
        if (reinstallFlag && this.canBeReinstalled) {
            FilesKt.deleteRecursively((File)bundleDir);
            this.canBeReinstalled = false;
        }
    }

    private final File resolveKotlinNativeConfiguration(String kotlinNativeVersion, ConfigurableFileCollection kotlinNativeCompilerConfiguration2) {
        File file;
        String resolutionErrorMessage = "Kotlin Native dependency has not been properly resolved. Please, make sure that you've declared the repository, which contains " + kotlinNativeVersion + '.';
        File file2 = (File)CollectionsKt.singleOrNull((Iterable)((Iterable)kotlinNativeCompilerConfiguration2));
        if (file2 == null || (file = FilesKt.resolve((File)file2, (String)kotlinNativeVersion)) == null) {
            throw new IllegalStateException(resolutionErrorMessage.toString());
        }
        File gradleCachesKotlinNativeDir = file;
        if (!gradleCachesKotlinNativeDir.exists()) {
            throw new IllegalArgumentException(resolutionErrorMessage);
        }
        return gradleCachesKotlinNativeDir;
    }

    private final void setupKotlinNativePlatformLibraries(Project $this$setupKotlinNativePlatformLibraries, Set<? extends KonanTarget> konanTargets) {
        NativeDistributionType distributionType = new NativeDistributionTypeProvider($this$setupKotlinNativePlatformLibraries).getDistributionType();
        if (distributionType.getMustGeneratePlatformLibs()) {
            Iterable $this$forEach$iv = konanTargets;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KonanTarget konanTarget2 = (KonanTarget)element$iv;
                boolean bl = false;
                Project project = $this$setupKotlinNativePlatformLibraries.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                new PlatformLibrariesGenerator(project, konanTarget2).generatePlatformLibsIfNeeded();
            }
        }
    }

    public static final /* synthetic */ void access$removeBundleIfNeeded(KotlinNativeBundleBuildService $this, boolean reinstallFlag, File bundleDir) {
        $this.removeBundleIfNeeded(reinstallFlag, bundleDir);
    }

    public static final /* synthetic */ File access$resolveKotlinNativeConfiguration(KotlinNativeBundleBuildService $this, String kotlinNativeVersion, ConfigurableFileCollection kotlinNativeCompilerConfiguration2) {
        return $this.resolveKotlinNativeConfiguration(kotlinNativeVersion, kotlinNativeCompilerConfiguration2);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/native/toolchain/KotlinNativeBundleBuildService$Companion;", "", "()V", "registerIfAbsent", "Lorg/gradle/api/provider/Provider;", "Lorg/jetbrains/kotlin/gradle/targets/native/toolchain/KotlinNativeBundleBuildService;", "project", "Lorg/gradle/api/Project;", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Provider<KotlinNativeBundleBuildService> registerIfAbsent(@NotNull Project project) {
            Provider provider;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Provider serviceProvider = provider = project.getGradle().getSharedServices().registerIfAbsent("kotlinNativeBundleBuildService", KotlinNativeBundleBuildService.class, (Action)registerIfAbsent.1.INSTANCE);
            boolean bl = false;
            String string = UsesKotlinNativeBundleBuildService.class.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UsesKotlinNativeBundleBu\u2026dService::class.java.name");
            SingleActionPerProject.INSTANCE.run(project, string, (Function0<Unit>)((Function0)new Function0<Unit>(project, (Provider<KotlinNativeBundleBuildService>)serviceProvider){
                final /* synthetic */ Project $project;
                final /* synthetic */ Provider<KotlinNativeBundleBuildService> $serviceProvider;
                {
                    this.$project = $project;
                    this.$serviceProvider = $serviceProvider;
                    super(0);
                }

                public final void invoke() {
                    TaskContainer taskContainer = this.$project.getTasks();
                    Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
                    TaskCollection $this$withType$iv = (TaskCollection)taskContainer;
                    boolean $i$f$withType = false;
                    TaskCollection taskCollection = $this$withType$iv.withType(UsesKotlinNativeBundleBuildService.class);
                    Intrinsics.checkNotNullExpressionValue((Object)taskCollection, (String)"withType(S::class.java)");
                    taskCollection.configureEach(new Action(this.$serviceProvider){
                        final /* synthetic */ Provider<KotlinNativeBundleBuildService> $serviceProvider;
                        {
                            this.$serviceProvider = $serviceProvider;
                        }

                        public final void execute(UsesKotlinNativeBundleBuildService task2) {
                            task2.getKotlinNativeBundleBuildService().value(this.$serviceProvider).disallowChanges();
                            task2.usesService(this.$serviceProvider);
                        }
                    });
                }
            }));
            Provider provider2 = provider;
            Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"project.gradle.sharedSer\u2026          }\n            }");
            return provider2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006H\u0002J*\u0010\u0011\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\f0\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\fH\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/native/toolchain/KotlinNativeBundleBuildService$DependencyExtractor;", "Lorg/jetbrains/kotlin/konan/util/ArchiveExtractor;", "(Lorg/jetbrains/kotlin/gradle/targets/native/toolchain/KotlinNativeBundleBuildService;)V", "extract", "", "archive", "Ljava/io/File;", "targetDirectory", "archiveType", "Lorg/jetbrains/kotlin/konan/util/ArchiveType;", "getPosixFilePermissions", "", "Ljava/nio/file/attribute/PosixFilePermission;", "mode", "", "unzipTarGz", "targetDir", "addPermission", "", "permissionBitMask", "permission", "kotlin-gradle-plugin_common"})
    @SourceDebugExtension(value={"SMAP\nKotlinNativeBundleBuildService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinNativeBundleBuildService.kt\norg/jetbrains/kotlin/gradle/targets/native/toolchain/KotlinNativeBundleBuildService$DependencyExtractor\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,247:1\n1317#2,2:248\n*S KotlinDebug\n*F\n+ 1 KotlinNativeBundleBuildService.kt\norg/jetbrains/kotlin/gradle/targets/native/toolchain/KotlinNativeBundleBuildService$DependencyExtractor\n*L\n201#1:248,2\n*E\n"})
    private final class DependencyExtractor
    implements ArchiveExtractor {
        public void extract(@NotNull File archive, @NotNull File targetDirectory, @NotNull ArchiveType archiveType) {
            Intrinsics.checkNotNullParameter((Object)archive, (String)"archive");
            Intrinsics.checkNotNullParameter((Object)targetDirectory, (String)"targetDirectory");
            Intrinsics.checkNotNullParameter((Object)archiveType, (String)"archiveType");
            switch (WhenMappings.$EnumSwitchMapping$0[archiveType.ordinal()]) {
                case 1: {
                    KotlinNativeBundleBuildService.this.getArchiveOperations().zipTree((Object)archive);
                    break;
                }
                case 2: {
                    this.unzipTarGz(archive, targetDirectory);
                    break;
                }
                default: {
                    throw new IllegalStateException(("Unsupported format for unzipping " + archive).toString());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final void unzipTarGz(File archive, File targetDir) {
            Closeable closeable = new GZIPInputStream(new BufferedInputStream(new FileInputStream(archive)));
            Throwable throwable = null;
            try {
                GZIPInputStream gzipInputStream = (GZIPInputStream)closeable;
                boolean bl = false;
                Closeable closeable2 = new TarArchiveInputStream(gzipInputStream);
                Throwable throwable2 = null;
                try {
                    void $this$forEach$iv;
                    TarArchiveInputStream tarInputStream = (TarArchiveInputStream)closeable2;
                    boolean bl2 = false;
                    Sequence sequence = SequencesKt.generateSequence((Function0)((Function0)new Function0<TarArchiveEntry>(tarInputStream){
                        final /* synthetic */ TarArchiveInputStream $tarInputStream;
                        {
                            this.$tarInputStream = $tarInputStream;
                            super(0);
                        }

                        public final TarArchiveEntry invoke() {
                            return this.$tarInputStream.getNextEntry();
                        }
                    }));
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        TarArchiveEntry entry2 = (TarArchiveEntry)element$iv;
                        boolean bl3 = false;
                        File outputFile2 = new File(targetDir + '/' + entry2.getName());
                        if (entry2.isDirectory()) {
                            outputFile2.mkdirs();
                            continue;
                        }
                        if (entry2.isSymbolicLink()) {
                            Files.createSymbolicLink(outputFile2.toPath(), Paths.get(entry2.getLinkName(), new String[0]), new FileAttribute[0]);
                            continue;
                        }
                        Closeable closeable3 = new FileOutputStream(outputFile2);
                        Throwable throwable3 = null;
                        try {
                            FileOutputStream it = (FileOutputStream)closeable3;
                            boolean bl4 = false;
                            long l = ByteStreamsKt.copyTo$default((InputStream)tarInputStream, (OutputStream)it, (int)0, (int)2, null);
                        }
                        catch (Throwable throwable4) {
                            throwable3 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                        }
                        Files.setPosixFilePermissions(outputFile2.toPath(), this.getPosixFilePermissions(entry2.getMode()));
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        private final Set<PosixFilePermission> getPosixFilePermissions(int mode) {
            Set permissions = new LinkedHashSet();
            this.addPermission(permissions, mode, 256, PosixFilePermission.OWNER_READ);
            this.addPermission(permissions, mode, 128, PosixFilePermission.OWNER_WRITE);
            this.addPermission(permissions, mode, 64, PosixFilePermission.OWNER_EXECUTE);
            this.addPermission(permissions, mode, 32, PosixFilePermission.GROUP_READ);
            this.addPermission(permissions, mode, 16, PosixFilePermission.GROUP_WRITE);
            this.addPermission(permissions, mode, 8, PosixFilePermission.GROUP_EXECUTE);
            this.addPermission(permissions, mode, 4, PosixFilePermission.OTHERS_READ);
            this.addPermission(permissions, mode, 2, PosixFilePermission.OTHERS_WRITE);
            this.addPermission(permissions, mode, 1, PosixFilePermission.OTHERS_EXECUTE);
            return permissions;
        }

        private final void addPermission(Set<PosixFilePermission> $this$addPermission, int mode, int permissionBitMask, PosixFilePermission permission) {
            if ((mode & permissionBitMask) > 0) {
                $this$addPermission.add(permission);
            }
        }

        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ArchiveType.values().length];
                try {
                    nArray[ArchiveType.ZIP.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ArchiveType.TAR_GZ.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

